///
/// This is a utility script used for generating the dir.json files of the experiment
/// directories. This only runs when manually called so modifying it should not
/// cause any immediate disruptions.
///
/// To refresh the list run `node ./graphFiles.js` from this directory
///

const fs = require("fs");
const path = require("path");

const OUTPUT_FILE = "./00-experimentFiles.json";
const files = getFiles(".");

const types = {
    "sd": [],
    "log": [],
    "stat": [],
    "json": [],
    "other": []
}

// Will retrieve the names of every file in the scope of {src}
function getFiles(src) {
    return fs.readdirSync(src, { withFileTypes: true })
        .filter(e => !(e.isDirectory()))
        .map(f => f.name);
}

for (const file of files) {
    const suffix = file.split(".").pop();

    switch (suffix.toLowerCase()) {
        case "sd":
            types["sd"].push(file);
            break;
        case "log":
            types["log"].push(file);
            break;
        case "stat":
            types["stat"].push(file);
            break;
        case "json":
            types["json"].push(file);
            break;
        default:
            types["other"].push(file);
    }
}

fs.writeFileSync(OUTPUT_FILE, JSON.stringify(types, null, 2));

// Writes for each subdirectory
// function runInDirectory(dirPath, name) {
//     const subdirs = getDirectories(dirPath);
//     const outputFile = path.join(dirPath, `${name}.json`);

//     fs.writeFileSync(outputFile, JSON.stringify(subdirs, null, 2));
// }

// // Write for the current directory
// fs.writeFileSync(OUTPUT_FILE, JSON.stringify(dirs, null, 2));

// dirs.forEach(name => {
//     const dirPath = path.join(".", name);
//     runInDirectory(dirPath, name);
// })