/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.LinkedList;

public class sudokuCell
extends Container
implements MouseListener,
KeyListener {
    private sudokuBoard parentBoard;
    private problemVariable parentVariable;
    private int prblmPvalsNumLines;
    private int prblmPvalsNumCols;
    private int cellWidth;
    private int cellHeight;
    private int numErrors = 0;
    public Color myBackgroundColor;
    public Color originalColor;
    private assignValueButtonHandler myAssignHandler = new assignValueButtonHandler();
    private removeValueButtonHandler myRemoveHandler = new removeValueButtonHandler();
    private boolean isHint;

    public sudokuCell(problemVariable newParentVariable, int newCellWidth, int newCellHeight, sudokuBoard newBoard, Color color) {
        this.parentBoard = newBoard;
        this.parentVariable = newParentVariable;
        this.cellWidth = newCellWidth;
        this.cellHeight = newCellHeight;
        this.prblmPvalsNumLines = 3;
        this.prblmPvalsNumCols = 3;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.myBackgroundColor = color;
        this.originalColor = color;
    }

    public void paint(Graphics g) {
        Rectangle2D bounds;
        Color defalt;
        Rectangle2D.Float redRectangle;
        Rectangle2D.Float innerRectangle;
        Point midPoint = new Point(this.getWidth() / 2, this.getHeight() / 2);
        String[] printString = new String[this.prblmPvalsNumLines * this.prblmPvalsNumCols];
        for (int i = 0; i < this.prblmPvalsNumLines * this.prblmPvalsNumCols; ++i) {
            printString[i] = new String("");
        }
        Graphics2D g2 = (Graphics2D)g;
        Color tempColor = g2.getColor();
        Rectangle2D.Float backRectangle = new Rectangle2D.Float(0.0f, 0.0f, this.cellWidth, this.cellHeight);
        g2.setColor(this.myBackgroundColor);
        g2.fill(backRectangle);
        g2.setColor(tempColor);
        Font originalFont = g2.getFont();
        Stroke originalStroke = g2.getStroke();
        Color originalColor = g2.getColor();
        g2.setFont(new Font("Monospaced", 1, 12));
        g2.setStroke(new BasicStroke(0.01f));
        g2.drawLine(0, 0, this.cellWidth, 0);
        g2.drawLine(0, this.cellHeight - 1, this.cellWidth, this.cellHeight - 1);
        g2.drawLine(0, 0, 0, this.cellHeight);
        g2.drawLine(this.cellWidth - 1, 0, this.cellWidth - 1, this.cellHeight);
        if (this.isError()) {
            this.parentBoard.incrementErrors();
            innerRectangle = new Rectangle2D.Float(7.0f, 7.0f, this.cellWidth - 14, this.cellHeight - 14);
            redRectangle = new Rectangle2D.Float(5.0f, 5.0f, this.cellWidth - 10, this.cellHeight - 10);
            defalt = g2.getColor();
            g2.setColor(Color.RED);
            g2.fill(redRectangle);
            g2.setColor(this.myBackgroundColor);
            g2.fill(innerRectangle);
            g2.setColor(defalt);
        }
        if (this.isHint()) {
            innerRectangle = new Rectangle2D.Float(6.0f, 6.0f, this.cellWidth - 13, this.cellHeight - 13);
            redRectangle = new Rectangle2D.Float(4.0f, 4.0f, this.cellWidth - 9, this.cellHeight - 9);
            defalt = g2.getColor();
            g2.setColor(Color.BLUE);
            g2.fill(redRectangle);
            g2.setColor(this.myBackgroundColor);
            g2.fill(innerRectangle);
            g2.setColor(defalt);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        if (this.parentVariable.isPreassigned()) {
            g2.setFont(g2.getFont().deriveFont(25.0f));
            printString[0] = this.parentVariable.getAssigned();
            bounds = g2.getFont().getStringBounds(printString[0], frc);
            float width = (float)bounds.getWidth();
            float height = (float)bounds.getHeight() * 5.0f / 8.0f;
            g2.drawString(printString[0], (float)midPoint.x - width / 2.0f + 1.0f, (float)midPoint.y + height / 2.0f);
        } else if (this.parentVariable.isAssigned()) {
            g2.setFont(g2.getFont().deriveFont(25.0f));
            g2.setColor(Color.BLUE);
            printString[0] = this.parentVariable.getAssigned();
            bounds = g2.getFont().getStringBounds(printString[0], frc);
            float width = (float)bounds.getWidth();
            float height = (float)bounds.getHeight() * 5.0f / 8.0f;
            g2.drawString(printString[0], (float)midPoint.x - width / 2.0f + 1.0f, (float)midPoint.y + height / 2.0f);
        } else {
            if (this.parentBoard.showDomains()) {
                LinkedList currentDomain = new LinkedList(this.parentVariable.getEntireDomain());
                g2.setFont(g2.getFont().deriveFont(11.0f));
                LinkedList initialDomain = new LinkedList(this.parentVariable.getInitialDomain());
                for (int printLine = 1; printLine <= this.prblmPvalsNumLines; ++printLine) {
                    for (int printCol = 1; printCol <= this.prblmPvalsNumCols; ++printCol) {
                        printString[(printLine - 1) * this.prblmPvalsNumLines + (printCol - 1)] = printCol - 1 + this.prblmPvalsNumCols * (printLine - 1) < initialDomain.size() && currentDomain.contains(initialDomain.get(printCol - 1 + this.prblmPvalsNumCols * (printLine - 1))) ? (String)initialDomain.get(printCol - 1 + this.prblmPvalsNumCols * (printLine - 1)) : " ";
                    }
                }
                Rectangle2D bounds2 = g2.getFont().getStringBounds("1", frc);
                bounds2.setRect(0.0, 0.0, bounds2.getWidth(), bounds2.getHeight() * 5.0 / 8.0);
                double distanceBetweenLines = ((double)this.cellHeight - (double)this.prblmPvalsNumLines * bounds2.getHeight()) / (double)(this.prblmPvalsNumLines + 1);
                double distanceBetweenCols = ((double)this.cellWidth - (double)this.prblmPvalsNumCols * bounds2.getWidth()) / (double)(this.prblmPvalsNumCols + 1);
                for (int i = 0; i < this.prblmPvalsNumLines * this.prblmPvalsNumCols; ++i) {
                    g2.setColor(this.parentBoard.getDomainValueColor(this.parentVariable.getLineIndex(), this.parentVariable.getColumnIndex(), printString[i]));
                    g2.drawString(printString[i], (int)((double)(i % this.prblmPvalsNumCols) * bounds2.getWidth() + (double)(i % this.prblmPvalsNumCols + 1) * distanceBetweenCols), (int)((Math.floor(i / this.prblmPvalsNumCols) + 1.0) * (distanceBetweenLines + bounds2.getHeight())) - 1);
                }
            }
            if (this.parentVariable.getCurrentDomainSize() == 0) {
                Rectangle2D.Float innerRectangle2 = new Rectangle2D.Float(7.0f, 7.0f, this.cellWidth - 14, this.cellHeight - 14);
                Rectangle2D.Float redRectangle2 = new Rectangle2D.Float(5.0f, 5.0f, this.cellWidth - 10, this.cellHeight - 10);
                Color defalt2 = g2.getColor();
                g2.setColor(Color.RED);
                g2.fill(redRectangle2);
                g2.setColor(g2.getBackground());
                g2.fill(innerRectangle2);
                g2.setColor(defalt2);
            }
        }
        g2.setFont(originalFont);
        g2.setStroke(originalStroke);
        g2.setColor(originalColor);
    }

    public void depress() {
        this.myBackgroundColor = Color.GRAY;
        this.repaint();
    }

    public void undepress() {
        this.myBackgroundColor = this.originalColor;
        this.repaint();
    }

    public void setBackgroundColor(Color newColor) {
        this.myBackgroundColor = newColor;
    }

    public void addError() {
        ++this.numErrors;
    }

    public void reduceError() {
        --this.numErrors;
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.parentVariable.isPreassigned() || this.parentVariable.isAssigned()) {
            if (e.getKeyCode() == 32) {
                this.parentBoard.preformBinaryForwardCheckOnVariable(this.parentVariable);
            }
        } else {
            if (e.getKeyCode() == 97) {
                this.parentBoard.preformReduction(this.parentVariable, "1");
            } else if (e.getKeyCode() == 98) {
                this.parentBoard.preformReduction(this.parentVariable, "2");
            } else if (e.getKeyCode() == 99) {
                this.parentBoard.preformReduction(this.parentVariable, "3");
            } else if (e.getKeyCode() == 100) {
                this.parentBoard.preformReduction(this.parentVariable, "4");
            } else if (e.getKeyCode() == 101) {
                this.parentBoard.preformReduction(this.parentVariable, "5");
            } else if (e.getKeyCode() == 102) {
                this.parentBoard.preformReduction(this.parentVariable, "6");
            } else if (e.getKeyCode() == 103) {
                this.parentBoard.preformReduction(this.parentVariable, "7");
            } else if (e.getKeyCode() == 104) {
                this.parentBoard.preformReduction(this.parentVariable, "8");
            } else if (e.getKeyCode() == 105) {
                this.parentBoard.preformReduction(this.parentVariable, "9");
            } else if (e.getKeyCode() == 49) {
                this.parentBoard.makeAssignment(this.parentVariable, "1");
            } else if (e.getKeyCode() == 50) {
                this.parentBoard.makeAssignment(this.parentVariable, "2");
            } else if (e.getKeyCode() == 51) {
                this.parentBoard.makeAssignment(this.parentVariable, "3");
            } else if (e.getKeyCode() == 52) {
                this.parentBoard.makeAssignment(this.parentVariable, "4");
            } else if (e.getKeyCode() == 53) {
                this.parentBoard.makeAssignment(this.parentVariable, "5");
            } else if (e.getKeyCode() == 54) {
                this.parentBoard.makeAssignment(this.parentVariable, "6");
            } else if (e.getKeyCode() == 55) {
                this.parentBoard.makeAssignment(this.parentVariable, "7");
            } else if (e.getKeyCode() == 56) {
                this.parentBoard.makeAssignment(this.parentVariable, "8");
            } else if (e.getKeyCode() == 57) {
                this.parentBoard.makeAssignment(this.parentVariable, "9");
            }
            if (e.getKeyCode() == 48) {
                this.parentBoard.preform_undo();
            }
            this.parentBoard.doAutoPropogation(this.parentVariable);
            this.parentBoard.repaint();
        }
    }

    private void displayInfo(KeyEvent e, String keyStatus) {
        int id = e.getID();
        if (id == 400) {
            char c = e.getKeyChar();
            String keyString = "key character = '" + c + "'";
        } else {
            int keyCode = e.getKeyCode();
            String keyString = "key code = " + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ")";
        }
        int modifiersEx = e.getModifiersEx();
        String modString = "extended modifiers = " + modifiersEx;
        String tmpString = KeyEvent.getModifiersExText(modifiersEx);
        modString = tmpString.length() > 0 ? modString + " (" + tmpString + ")" : modString + " (no extended modifiers)";
        String actionString = "action key? ";
        actionString = e.isActionKey() ? actionString + "YES" : actionString + "NO";
        String locationString = "key location: ";
        int location = e.getKeyLocation();
        locationString = location == 1 ? locationString + "standard" : (location == 2 ? locationString + "left" : (location == 3 ? locationString + "right" : (location == 4 ? locationString + "numpad" : locationString + "unknown")));
    }

    public void mouseEntered(MouseEvent e) {
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocusInWindow();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.parentVariable.isPreassigned() || this.parentVariable.isAssigned()) {
            if (e.getClickCount() == 2) {
                this.parentBoard.preformBinaryForwardCheckOnVariable(this.parentVariable);
            }
        } else if (e.getButton() == 3) {
            PopupMenu pumModel = new PopupMenu();
            pumModel.addActionListener(this.myRemoveHandler);
            LinkedList currentDomain = new LinkedList(this.parentVariable.getEntireDomain());
            MenuItem[] assignmentChoices = new MenuItem[currentDomain.size()];
            Collections.sort(currentDomain);
            for (int i = 0; i < currentDomain.size(); ++i) {
                assignmentChoices[i] = new MenuItem(currentDomain.get(i).toString());
                pumModel.add(assignmentChoices[i]);
            }
            pumModel.setEnabled(true);
            this.add(pumModel);
            pumModel.show(this, 0, 0);
        } else if (e.getButton() == 1) {
            PopupMenu pumModel = new PopupMenu();
            pumModel.addActionListener(this.myAssignHandler);
            LinkedList currentDomain = new LinkedList(this.parentVariable.getEntireDomain());
            MenuItem[] assignmentChoices = new MenuItem[currentDomain.size()];
            Collections.sort(currentDomain);
            for (int i = 0; i < currentDomain.size(); ++i) {
                assignmentChoices[i] = new MenuItem(currentDomain.get(i).toString());
                pumModel.add(assignmentChoices[i]);
            }
            pumModel.setEnabled(true);
            this.add(pumModel);
            pumModel.show(this, 0, 0);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private boolean isError() {
        return this.numErrors > 0;
    }

    public void setHint(boolean isHint) {
        this.isHint = isHint;
    }

    private boolean isHint() {
        return this.isHint;
    }

    public class removeValueButtonHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            sudokuCell.this.parentBoard.preformReduction(sudokuCell.this.parentVariable, e.getActionCommand());
        }
    }

    public class assignValueButtonHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            LinkedList currentDomain = (LinkedList)sudokuCell.this.parentVariable.getEntireDomain();
            for (int i = 0; i < currentDomain.size(); ++i) {
                System.out.println(e.getActionCommand());
                if (!e.getActionCommand().equals(currentDomain.get(i).toString())) continue;
                sudokuCell.this.parentBoard.makeAssignment(sudokuCell.this.parentVariable, currentDomain.get(i).toString());
                sudokuCell.this.parentBoard.doAutoPropogation(sudokuCell.this.parentVariable);
                sudokuCell.this.parentBoard.repaint();
            }
        }
    }
}

