/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.assignSingletons;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.arcConsistency;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.backCheckAll;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.backCheckOnVariable;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.binaryForwardCheckAll;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.binaryForwardCheckOnVariable;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.binaryRestrictedArcConsistency;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.nonBinaryMAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.nonBinaryRestrictedArcConsistency;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingGAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingMAC;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.dbmysql;
import edu.unl.consystlab.sudokuSolver.hints;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuCell;
import edu.unl.consystlab.sudokuSolver.sudokuInterface;
import edu.unl.consystlab.sudokuSolver.user_action;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class sudokuBoard
extends Container {
    private Image offscreen;
    constraintProblem parentProblem;
    sudokuInterface parentInterface;
    private final int UNIT_BORDER_WIDTH = 3;
    private int test = 0;
    private int boardWidth;
    private int boardHeight;
    private int unitsWide;
    private int unitsHigh;
    private int cellWidth;
    private int cellHeight;
    private int numCols;
    private int numLines;
    private boolean isError = false;
    private String boardErrors = "";
    private Stack undoStack;
    private Stack redoStack;
    private sudokuCell[] problemCells;
    private List constraintsInError = new LinkedList();
    private Hashtable myCells;
    private boolean displayingHint = false;
    private String mouseAction;
    private int num_errors = 0;

    public sudokuBoard(constraintProblem myProblem, sudokuInterface myInterface) {
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.parentProblem = myProblem;
        this.parentInterface = myInterface;
        this.myCells = new Hashtable();
        if (this.parentProblem == null) {
            this.isError = true;
            this.boardErrors = this.boardErrors + "The problem was not loaded correctly.\n";
        }
        this.numCols = this.parentProblem.totalColumns;
        this.numLines = this.parentProblem.totalLines;
        if (this.numCols != this.numLines) {
            this.isError = true;
            this.boardErrors = this.boardErrors + "The number of columns and lines should be equal.\n";
        }
        if (this.numCols > 16) {
            this.isError = true;
            this.boardErrors = this.boardErrors + "The number of columns and lines should be less than 16.\n";
        }
        if (!this.isError) {
            this.unitsWide = this.numCols / this.parentProblem.columnsPerUnit;
            this.unitsHigh = this.numLines / this.parentProblem.linesPerUnit;
            this.boardWidth = 360;
            this.boardHeight = 360;
            this.boardHeight += 3 * (this.unitsHigh - 1);
            this.boardWidth += 3 * (this.unitsWide - 1);
            this.setSize(this.boardWidth, this.boardHeight);
            this.cellHeight = 40;
            this.cellWidth = 40;
            this.problemCells = new sudokuCell[81];
            int tempCellNum = 0;
            for (int lineIndex = 0; lineIndex < 9; ++lineIndex) {
                for (int colIndex = 0; colIndex < 9; ++colIndex) {
                    problemVariable tempVar = this.parentProblem.getVariable(lineIndex + 1 + "," + (colIndex + 1));
                    this.problemCells[tempCellNum] = colIndex >= 3 && colIndex < 6 && (lineIndex < 3 || lineIndex >= 6) ? new sudokuCell(tempVar, this.cellWidth, this.cellHeight, this, new Color(200, 200, 255)) : ((colIndex < 3 || colIndex >= 6) && lineIndex >= 3 && lineIndex < 6 ? new sudokuCell(tempVar, this.cellWidth, this.cellHeight, this, new Color(200, 200, 255)) : new sudokuCell(tempVar, this.cellWidth, this.cellHeight, this, new Color(255, 255, 200)));
                    this.problemCells[tempCellNum].setLocation(colIndex * this.cellHeight + (int)Math.floor(colIndex / this.unitsWide) * 3, lineIndex * this.cellWidth + (int)Math.floor(lineIndex / this.unitsHigh) * 3);
                    this.problemCells[tempCellNum].setSize(this.cellWidth, this.cellHeight);
                    this.problemCells[tempCellNum].setFocusable(true);
                    this.add(this.problemCells[tempCellNum]);
                    this.myCells.put(tempVar, this.problemCells[tempCellNum]);
                    ++tempCellNum;
                }
            }
        }
        this.setFocusable(true);
        this.requestFocusInWindow();
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public int getUnitBorderWidth() {
        return 3;
    }

    public String getMouseAction() {
        return this.mouseAction;
    }

    public void setMouseAction(String action) {
        this.mouseAction = action;
    }

    public void incrementErrors() {
        ++this.num_errors;
    }

    public void resetErrors() {
        this.num_errors = 0;
    }

    public int getNumErrors() {
        return this.num_errors;
    }

    public void update(Graphics g) {
        this.offscreen = this.createImage(this.getWidth(), this.getHeight());
        Graphics bufferGraphics = this.offscreen.getGraphics();
        for (int i = 0; i <= 80; ++i) {
            bufferGraphics.translate(this.problemCells[i].getX(), this.problemCells[i].getY());
            this.problemCells[i].paint(bufferGraphics);
            bufferGraphics.translate(-this.problemCells[i].getX(), -this.problemCells[i].getY());
        }
        if (!this.isError) {
            Graphics2D g2 = (Graphics2D)bufferGraphics;
            g2.setColor(Color.BLACK);
            for (int lineIndex = 1; lineIndex < this.unitsWide; ++lineIndex) {
                g2.fillRect(0, lineIndex * (this.cellHeight * this.numLines / this.unitsHigh) + (lineIndex - 1) * 3, this.boardWidth, 3);
            }
            for (int colIndex = 1; colIndex < this.unitsHigh; ++colIndex) {
                g2.fillRect(colIndex * (this.cellWidth * this.numCols / this.unitsWide) + (colIndex - 1) * 3, 0, 3, this.boardHeight);
            }
        } else {
            Label errorLabel = new Label(this.boardErrors);
            errorLabel.setLocation(0, 0);
            errorLabel.setSize(this.boardWidth, this.boardHeight);
            this.add(errorLabel);
        }
        g.drawImage(this.offscreen, 0, 0, this);
        this.offscreen.flush();
        bufferGraphics.dispose();
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public Color getDomainValueColor(int xIndex, int yIndex, String value) {
        return Color.BLACK;
    }

    public void depress(List variablesAffected) {
        Iterator i = variablesAffected.iterator();
        while (i.hasNext()) {
            ((sudokuCell)this.myCells.get(i.next())).depress();
        }
    }

    public void undepress(List variablesAffected) {
        Iterator i = variablesAffected.iterator();
        while (i.hasNext()) {
            ((sudokuCell)this.myCells.get(i.next())).undepress();
        }
    }

    public void doAutoPropogation(problemVariable originalVariable) {
        this.parentInterface.doAutoPropogation(originalVariable);
    }

    public void makeAssignment(problemVariable variableToAssign, String valueToAssign) {
        this.resetErrors();
        System.out.println("reset errors " + Integer.toString(this.num_errors));
        LinkedList myDomainReductions = new LinkedList();
        this.parentProblem.registerDomainReductionListener(myDomainReductions);
        variableToAssign.setAssigned(valueToAssign);
        this.parentProblem.unregisterDomainReductionList(myDomainReductions);
        this.add_assignment_undo(variableToAssign, myDomainReductions);
        this.repaint();
    }

    public void check_if_complete() {
        boolean res = this.check_if_solved(this.parentProblem);
        if (this.parentInterface.getHaveUsed() == 0 && !res) {
            try {
                this.parentInterface.stopTimer();
                this.show_high_scores_box();
            }
            catch (Exception ex) {
                Logger.getLogger(sudokuInterface.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void show_high_scores_box() throws Exception {
        dbmysql database = new dbmysql();
        database.is_high_score(this.parentInterface.getHours(), this.parentInterface.getMinutes(), this.parentInterface.getSeconds());
    }

    private boolean check_if_solved(constraintProblem newProblem) {
        ++this.test;
        boolean not_done = false;
        this.parentProblem = newProblem;
        LinkedList allVariables = new LinkedList(this.parentProblem.getAllVariables());
        for (problemVariable currentVar : allVariables) {
            if (currentVar.isAssigned()) continue;
            not_done = true;
        }
        if (this.num_errors > 0) {
            not_done = true;
        }
        return not_done;
    }

    private void add_assignSingletons_undo(assignSingletons newAssignSingletons) {
        user_action temp_user_action = new user_action();
        temp_user_action.user_assignSingletons(newAssignSingletons);
        this.undoStack.push(temp_user_action);
        this.redoStack.clear();
        this.actionOccured();
    }

    private void add_assignment_undo(problemVariable new_variableAffected, List domainReductions) {
        user_action temp_user_action = new user_action();
        temp_user_action.user_assign(new_variableAffected, domainReductions);
        this.undoStack.push(temp_user_action);
        this.redoStack.clear();
        this.actionOccured();
    }

    public void add_consistency_undo(consistencyAlgorithm newAlgorithm) {
        this.parentInterface.updateValuesRemoved(newAlgorithm.getVariableReductions().size());
        user_action temp_user_action = new user_action();
        temp_user_action.user_consistency(newAlgorithm);
        if (newAlgorithm.isEncounteredError()) {
            this.addNewBrokenConstraint(newAlgorithm.getBrokenConstraint());
        }
        this.undoStack.push(temp_user_action);
        this.redoStack.clear();
        this.actionOccured();
    }

    public void add_reduction_undo(List domainReductions) {
        user_action temp_user_action = new user_action();
        temp_user_action.user_domain_reduction(domainReductions);
        this.undoStack.push(temp_user_action);
        this.redoStack.clear();
    }

    public void preform_undo() {
        this.actionOccured();
        this.parentInterface.updateValuesRemoved("");
        if (this.undoStack.isEmpty()) {
            return;
        }
        user_action actionToUndo = (user_action)this.undoStack.pop();
        this.redoStack.push(actionToUndo);
        if (actionToUndo.getAction().equals("assign")) {
            actionToUndo.setStringAssigned(actionToUndo.getVariableAffected().getAssigned());
            actionToUndo.getVariableAffected().unSetAssigned();
            for (variableIndexAndValueGrouping variableValue : actionToUndo.getDomainReductions()) {
                this.parentProblem.getVariable(variableValue.getVariableIndex()).addToCurrentDomain(variableValue.getValue());
            }
        } else if (actionToUndo.getAction().equals("consistency")) {
            for (variableIndexAndValueGrouping currentReduction : actionToUndo.getConsistencyAlgorithm().getVariableReductions()) {
                this.parentProblem.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
            if (actionToUndo.getConsistencyAlgorithm().isEncounteredError()) {
                this.removeConstraintInError(actionToUndo.getConsistencyAlgorithm().getBrokenConstraint());
            }
        } else if (actionToUndo.getAction().equals("autoAssign")) {
            Iterator i = actionToUndo.getAssignments().iterator();
            while (i.hasNext()) {
                this.parentProblem.getVariable(((variableIndexAndValueGrouping)i.next()).getVariableIndex()).unSetAssigned();
            }
            for (variableIndexAndValueGrouping domainReduction : actionToUndo.getDomainReductions()) {
                this.parentProblem.getVariable(domainReduction.getVariableIndex()).addToCurrentDomain(domainReduction.getValue());
            }
        } else if (actionToUndo.getAction().equals("reduction")) {
            for (variableIndexAndValueGrouping currentReduction : actionToUndo.getDomainReductions()) {
                this.parentProblem.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
        }
        this.repaint();
    }

    public void preform_redo() {
        this.actionOccured();
        if (this.redoStack.isEmpty()) {
            return;
        }
        user_action actionToRedo = (user_action)this.redoStack.pop();
        this.undoStack.push(actionToRedo);
        if (actionToRedo.getAction().equals("assign")) {
            actionToRedo.getVariableAffected().setAssigned(actionToRedo.getStringAssigned());
        } else if (actionToRedo.getAction().equals("consistency")) {
            for (variableIndexAndValueGrouping currentReduction : actionToRedo.getConsistencyAlgorithm().getVariableReductions()) {
                this.parentProblem.getVariable(currentReduction.getVariableIndex()).removeFromCurrentDomain(currentReduction.getValue());
            }
            if (actionToRedo.getConsistencyAlgorithm().isEncounteredError()) {
                this.addNewBrokenConstraint(actionToRedo.getConsistencyAlgorithm().getBrokenConstraint());
            }
        } else if (actionToRedo.getAction().equals("autoAssign")) {
            for (variableIndexAndValueGrouping myGrouping : actionToRedo.getAssignments()) {
                this.parentProblem.getVariable(myGrouping.getVariableIndex()).setAssigned(myGrouping.getValue());
            }
        } else if (actionToRedo.getAction().equals("reduction")) {
            for (variableIndexAndValueGrouping currentReduction : actionToRedo.getDomainReductions()) {
                this.parentProblem.getVariable(currentReduction.getVariableIndex()).removeFromCurrentDomain(currentReduction.getValue());
            }
        }
        this.repaint();
    }

    public boolean showDomains() {
        return this.parentInterface.showDomains();
    }

    public void preformReduction(problemVariable variableToReduce, String reduction) {
        if (!variableToReduce.isAssigned()) {
            LinkedList myReductions = new LinkedList();
            this.parentProblem.registerDomainReductionListener(myReductions);
            variableToReduce.removeFromCurrentDomain(reduction);
            this.parentProblem.unregisterDomainReductionList(myReductions);
            this.add_reduction_undo(myReductions);
            this.repaint();
        }
    }

    public Thread preformBackChecking() {
        return new backCheckAll(this.parentProblem, this);
    }

    public void preformBackCheckingOnVariable(problemVariable newMasterVariable) {
        backCheckOnVariable myAlgorithm = new backCheckOnVariable(this.parentProblem, this, newMasterVariable);
        try {
            ((consistencyAlgorithm)myAlgorithm).runAlgorithm();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(sudokuBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.add_consistency_undo(myAlgorithm);
        this.repaint();
    }

    public Thread preformArcConsistency() {
        return new arcConsistency(this.parentProblem, this);
    }

    public void preformBinaryForwardCheckOnVariable(problemVariable newMasterVariable) {
        binaryForwardCheckOnVariable myAlgorithm = new binaryForwardCheckOnVariable(this.parentProblem, this, newMasterVariable);
        try {
            ((consistencyAlgorithm)myAlgorithm).runAlgorithm();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(sudokuBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.add_consistency_undo(myAlgorithm);
        this.repaint();
    }

    public void preformBinaryForwardCheckAll() {
        binaryForwardCheckAll myAlgorithm = new binaryForwardCheckAll(this.parentProblem, this);
        try {
            ((consistencyAlgorithm)myAlgorithm).runAlgorithm();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(sudokuBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.add_consistency_undo(myAlgorithm);
        this.repaint();
    }

    public void preformBinaryRestrictedArcConsistency(List newVariables) {
        binaryRestrictedArcConsistency myAlgorithm = new binaryRestrictedArcConsistency(this.parentProblem, this, newVariables);
        try {
            ((consistencyAlgorithm)myAlgorithm).runAlgorithm();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(sudokuBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.add_consistency_undo(myAlgorithm);
        this.repaint();
    }

    public Thread preformNonBinaryMAC() {
        return new nonBinaryMAC(this.parentProblem, this);
    }

    public void preformNonBinaryRestrictedArcConsistency(String newLocation) {
        nonBinaryRestrictedArcConsistency myAlgorithm = new nonBinaryRestrictedArcConsistency(this.parentProblem, this, newLocation);
        try {
            ((consistencyAlgorithm)myAlgorithm).runAlgorithm();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(sudokuBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.add_consistency_undo(myAlgorithm);
        this.repaint();
    }

    public Thread preformShavingGAC() {
        return new shavingGAC(this.parentProblem, this);
    }

    public Thread preformShavingMAC() {
        return new shavingMAC(this.parentProblem, this);
    }

    public void preformAutoAssign() {
        assignSingletons myAlgorithm = new assignSingletons(this.parentProblem);
        myAlgorithm.runAlgorithm();
        this.add_assignSingletons_undo(myAlgorithm);
        this.parentInterface.doAutoPropogation();
        this.repaint();
    }

    public void addNewBrokenConstraint(problemConstraint newConstraint) {
        this.constraintsInError.add(newConstraint);
        Iterator i = newConstraint.getScope().iterator();
        while (i.hasNext()) {
            ((sudokuCell)this.myCells.get(i.next())).addError();
        }
        this.parentInterface.setEnableHints(false);
    }

    public void removeConstraintInError(problemConstraint oldConstraint) {
        this.constraintsInError.remove(oldConstraint);
        Iterator i = oldConstraint.getScope().iterator();
        while (i.hasNext()) {
            ((sudokuCell)this.myCells.get(i.next())).reduceError();
        }
        if (this.constraintsInError.size() == 0) {
            this.parentInterface.setEnableHints(true);
        }
    }

    public void displayHint(hints myHint) {
        this.displayingHint = true;
        if (!myHint.foundError()) {
            if (myHint.hasHint()) {
                sudokuCell myCell = (sudokuCell)this.myCells.get(myHint.getCurrentHintVariable());
                myCell.setHint(true);
            }
        } else {
            LinkedList errorVariables = new LinkedList(myHint.getErrorConstraint().getScope());
            for (problemVariable currentVariable : errorVariables) {
                ((sudokuCell)this.myCells.get(currentVariable)).addError();
            }
        }
        this.repaint();
    }

    public void hideHint(hints myHint) {
        if (!myHint.foundError()) {
            if (myHint.hasHint()) {
                sudokuCell myCell = (sudokuCell)this.myCells.get(myHint.getCurrentHintVariable());
                myCell.setHint(false);
            }
        } else {
            LinkedList errorVariables = new LinkedList(myHint.getErrorConstraint().getScope());
            for (problemVariable currentVariable : errorVariables) {
                ((sudokuCell)this.myCells.get(currentVariable)).reduceError();
            }
        }
        this.displayingHint = false;
        this.repaint();
    }

    private void actionOccured() {
        if (this.constraintsInError.size() == 0 && !this.displayingHint) {
            this.parentInterface.resetHintBoard();
        }
    }
}

