/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.solBoard;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;

public class solCell
extends Container {
    private solBoard parentBoard;
    private String assignedNumber;
    private int cellWidth;
    private int cellHeight;
    private Color myBackgroundColor;

    public solCell(String assignNum, int newCellWidth, int newCellHeight, solBoard newBoard) {
        this.assignedNumber = assignNum == null ? "0" : assignNum;
        this.parentBoard = newBoard;
        this.cellWidth = newCellWidth;
        this.cellHeight = newCellHeight;
        this.myBackgroundColor = Color.WHITE;
    }

    public void paint(Graphics g) {
        Point midPoint = new Point(this.getWidth() / 2, this.getHeight() / 2);
        String printString = this.assignedNumber;
        Graphics2D g2 = (Graphics2D)g;
        Color tempColor = g2.getColor();
        Rectangle2D.Float backRectangle = new Rectangle2D.Float(0.0f, 0.0f, this.cellWidth, this.cellHeight);
        g2.setColor(this.myBackgroundColor);
        g2.fill(backRectangle);
        g2.setColor(tempColor);
        Font originalFont = g2.getFont();
        Stroke originalStroke = g2.getStroke();
        Color originalColor = g2.getColor();
        g2.setFont(new Font("Monospaced", 0, 10));
        g2.setStroke(new BasicStroke(0.01f));
        g2.drawLine(0, 0, this.cellWidth, 0);
        g2.drawLine(0, this.cellHeight - 1, this.cellWidth, this.cellHeight - 1);
        g2.drawLine(0, 0, 0, this.cellHeight);
        g2.drawLine(this.cellWidth - 1, 0, this.cellWidth - 1, this.cellHeight);
        FontRenderContext frc = g2.getFontRenderContext();
        g2.setFont(g2.getFont().deriveFont(15.0f));
        Rectangle2D bounds = g2.getFont().getStringBounds(printString, frc);
        float width = (float)bounds.getWidth();
        float height = (float)bounds.getHeight() * 5.0f / 8.0f;
        g2.drawString(printString, (float)midPoint.x - width / 2.0f + 1.0f, (float)midPoint.y + height / 2.0f);
        g2.setFont(originalFont);
        g2.setStroke(originalStroke);
        g2.setColor(originalColor);
    }

    public void setBackgroundColor(Color newColor) {
        this.myBackgroundColor = newColor;
    }
}

