/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.solCell;
import edu.unl.consystlab.sudokuSolver.sudokuInterface;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;

public class solBoard
extends Container {
    private Image offscreen;
    constraintProblem parentProblem;
    sudokuInterface parentInterface;
    private final int UNIT_BORDER_WIDTH = 3;
    private int boardWidth;
    private int boardHeight;
    private int unitsWide;
    private int unitsHigh;
    private int cellWidth;
    private int cellHeight;
    private int numCols;
    private int numLines;
    private boolean isError = false;
    private String boardErrors = "";
    private solCell[] solCells;

    public solBoard(String[][] mySolution, constraintProblem myProblem, sudokuInterface myInterface) {
        this.parentProblem = myProblem;
        this.parentInterface = myInterface;
        if (mySolution == null) {
            this.isError = true;
            this.boardErrors = this.boardErrors + "The solutions was not loaded correctly.\n";
        }
        this.numCols = this.parentProblem.totalColumns;
        this.numLines = this.parentProblem.totalLines;
        if (this.numCols != this.numLines) {
            this.isError = true;
            this.boardErrors = this.boardErrors + "The number of columns and lines should be equal.\n";
        }
        if (this.numCols > 16) {
            this.isError = true;
            this.boardErrors = this.boardErrors + "The number of columns and lines should be less than 16.\n";
        }
        if (!this.isError) {
            this.unitsWide = this.numCols / this.parentProblem.columnsPerUnit;
            this.unitsHigh = this.numLines / this.parentProblem.linesPerUnit;
            this.boardWidth = 180;
            this.boardHeight = 180;
            this.boardHeight += 3 * (this.unitsHigh - 1);
            this.boardWidth += 3 * (this.unitsWide - 1);
            this.setSize(this.boardWidth, this.boardHeight);
            this.cellHeight = 20;
            this.cellWidth = 20;
            this.solCells = new solCell[81];
            int tempCellNum = 0;
            for (int lineIndex = 0; lineIndex < 9; ++lineIndex) {
                for (int colIndex = 0; colIndex < 9; ++colIndex) {
                    System.out.println("mySolution[lineIndex][colIndex]");
                    System.out.println(mySolution[lineIndex + 1][colIndex + 1]);
                    this.solCells[tempCellNum] = new solCell(mySolution[lineIndex + 1][colIndex + 1], this.cellWidth, this.cellHeight, this);
                    this.solCells[tempCellNum].setLocation(colIndex * this.cellHeight + (int)Math.floor(colIndex / this.unitsWide) * 3, lineIndex * this.cellWidth + (int)Math.floor(lineIndex / this.unitsHigh) * 3);
                    this.solCells[tempCellNum].setSize(this.cellWidth, this.cellHeight);
                    this.add(this.solCells[tempCellNum]);
                    ++tempCellNum;
                }
            }
        }
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public int getUnitBorderWidth() {
        return 3;
    }

    public void update(Graphics g) {
        this.offscreen = this.createImage(this.getWidth(), this.getHeight());
        Graphics bufferGraphics = this.offscreen.getGraphics();
        for (int i = 0; i <= 80; ++i) {
            bufferGraphics.translate(this.solCells[i].getX(), this.solCells[i].getY());
            this.solCells[i].paint(bufferGraphics);
            bufferGraphics.translate(-this.solCells[i].getX(), -this.solCells[i].getY());
        }
        if (!this.isError) {
            Graphics2D g2 = (Graphics2D)bufferGraphics;
            g2.setColor(Color.BLACK);
            for (int lineIndex = 1; lineIndex < this.unitsWide; ++lineIndex) {
                g2.fillRect(0, lineIndex * (this.cellHeight * this.numLines / this.unitsHigh) + (lineIndex - 1) * 3, this.boardWidth, 3);
            }
            for (int colIndex = 1; colIndex < this.unitsHigh; ++colIndex) {
                g2.fillRect(colIndex * (this.cellWidth * this.numCols / this.unitsWide) + (colIndex - 1) * 3, 0, 3, this.boardHeight);
            }
        } else {
            Label errorLabel = new Label(this.boardErrors);
            errorLabel.setLocation(0, 0);
            errorLabel.setSize(this.boardWidth, this.boardHeight);
            this.add(errorLabel);
        }
        g.drawImage(this.offscreen, 0, 0, this);
        this.offscreen.flush();
        bufferGraphics.dispose();
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public Color getDomainValueColor(int xIndex, int yIndex, String value) {
        return Color.BLACK;
    }
}

