/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;
import java.util.LinkedList;
import java.util.List;

public class problemVariable {
    private constraintProblem parentProblem;
    private String variableIndex;
    private String variableAssigned;
    private List variableInitialDomain;
    private List variableCurrentDomain;
    private List variableBinaryIntensiveConstraints;
    private List variableNonBinaryIntensiveConstraints;
    private List variableNonBinaryConstraints;
    private boolean boolAssigned;

    public problemVariable(String name, constraintProblem parent) {
        this.parentProblem = parent;
        this.variableIndex = name;
        parent.addVariable(this);
        this.variableNonBinaryIntensiveConstraints = new LinkedList();
        this.variableBinaryIntensiveConstraints = new LinkedList();
        this.boolAssigned = false;
    }

    public boolean isPreassigned() {
        return this.boolAssigned && this.variableInitialDomain.size() == 1;
    }

    public void setDomain(List newDomain) {
        this.variableInitialDomain = new LinkedList(newDomain);
        this.variableCurrentDomain = new LinkedList(newDomain);
    }

    public void setCurrentDomain(List newDomain) {
        this.variableCurrentDomain = new LinkedList(newDomain);
    }

    public List getInitialDomain() {
        return this.variableInitialDomain;
    }

    public List getEntireDomain() {
        return this.variableCurrentDomain;
    }

    public void addToCurrentDomain(String newDomainValue) {
        if (!this.variableCurrentDomain.contains(newDomainValue)) {
            this.variableCurrentDomain.add(newDomainValue);
        }
    }

    public void addToCurrentDomain(List newDomainList) {
        for (int i = 0; i < newDomainList.size(); ++i) {
            this.variableCurrentDomain.add((String)newDomainList.get(i));
        }
    }

    public void removeFromCurrentDomain(String oldDomainValue) {
        this.parentProblem.addDomainReduction(new variableIndexAndValueGrouping(this.getIndex(), oldDomainValue));
        this.variableCurrentDomain.remove(oldDomainValue);
    }

    public boolean isInCurrentDomain(String domainValue) {
        return this.variableCurrentDomain.contains(domainValue);
    }

    public int getCurrentDomainSize() {
        return this.variableCurrentDomain.size();
    }

    public String getCurrentDomainFirstValue() {
        return (String)this.variableCurrentDomain.get(0);
    }

    public boolean isLastValueInCurrentDomain() {
        int currentIndex = this.variableCurrentDomain.indexOf(this.variableAssigned);
        return currentIndex == this.variableCurrentDomain.size() - 1;
    }

    public void setAssigned(String newAssignment) {
        this.boolAssigned = true;
        this.variableAssigned = newAssignment;
        LinkedList currentDomain = new LinkedList(this.getEntireDomain());
        while (currentDomain.size() > 0) {
            if (!((String)currentDomain.get(0)).equals(newAssignment)) {
                this.removeFromCurrentDomain((String)currentDomain.get(0));
            }
            currentDomain.remove(0);
        }
    }

    public void unSetAssigned() {
        this.boolAssigned = false;
        this.variableAssigned = null;
    }

    public boolean isAssigned() {
        return this.boolAssigned;
    }

    public String getAssigned() {
        return this.variableAssigned;
    }

    public void setDomain(String domainName) {
        this.variableInitialDomain = new LinkedList(this.parentProblem.getDomain(domainName).getDomainList());
        this.variableCurrentDomain = new LinkedList(this.parentProblem.getDomain(domainName).getDomainList());
    }

    public String getIndex() {
        return this.variableIndex;
    }

    public int getColumnIndex() {
        String[] variableIndexes = this.variableIndex.split(",");
        return Integer.parseInt(variableIndexes[0]);
    }

    public int getLineIndex() {
        String[] variableIndexes = this.variableIndex.split(",");
        return Integer.parseInt(variableIndexes[1]);
    }

    public String toString() {
        return this.variableAssigned;
    }

    public void addBinaryIntensiveConstraint(problemConstraint newConstraint) {
        this.variableBinaryIntensiveConstraints.add(newConstraint);
    }

    public void addNonBinaryIntensiveConstraint(problemConstraint newConstraint) {
        this.variableNonBinaryIntensiveConstraints.add(newConstraint);
    }

    public List getNonBinaryIntensiveConstraints() {
        return this.variableNonBinaryIntensiveConstraints;
    }

    public List getBinaryConstraints() {
        return this.variableBinaryIntensiveConstraints;
    }
}

