/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.binaryIntensiveConstraint;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.nonBinaryIntensiveConstraint;
import edu.unl.consystlab.sudokuSolver.problemDomain;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import java.io.IOException;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class parserXML3 {
    private constraintProblem describedProblem;

    public void parseXML3(String fileName) {
        this.describedProblem = new constraintProblem();
        try {
            DocumentBuilderFactory factoryBuilder = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factoryBuilder.newDocumentBuilder();
            Document doc = builder.parse(fileName);
            Element docElement = doc.getDocumentElement();
            NodeList currentNodeList = docElement.getElementsByTagName("presentation");
            this.interpretPresentation(currentNodeList);
            currentNodeList = docElement.getElementsByTagName("displayInfo");
            this.interpretDimensions(currentNodeList);
            this.generateDomain(this.describedProblem);
            this.generateVariables(this.describedProblem);
            this.generateConstraints();
            currentNodeList = docElement.getElementsByTagName("constraint");
            this.interpretPreassign(currentNodeList);
        }
        catch (IOException e) {
            System.out.println("IO ERROR");
            System.out.println(e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("IO ERROR");
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println("IO ERROR");
            System.out.println(e);
        }
    }

    public constraintProblem getProblem() {
        return this.describedProblem;
    }

    private void interpretPresentation(NodeList presentationNodeList) {
        if (presentationNodeList.getLength() != 1) {
            System.out.println("Error only expecting one Presentation attribute.  The result of this file is unpredictable");
        }
        String tempLine = presentationNodeList.item(0).getAttributes().getNamedItem("name").getNodeValue();
        this.describedProblem.setName(tempLine);
    }

    private String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    private void interpretDimensions(NodeList dimensionNodeList) {
        Element element = (Element)dimensionNodeList.item(0);
        NodeList rowSize = element.getElementsByTagName("rowSize");
        Element line = (Element)rowSize.item(0);
        String tempLines = this.getCharacterDataFromElement(line);
        NodeList columnSize = element.getElementsByTagName("columnSize");
        line = (Element)columnSize.item(0);
        String tempColumns = this.getCharacterDataFromElement(line);
        this.describedProblem.setDimensionsForXML3(tempLines, tempColumns);
    }

    private void interpretPreassign(NodeList variableNodeList) {
        for (int i = 0; i < variableNodeList.getLength(); ++i) {
            if (!variableNodeList.item(i).getAttributes().getNamedItem("reference").getNodeValue().equals("Preassigned")) continue;
            NodeList childNodes = variableNodeList.item(i).getChildNodes();
            String nodeValue = childNodes.item(0).getTextContent();
            String[] parameters = null;
            parameters = nodeValue.split(" ");
            String[] preAssignedCoords = null;
            preAssignedCoords = parameters[0].split("-");
            String variableLine = preAssignedCoords[0].replace("V", "");
            String variableColumn = preAssignedCoords[1];
            LinkedList<String> preassignedDomain = new LinkedList<String>();
            problemVariable meh = this.describedProblem.getVariable(variableLine + "," + variableColumn);
            meh.setAssigned(parameters[1]);
            preassignedDomain.add(parameters[1]);
            this.describedProblem.getVariable(variableLine + "," + variableColumn).setDomain(preassignedDomain);
        }
    }

    private void generateDomain(constraintProblem describedProblem) {
        problemDomain newDomain = new problemDomain("standardDomain", describedProblem);
        int max = describedProblem.linesPerUnit * describedProblem.columnsPerUnit;
        String range = "1.." + max;
        newDomain.addRangeToDomain(range);
    }

    private void generateVariables(constraintProblem parentProblem) {
        for (int lineIndex = 1; lineIndex <= parentProblem.totalLines; ++lineIndex) {
            for (int columnIndex = 1; columnIndex <= parentProblem.totalColumns; ++columnIndex) {
                problemVariable newVariable = new problemVariable(lineIndex + "," + columnIndex, this.describedProblem);
                newVariable.setDomain("standardDomain");
            }
        }
    }

    private void generateConstraints() {
        int unitLine;
        int cellLineIndex;
        for (cellLineIndex = 1; cellLineIndex <= this.describedProblem.totalLines; ++cellLineIndex) {
            for (int cellColumnIndex = 1; cellColumnIndex <= this.describedProblem.totalColumns; ++cellColumnIndex) {
                binaryIntensiveConstraint newConstraint;
                for (int colpointer = cellColumnIndex + 1; colpointer <= this.describedProblem.totalColumns; ++colpointer) {
                    newConstraint = new binaryIntensiveConstraint(cellLineIndex + "," + cellColumnIndex + " " + cellLineIndex + "," + colpointer, this.describedProblem);
                }
                for (int rowPointer = cellLineIndex + 1; rowPointer <= this.describedProblem.totalLines; ++rowPointer) {
                    newConstraint = new binaryIntensiveConstraint(cellLineIndex + "," + cellColumnIndex + " " + rowPointer + "," + cellColumnIndex, this.describedProblem);
                }
            }
        }
        for (unitLine = 0; unitLine < this.describedProblem.columnsPerUnit; ++unitLine) {
            for (int unitColumn = 0; unitColumn < this.describedProblem.linesPerUnit; ++unitColumn) {
                for (int unitLineIndex = 1; unitLineIndex <= this.describedProblem.linesPerUnit; ++unitLineIndex) {
                    for (int unitColumnIndex = 1; unitColumnIndex < this.describedProblem.columnsPerUnit; ++unitColumnIndex) {
                        for (int linePointerIndex = 1; linePointerIndex <= this.describedProblem.linesPerUnit; ++linePointerIndex) {
                            for (int columnPointerIndex = unitColumnIndex + 1; columnPointerIndex <= this.describedProblem.columnsPerUnit; ++columnPointerIndex) {
                                if (linePointerIndex == unitLineIndex) continue;
                                binaryIntensiveConstraint newConstraint = new binaryIntensiveConstraint(unitLine * this.describedProblem.linesPerUnit + unitLineIndex + "," + (unitColumn * this.describedProblem.columnsPerUnit + unitColumnIndex) + " " + (unitLine * this.describedProblem.linesPerUnit + linePointerIndex) + "," + (unitColumn * this.describedProblem.columnsPerUnit + columnPointerIndex), this.describedProblem);
                            }
                        }
                    }
                }
            }
        }
        for (cellLineIndex = 1; cellLineIndex <= this.describedProblem.totalLines; ++cellLineIndex) {
            String variablesAffected = "";
            for (int cellColumnIndex = 1; cellColumnIndex <= this.describedProblem.totalColumns; ++cellColumnIndex) {
                variablesAffected = variablesAffected + cellLineIndex + "," + cellColumnIndex + " ";
            }
            variablesAffected.trim();
            nonBinaryIntensiveConstraint newConstraint = new nonBinaryIntensiveConstraint(variablesAffected, this.describedProblem, "L" + cellLineIndex);
        }
        for (int cellColIndex = 1; cellColIndex <= this.describedProblem.totalLines; ++cellColIndex) {
            String variablesAffected = "";
            for (int cellLineIndex2 = 1; cellLineIndex2 <= this.describedProblem.totalColumns; ++cellLineIndex2) {
                variablesAffected = variablesAffected + cellLineIndex2 + "," + cellColIndex + " ";
            }
            variablesAffected.trim();
            nonBinaryIntensiveConstraint newConstraint = new nonBinaryIntensiveConstraint(variablesAffected, this.describedProblem, "C" + cellColIndex);
        }
        for (unitLine = 0; unitLine < this.describedProblem.columnsPerUnit; ++unitLine) {
            for (int unitColumn = 0; unitColumn < this.describedProblem.linesPerUnit; ++unitColumn) {
                String variablesAffected = "";
                for (int unitLineIndex = 1; unitLineIndex <= this.describedProblem.linesPerUnit; ++unitLineIndex) {
                    for (int unitColumnIndex = 1; unitColumnIndex <= this.describedProblem.columnsPerUnit; ++unitColumnIndex) {
                        variablesAffected = variablesAffected + (unitLine * this.describedProblem.linesPerUnit + unitLineIndex) + "," + (unitColumn * this.describedProblem.columnsPerUnit + unitColumnIndex) + " ";
                    }
                }
                variablesAffected.trim();
                nonBinaryIntensiveConstraint newConstraint = new nonBinaryIntensiveConstraint(variablesAffected, this.describedProblem, "U" + (unitLine + 1) + "," + (unitColumn + 1));
            }
        }
    }
}

