/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.binaryIntensiveConstraint;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.nonBinaryIntensiveConstraint;
import edu.unl.consystlab.sudokuSolver.problemDomain;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class parserArray {
    private constraintProblem describedProblem;
    private String[] numbers;

    public void parseArray(String[] tmpNumbers) {
        this.describedProblem = new constraintProblem();
        this.numbers = tmpNumbers;
        this.interpretPresentation();
        this.interpretDimensions();
        this.generateDomain(this.describedProblem);
        this.generateVariables(this.describedProblem);
        this.generateConstraints();
        this.interpretPreassign();
    }

    public void parseArray(String[] tmpNumbers, int diffLevel) {
        this.describedProblem = new constraintProblem();
        this.numbers = tmpNumbers;
        this.interpretPresentation(diffLevel);
        this.interpretDimensions();
        this.generateDomain(this.describedProblem);
        this.generateVariables(this.describedProblem);
        this.generateConstraints();
        this.interpretPreassign();
    }

    public constraintProblem getProblem() {
        return this.describedProblem;
    }

    private void interpretPresentation() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "MM-dd-yyyy-hhmmss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        this.describedProblem.setName(sdf.format(cal.getTime()));
    }

    private void interpretPresentation(int diffLevel) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "MM-dd-yyyy-hhmmss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        this.describedProblem.setName(sdf.format(cal.getTime()));
    }

    private String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    private void interpretDimensions() {
        this.describedProblem.setDimensionsForXML3("9", "9");
    }

    private void interpretPreassign() {
        int arrayIndex = 1;
        for (int i = 1; i <= 9; ++i) {
            for (int j = 1; j <= 9; ++j) {
                String tmpAsigned;
                problemVariable meh = this.describedProblem.getVariable(i + "," + j);
                if ((tmpAsigned = this.numbers[arrayIndex++]).equals("0") || tmpAsigned.equals(".")) continue;
                meh.setAssigned(tmpAsigned);
            }
        }
    }

    private void generateDomain(constraintProblem describedProblem) {
        problemDomain newDomain = new problemDomain("standardDomain", describedProblem);
        int max = describedProblem.linesPerUnit * describedProblem.columnsPerUnit;
        String range = "1.." + max;
        newDomain.addRangeToDomain(range);
    }

    private void generateVariables(constraintProblem parentProblem) {
        for (int lineIndex = 1; lineIndex <= parentProblem.totalLines; ++lineIndex) {
            for (int columnIndex = 1; columnIndex <= parentProblem.totalColumns; ++columnIndex) {
                problemVariable newVariable = new problemVariable(lineIndex + "," + columnIndex, this.describedProblem);
                newVariable.setDomain("standardDomain");
            }
        }
    }

    private void generateConstraints() {
        int unitLine;
        int cellLineIndex;
        for (cellLineIndex = 1; cellLineIndex <= this.describedProblem.totalLines; ++cellLineIndex) {
            for (int cellColumnIndex = 1; cellColumnIndex <= this.describedProblem.totalColumns; ++cellColumnIndex) {
                binaryIntensiveConstraint newConstraint;
                for (int colpointer = cellColumnIndex + 1; colpointer <= this.describedProblem.totalColumns; ++colpointer) {
                    newConstraint = new binaryIntensiveConstraint(cellLineIndex + "," + cellColumnIndex + " " + cellLineIndex + "," + colpointer, this.describedProblem);
                }
                for (int rowPointer = cellLineIndex + 1; rowPointer <= this.describedProblem.totalLines; ++rowPointer) {
                    newConstraint = new binaryIntensiveConstraint(cellLineIndex + "," + cellColumnIndex + " " + rowPointer + "," + cellColumnIndex, this.describedProblem);
                }
            }
        }
        for (unitLine = 0; unitLine < this.describedProblem.columnsPerUnit; ++unitLine) {
            for (int unitColumn = 0; unitColumn < this.describedProblem.linesPerUnit; ++unitColumn) {
                for (int unitLineIndex = 1; unitLineIndex <= this.describedProblem.linesPerUnit; ++unitLineIndex) {
                    for (int unitColumnIndex = 1; unitColumnIndex < this.describedProblem.columnsPerUnit; ++unitColumnIndex) {
                        for (int linePointerIndex = 1; linePointerIndex <= this.describedProblem.linesPerUnit; ++linePointerIndex) {
                            for (int columnPointerIndex = unitColumnIndex + 1; columnPointerIndex <= this.describedProblem.columnsPerUnit; ++columnPointerIndex) {
                                if (linePointerIndex == unitLineIndex) continue;
                                binaryIntensiveConstraint newConstraint = new binaryIntensiveConstraint(unitLine * this.describedProblem.linesPerUnit + unitLineIndex + "," + (unitColumn * this.describedProblem.columnsPerUnit + unitColumnIndex) + " " + (unitLine * this.describedProblem.linesPerUnit + linePointerIndex) + "," + (unitColumn * this.describedProblem.columnsPerUnit + columnPointerIndex), this.describedProblem);
                            }
                        }
                    }
                }
            }
        }
        for (cellLineIndex = 1; cellLineIndex <= this.describedProblem.totalLines; ++cellLineIndex) {
            String variablesAffected = "";
            for (int cellColumnIndex = 1; cellColumnIndex <= this.describedProblem.totalColumns; ++cellColumnIndex) {
                variablesAffected = variablesAffected + cellLineIndex + "," + cellColumnIndex + " ";
            }
            variablesAffected.trim();
            nonBinaryIntensiveConstraint newConstraint = new nonBinaryIntensiveConstraint(variablesAffected, this.describedProblem, "L" + cellLineIndex);
        }
        for (int cellColIndex = 1; cellColIndex <= this.describedProblem.totalLines; ++cellColIndex) {
            String variablesAffected = "";
            for (int cellLineIndex2 = 1; cellLineIndex2 <= this.describedProblem.totalColumns; ++cellLineIndex2) {
                variablesAffected = variablesAffected + cellLineIndex2 + "," + cellColIndex + " ";
            }
            variablesAffected.trim();
            nonBinaryIntensiveConstraint newConstraint = new nonBinaryIntensiveConstraint(variablesAffected, this.describedProblem, "C" + cellColIndex);
        }
        for (unitLine = 0; unitLine < this.describedProblem.columnsPerUnit; ++unitLine) {
            for (int unitColumn = 0; unitColumn < this.describedProblem.linesPerUnit; ++unitColumn) {
                String variablesAffected = "";
                for (int unitLineIndex = 1; unitLineIndex <= this.describedProblem.linesPerUnit; ++unitLineIndex) {
                    for (int unitColumnIndex = 1; unitColumnIndex <= this.describedProblem.columnsPerUnit; ++unitColumnIndex) {
                        variablesAffected = variablesAffected + (unitLine * this.describedProblem.linesPerUnit + unitLineIndex) + "," + (unitColumn * this.describedProblem.columnsPerUnit + unitColumnIndex) + " ";
                    }
                }
                variablesAffected.trim();
                nonBinaryIntensiveConstraint newConstraint = new nonBinaryIntensiveConstraint(variablesAffected, this.describedProblem, "U" + (unitLine + 1) + "," + (unitColumn + 1));
            }
        }
    }
}

