/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.graph;
import edu.unl.consystlab.sudokuSolver.graphNode;
import edu.unl.consystlab.sudokuSolver.intensiveConstraint;
import edu.unl.consystlab.sudokuSolver.nonBinaryConstraint;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import java.util.LinkedList;
import java.util.List;

public class nonBinaryIntensiveConstraint
extends nonBinaryConstraint
implements intensiveConstraint {
    private String key;
    private boolean isViolated;
    private graph matching = null;
    private graph constraintGraph;
    private List allNodes;

    public nonBinaryIntensiveConstraint(String constraintScopeString, constraintProblem currentProblem, String constraintKey) {
        super(constraintScopeString, currentProblem);
        int i;
        List constraintScope = new LinkedList();
        constraintScope = this.parseScope(constraintScopeString);
        currentProblem.addNonBinaryIntensiveConstraint(this, constraintKey);
        for (int i2 = 0; i2 < constraintScope.size(); ++i2) {
            ((problemVariable)constraintScope.get(i2)).addNonBinaryIntensiveConstraint(this);
        }
        this.allNodes = new LinkedList();
        int adjacencyMatrixIterator = 0;
        LinkedList domainValues = new LinkedList(currentProblem.getDomain().getDomainList());
        for (i = 0; i < domainValues.size(); ++i) {
            this.allNodes.add(new graphNode((String)domainValues.get(i), adjacencyMatrixIterator));
            ++adjacencyMatrixIterator;
        }
        for (i = 0; i < constraintScope.size(); ++i) {
            this.allNodes.add(new graphNode((problemVariable)constraintScope.get(i), adjacencyMatrixIterator));
            ++adjacencyMatrixIterator;
        }
        this.constraintGraph = new graph(this.allNodes);
        this.isViolated = false;
    }

    public List updateGraph() {
        this.constraintGraph.clear();
        LinkedList variableNodes = new LinkedList(this.constraintGraph.getVariableNodes());
        for (int variableIndex = 0; variableIndex < variableNodes.size(); ++variableIndex) {
            LinkedList variableValues = new LinkedList(((graphNode)variableNodes.get(variableIndex)).getVariable().getEntireDomain());
            for (int valuableIndex = 0; valuableIndex < variableValues.size(); ++valuableIndex) {
                graphNode valueNode = this.constraintGraph.getValueNode((String)variableValues.get(valuableIndex));
                this.constraintGraph.addBidirectionalEdge(valueNode, (graphNode)variableNodes.get(variableIndex));
            }
        }
        this.matching = this.constraintGraph.computeMaximumMatching(null);
        if (this.matching.getAllFreeNodes().size() == 0) {
            return this.constraintGraph.reduceGraph(this.matching);
        }
        return null;
    }

    public boolean isViolated() {
        return this.constraintGraph.getAllFreeNodes().size() != 0;
    }

    public List getAllNodes() {
        return this.allNodes;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }
}

