/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.arcConsistency;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.binaryForwardCheckAll;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.nonBinaryMAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.nonBinaryRestrictedArcConsistency;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingGAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingMAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingSingleGAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingSingleMAC;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.nonBinaryIntensiveConstraint;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class hints
extends Thread {
    private static String FC_LEVEL = "FC";
    private static String AC_LEVEL = "AC";
    private static String SINGLE_GAC_LEVEL = "Single GAC";
    private static String GAC_LEVEL = "GAC";
    private static String SINGLE_SAC_LEVEL = "Single SAC";
    private static String SAC_LEVEL = "SAC";
    private static String SINGLE_SGAC_LEVEL = "Single SGAC";
    private static String SGAC_LEVEL = "SGAC";
    private constraintProblem myOriginalProblem;
    private constraintProblem myInternalCopy;
    private String hintLevel;
    private String hintType;
    private int currentHintIndex;
    private List hintVariables;
    private List switchVariables;
    private problemConstraint errorConstraint;

    hints(constraintProblem originalProblem, constraintProblem myCopy) {
        this.myOriginalProblem = originalProblem;
        this.hintVariables = null;
        this.errorConstraint = null;
        this.hintLevel = null;
        this.hintType = null;
        this.currentHintIndex = -1;
        this.myInternalCopy = myCopy;
    }

    public void calculateHint() {
        try {
            this.calculateHint(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void incrementLevel() throws InterruptedException {
        this.hintVariables = null;
        this.errorConstraint = null;
        this.hintType = null;
        this.currentHintIndex = -1;
        this.myInternalCopy = this.myOriginalProblem.copy();
        if (this.hintLevel.equals(FC_LEVEL)) {
            this.calculateHint(AC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(AC_LEVEL)) {
            this.calculateHint(SINGLE_GAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SINGLE_GAC_LEVEL)) {
            this.calculateHint(GAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(GAC_LEVEL)) {
            this.calculateHint(SINGLE_SAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SINGLE_SAC_LEVEL)) {
            this.calculateHint(SAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SAC_LEVEL)) {
            this.calculateHint(SINGLE_SGAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SINGLE_SGAC_LEVEL)) {
            this.calculateHint(SGAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SGAC_LEVEL)) {
            this.calculateHint(FC_LEVEL);
            return;
        }
    }

    public void decrementLevel() throws InterruptedException {
        this.hintVariables = null;
        this.errorConstraint = null;
        this.hintType = null;
        this.currentHintIndex = -1;
        this.myInternalCopy = this.myOriginalProblem.copy();
        if (this.hintLevel.equals(AC_LEVEL)) {
            this.calculateHintPrev(FC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SINGLE_GAC_LEVEL)) {
            this.calculateHintPrev(AC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(GAC_LEVEL)) {
            this.calculateHintPrev(SINGLE_GAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SINGLE_SAC_LEVEL)) {
            this.calculateHintPrev(GAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SAC_LEVEL)) {
            this.calculateHintPrev(SINGLE_SAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SINGLE_SGAC_LEVEL)) {
            this.calculateHintPrev(SAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(SGAC_LEVEL)) {
            this.calculateHintPrev(SINGLE_SGAC_LEVEL);
            return;
        }
        if (this.hintLevel.equals(FC_LEVEL)) {
            this.calculateHintPrev(SGAC_LEVEL);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculateHint(String level) throws InterruptedException {
        shavingGAC mySGAC;
        LinkedList switchHintsList;
        LinkedList newHintsList;
        HashSet temp;
        LinkedList switchHintsList2;
        LinkedList newHintsList2;
        String currLevel;
        Set switchHints;
        Set newHints;
        if (this.myInternalCopy == null) {
            return;
        }
        if (level == null || level.equals(FC_LEVEL)) {
            binaryForwardCheckAll myFC = new binaryForwardCheckAll(this.myInternalCopy, null);
            if (this.runConsistencyLevel(FC_LEVEL, myFC)) {
                return;
            }
            level = null;
        }
        if (level == null || level.equals(AC_LEVEL)) {
            arcConsistency myAC = new arcConsistency(this.myInternalCopy, null);
            if (this.runConsistencyLevel(AC_LEVEL, myAC)) {
                return;
            }
            level = null;
            for (variableIndexAndValueGrouping currentReduction : myAC.getVariableReductions()) {
                this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
        }
        if (level == null || level.equals(SINGLE_GAC_LEVEL)) {
            HashSet gacSingletonHints = new HashSet();
            HashSet gacVitalHints = new HashSet();
            if (!this.runGACLineCol(gacSingletonHints, gacVitalHints, "L")) {
                return;
            }
            if (!this.runGACLineCol(gacSingletonHints, gacVitalHints, "C")) {
                return;
            }
            if (!this.runGACUnit(gacSingletonHints, gacVitalHints)) {
                return;
            }
            if (gacSingletonHints.size() > 0) {
                this.hintVariables = new LinkedList(gacSingletonHints);
                this.switchVariables = new LinkedList(gacVitalHints);
                this.errorConstraint = null;
                this.hintLevel = SINGLE_GAC_LEVEL;
                this.hintType = "Singleton";
                this.currentHintIndex = 0;
                return;
            }
            if (gacVitalHints.size() > 0) {
                this.hintVariables = new LinkedList(gacVitalHints);
                this.switchVariables = new LinkedList(gacSingletonHints);
                this.errorConstraint = null;
                this.hintLevel = SINGLE_GAC_LEVEL;
                this.hintType = "Vital";
                this.currentHintIndex = 0;
                return;
            }
            level = null;
        }
        if (level == null || level.equals(GAC_LEVEL)) {
            nonBinaryMAC myGAC = new nonBinaryMAC(this.myInternalCopy, null);
            if (this.runConsistencyLevel(GAC_LEVEL, myGAC)) {
                return;
            }
            level = null;
            for (variableIndexAndValueGrouping currentReduction : myGAC.getVariableReductions()) {
                this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
        }
        if (level == null || level.equals(SINGLE_SAC_LEVEL)) {
            newHints = new HashSet();
            switchHints = new HashSet();
            for (problemVariable currentVariable : this.myInternalCopy.getAllVariables()) {
                shavingSingleMAC mySingleSAC = new shavingSingleMAC(this.myInternalCopy, null, currentVariable);
                if (!((consistencyAlgorithm)mySingleSAC).runAlgorithm()) {
                    this.logError(mySingleSAC, SINGLE_SAC_LEVEL);
                    return;
                }
                newHints.addAll(this.checkSingletons());
                switchHints.addAll(this.checkVitals());
                for (variableIndexAndValueGrouping currentReduction : mySingleSAC.getVariableReductions()) {
                    this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
                }
            }
            currLevel = SINGLE_SAC_LEVEL;
            if (!newHints.isEmpty()) {
                newHintsList2 = new LinkedList(newHints);
                switchHintsList2 = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Singleton", newHintsList2, switchHintsList2);
                return;
            }
            temp = switchHints;
            switchHints = newHints;
            newHints = temp;
            if (!newHints.isEmpty()) {
                newHintsList = new LinkedList(newHints);
                switchHintsList = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Vital", newHintsList, switchHintsList);
                return;
            }
            level = null;
        }
        if (level == null || level.equals(SAC_LEVEL)) {
            shavingMAC mySAC = new shavingMAC(this.myInternalCopy, null);
            if (this.runConsistencyLevel(SAC_LEVEL, mySAC)) {
                return;
            }
            level = null;
            for (variableIndexAndValueGrouping currentReduction : mySAC.getVariableReductions()) {
                this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
        }
        if (level == null || level.equals(SINGLE_SGAC_LEVEL)) {
            newHints = new HashSet();
            switchHints = new HashSet();
            for (problemVariable currentVariable : this.myInternalCopy.getAllVariables()) {
                shavingSingleGAC mySingleSGAC = new shavingSingleGAC(this.myInternalCopy, null, currentVariable);
                if (!((consistencyAlgorithm)mySingleSGAC).runAlgorithm()) {
                    this.logError(mySingleSGAC, SINGLE_SGAC_LEVEL);
                    return;
                }
                newHints.addAll(this.checkSingletons());
                switchHints.addAll(this.checkVitals());
                for (variableIndexAndValueGrouping currentReduction : mySingleSGAC.getVariableReductions()) {
                    this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
                }
            }
            currLevel = SINGLE_SGAC_LEVEL;
            if (!newHints.isEmpty()) {
                newHintsList2 = new LinkedList(newHints);
                switchHintsList2 = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Singleton", newHintsList2, switchHintsList2);
                return;
            }
            temp = switchHints;
            switchHints = newHints;
            newHints = temp;
            if (!newHints.isEmpty()) {
                newHintsList = new LinkedList(newHints);
                switchHintsList = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Vital", newHintsList, switchHintsList);
                return;
            }
            level = null;
        }
        if ((level == null || level.equals(SGAC_LEVEL)) && this.runConsistencyLevel(SGAC_LEVEL, mySGAC = new shavingGAC(this.myInternalCopy, null))) {
            return;
        }
        this.hintVariables = null;
        this.errorConstraint = null;
        this.hintLevel = null;
        this.hintType = null;
        this.currentHintIndex = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculateHintPrev(String level) throws InterruptedException {
        LinkedList switchHintsList;
        LinkedList newHintsList;
        HashSet temp;
        LinkedList switchHintsList2;
        LinkedList newHintsList2;
        String currLevel;
        Set switchHints;
        Set newHints;
        shavingGAC mySGAC;
        if (this.myInternalCopy == null) {
            return;
        }
        if ((level == null || level.equals(SGAC_LEVEL)) && this.runConsistencyLevel(SGAC_LEVEL, mySGAC = new shavingGAC(this.myInternalCopy, null))) {
            return;
        }
        if (level == null || level.equals(SINGLE_SGAC_LEVEL)) {
            newHints = new HashSet();
            switchHints = new HashSet();
            for (problemVariable currentVariable : this.myInternalCopy.getAllVariables()) {
                shavingSingleGAC mySingleSGAC = new shavingSingleGAC(this.myInternalCopy, null, currentVariable);
                if (!((consistencyAlgorithm)mySingleSGAC).runAlgorithm()) {
                    this.logError(mySingleSGAC, SINGLE_SGAC_LEVEL);
                    return;
                }
                newHints.addAll(this.checkSingletons());
                switchHints.addAll(this.checkVitals());
                for (variableIndexAndValueGrouping currentReduction : mySingleSGAC.getVariableReductions()) {
                    this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
                }
            }
            currLevel = SINGLE_SGAC_LEVEL;
            if (!newHints.isEmpty()) {
                newHintsList2 = new LinkedList(newHints);
                switchHintsList2 = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Singleton", newHintsList2, switchHintsList2);
                return;
            }
            temp = switchHints;
            switchHints = newHints;
            newHints = temp;
            if (!newHints.isEmpty()) {
                newHintsList = new LinkedList(newHints);
                switchHintsList = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Vital", newHintsList, switchHintsList);
                return;
            }
            level = null;
        }
        if (level == null || level.equals(SAC_LEVEL)) {
            shavingMAC mySAC = new shavingMAC(this.myInternalCopy, null);
            if (this.runConsistencyLevel(SAC_LEVEL, mySAC)) {
                return;
            }
            level = null;
            for (variableIndexAndValueGrouping currentReduction : mySAC.getVariableReductions()) {
                this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
        }
        if (level == null || level.equals(SINGLE_SAC_LEVEL)) {
            newHints = new HashSet();
            switchHints = new HashSet();
            for (problemVariable currentVariable : this.myInternalCopy.getAllVariables()) {
                shavingSingleMAC mySingleSAC = new shavingSingleMAC(this.myInternalCopy, null, currentVariable);
                if (!((consistencyAlgorithm)mySingleSAC).runAlgorithm()) {
                    this.logError(mySingleSAC, SINGLE_SAC_LEVEL);
                    return;
                }
                newHints.addAll(this.checkSingletons());
                switchHints.addAll(this.checkVitals());
                for (variableIndexAndValueGrouping currentReduction : mySingleSAC.getVariableReductions()) {
                    this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
                }
            }
            currLevel = SINGLE_SAC_LEVEL;
            if (!newHints.isEmpty()) {
                newHintsList2 = new LinkedList(newHints);
                switchHintsList2 = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Singleton", newHintsList2, switchHintsList2);
                return;
            }
            temp = switchHints;
            switchHints = newHints;
            newHints = temp;
            if (!newHints.isEmpty()) {
                newHintsList = new LinkedList(newHints);
                switchHintsList = new LinkedList(switchHints);
                this.setPrivates(currLevel, "Vital", newHintsList, switchHintsList);
                return;
            }
            level = null;
        }
        if (level == null || level.equals(GAC_LEVEL)) {
            nonBinaryMAC myGAC = new nonBinaryMAC(this.myInternalCopy, null);
            if (this.runConsistencyLevel(GAC_LEVEL, myGAC)) {
                return;
            }
            level = null;
            for (variableIndexAndValueGrouping currentReduction : myGAC.getVariableReductions()) {
                this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
        }
        if (level == null || level.equals(SINGLE_GAC_LEVEL)) {
            HashSet gacSingletonHints = new HashSet();
            HashSet gacVitalHints = new HashSet();
            if (!this.runGACLineCol(gacSingletonHints, gacVitalHints, "L")) {
                return;
            }
            if (!this.runGACLineCol(gacSingletonHints, gacVitalHints, "C")) {
                return;
            }
            if (!this.runGACUnit(gacSingletonHints, gacVitalHints)) {
                return;
            }
            if (gacSingletonHints.size() > 0) {
                this.hintVariables = new LinkedList(gacSingletonHints);
                this.switchVariables = new LinkedList(gacVitalHints);
                this.errorConstraint = null;
                this.hintLevel = SINGLE_GAC_LEVEL;
                this.hintType = "Singleton";
                this.currentHintIndex = 0;
                return;
            }
            if (gacVitalHints.size() > 0) {
                this.hintVariables = new LinkedList(gacVitalHints);
                this.switchVariables = new LinkedList(gacSingletonHints);
                this.errorConstraint = null;
                this.hintLevel = SINGLE_GAC_LEVEL;
                this.hintType = "Vital";
                this.currentHintIndex = 0;
                return;
            }
            level = null;
        }
        if (level == null || level.equals(AC_LEVEL)) {
            arcConsistency myAC = new arcConsistency(this.myInternalCopy, null);
            if (this.runConsistencyLevel(AC_LEVEL, myAC)) {
                return;
            }
            level = null;
            for (variableIndexAndValueGrouping currentReduction : myAC.getVariableReductions()) {
                this.myInternalCopy.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            }
        }
        if (level == null || level.equals(FC_LEVEL)) {
            binaryForwardCheckAll myFC = new binaryForwardCheckAll(this.myInternalCopy, null);
            if (this.runConsistencyLevel(FC_LEVEL, myFC)) {
                return;
            }
            level = null;
        }
        this.hintVariables = null;
        this.errorConstraint = null;
        this.hintLevel = null;
        this.hintType = null;
        this.currentHintIndex = -1;
    }

    public boolean hasHint() {
        return this.hintVariables != null;
    }

    public boolean foundError() {
        return this.errorConstraint != null;
    }

    public problemConstraint getErrorConstraint() {
        if (this.errorConstraint == null) {
            return null;
        }
        LinkedList scope = new LinkedList(this.errorConstraint.getScope());
        if (scope.size() == 2) {
            LinkedList<problemVariable> key = new LinkedList<problemVariable>();
            key.add(this.myOriginalProblem.getVariable(((problemVariable)scope.get(0)).getIndex()));
            key.add(this.myOriginalProblem.getVariable(((problemVariable)scope.get(1)).getIndex()));
            return this.myOriginalProblem.getConstraint(key);
        }
        if (scope.size() == 9) {
            return this.myOriginalProblem.getNonBinaryIntensiveConstraint(((nonBinaryIntensiveConstraint)this.errorConstraint).getKey());
        }
        return null;
    }

    private boolean runConsistencyLevel(String currLevel, consistencyAlgorithm currAlg) throws InterruptedException {
        if (currAlg.runAlgorithm()) {
            return this.findHints(currLevel);
        }
        this.logError(currAlg, currLevel);
        return true;
    }

    private boolean runGACUnit(Collection gacSingletonHints, Collection gacVitalHints) throws InterruptedException {
        LinkedList<String> myReductions = new LinkedList<String>();
        this.myInternalCopy.registerDomainReductionListener(myReductions);
        int unitsWide = this.myInternalCopy.totalColumns / this.myInternalCopy.columnsPerUnit;
        int unitsHigh = this.myInternalCopy.totalLines / this.myInternalCopy.linesPerUnit;
        for (int row = 1; row <= unitsHigh; ++row) {
            for (int i = 1; i <= unitsWide; ++i) {
                nonBinaryRestrictedArcConsistency myGAC = new nonBinaryRestrictedArcConsistency(this.myInternalCopy, null, "U" + row + "," + i);
                if (((consistencyAlgorithm)myGAC).runAlgorithm()) continue;
                myReductions.add("deleteme");
                this.myInternalCopy.unregisterDomainReductionList(myReductions);
                myReductions.remove("deleteme");
                this.logError(myGAC, SINGLE_GAC_LEVEL);
                return false;
            }
        }
        gacSingletonHints.addAll(this.getSingletons(this.myInternalCopy));
        gacVitalHints.addAll(this.getVitalLinks(this.myInternalCopy));
        myReductions.add("deleteme");
        this.myInternalCopy.unregisterDomainReductionList(myReductions);
        myReductions.remove("deleteme");
        for (variableIndexAndValueGrouping variableIndexAndValueGrouping2 : myReductions) {
            this.myInternalCopy.getVariable(variableIndexAndValueGrouping2.getVariableIndex()).addToCurrentDomain(variableIndexAndValueGrouping2.getValue());
        }
        return true;
    }

    private boolean runGACLineCol(Collection gacSingletonHints, Collection gacVitalHints, String lineColType) throws InterruptedException {
        LinkedList<String> myReductions = new LinkedList<String>();
        this.myInternalCopy.registerDomainReductionListener(myReductions);
        int limit = 0;
        if (lineColType.equals("L")) {
            limit = this.myInternalCopy.totalLines;
        } else if (lineColType.equals("C")) {
            limit = this.myInternalCopy.totalColumns;
        }
        for (int i = 1; i < limit; ++i) {
            nonBinaryRestrictedArcConsistency nonBinaryRestrictedArcConsistency2 = new nonBinaryRestrictedArcConsistency(this.myInternalCopy, null, lineColType + i);
            if (((consistencyAlgorithm)nonBinaryRestrictedArcConsistency2).runAlgorithm()) continue;
            myReductions.add("deleteme");
            this.myInternalCopy.unregisterDomainReductionList(myReductions);
            myReductions.remove("deleteme");
            this.logError(nonBinaryRestrictedArcConsistency2, SINGLE_GAC_LEVEL);
            return false;
        }
        gacSingletonHints.addAll(this.getSingletons(this.myInternalCopy));
        gacVitalHints.addAll(this.getVitalLinks(this.myInternalCopy));
        myReductions.add("deleteme");
        this.myInternalCopy.unregisterDomainReductionList(myReductions);
        myReductions.remove("deleteme");
        for (variableIndexAndValueGrouping variableIndexAndValueGrouping2 : myReductions) {
            this.myInternalCopy.getVariable(variableIndexAndValueGrouping2.getVariableIndex()).addToCurrentDomain(variableIndexAndValueGrouping2.getValue());
        }
        return true;
    }

    private void logError(consistencyAlgorithm myAlg, String currLevel) {
        this.hintVariables = null;
        this.errorConstraint = myAlg.getBrokenConstraint();
        this.hintLevel = currLevel;
        this.hintType = "Error";
        this.currentHintIndex = -2;
    }

    private boolean findHints(String currLevel) {
        List newHints = this.checkSingletons();
        if (newHints.isEmpty()) {
            List switchHints = newHints;
            newHints = this.checkVitals();
            if (newHints.isEmpty()) {
                return false;
            }
            this.setPrivates(currLevel, "Vital", newHints, switchHints);
            return true;
        }
        List switchHints = this.checkVitals();
        this.setPrivates(currLevel, "Singleton", newHints, switchHints);
        return true;
    }

    private List checkSingletons() {
        LinkedList newHints = new LinkedList(this.getSingletons(this.myInternalCopy));
        return newHints;
    }

    private List checkVitals() {
        LinkedList newHints = new LinkedList(this.getVitalLinks(this.myInternalCopy));
        return newHints;
    }

    private void setPrivates(String currLevel, String currType, List hints2, List switchHints) {
        this.hintVariables = hints2;
        this.switchVariables = switchHints;
        this.errorConstraint = null;
        this.hintLevel = currLevel;
        this.hintType = currType;
        this.currentHintIndex = 0;
    }

    private Collection getSingletons(constraintProblem myProblem) {
        LinkedList<problemVariable> singletonVariables = new LinkedList<problemVariable>();
        LinkedList problemVariables = new LinkedList(myProblem.getAllVariables());
        for (problemVariable currentVariable : problemVariables) {
            if (currentVariable.isAssigned() || currentVariable.getCurrentDomainSize() != 1) continue;
            singletonVariables.add(currentVariable);
        }
        return singletonVariables;
    }

    private Collection getVitalLinks(constraintProblem myProblem) {
        int i;
        LinkedList<problemVariable> vitalLinkVariables = new LinkedList<problemVariable>();
        Hashtable[] lineValueFrequency = new Hashtable[this.myInternalCopy.totalLines + 1];
        for (i = 1; i <= this.myInternalCopy.totalLines; ++i) {
            lineValueFrequency[i] = new Hashtable();
        }
        Hashtable[] colValueFrequency = new Hashtable[this.myInternalCopy.totalColumns + 1];
        for (i = 1; i <= this.myInternalCopy.totalColumns; ++i) {
            colValueFrequency[i] = new Hashtable();
        }
        Hashtable[][] unitValueFrequency = new Hashtable[this.myInternalCopy.columnsPerUnit + 1][this.myInternalCopy.linesPerUnit + 1];
        for (i = 1; i <= this.myInternalCopy.columnsPerUnit; ++i) {
            for (int j = 1; j <= this.myInternalCopy.linesPerUnit; ++j) {
                unitValueFrequency[i][j] = new Hashtable();
            }
        }
        for (int colIndex = 1; colIndex <= this.myInternalCopy.totalColumns; ++colIndex) {
            for (int lineIndex = 1; lineIndex <= this.myInternalCopy.totalLines; ++lineIndex) {
                LinkedList valueList = new LinkedList(this.myInternalCopy.getVariable(colIndex + "," + lineIndex).getEntireDomain());
                while (!valueList.isEmpty()) {
                    String currentValue = (String)valueList.get(0);
                    valueList.remove(0);
                    if (!lineValueFrequency[lineIndex].containsKey(currentValue)) {
                        lineValueFrequency[lineIndex].put(currentValue, new Integer(1));
                    } else {
                        lineValueFrequency[lineIndex].put(currentValue, new Integer((Integer)lineValueFrequency[lineIndex].get(currentValue) + 1));
                    }
                    if (!colValueFrequency[colIndex].containsKey(currentValue)) {
                        colValueFrequency[colIndex].put(currentValue, new Integer(1));
                    } else {
                        colValueFrequency[colIndex].put(currentValue, new Integer((Integer)colValueFrequency[colIndex].get(currentValue) + 1));
                    }
                    if (!unitValueFrequency[(int)Math.floor((lineIndex - 1) / this.myInternalCopy.linesPerUnit) + 1][(int)Math.floor((colIndex - 1) / this.myInternalCopy.columnsPerUnit) + 1].containsKey(currentValue)) {
                        unitValueFrequency[(int)Math.floor((lineIndex - 1) / this.myInternalCopy.linesPerUnit) + 1][(int)Math.floor((colIndex - 1) / this.myInternalCopy.columnsPerUnit) + 1].put(currentValue, new Integer(1));
                        continue;
                    }
                    unitValueFrequency[(int)Math.floor((lineIndex - 1) / this.myInternalCopy.linesPerUnit) + 1][(int)Math.floor((colIndex - 1) / this.myInternalCopy.columnsPerUnit) + 1].put(currentValue, new Integer((Integer)unitValueFrequency[(int)Math.floor((lineIndex - 1) / this.myInternalCopy.linesPerUnit) + 1][(int)Math.floor((colIndex - 1) / this.myInternalCopy.columnsPerUnit) + 1].get(currentValue) + 1));
                }
            }
        }
        for (int xIndex = 1; xIndex <= this.myInternalCopy.totalLines; ++xIndex) {
            for (int yIndex = 1; yIndex <= this.myInternalCopy.totalColumns; ++yIndex) {
                if (this.myInternalCopy.getVariable(yIndex + "," + xIndex).isAssigned()) continue;
                Iterator i2 = this.myInternalCopy.getVariable(yIndex + "," + xIndex).getEntireDomain().iterator();
                while (i2.hasNext()) {
                    String value = (String)i2.next();
                    if (!(unitValueFrequency[(int)Math.floor((xIndex - 1) / this.myInternalCopy.linesPerUnit) + 1][(int)Math.floor((yIndex - 1) / this.myInternalCopy.columnsPerUnit) + 1].containsKey(value) && (Integer)unitValueFrequency[(int)Math.floor((xIndex - 1) / this.myInternalCopy.linesPerUnit) + 1][(int)Math.floor((yIndex - 1) / this.myInternalCopy.columnsPerUnit) + 1].get(value) == 1 || colValueFrequency[yIndex].containsKey(value) && (Integer)colValueFrequency[yIndex].get(value) == 1) && (!lineValueFrequency[xIndex].containsKey(value) || (Integer)lineValueFrequency[xIndex].get(value) != 1)) continue;
                    vitalLinkVariables.add(this.myInternalCopy.getVariable(yIndex + "," + xIndex));
                    while (i2.hasNext()) {
                        i2.next();
                    }
                }
            }
        }
        return vitalLinkVariables;
    }

    public String getHintType() {
        return this.hintType;
    }

    public String getHintLevel() {
        return this.hintLevel;
    }

    public void incrementHintIndex() {
        if (this.hintVariables == null) {
            return;
        }
        this.currentHintIndex = this.currentHintIndex >= this.hintVariables.size() - 1 ? 0 : ++this.currentHintIndex;
    }

    public void decrementHintIndex() {
        if (this.hintVariables == null) {
            return;
        }
        this.currentHintIndex = this.currentHintIndex <= 0 ? this.hintVariables.size() - 1 : --this.currentHintIndex;
    }

    public int getCurrentHintIndex() {
        return this.currentHintIndex;
    }

    public int getHintVariablesSize() {
        if (this.hintVariables == null) {
            return -1;
        }
        return this.hintVariables.size();
    }

    public problemVariable getCurrentHintVariable() {
        problemVariable copyVar = (problemVariable)this.hintVariables.get(this.currentHintIndex);
        return this.myOriginalProblem.getVariable(copyVar.getIndex());
    }

    public void switchType() {
        if (this.hintType.equals("Error")) {
            return;
        }
        List temp = this.hintVariables;
        this.hintVariables = this.switchVariables;
        this.switchVariables = temp;
        if (this.hintType.equals("Vital")) {
            this.hintType = "Singelton";
        } else if (this.hintType.equals("Singleton")) {
            this.hintType = "Vital";
        }
        this.currentHintIndex = 0;
    }
}

