/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.graphNode;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class graph {
    private int[][] adjacencyMatrix;
    private List allNodes;
    private List valueNodes;
    private List variableNodes;
    private Hashtable htblValueNodes;
    private Hashtable htblVariableNodes;
    private Hashtable adjacencyValueLookup;

    public graph(List graphNodes) {
        int i;
        this.adjacencyMatrix = new int[graphNodes.size()][graphNodes.size()];
        for (i = 0; i < graphNodes.size(); ++i) {
            for (int j = 0; j < graphNodes.size(); ++j) {
                this.adjacencyMatrix[i][j] = 0;
            }
        }
        this.allNodes = new LinkedList(graphNodes);
        this.valueNodes = new LinkedList();
        this.variableNodes = new LinkedList();
        this.htblValueNodes = new Hashtable();
        this.htblVariableNodes = new Hashtable();
        this.adjacencyValueLookup = new Hashtable();
        for (i = 0; i < this.allNodes.size(); ++i) {
            if (((graphNode)this.allNodes.get(i)).isVariable()) {
                this.variableNodes.add(this.allNodes.get(i));
                this.htblVariableNodes.put(((graphNode)this.allNodes.get(i)).getVariable(), this.allNodes.get(i));
            } else if (((graphNode)this.allNodes.get(i)).isValue()) {
                this.valueNodes.add(this.allNodes.get(i));
                this.htblValueNodes.put(((graphNode)this.allNodes.get(i)).getValue(), this.allNodes.get(i));
            } else {
                System.out.println("Error in graph object, unknown node type");
            }
            this.adjacencyValueLookup.put(new Integer(((graphNode)this.allNodes.get(i)).getAdjacencyValue()), this.allNodes.get(i));
        }
    }

    public int[][] getAdjacencyMatrix() {
        return this.adjacencyMatrix;
    }

    public graph(graph oldGraph) {
        int i;
        this.allNodes = new LinkedList(oldGraph.getAllNodes());
        int graphSize = oldGraph.getAllNodes().size();
        int[][] ogAdjacencyMatrix = oldGraph.getAdjacencyMatrix();
        this.adjacencyMatrix = new int[graphSize][graphSize];
        for (i = 0; i < graphSize; ++i) {
            for (int j = 0; j < graphSize; ++j) {
                this.adjacencyMatrix[i][j] = ogAdjacencyMatrix[i][j];
            }
        }
        this.valueNodes = new LinkedList();
        this.variableNodes = new LinkedList();
        this.htblValueNodes = new Hashtable();
        this.htblVariableNodes = new Hashtable();
        this.adjacencyValueLookup = new Hashtable();
        for (i = 0; i < this.allNodes.size(); ++i) {
            if (((graphNode)this.allNodes.get(i)).isVariable()) {
                this.variableNodes.add(this.allNodes.get(i));
                this.htblVariableNodes.put(((graphNode)this.allNodes.get(i)).getVariable(), this.allNodes.get(i));
            } else if (((graphNode)this.allNodes.get(i)).isValue()) {
                this.valueNodes.add(this.allNodes.get(i));
                this.htblValueNodes.put(((graphNode)this.allNodes.get(i)).getValue(), this.allNodes.get(i));
            } else {
                System.out.println("Error in graph object, unknown node type");
            }
            this.adjacencyValueLookup.put(new Integer(((graphNode)this.allNodes.get(i)).getAdjacencyValue()), this.allNodes.get(i));
        }
    }

    public List getAllFreeNodes() {
        List allNodes = this.getAllNodes();
        LinkedList freeNodes = new LinkedList();
        for (int i = 0; i < allNodes.size(); ++i) {
            if (!this.isFreeNode((graphNode)allNodes.get(i))) continue;
            freeNodes.add(allNodes.get(i));
        }
        return freeNodes;
    }

    public boolean isFreeNode(graphNode checkNode) {
        int i;
        int nodeAdjValue = checkNode.getAdjacencyValue();
        for (i = 0; i < this.allNodes.size(); ++i) {
            if (this.adjacencyMatrix[nodeAdjValue][i] != 1) continue;
            return false;
        }
        for (i = 0; i < this.allNodes.size(); ++i) {
            if (this.adjacencyMatrix[i][nodeAdjValue] != 1) continue;
            return false;
        }
        return true;
    }

    public void addVital(graphNode newVital) {
    }

    public graphNode getNode(int adjacencyValue) {
        return (graphNode)this.adjacencyValueLookup.get(new Integer(adjacencyValue));
    }

    public List getAllNodes() {
        return this.allNodes;
    }

    public List getValueNodes() {
        return this.valueNodes;
    }

    public List getVariableNodes() {
        return this.variableNodes;
    }

    public void clear() {
        for (int i = 0; i < this.allNodes.size(); ++i) {
            for (int j = 0; j < this.allNodes.size(); ++j) {
                this.adjacencyMatrix[i][j] = 0;
            }
        }
    }

    public void makeBidirectional() {
        for (int row = 0; row < this.allNodes.size(); ++row) {
            for (int col = 0; col < this.allNodes.size(); ++col) {
                if (this.adjacencyMatrix[row][col] != 1) continue;
                this.adjacencyMatrix[col][row] = 1;
            }
        }
    }

    public graph getTransverse() {
        graph result = new graph(this);
        int[][] transverseMatrix = result.getAdjacencyMatrix();
        int[][] originalMatrix = this.getAdjacencyMatrix();
        for (int row = 0; row < result.getNodeNumber(); ++row) {
            for (int col = 0; col < result.getNodeNumber(); ++col) {
                transverseMatrix[row][col] = originalMatrix[col][row];
            }
        }
        return result;
    }

    public graphNode getValueNode(String value) {
        return (graphNode)this.htblValueNodes.get(value);
    }

    public graphNode getVariableNode(problemVariable variable) {
        return (graphNode)this.htblVariableNodes.get(variable);
    }

    public void addBidirectionalEdge(graphNode firstNode, graphNode secondNode) {
        this.adjacencyMatrix[firstNode.getAdjacencyValue()][secondNode.getAdjacencyValue()] = 1;
        this.adjacencyMatrix[secondNode.getAdjacencyValue()][firstNode.getAdjacencyValue()] = 1;
    }

    public int getNodeNumber() {
        return this.allNodes.size();
    }

    public void addEdge(int startPoint, int endPoint) {
        this.adjacencyMatrix[startPoint][endPoint] = 1;
    }

    public void addEdge(graphNode startNode, graphNode endNode) {
        int startPoint = startNode.getAdjacencyValue();
        int endPoint = endNode.getAdjacencyValue();
        this.adjacencyMatrix[startPoint][endPoint] = 1;
    }

    public void removeAllOutEdges(graphNode startNode) {
        int startPoint = startNode.getAdjacencyValue();
        for (int i = 0; i < this.getNodeNumber(); ++i) {
            this.adjacencyMatrix[startPoint][i] = 0;
        }
    }

    public void removeEdge(int startPoint, int endPoint) {
        this.adjacencyMatrix[startPoint][endPoint] = 0;
    }

    public void removeEdge(graphNode startNode, graphNode endNode) {
        int startPoint = startNode.getAdjacencyValue();
        int endPoint = endNode.getAdjacencyValue();
        this.adjacencyMatrix[startPoint][endPoint] = 0;
    }

    public boolean existsEdge(int startPoint, int endPoint) {
        return this.adjacencyMatrix[startPoint][endPoint] == 1;
    }

    public List getNodesConnectedTo(graphNode endNode) {
        LinkedList<graphNode> connectedNodes = new LinkedList<graphNode>();
        int endPoint = endNode.getAdjacencyValue();
        for (int i = 0; i < this.getNodeNumber(); ++i) {
            if (this.adjacencyMatrix[i][endPoint] != 1) continue;
            connectedNodes.add(this.getNode(i));
        }
        return connectedNodes;
    }

    public void xorWith(graph otherGraph) {
        int[][] ogAM = otherGraph.getAdjacencyMatrix();
        for (int row = 0; row < this.getNodeNumber(); ++row) {
            for (int col = 0; col < this.getNodeNumber(); ++col) {
                this.adjacencyMatrix[row][col] = this.adjacencyMatrix[row][col] ^ ogAM[row][col];
            }
        }
    }

    public List getNodesPointedTo(graphNode startNode) {
        LinkedList<graphNode> connectedNodes = new LinkedList<graphNode>();
        int startPoint = startNode.getAdjacencyValue();
        for (int i = 0; i < this.getNodeNumber(); ++i) {
            if (this.adjacencyMatrix[startPoint][i] != 1) continue;
            connectedNodes.add(this.getNode(i));
        }
        return connectedNodes;
    }

    public graph computeMaximumMatching(graph partialMatching) {
        if (partialMatching == null) {
            partialMatching = new graph(this.allNodes);
        }
        partialMatching.makeBidirectional();
        graph directedGraph = new graph(this);
        int[][] dgAdjacencyMatrix = directedGraph.getAdjacencyMatrix();
        for (int col = 0; col < directedGraph.getNodeNumber(); ++col) {
            for (int row = 0; row < directedGraph.getNodeNumber(); ++row) {
                if (dgAdjacencyMatrix[row][col] != 1) continue;
                if (partialMatching.existsEdge(row, col)) {
                    if (directedGraph.getNode(row).isValue()) {
                        directedGraph.removeEdge(row, col);
                        continue;
                    }
                    directedGraph.removeEdge(col, row);
                    continue;
                }
                if (directedGraph.getNode(row).isValue()) {
                    directedGraph.removeEdge(col, row);
                    continue;
                }
                directedGraph.removeEdge(row, col);
            }
        }
        graph searchGraph = new graph(directedGraph.getAllNodes());
        HashSet[] L = new HashSet[directedGraph.getNodeNumber()];
        L[0] = new HashSet();
        boolean stopBuilding = false;
        boolean noAugmentPathsExist = false;
        noAugmentPathsExist = true;
        List pmVars = partialMatching.getVariableNodes();
        for (int i = 0; i < pmVars.size(); ++i) {
            if (!partialMatching.isFreeNode((graphNode)pmVars.get(i))) continue;
            noAugmentPathsExist = false;
            L[0].add(pmVars.get(i));
        }
        if (noAugmentPathsExist) {
            return partialMatching;
        }
        L[1] = new HashSet();
        if (!stopBuilding) {
            noAugmentPathsExist = true;
            for (graphNode currentNode : L[0]) {
                List connectedNodes = directedGraph.getNodesConnectedTo(currentNode);
                for (int j = 0; j < connectedNodes.size(); ++j) {
                    noAugmentPathsExist = false;
                    L[1].add(connectedNodes.get(j));
                    searchGraph.addEdge((graphNode)connectedNodes.get(j), currentNode);
                }
            }
            if (noAugmentPathsExist) {
                return partialMatching;
            }
            List freeGirls = partialMatching.getMatchingFreeValues(L[1]);
            if (freeGirls.size() > 0) {
                stopBuilding = true;
                for (graphNode currentNode : L[1]) {
                    if (freeGirls.contains(currentNode)) continue;
                    searchGraph.removeAllOutEdges(currentNode);
                }
            }
        }
        int currentLevel = 1;
        while (!stopBuilding) {
            List freeGirls;
            noAugmentPathsExist = true;
            L[++currentLevel] = new HashSet();
            for (graphNode currentNode : L[currentLevel - 1]) {
                List connectedNodes = directedGraph.getNodesConnectedTo(currentNode);
                for (int j = 0; j < connectedNodes.size(); ++j) {
                    boolean addNode = true;
                    for (int k = currentLevel - 2; k >= 0; k -= 2) {
                        if (!L[k].contains(connectedNodes.get(j))) continue;
                        addNode = false;
                    }
                    if (addNode) {
                        noAugmentPathsExist = false;
                        L[currentLevel].add(connectedNodes.get(j));
                    }
                    searchGraph.addEdge((graphNode)connectedNodes.get(j), currentNode);
                }
            }
            if (noAugmentPathsExist) {
                return partialMatching;
            }
            if (currentLevel % 2 != 1 || stopBuilding || (freeGirls = partialMatching.getMatchingFreeValues(L[currentLevel])).size() <= 0) continue;
            stopBuilding = true;
            for (graphNode currentNode : L[currentLevel]) {
                if (freeGirls.contains(currentNode)) continue;
                searchGraph.removeAllOutEdges(currentNode);
            }
        }
        directedGraph.clear();
        Iterator sourceNodes = L[currentLevel].iterator();
        Stack nodeStack = new Stack();
        HashSet<graphNode> B = new HashSet<graphNode>();
        if (sourceNodes.hasNext()) {
            nodeStack.push(sourceNodes.next());
        }
        while (!nodeStack.isEmpty()) {
            while (!nodeStack.isEmpty() && searchGraph.getNodesPointedTo((graphNode)nodeStack.peek()).size() > 0) {
                graphNode firstNode = (graphNode)searchGraph.getNodesPointedTo((graphNode)nodeStack.peek()).get(0);
                searchGraph.removeEdge((graphNode)nodeStack.peek(), firstNode);
                if (B.contains(firstNode)) continue;
                nodeStack.push(firstNode);
                B.add(firstNode);
                if (!L[0].contains(nodeStack.peek())) continue;
                graphNode tempNode = (graphNode)nodeStack.pop();
                while (nodeStack.size() > 0) {
                    directedGraph.addBidirectionalEdge(tempNode, (graphNode)nodeStack.peek());
                    tempNode = (graphNode)nodeStack.pop();
                }
                if (!sourceNodes.hasNext()) continue;
                nodeStack.push(sourceNodes.next());
            }
            if (!nodeStack.isEmpty()) {
                nodeStack.pop();
                if (!nodeStack.isEmpty() || !sourceNodes.hasNext()) continue;
                nodeStack.push(sourceNodes.next());
                continue;
            }
            if (!sourceNodes.hasNext()) continue;
            nodeStack.push(sourceNodes.next());
        }
        partialMatching.xorWith(directedGraph);
        this.computeMaximumMatching(partialMatching);
        return partialMatching;
    }

    public List reduceGraph(graph matching) {
        LinkedList removedEdges = new LinkedList();
        if (matching.getAllFreeNodes().size() != 0) {
            return null;
        }
        graph directedGraph = new graph(this);
        int[][] dgAdjacencyMatrix = directedGraph.getAdjacencyMatrix();
        for (int col = 0; col < directedGraph.getNodeNumber(); ++col) {
            for (int row = 0; row < directedGraph.getNodeNumber(); ++row) {
                if (dgAdjacencyMatrix[row][col] != 1) continue;
                if (matching.existsEdge(row, col)) {
                    if (directedGraph.getNode(row).isValue()) {
                        directedGraph.removeEdge(row, col);
                        continue;
                    }
                    directedGraph.removeEdge(col, row);
                    continue;
                }
                if (directedGraph.getNode(row).isValue()) {
                    directedGraph.removeEdge(col, row);
                    continue;
                }
                directedGraph.removeEdge(row, col);
            }
        }
        graph transverse = directedGraph.getTransverse();
        LinkedList orderLeft = new LinkedList();
        List allNodes = directedGraph.getAllNodes();
        Iterator sourceNodes = allNodes.iterator();
        Stack nodeStack = new Stack();
        HashSet arrived = new HashSet();
        if (sourceNodes.hasNext()) {
            nodeStack.push(sourceNodes.next());
            arrived.add(nodeStack.peek());
        }
        while (!nodeStack.isEmpty()) {
            while (!nodeStack.isEmpty() && directedGraph.getNodesPointedTo((graphNode)nodeStack.peek()).size() > 0) {
                graphNode firstNode = (graphNode)directedGraph.getNodesPointedTo((graphNode)nodeStack.peek()).get(0);
                directedGraph.removeEdge((graphNode)nodeStack.peek(), firstNode);
                if (arrived.contains(firstNode)) continue;
                nodeStack.push(firstNode);
                arrived.add(firstNode);
            }
            orderLeft.addFirst(nodeStack.pop());
            while (nodeStack.isEmpty() && sourceNodes.hasNext()) {
                Object next = sourceNodes.next();
                if (arrived.contains(next)) continue;
                nodeStack.push(next);
                arrived.add(nodeStack.peek());
            }
        }
        nodeStack = new Stack();
        arrived = new HashSet();
        Hashtable stronglyConnectedComponents = new Hashtable();
        int sccInt = 0;
        Integer sccInteger = sccInt;
        if (!orderLeft.isEmpty()) {
            nodeStack.push(orderLeft.getFirst());
            arrived.add(nodeStack.peek());
            stronglyConnectedComponents.put(nodeStack.peek(), sccInteger);
        }
        while (!nodeStack.isEmpty()) {
            while (!nodeStack.isEmpty() && transverse.getNodesPointedTo((graphNode)nodeStack.peek()).size() > 0) {
                List nodesPointedTo = transverse.getNodesPointedTo((graphNode)nodeStack.peek());
                Iterator possibleNode = nodesPointedTo.iterator();
                Object nextNode = possibleNode.next();
                while (arrived.contains(nextNode) && possibleNode.hasNext()) {
                    nextNode = possibleNode.next();
                }
                Object firstNode = nextNode;
                while (possibleNode.hasNext()) {
                    Object secondNode = possibleNode.next();
                    if (arrived.contains(secondNode) || orderLeft.indexOf(secondNode) >= orderLeft.indexOf(firstNode)) continue;
                    firstNode = secondNode;
                }
                transverse.removeEdge((graphNode)nodeStack.peek(), (graphNode)firstNode);
                if (arrived.contains(firstNode)) continue;
                nodeStack.push(firstNode);
                arrived.add(firstNode);
                stronglyConnectedComponents.put(nodeStack.peek(), sccInteger);
            }
            nodeStack.pop();
            if (!nodeStack.isEmpty()) continue;
            sccInteger = ++sccInt;
            Iterator leftNodes = orderLeft.iterator();
            while (nodeStack.isEmpty() && leftNodes.hasNext()) {
                Object next = leftNodes.next();
                if (arrived.contains(next)) continue;
                nodeStack.push(next);
                arrived.add(nodeStack.peek());
                stronglyConnectedComponents.put(nodeStack.peek(), sccInteger);
            }
        }
        for (int col = 0; col < this.getNodeNumber(); ++col) {
            for (int row = 0; row < this.getNodeNumber(); ++row) {
                if (this.adjacencyMatrix[row][col] != 1 || ((Integer)stronglyConnectedComponents.get(this.getNode(row))).equals((Integer)stronglyConnectedComponents.get(this.getNode(col))) || matching.existsEdge(row, col)) continue;
                this.adjacencyMatrix[row][col] = 0;
                this.adjacencyMatrix[col][row] = 0;
                LinkedList<graphNode> removedEdge = new LinkedList<graphNode>();
                if (this.getNode(row).isVariable()) {
                    this.getNode(row).getVariable().removeFromCurrentDomain(this.getNode(col).getValue());
                    removedEdge.add(this.getNode(row));
                    removedEdge.add(this.getNode(col));
                } else if (this.getNode(col).isVariable()) {
                    this.getNode(col).getVariable().removeFromCurrentDomain(this.getNode(row).getValue());
                    removedEdge.add(this.getNode(row));
                    removedEdge.add(this.getNode(col));
                }
                removedEdges.add(removedEdge);
            }
        }
        return removedEdges;
    }

    private List getMatchingFreeValues(Set currentLevel) {
        LinkedList<graphNode> freeValues = new LinkedList<graphNode>();
        if (currentLevel == null) {
            return freeValues;
        }
        for (graphNode currentNode : currentLevel) {
            if (!this.isFreeNode(currentNode)) continue;
            freeValues.add(currentNode);
        }
        return freeValues;
    }
}

