/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import com.sun.org.apache.xalan.internal.xsltc.runtime.Hashtable;
import edu.unl.consystlab.sudokuSolver.assignSingletons;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.arcConsistency;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.binaryForwardCheckOnVariable;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.nonBinaryMAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingGAC;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingMAC;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class forwardCheckingSearch {
    private constraintProblem problem;
    private List solutions = new LinkedList();
    private Stack solutionTree;
    private Stack domainReductions;
    public int BACKTRACKS;

    public forwardCheckingSearch(constraintProblem newProblem) {
        this.problem = newProblem;
        this.solutionTree = new Stack();
        this.domainReductions = new Stack();
    }

    public int getSolutionNum() {
        return this.solutions.size();
    }

    public List getSolutions() {
        return this.solutions;
    }

    public void solve() throws InterruptedException {
        this.BACKTRACKS = 0;
        if (!this.runConsistancyAlgorithms()) {
            return;
        }
        for (int lineIndex = 1; lineIndex <= this.problem.totalLines; ++lineIndex) {
            for (int columnIndex = 1; columnIndex <= this.problem.totalColumns; ++columnIndex) {
                if (!this.problem.getVariable(lineIndex + "," + columnIndex).isAssigned()) continue;
                problemVariable currentVariable = this.problem.getVariable(lineIndex + "," + columnIndex);
                this.solutionTree.push(currentVariable);
                if (this.reduceDomains(currentVariable)) continue;
                return;
            }
        }
        int noSolutionCutoff = this.solutionTree.size();
        problemVariable currentVariable = this.getNextVariable();
        if (currentVariable == null) {
            String[][] newSolution = new String[this.problem.totalLines + 1][this.problem.totalColumns + 1];
            for (problemVariable currVar : this.solutionTree) {
                newSolution[currVar.getLineIndex()][currVar.getColumnIndex()] = currVar.getAssigned();
            }
            this.solutions.add(newSolution);
            return;
        }
        Hashtable initialPosibleValues = new Hashtable();
        do {
            boolean consistentValue;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            do {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                consistentValue = true;
                if (!currentVariable.isAssigned()) {
                    if (currentVariable.getCurrentDomainSize() != 0) {
                        initialPosibleValues.put((Object)currentVariable, (Object)new domainIterator(new LinkedList(currentVariable.getEntireDomain())));
                        currentVariable.setAssigned((String)((LinkedList)((domainIterator)initialPosibleValues.get((Object)currentVariable)).myList).get(0));
                        ++((domainIterator)initialPosibleValues.get((Object)currentVariable)).nextIndex;
                        consistentValue = this.reduceDomains(currentVariable);
                        if (!consistentValue) {
                            this.unreduceDomains();
                            continue;
                        }
                        this.solutionTree.push(currentVariable);
                        currentVariable = this.getNextVariable();
                        continue;
                    }
                    if (this.solutionTree.size() != noSolutionCutoff) {
                        consistentValue = false;
                        currentVariable.unSetAssigned();
                        currentVariable.setCurrentDomain(((domainIterator)initialPosibleValues.get((Object)currentVariable)).myList);
                        currentVariable = (problemVariable)this.solutionTree.pop();
                        this.unreduceDomains();
                        continue;
                    }
                    return;
                }
                domainIterator currentIterator = (domainIterator)initialPosibleValues.get((Object)currentVariable);
                if (currentIterator.nextIndex < currentIterator.myList.size()) {
                    currentVariable.setAssigned((String)currentIterator.myList.get(currentIterator.nextIndex));
                    ++currentIterator.nextIndex;
                    consistentValue = this.reduceDomains(currentVariable);
                    if (!consistentValue) {
                        this.unreduceDomains();
                        continue;
                    }
                    this.solutionTree.push(currentVariable);
                    currentVariable = this.getNextVariable();
                    continue;
                }
                if (this.solutionTree.size() != noSolutionCutoff) {
                    consistentValue = false;
                    currentVariable.unSetAssigned();
                    currentVariable.setCurrentDomain(((domainIterator)initialPosibleValues.get((Object)currentVariable)).myList);
                    currentVariable = (problemVariable)this.solutionTree.pop();
                    this.unreduceDomains();
                    continue;
                }
                return;
            } while (!consistentValue);
            if (currentVariable != null) continue;
            String[][] newSolution = new String[this.problem.totalLines + 1][this.problem.totalColumns + 1];
            for (problemVariable currVar : this.solutionTree) {
                newSolution[currVar.getLineIndex()][currVar.getColumnIndex()] = currVar.getAssigned();
            }
            this.solutions.add(newSolution);
            if (this.solutions.size() > 50) {
                return;
            }
            currentVariable = (problemVariable)this.solutionTree.pop();
            this.unreduceDomains();
        } while (currentVariable != null);
    }

    public void printSolution() {
        System.out.println("Solutions:" + this.solutions.size());
        for (int solutionIndex = this.solutions.size() - 1; solutionIndex >= 0; --solutionIndex) {
            String[][] solutionArray = (String[][])this.solutions.get(solutionIndex);
            for (int lineIndex = 1; lineIndex <= this.problem.totalLines; ++lineIndex) {
                for (int columnIndex = 1; columnIndex <= this.problem.totalColumns; ++columnIndex) {
                    System.out.print(solutionArray[lineIndex][columnIndex]);
                    if (columnIndex % this.problem.columnsPerUnit == 0 && columnIndex != this.problem.totalColumns) {
                        System.out.print("|");
                        continue;
                    }
                    if (columnIndex != this.problem.totalColumns) continue;
                    System.out.print('\n');
                }
                if (lineIndex % this.problem.linesPerUnit != 0 || lineIndex == this.problem.totalLines) continue;
                for (int i = 0; i < this.problem.totalColumns + this.problem.linesPerUnit - 1; ++i) {
                    System.out.print("-");
                }
                System.out.print('\n');
            }
            if (solutionIndex == 0) continue;
            System.out.println("+");
        }
        System.out.println("BACKTRACKS : " + this.BACKTRACKS);
    }

    private boolean runConsistancyAlgorithms() throws InterruptedException {
        arcConsistency myAC = new arcConsistency(this.problem, null);
        if (!((consistencyAlgorithm)myAC).runAlgorithm()) {
            return false;
        }
        nonBinaryMAC myGAC = new nonBinaryMAC(this.problem, null);
        if (!((consistencyAlgorithm)myGAC).runAlgorithm()) {
            return false;
        }
        assignSingletons myAssignSingletons = new assignSingletons(this.problem);
        myAssignSingletons.runAlgorithm();
        shavingMAC myShavingAC = new shavingMAC(this.problem, null);
        if (!((consistencyAlgorithm)myShavingAC).runAlgorithm()) {
            return false;
        }
        myAssignSingletons.runAlgorithm();
        shavingGAC myShavingGAC = new shavingGAC(this.problem, null);
        if (!((consistencyAlgorithm)myShavingGAC).runAlgorithm()) {
            return false;
        }
        myAssignSingletons.runAlgorithm();
        return true;
    }

    private void unreduceDomains() {
        ++this.BACKTRACKS;
        LinkedList domainsToUnreduce = (LinkedList)this.domainReductions.pop();
        while (domainsToUnreduce != null && domainsToUnreduce.size() != 0) {
            variableIndexAndValueGrouping currentReduction = (variableIndexAndValueGrouping)domainsToUnreduce.get(0);
            this.problem.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
            domainsToUnreduce.remove(0);
        }
    }

    public boolean reduceDomains(problemVariable masterVariable) throws InterruptedException {
        binaryForwardCheckOnVariable mybinaryForwardCheck = new binaryForwardCheckOnVariable(this.problem, null, masterVariable);
        ((consistencyAlgorithm)mybinaryForwardCheck).runAlgorithm();
        this.domainReductions.push(mybinaryForwardCheck.getVariableReductions());
        return !mybinaryForwardCheck.isEncounteredError();
    }

    private problemVariable getNextVariable() {
        for (int lineIndex = 1; lineIndex <= this.problem.totalLines; ++lineIndex) {
            for (int columnIndex = 1; columnIndex <= this.problem.totalColumns; ++columnIndex) {
                if (this.problem.getVariable(lineIndex + "," + columnIndex).isAssigned()) continue;
                problemVariable nextVariable = this.problem.getVariable(lineIndex + "," + columnIndex);
                return nextVariable;
            }
        }
        return null;
    }

    class domainIterator {
        public List myList;
        public int nextIndex;

        public domainIterator(List newList) {
            this.myList = newList;
            this.nextIndex = 0;
        }
    }
}

