/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.dbmysql;
import edu.unl.consystlab.sudokuSolver.parserArray;
import edu.unl.consystlab.sudokuSolver.parserXML;
import edu.unl.consystlab.sudokuSolver.parserXML3;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuInterface;
import edu.unl.consystlab.sudokuSolver.testXMLFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class constructorInterface
extends JPanel
implements ActionListener,
ItemListener {
    private final String LIBRARY_LOCATION = "http://consystlab.unl.edu/SudokuLibrary/";
    private final int PLAYING_BOARD_X_POS = 40;
    private final int PLAYING_BOARD_Y_POS = 40;
    private String autoPropogationType;
    private boolean showDomains;
    private String sudoku_type;
    private String problemLocation;
    private JPanel controlPanel;
    private JPanel inputPanel;
    private JComboBox suTypeList;
    private ItemListener suTypeListListener;
    private JTextField sourceField;
    private JTextField lowerField;
    private JTextField upperField;
    private JTextField levelField;
    private JTextField nameField;
    private JTextField originalField;
    private JTextArea descriptionField;
    private JScrollPane scrollDescriptionField;
    public Map extraRegionCells;
    private Map evenOddCells;
    private JLabel inputNumLabel;
    private JLabel defaultLabel;
    private JTextField inputNumField;
    private JButton chooser;
    private String batchFile;
    private List soluList;
    private JFrame aboutBox;
    private JButton cancelButton;
    private int puzzlesInDB = 0;
    private String[] puzzleNumbers;
    private DocumentBuilderFactory factoryBuilder = null;
    private DocumentBuilder builder = null;
    private Document doc = null;
    private JLabel numberEliminatedLabel;
    private JLabel numSolutions;
    private JComboBox puzzTypeBox;
    private JComboBox diffBox;
    private JComboBox maxDiffBox;
    private JTextField matchesBox;
    private JList queryResults;
    private String[][] results;
    private Thread t;
    private JComboBox numSolBox;
    private String orderBy;
    private JComboBox consisBox;
    private String puzzleType;
    private String maxLevel;
    private String level;
    private int numSol;
    private String consistency;
    private boolean queried = false;
    private JButton dbDefaultBtn2;
    private JButton dbDefaultBtn3;
    private JButton dbDefaultBtn4;
    private JButton dbDefaultBtn5;
    private JButton dbDefaultBtn6;
    private sudokuInterface parentInterface;

    public constructorInterface() {
        this.initialize();
    }

    public constructorInterface(sudokuInterface parent) {
        this.parentInterface = parent;
        this.initialize();
    }

    public void initialize() {
        Font standardbutton = new Font("Times Unicode", 0, 10);
        Font standardlabel = new Font("Times Unicode", 0, 12);
        int xloc = 80;
        this.sudoku_type = "Base";
        this.setSize(499, 538);
        this.setLayout(null);
        this.setFont(standardlabel);
        JLabel label1 = new JLabel("Sudoku Type");
        label1.setLocation(xloc, 15);
        label1.setSize(200, 20);
        label1.setFont(standardlabel);
        this.add(label1);
        String[] typeStrings = new String[]{"Base"};
        this.suTypeList = new JComboBox<String>(typeStrings);
        this.suTypeList.setFont(standardlabel);
        this.suTypeList.setSelectedIndex(0);
        this.suTypeList.setActionCommand("type");
        this.suTypeList.addFocusListener(new FocusAdapter(){
            int aux_selected;

            public void focusGained(FocusEvent fe) {
                this.aux_selected = constructorInterface.this.suTypeList.getSelectedIndex();
                constructorInterface.this.suTypeListListener = new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1 && aux_selected != constructorInterface.this.suTypeList.getSelectedIndex()) {
                            System.out.println("ComboBox Changed !");
                            System.out.println("ItemListener has been started.");
                            constructorInterface.this.sudoku_type = (String)constructorInterface.this.suTypeList.getSelectedItem();
                            System.out.println(constructorInterface.this.sudoku_type);
                            if (constructorInterface.this.sudoku_type == "Extra-Regions") {
                                constructorInterface.this.extraRegionCells = new HashMap();
                                constructorInterface.this.extraRegionCells.put("2,3", new Integer(1));
                                constructorInterface.this.extraRegionCells.put("2,4", new Integer(2));
                                constructorInterface.this.extraRegionCells.put("2,5", new Integer(3));
                                constructorInterface.this.extraRegionCells.put("3,3", new Integer(4));
                                constructorInterface.this.extraRegionCells.put("3,4", new Integer(5));
                                constructorInterface.this.extraRegionCells.put("3,5", new Integer(6));
                                constructorInterface.this.extraRegionCells.put("4,3", new Integer(7));
                                constructorInterface.this.extraRegionCells.put("4,4", new Integer(8));
                                constructorInterface.this.extraRegionCells.put("4,5", new Integer(9));
                                constructorInterface.this.initialize_extra_region();
                            } else if (constructorInterface.this.sudoku_type == "Even-Odd") {
                                constructorInterface.this.evenOddCells = new HashMap();
                                constructorInterface.this.evenOddCells.put("2,3", new Integer(1));
                                constructorInterface.this.evenOddCells.put("2,4", new Integer(1));
                                constructorInterface.this.evenOddCells.put("2,5", new Integer(1));
                                constructorInterface.this.evenOddCells.put("3,3", new Integer(1));
                                constructorInterface.this.evenOddCells.put("3,4", new Integer(1));
                                constructorInterface.this.evenOddCells.put("3,5", new Integer(1));
                                constructorInterface.this.evenOddCells.put("4,3", new Integer(1));
                                constructorInterface.this.evenOddCells.put("4,4", new Integer(1));
                                constructorInterface.this.evenOddCells.put("4,5", new Integer(1));
                                constructorInterface.this.evenOddCells.put("5,3", new Integer(1));
                                constructorInterface.this.evenOddCells.put("6,1", new Integer(1));
                                constructorInterface.this.evenOddCells.put("6,7", new Integer(1));
                                constructorInterface.this.evenOddCells.put("8,7", new Integer(1));
                                constructorInterface.this.evenOddCells.put("9,2", new Integer(1));
                                constructorInterface.this.initialize_even_odd();
                            }
                        }
                    }
                };
                constructorInterface.this.suTypeList.addItemListener(constructorInterface.this.suTypeListListener);
            }

            public void focusLost(FocusEvent fe) {
                constructorInterface.this.suTypeList.removeItemListener(constructorInterface.this.suTypeListListener);
            }
        });
        this.suTypeList.setLocation(xloc, 36);
        this.suTypeList.setSize(110, 23);
        this.add(this.suTypeList);
        JLabel label2 = new JLabel("Source (e.g., URL, your name)");
        label2.setLocation(xloc, 67);
        label2.setSize(300, 20);
        label2.setFont(standardlabel);
        this.add(label2);
        this.sourceField = new JTextField(20);
        this.sourceField.addActionListener(this);
        this.sourceField.setDocument(new JTextFieldLimit(50));
        this.sourceField.setLocation(xloc, 94);
        this.sourceField.setSize(250, 20);
        this.sourceField.setFont(standardlabel);
        this.add(this.sourceField);
        JLabel label3 = new JLabel("Difficulty level:");
        label3.setLocation(xloc, 120);
        label3.setSize(250, 20);
        label3.setFont(standardlabel);
        this.add(label3);
        JLabel label4 = new JLabel("Min         This Puzzle              Max");
        label4.setLocation(xloc, 144);
        label4.setSize(250, 20);
        label4.setFont(standardlabel);
        this.add(label4);
        this.lowerField = new JTextField(10);
        this.lowerField.setFont(standardlabel);
        this.lowerField.setEditable(false);
        this.lowerField.setDocument(new JTextFieldLimit(2));
        this.lowerField.setText("1");
        this.lowerField.addActionListener(this);
        this.lowerField.setLocation(xloc, 168);
        this.lowerField.setSize(25, 20);
        this.add(this.lowerField);
        this.levelField = new JTextField(10);
        this.levelField.setFont(standardlabel);
        this.levelField.setDocument(new JTextFieldLimit(2));
        this.levelField.setText("1");
        this.levelField.addActionListener(this);
        this.levelField.setLocation(xloc + 70, 168);
        this.levelField.setSize(25, 20);
        this.add(this.levelField);
        this.upperField = new JTextField(10);
        this.upperField.setFont(standardlabel);
        this.upperField.setDocument(new JTextFieldLimit(2));
        this.upperField.setText("5");
        this.upperField.addActionListener(this);
        this.upperField.setLocation(xloc + 150, 168);
        this.upperField.setSize(25, 20);
        this.add(this.upperField);
        JLabel label6 = new JLabel("Name of Puzzle");
        label6.setLocation(xloc, 195);
        label6.setSize(190, 20);
        label6.setFont(standardlabel);
        this.add(label6);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "MM-dd-yyyy-hhmmss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        this.nameField = new JTextField(10);
        this.nameField.addActionListener(this);
        this.nameField.setDocument(new JTextFieldLimit(50));
        this.nameField.setLocation(xloc, 219);
        this.nameField.setText(sdf.format(cal.getTime()));
        this.nameField.setFont(standardlabel);
        this.nameField.setSize(250, 20);
        this.add(this.nameField);
        JLabel label7 = new JLabel("Name of Puzzle in Original Source");
        label7.setLocation(xloc, 246);
        label7.setFont(standardlabel);
        label7.setSize(200, 20);
        this.add(label7);
        this.originalField = new JTextField(10);
        this.originalField.setFont(standardlabel);
        this.originalField.setText("");
        this.originalField.addActionListener(this);
        this.originalField.setLocation(xloc, 270);
        this.originalField.setDocument(new JTextFieldLimit(50));
        this.originalField.setSize(320, 20);
        this.add(this.originalField);
        JLabel label8 = new JLabel("Enter Description");
        label8.setLocation(xloc, 297);
        label8.setFont(standardlabel);
        label8.setSize(200, 20);
        this.add(label8);
        this.descriptionField = new JTextArea("Sudoku Puzzle");
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setFont(standardlabel);
        this.descriptionField.setDocument(new JTextFieldLimit(150));
        this.descriptionField.setWrapStyleWord(true);
        this.scrollDescriptionField = new JScrollPane(this.descriptionField, 22, 30);
        this.scrollDescriptionField.setLocation(xloc, 321);
        this.scrollDescriptionField.setSize(340, 62);
        this.scrollDescriptionField.setFont(standardlabel);
        this.scrollDescriptionField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add(this.scrollDescriptionField);
        JButton displaySolutionsButton = new JButton("Display Solutions");
        displaySolutionsButton.setActionCommand("displaySolutions");
        displaySolutionsButton.addActionListener(this);
        displaySolutionsButton.setLocation(xloc, 440);
        displaySolutionsButton.setSize(120, 30);
        displaySolutionsButton.setFont(standardbutton);
        this.add(displaySolutionsButton);
        JButton numSolutionsButton = new JButton("# Solutions:");
        numSolutionsButton.setActionCommand("findSolutions");
        numSolutionsButton.addActionListener(this);
        numSolutionsButton.setLocation(xloc, 400);
        numSolutionsButton.setSize(100, 30);
        numSolutionsButton.setFont(standardbutton);
        this.add(numSolutionsButton);
        this.numSolutions = new JLabel("");
        this.numSolutions.setFont(standardlabel);
        this.numSolutions.setLocation(xloc + 130, 410);
        this.numSolutions.setSize(60, 15);
        this.add(this.numSolutions);
        JButton btnSubmit = new JButton();
        btnSubmit.setText("Submit Puzzle");
        btnSubmit.addActionListener(this);
        btnSubmit.setActionCommand("submit");
        btnSubmit.setLocation(xloc + 220, 480);
        btnSubmit.setSize(120, 30);
        btnSubmit.setFont(standardbutton);
        this.add(btnSubmit);
        JButton btnResetGridProblem = new JButton();
        btnResetGridProblem.setText("Reset Grid");
        btnResetGridProblem.addActionListener(this);
        btnResetGridProblem.setActionCommand("resetGrid");
        btnResetGridProblem.setLocation(xloc, 480);
        btnResetGridProblem.setSize(100, 30);
        btnResetGridProblem.setFont(standardbutton);
        this.add(btnResetGridProblem);
        JButton btnResetAllProblem = new JButton();
        btnResetAllProblem.setFont(standardbutton);
        btnResetAllProblem.setText("Reset All");
        btnResetAllProblem.addActionListener(this);
        btnResetAllProblem.setActionCommand("resetAll");
        btnResetAllProblem.setLocation(xloc + 110, 480);
        btnResetAllProblem.setSize(100, 30);
        this.add(btnResetAllProblem);
        JCheckBox domainBox = new JCheckBox("Show domains", true);
        domainBox.setActionCommand("showDomains");
        domainBox.setSize(110, 20);
        domainBox.setFont(standardlabel);
        domainBox.setLocation(130, 36);
        domainBox.setBackground(Color.WHITE);
        domainBox.addItemListener(this);
        this.showDomains = true;
        this.autoPropogationType = "propNone";
        this.repaint();
    }

    public void initialize_extra_region() {
        JCheckBox extraRegionBox = new JCheckBox("Select Extra Region", true);
        extraRegionBox.setActionCommand("extra regions");
        extraRegionBox.setSize(200, 20);
        extraRegionBox.setLocation(10, 15);
        extraRegionBox.setBackground(Color.WHITE);
        extraRegionBox.addItemListener(this);
        this.controlPanel.add(extraRegionBox);
        this.repaint();
    }

    public void initialize_even_odd() {
        JCheckBox evenOddBox = new JCheckBox("Select Odd Cells", true);
        evenOddBox.setActionCommand("even-odd");
        evenOddBox.setSize(200, 20);
        evenOddBox.setLocation(10, 15);
        evenOddBox.setBackground(Color.WHITE);
        evenOddBox.addItemListener(this);
        this.controlPanel.add(evenOddBox);
        this.repaint();
    }

    public void setsuTypeList(String suType) {
        this.suTypeList.setSelectedItem(suType);
    }

    public void setSourceField(String source) {
        this.sourceField.setText(source);
    }

    public void setLowerField(String lower) {
        this.lowerField.setText(lower);
    }

    public void setUpperField(String upper) {
        this.upperField.setText(upper);
    }

    public void setNameField(String name) {
        this.nameField.setText(name);
    }

    public void setLevelField(String level) {
        this.levelField.setText(level);
    }

    public void setOriginalField(String original) {
        this.originalField.setText(original);
    }

    public void setDescriptionField(String description) {
        this.descriptionField.setText(description);
    }

    public void setNumSolutionsField(String numSol) {
        this.numSolutions.setText(numSol);
    }

    public String getNameField() {
        return this.nameField.getText();
    }

    public String getSourceField() {
        return this.sourceField.getText();
    }

    public String getLowerField() {
        return this.lowerField.getText();
    }

    public String getUpperField() {
        return this.upperField.getText();
    }

    public String getLevelField() {
        return this.levelField.getText();
    }

    public String getOriginalField() {
        return this.originalField.getText();
    }

    public String getDescriptionField() {
        return this.descriptionField.getText();
    }

    public String getSelectedSuType() {
        return (String)this.suTypeList.getSelectedItem();
    }

    public String getSudoku_Type() {
        return this.sudoku_type;
    }

    public String getNumSolutionsField() {
        return this.numSolutions.getText();
    }

    public JLabel getNumSolutions() {
        return this.numSolutions;
    }

    private constraintProblem loadProblemFromArray(String[] numArray) {
        parserArray myparser = new parserArray();
        myparser.parseArray(numArray);
        System.out.println("Load constraint from array");
        return myparser.getProblem();
    }

    private constraintProblem loadProblemFromArray(String[] numArray, int diffLevel) {
        parserArray myparser = new parserArray();
        myparser.parseArray(numArray, diffLevel);
        System.out.println("Load constraint from array");
        return myparser.getProblem();
    }

    public void writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public String xmlToString(Document doc) {
        try {
            DOMSource source = new DOMSource(doc);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void displayLineOfFile(String address) {
        Font standard = new Font("Times Unicode", 0, 11);
        this.batchFile = address;
        int numOfLines = 0;
        try {
            numOfLines = this.count(this.batchFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String rangeOfFile = "[1.." + numOfLines + "]";
        this.inputNumLabel = new JLabel();
        this.inputNumLabel.setLocation(10, 10);
        this.inputNumLabel.setSize(300, 20);
        this.inputNumLabel.setFont(standard);
        this.inputNumLabel.setText("Please choose an instance in " + rangeOfFile + "?");
        this.add(this.inputNumLabel);
        this.inputNumField = new JTextField();
        this.inputNumField.setLocation(260, 10);
        this.inputNumField.setSize(100, 20);
        this.add(this.inputNumField);
        this.chooser = new JButton("Submit");
        this.chooser.setActionCommand("Choose");
        this.chooser.setFont(standard);
        this.chooser.addActionListener(this);
        this.chooser.setLocation(10, 35);
        this.chooser.setSize(100, 20);
        this.add(this.chooser);
        this.defaultLabel = new JLabel();
        this.defaultLabel.setLocation(260, 35);
        this.defaultLabel.setSize(250, 20);
        this.defaultLabel.setFont(standard);
        this.defaultLabel.setText("(Default/out of range =1)");
        this.add(this.defaultLabel);
        this.repaint();
    }

    public int count(String fileName) throws IOException {
        String line;
        int numLines = 0;
        URL source = new URL(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(source.openStream()));
        do {
            if ((line = br.readLine()) == null) continue;
            ++numLines;
        } while (line != null);
        return numLines;
    }

    public void writeLibraryIndex(String indexLocation, String fileName, String indexPath) {
        try {
            DocumentBuilderFactory factoryBuilder = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factoryBuilder.newDocumentBuilder();
            Document doc = builder.parse(indexLocation);
            Element docElement = doc.getDocumentElement();
            NodeList children = docElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1 || !children.item(i).getNodeName().equals("directory") || !children.item(i).getAttributes().getNamedItem("name").getNodeValue().equals("UsersInput")) continue;
                Node firstChild = this.findNodeItem(children.item(i), "Difficulty0.." + this.upperField.getText());
                Node secondChild = this.findNodeItem(firstChild, "Level" + this.levelField.getText());
                Node thirdChild = this.findNodeItem(secondChild, (String)this.suTypeList.getSelectedItem());
                Element newFile = doc.createElement("file");
                newFile.setAttribute("name", fileName);
                thirdChild.appendChild(newFile);
            }
        }
        catch (IOException e) {
            System.out.println("IO ERROR7");
            System.out.println(e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("IO ERROR8");
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println("IO ERROR9");
            System.out.println(e);
        }
    }

    private Node findNodeItem(Node currentNode, String nodeValue) {
        try {
            NodeList children = currentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1 || !children.item(i).getNodeName().equals("directory") || !children.item(i).getAttributes().getNamedItem("name").getNodeValue().equals(nodeValue)) continue;
                return children.item(i);
            }
        }
        catch (Exception e) {
            System.out.println("IO ERROR");
            System.out.println(e);
            return null;
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("submit")) {
            this.parentInterface.submitPuzzle();
        } else if (e.getActionCommand().equals("fromdb")) {
            int selected = this.queryResults.getSelectedIndex();
            int puzzle = Integer.parseInt(this.results[selected][6]);
        } else if (e.getActionCommand().equals("query")) {
            this.orderBy = "PuzzleName";
            this.puzzleType = this.puzzTypeBox.getSelectedItem().toString();
            this.maxLevel = this.maxDiffBox.getSelectedItem().toString();
            this.level = this.diffBox.getSelectedItem().toString();
            this.numSol = this.numSolBox.getSelectedIndex();
            this.consistency = this.consisBox.getSelectedItem().toString();
            this.queried = true;
            try {
                dbmysql database = new dbmysql();
                this.results = database.populateList(this.puzzTypeBox.getSelectedItem().toString(), this.maxDiffBox.getSelectedItem().toString(), this.diffBox.getSelectedItem().toString(), this.numSolBox.getSelectedIndex(), this.consisBox.getSelectedItem().toString(), this.orderBy);
                this.queryResults.setListData((E[])this.results);
            }
            catch (Exception ex) {
                Logger.getLogger(constructorInterface.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (e.getActionCommand().equals("orderby1")) {
            if (this.queried) {
                this.orderBy = this.orderBy.equalsIgnoreCase("PuzzleName") ? "PuzzleName DESC" : "PuzzleName";
                try {
                    dbmysql database = new dbmysql();
                    this.results = database.populateList(this.puzzleType, this.maxLevel, this.level, this.numSol, this.consistency, this.orderBy);
                    this.queryResults.setListData((E[])this.results);
                }
                catch (Exception ex) {}
            }
        } else if (e.getActionCommand().equals("orderby2")) {
            if (this.queried) {
                this.orderBy = this.orderBy.equalsIgnoreCase("MaxDiffLvl") ? "MaxDiffLvl DESC" : "MaxDiffLvl";
                try {
                    dbmysql database = new dbmysql();
                    this.results = database.populateList(this.puzzleType, this.maxLevel, this.level, this.numSol, this.consistency, this.orderBy);
                    this.queryResults.setListData((E[])this.results);
                }
                catch (Exception ex) {}
            }
        } else if (e.getActionCommand().equals("orderby3")) {
            if (this.queried) {
                this.orderBy = this.orderBy.equalsIgnoreCase("DiffLvl") ? "DiffLvl DESC" : "DiffLvl";
                try {
                    dbmysql database = new dbmysql();
                    this.results = database.populateList(this.puzzleType, this.maxLevel, this.level, this.numSol, this.consistency, this.orderBy);
                    this.queryResults.setListData((E[])this.results);
                }
                catch (Exception ex) {}
            }
        } else if (e.getActionCommand().equals("orderby4")) {
            if (this.queried) {
                this.orderBy = this.orderBy.equalsIgnoreCase("Source") ? "Source DESC" : "Source";
                try {
                    dbmysql database = new dbmysql();
                    this.results = database.populateList(this.puzzleType, this.maxLevel, this.level, this.numSol, this.consistency, this.orderBy);
                    this.queryResults.setListData((E[])this.results);
                }
                catch (Exception ex) {}
            }
        } else if (e.getActionCommand().equals("orderby5")) {
            if (this.queried) {
                this.orderBy = this.orderBy.equalsIgnoreCase("Solutions") ? "Solutions DESC" : "Solutions";
                try {
                    dbmysql database = new dbmysql();
                    this.results = database.populateList(this.puzzleType, this.maxLevel, this.level, this.numSol, this.consistency, this.orderBy);
                    this.queryResults.setListData((E[])this.results);
                }
                catch (Exception ex) {}
            }
        } else if (e.getActionCommand().equals("orderby6")) {
            if (this.queried) {
                this.orderBy = this.orderBy.equalsIgnoreCase("Consistency") ? "Consistency DESC" : "Consistency";
                try {
                    dbmysql database = new dbmysql();
                    this.results = database.populateList(this.puzzleType, this.maxLevel, this.level, this.numSol, this.consistency, this.orderBy);
                    this.queryResults.setListData((E[])this.results);
                }
                catch (Exception ex) {}
            }
        } else if (e.getActionCommand().equals("canceldb")) {
            this.initialize();
        } else if (e.getActionCommand().equals("load")) {
            Frame parent = new Frame();
            FileDialog openDialog = new FileDialog(parent, "load", 0);
            openDialog.setVisible(true);
            String inputFile = openDialog.getFile();
            if (inputFile != null) {
                this.initialize();
            }
        } else if (e.getActionCommand().equals("findSolutions")) {
            this.numSolutions.setText("...");
            this.parentInterface.findSolutions();
        } else if (e.getActionCommand().equals("XML")) {
            String XMLfile = this.parentInterface.generateSudokuXML();
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter("/Users/jasongaare/puzzle.xml"));
                bw.write(XMLfile);
            }
            catch (IOException ex) {}
        } else if (e.getActionCommand().equals("stop!")) {
            this.t.interrupt();
            this.numSolutions.setText("Unknown");
        } else if (e.getActionCommand().equals("displaySolutions")) {
            JOptionPane.showMessageDialog(this.parentInterface, "Currently cannot display solutions.");
            System.out.println("displaySolutions starts...");
        } else if (e.getActionCommand().equals("next")) {
            this.parentInterface.displayNextSols(this.soluList);
            System.out.println("next doing...");
        } else if (e.getActionCommand().equals("prev")) {
            this.parentInterface.displayPrevSols(this.soluList);
            System.out.println("prev doing...");
        } else if (e.getActionCommand().equals("back")) {
            this.parentInterface.backToOrigProblem();
            System.out.println("back to constructor...");
        } else if (e.getActionCommand().equals("resetGrid")) {
            this.parentInterface.resetGrid();
        } else if (e.getActionCommand().equals("resetAll")) {
            this.parentInterface.loadNewProblemWithResetAll(this.problemLocation);
        } else if (e.getActionCommand().equals("Choose")) {
            int num = Integer.parseInt(this.inputNumField.getText());
            this.parentInterface.loadNewProblemFromFile(num);
        } else if (e.getActionCommand().equals("Open")) {
            int num = Integer.parseInt(this.inputNumField.getText());
            if (num <= 0 || num > 100) {
                num = 1;
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(3);
            nf.setMaximumIntegerDigits(3);
            String sb = nf.format(num);
            this.batchFile = this.batchFile + sb;
        }
    }

    public void removeAllEvenOddCells() {
        this.evenOddCells.clear();
    }

    public void itemStateChanged(ItemEvent e) {
        JCheckBox item;
        if (!(e.getItem() instanceof JCheckBox) || (item = (JCheckBox)e.getItem()).getActionCommand() == "showDomains" || (item.getActionCommand() == "extra regions" ? item.isSelected() : item.getActionCommand() != "even-odd" || item.isSelected())) {
            // empty if block
        }
    }

    public void runDomainColoring() {
    }

    public void doAutoPropogation() {
        if (this.autoPropogationType.equals("propNone")) {
            return;
        }
        if (this.autoPropogationType.equals("propNonBinaryFC") || this.autoPropogationType.equals("propBinaryFC") || this.autoPropogationType.equals("propBinaryMAC") || this.autoPropogationType.equals("propNonBinaryMAC") || this.autoPropogationType.equals("prop2RC")) {
            // empty if block
        }
    }

    public void doAutoPropogation(problemVariable originalVariable) {
        if (this.autoPropogationType.equals("propNone")) {
            return;
        }
        if (this.autoPropogationType.equals("propBinaryFC")) {
            // empty if block
        }
        if (this.autoPropogationType.equals("propBinaryMAC")) {
            // empty if block
        }
    }

    public void setAutoPropogationType(String new_type) {
        this.autoPropogationType = new_type;
        if (this.autoPropogationType.equals("propBinaryFC") || this.autoPropogationType.equals("propBinaryMAC")) {
            // empty if block
        }
    }

    public boolean showDomains() {
        return this.showDomains;
    }

    public void updateValuesRemoved(int numRemoved) {
        this.numberEliminatedLabel.setText("" + numRemoved);
    }

    public void updateValuesRemoved(String numRemoved) {
        this.numberEliminatedLabel.setText(numRemoved);
    }

    private void createLoadMenu(String indexLocation, JMenu mainMenu, ActionListener myListener) {
        try {
            DocumentBuilderFactory factoryBuilder = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factoryBuilder.newDocumentBuilder();
            Document doc = builder.parse(indexLocation);
            Element docElement = doc.getDocumentElement();
            this.createLoadMenu(docElement, mainMenu, myListener);
        }
        catch (IOException e) {
            System.out.println("IO ERROR");
            System.out.println(e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("IO ERROR");
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println("IO ERROR");
            System.out.println(e);
        }
    }

    private void createLoadMenu(Node currentNode, JMenu parentMenu, ActionListener myListener) {
        if (currentNode.getNodeType() == 1) {
            if (currentNode.getNodeName().equals("directory")) {
                JMenu tempMenu = new JMenu(currentNode.getAttributes().getNamedItem("name").getNodeValue());
                parentMenu.add(tempMenu);
                NodeList files = currentNode.getChildNodes();
                for (int fileIndex = 0; fileIndex < files.getLength(); ++fileIndex) {
                    this.createLoadMenu(files.item(fileIndex), tempMenu, myListener);
                }
            } else if (currentNode.getNodeName().equals("file")) {
                JMenuItem tempItem = new JMenuItem(currentNode.getAttributes().getNamedItem("name").getNodeValue());
                String address = currentNode.getAttributes().getNamedItem("name").getNodeValue();
                Node parentNode = currentNode.getParentNode();
                while (!parentNode.getAttributes().getNamedItem("name").getNodeValue().equals("SudokuLibrary")) {
                    address = parentNode.getAttributes().getNamedItem("name").getNodeValue() + "/" + address;
                    parentNode = parentNode.getParentNode();
                }
                tempItem.setActionCommand("http://consystlab.unl.edu/SudokuLibrary/" + address);
                tempItem.addActionListener(myListener);
                parentMenu.add(tempItem);
            }
        }
    }

    private constraintProblem loadProblem() {
        parserXML myparser = new parserXML();
        parserXML3 myparser3 = new parserXML3();
        return null;
    }

    private constraintProblem loadProblem(String absoluteAddress) {
        parserXML myparser = new parserXML();
        parserXML3 myparser3 = new parserXML3();
        testXMLFormat testF = new testXMLFormat();
        this.problemLocation = absoluteAddress;
        String format = testF.testXMLFormat(this.problemLocation);
        if (format.equals("Sudoku 3.0")) {
            myparser3.parseXML3(this.problemLocation);
            System.out.println("Load 3.0 File");
            return myparser3.getProblem();
        }
        if (format.equals("Sudokuv2.0")) {
            myparser.parseXML(this.problemLocation);
            return myparser.getProblem();
        }
        if (format.equals("Sudokuv1.0")) {
            myparser.parseXML(this.problemLocation);
            return myparser.getProblem();
        }
        return null;
    }

    public String getSudokuType() {
        return (String)this.suTypeList.getSelectedItem();
    }

    public Map getExtraRegionCells() {
        return this.extraRegionCells;
    }

    public boolean extraRegionCellsContains(String key) {
        return this.extraRegionCells.containsKey(key);
    }

    public void setExtraRegionCell(Object obj1, Object obj2) {
        this.extraRegionCells.put(obj1, obj2);
    }

    public void removeExtraRegionCell(Object obj1) {
        this.extraRegionCells.remove(obj1);
    }

    public Map getEvenOddCells() {
        return this.evenOddCells;
    }

    public boolean evenOddCellsContains(String key) {
        return this.evenOddCells.containsKey(key);
    }

    public void setEvenOddCell(Object obj1, Object obj2) {
        this.evenOddCells.put(obj1, obj2);
    }

    public void removeEvenOddCell(Object obj1) {
        this.evenOddCells.remove(obj1);
    }

    public void setSoluList(List newSoluList) {
        this.soluList = newSoluList;
    }

    private constraintProblem LoadProblemNoPreassign() {
        parserXML myparser = new parserXML();
        parserXML3 myparser3 = new parserXML3();
        testXMLFormat testF = new testXMLFormat();
        return myparser.getProblem();
    }

    public class showAboutMenu
    implements ActionListener {
        private Component component;

        showAboutMenu(Component component) {
            this.component = component;
        }

        public void actionPerformed(ActionEvent e) {
            constructorInterface.this.aboutBox.setVisible(true);
        }
    }

    public class JTextFieldLimit
    extends PlainDocument {
        private int limit;
        private boolean toUppercase = false;

        JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                if (this.toUppercase) {
                    str = str.toUpperCase();
                }
                super.insertString(offset, str, attr);
            }
        }
    }

    static class MyCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel column1;
        JLabel column2;
        JLabel column3;
        JLabel column4;
        JLabel column5;
        JLabel column6;

        MyCellRenderer() {
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.column1 = new JLabel();
            this.column2 = new JLabel();
            this.column3 = new JLabel();
            this.column4 = new JLabel();
            this.column5 = new JLabel();
            this.column6 = new JLabel();
            this.column1.setOpaque(true);
            this.column2.setOpaque(true);
            this.column3.setOpaque(true);
            this.column4.setOpaque(true);
            this.column5.setOpaque(true);
            this.column6.setOpaque(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.column1, 225, 225, 225).addComponent(this.column2, 50, 50, 50).addComponent(this.column3, 50, 50, 50).addComponent(this.column4, 200, 200, 200).addComponent(this.column5, 50, 50, 50).addComponent(this.column6, 75, 75, 75));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.column1, -1, -1, Short.MAX_VALUE).addComponent(this.column2, -1, -1, Short.MAX_VALUE).addComponent(this.column3, -1, -1, Short.MAX_VALUE).addComponent(this.column4, -1, -1, Short.MAX_VALUE).addComponent(this.column5, -1, -1, Short.MAX_VALUE).addComponent(this.column6, -1, -1, Short.MAX_VALUE)));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String col1data = ((String[])value)[0];
            String col2data = ((String[])value)[1];
            String col3data = ((String[])value)[2];
            String col4data = ((String[])value)[3];
            String col5data = ((String[])value)[4];
            String col6data = ((String[])value)[5];
            this.column1.setText(col1data);
            this.column2.setText(col2data);
            this.column3.setText(col3data);
            this.column4.setText(col4data);
            this.column5.setText(col5data);
            this.column6.setText(col6data);
            if (isSelected) {
                this.column1.setBackground(list.getSelectionBackground());
                this.column1.setForeground(list.getSelectionForeground());
                this.column2.setBackground(list.getSelectionBackground());
                this.column2.setForeground(list.getSelectionForeground());
                this.column3.setBackground(list.getSelectionBackground());
                this.column3.setForeground(list.getSelectionForeground());
                this.column4.setBackground(list.getSelectionBackground());
                this.column4.setForeground(list.getSelectionForeground());
                this.column5.setBackground(list.getSelectionBackground());
                this.column5.setForeground(list.getSelectionForeground());
                this.column6.setBackground(list.getSelectionBackground());
                this.column6.setForeground(list.getSelectionForeground());
            } else {
                this.column1.setBackground(list.getBackground());
                this.column1.setForeground(list.getForeground());
                this.column2.setBackground(list.getBackground());
                this.column2.setForeground(list.getForeground());
                this.column3.setBackground(list.getBackground());
                this.column3.setForeground(list.getForeground());
                this.column4.setBackground(list.getBackground());
                this.column4.setForeground(list.getForeground());
                this.column5.setBackground(list.getBackground());
                this.column5.setForeground(list.getForeground());
                this.column6.setBackground(list.getBackground());
                this.column6.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    public class FilterListener
    implements ActionListener {
        private Component component;
        private int matches;

        FilterListener(Component component) {
            this.component = component;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                dbmysql database = new dbmysql();
                this.matches = database.filter(constructorInterface.this.puzzTypeBox.getSelectedItem().toString(), constructorInterface.this.maxDiffBox.getSelectedItem().toString(), constructorInterface.this.diffBox.getSelectedItem().toString(), constructorInterface.this.numSolBox.getSelectedIndex(), constructorInterface.this.consisBox.getSelectedItem().toString());
                constructorInterface.this.matchesBox.setText(this.matches + "");
            }
            catch (Exception ex) {
                Logger.getLogger(constructorInterface.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class ShowDatabaseListener
    implements ActionListener {
        private Component component;

        ShowDatabaseListener(Component component) {
            this.component = component;
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

