/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.Globals;
import edu.unl.consystlab.sudokuSolver.binaryIntensiveConstraint;
import edu.unl.consystlab.sudokuSolver.nonBinaryIntensiveConstraint;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.problemDomain;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class constraintProblem {
    private String suType;
    private String sourceValue;
    private int lowerDiffValue;
    private int upperDiffValue;
    private int levelDiffValue;
    private String origNameValue;
    private String descValue;
    private String problemName;
    private Hashtable problemRelations;
    private Hashtable problemVariables;
    private Hashtable problemBinaryIntensiveConstraints;
    private Hashtable problemNonBinaryIntensiveConstraints;
    private Hashtable problemDomains;
    private Collection domainReductionListeners = new LinkedList();
    int linesPerUnit;
    int columnsPerUnit;
    int totalLines;
    int totalColumns;

    public constraintProblem() {
        this.problemName = this.generateName();
        Globals.allProblems.add(this);
        this.problemDomains = new Hashtable();
        this.problemVariables = new Hashtable();
        this.problemRelations = new Hashtable();
        this.problemBinaryIntensiveConstraints = new Hashtable();
        this.problemNonBinaryIntensiveConstraints = new Hashtable();
        this.linesPerUnit = 0;
        this.columnsPerUnit = 0;
        this.totalLines = 0;
        this.totalColumns = 0;
    }

    public constraintProblem(String tempUserName) {
        this.problemName = tempUserName;
        Globals.allProblems.add(this);
        this.problemDomains = new Hashtable();
        this.problemVariables = new Hashtable();
        this.problemBinaryIntensiveConstraints = new Hashtable();
        this.linesPerUnit = 0;
        this.columnsPerUnit = 0;
        this.totalLines = 0;
        this.totalColumns = 0;
    }

    public constraintProblem copy() {
        int unitLine;
        problemConstraint newConstraint;
        int cellLineIndex;
        constraintProblem myCopy = new constraintProblem(this.problemName, this.linesPerUnit, this.columnsPerUnit, this.totalLines, this.totalColumns);
        Enumeration tempEnumeration = this.problemDomains.elements();
        problemDomain myNewDomain = null;
        while (tempEnumeration.hasMoreElements()) {
            myNewDomain = ((problemDomain)tempEnumeration.nextElement()).copy(myCopy);
        }
        for (problemVariable tempVariable : this.getAllVariables()) {
            problemVariable tempNewVariable = new problemVariable(tempVariable.getIndex(), myCopy);
            tempNewVariable.setDomain(myNewDomain.getName());
            if (tempVariable.isAssigned()) {
                tempNewVariable.setAssigned(tempVariable.getAssigned());
            }
            List tempOldDomain = tempVariable.getEntireDomain();
            Iterator j = tempOldDomain.iterator();
            LinkedList<String> newCurrentDomain = new LinkedList<String>();
            while (j.hasNext()) {
                String element = (String)j.next();
                String newElement = new String(element);
                newCurrentDomain.add(newElement);
            }
            tempNewVariable.setCurrentDomain(newCurrentDomain);
        }
        for (cellLineIndex = 1; cellLineIndex <= myCopy.totalLines; ++cellLineIndex) {
            for (int cellColumnIndex = 1; cellColumnIndex <= myCopy.totalColumns; ++cellColumnIndex) {
                for (int colpointer = cellColumnIndex + 1; colpointer <= myCopy.totalColumns; ++colpointer) {
                    newConstraint = new binaryIntensiveConstraint(cellLineIndex + "," + cellColumnIndex + " " + cellLineIndex + "," + colpointer, myCopy);
                }
                for (int rowPointer = cellLineIndex + 1; rowPointer <= myCopy.totalLines; ++rowPointer) {
                    newConstraint = new binaryIntensiveConstraint(cellLineIndex + "," + cellColumnIndex + " " + rowPointer + "," + cellColumnIndex, myCopy);
                }
            }
        }
        for (unitLine = 0; unitLine < myCopy.columnsPerUnit; ++unitLine) {
            for (int unitColumn = 0; unitColumn < myCopy.linesPerUnit; ++unitColumn) {
                for (int unitLineIndex = 1; unitLineIndex <= myCopy.linesPerUnit; ++unitLineIndex) {
                    for (int unitColumnIndex = 1; unitColumnIndex < myCopy.columnsPerUnit; ++unitColumnIndex) {
                        for (int linePointerIndex = 1; linePointerIndex <= myCopy.linesPerUnit; ++linePointerIndex) {
                            for (int columnPointerIndex = unitColumnIndex + 1; columnPointerIndex <= myCopy.columnsPerUnit; ++columnPointerIndex) {
                                if (linePointerIndex == unitLineIndex) continue;
                                binaryIntensiveConstraint newConstraint2 = new binaryIntensiveConstraint(unitLine * myCopy.linesPerUnit + unitLineIndex + "," + (unitColumn * myCopy.columnsPerUnit + unitColumnIndex) + " " + (unitLine * myCopy.linesPerUnit + linePointerIndex) + "," + (unitColumn * myCopy.columnsPerUnit + columnPointerIndex), myCopy);
                            }
                        }
                    }
                }
            }
        }
        for (cellLineIndex = 1; cellLineIndex <= myCopy.totalLines; ++cellLineIndex) {
            String variablesAffected = "";
            for (int cellColumnIndex = 1; cellColumnIndex <= myCopy.totalColumns; ++cellColumnIndex) {
                variablesAffected = variablesAffected + cellLineIndex + "," + cellColumnIndex + " ";
            }
            variablesAffected.trim();
            nonBinaryIntensiveConstraint newConstraint3 = new nonBinaryIntensiveConstraint(variablesAffected, myCopy, "L" + cellLineIndex);
        }
        for (int cellColIndex = 1; cellColIndex <= myCopy.totalLines; ++cellColIndex) {
            String variablesAffected = "";
            for (int cellLineIndex2 = 1; cellLineIndex2 <= myCopy.totalColumns; ++cellLineIndex2) {
                variablesAffected = variablesAffected + cellLineIndex2 + "," + cellColIndex + " ";
            }
            variablesAffected.trim();
            nonBinaryIntensiveConstraint newConstraint4 = new nonBinaryIntensiveConstraint(variablesAffected, myCopy, "C" + cellColIndex);
        }
        for (unitLine = 0; unitLine < myCopy.columnsPerUnit; ++unitLine) {
            for (int unitColumn = 0; unitColumn < myCopy.linesPerUnit; ++unitColumn) {
                String variablesAffected = "";
                for (int unitLineIndex = 1; unitLineIndex <= myCopy.linesPerUnit; ++unitLineIndex) {
                    for (int unitColumnIndex = 1; unitColumnIndex <= myCopy.columnsPerUnit; ++unitColumnIndex) {
                        variablesAffected = variablesAffected + (unitLine * myCopy.linesPerUnit + unitLineIndex) + "," + (unitColumn * myCopy.columnsPerUnit + unitColumnIndex) + " ";
                    }
                }
                variablesAffected.trim();
                newConstraint = new nonBinaryIntensiveConstraint(variablesAffected, myCopy, "U" + (unitLine + 1) + "," + (unitColumn + 1));
            }
        }
        Collection oldDomainReductionListeners = this.domainReductionListeners;
        LinkedList copyDomainReductionListeners = new LinkedList();
        for (LinkedList currentListener : oldDomainReductionListeners) {
            LinkedList newListener = new LinkedList();
            for (variableIndexAndValueGrouping currentReduction : currentListener) {
                String currentValue = currentReduction.getValue();
                String copyValue = new String(currentValue);
                problemVariable copyVariable = myCopy.getVariable(currentReduction.getVariableIndex());
                variableIndexAndValueGrouping copyReduction = new variableIndexAndValueGrouping(copyVariable.getIndex(), copyValue);
            }
        }
        return myCopy;
    }

    private constraintProblem(String tempName, int tempLinesPerUnit, int tempColumnsPerUnit, int tempTotalLines, int tempTotalColumns) {
        this.problemName = tempName;
        Globals.allProblems.add(this);
        this.problemDomains = new Hashtable();
        this.problemVariables = new Hashtable();
        this.problemRelations = new Hashtable();
        this.problemBinaryIntensiveConstraints = new Hashtable();
        this.problemNonBinaryIntensiveConstraints = new Hashtable();
        this.linesPerUnit = tempLinesPerUnit;
        this.columnsPerUnit = tempColumnsPerUnit;
        this.totalLines = tempTotalLines;
        this.totalColumns = tempTotalColumns;
    }

    public String toString() {
        return this.problemName;
    }

    public void setName(String name) {
        this.problemName = name;
    }

    public String getName() {
        return this.problemName;
    }

    public void setDimensions(String newLines, String newColumns) {
        this.linesPerUnit = Integer.parseInt(newLines);
        this.columnsPerUnit = Integer.parseInt(newColumns);
        this.totalColumns = this.totalLines = this.linesPerUnit * this.columnsPerUnit;
    }

    public void setDimensionsForXML3(String newLines, String newColumns) {
        this.totalLines = Integer.parseInt(newLines);
        this.totalColumns = Integer.parseInt(newColumns);
        this.linesPerUnit = this.totalLines / 3;
        this.columnsPerUnit = this.totalColumns / 3;
    }

    public void setSuType(String type) {
        this.suType = type;
    }

    public void setSourceValue(String source) {
        this.sourceValue = source;
    }

    public void setLowerDiffValue(int lower) {
        this.lowerDiffValue = lower;
    }

    public void setUpperDiffValue(int upper) {
        this.upperDiffValue = upper;
    }

    public void setLevelDiffValue(int level) {
        this.levelDiffValue = level;
    }

    public void setOrigNameValue(String orig) {
        this.origNameValue = orig;
    }

    public void setDescValue(String desc) {
        this.descValue = desc;
    }

    public String getSuType() {
        return this.suType;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public int getLowerDiffValue() {
        return this.lowerDiffValue;
    }

    public int getUpperDiffValue() {
        return this.upperDiffValue;
    }

    public int getLevelDiffValue() {
        return this.levelDiffValue;
    }

    public String getOrigNameValue() {
        return this.origNameValue;
    }

    public String getDescValue() {
        return this.descValue;
    }

    public int getLinesPerUnit() {
        return this.linesPerUnit;
    }

    public int getColumnsPerUnit() {
        return this.columnsPerUnit;
    }

    public void addVariable(problemVariable newVariable) {
        this.problemVariables.put(newVariable.getIndex(), newVariable);
    }

    public problemVariable getVariable(String variableName) {
        return (problemVariable)this.problemVariables.get(variableName);
    }

    public void addDomain(problemDomain newDomain, String domainName) {
        this.problemDomains.put(domainName, newDomain);
    }

    public problemDomain getDomain(String domainName) {
        return (problemDomain)this.problemDomains.get(domainName);
    }

    public problemDomain getDomain() {
        if (this.problemDomains.size() == 1) {
            return (problemDomain)new LinkedList(this.problemDomains.values()).element();
        }
        return null;
    }

    public void addBinaryIntensiveConstraint(problemConstraint newConstraint, List constraintScopeVariables) {
        this.problemBinaryIntensiveConstraints.put(constraintScopeVariables, newConstraint);
    }

    public void addNonBinaryIntensiveConstraint(problemConstraint newConstraint, String key) {
        ((nonBinaryIntensiveConstraint)newConstraint).setKey(key);
        this.problemNonBinaryIntensiveConstraints.put(key, newConstraint);
    }

    public problemConstraint getNonBinaryIntensiveConstraint(String constraintKey) {
        return (problemConstraint)this.problemNonBinaryIntensiveConstraints.get(constraintKey);
    }

    public problemConstraint getConstraint(List constraintKey) {
        return (problemConstraint)this.problemBinaryIntensiveConstraints.get(constraintKey);
    }

    public Collection getAllConstraints() {
        return this.problemBinaryIntensiveConstraints.values();
    }

    public Collection getAllNonBinaryIntensiveConstraints() {
        return this.problemNonBinaryIntensiveConstraints.values();
    }

    public Collection getAllVariables() {
        return this.problemVariables.values();
    }

    public void addDomainReduction(variableIndexAndValueGrouping newReduction) {
        Iterator i = this.domainReductionListeners.iterator();
        while (i.hasNext()) {
            ((List)i.next()).add(newReduction);
        }
    }

    public void registerDomainReductionListener(List newDomainReductionListener) {
        this.domainReductionListeners.add(newDomainReductionListener);
    }

    public void unregisterDomainReductionList(List oldDomainReductionListener) {
        this.domainReductionListeners.remove(oldDomainReductionListener);
    }

    public void print() {
        for (int lineIndex = 1; lineIndex <= this.totalLines; ++lineIndex) {
            for (int columnIndex = 1; columnIndex <= this.totalColumns; ++columnIndex) {
                if (this.getVariable(lineIndex + "," + columnIndex).isAssigned()) {
                    System.out.print(this.getVariable(lineIndex + "," + columnIndex).getAssigned());
                } else {
                    System.out.print("?");
                }
                if (columnIndex % this.columnsPerUnit == 0 && columnIndex != this.totalColumns) {
                    System.out.print("|");
                    continue;
                }
                if (columnIndex != this.totalColumns) continue;
                System.out.print('\n');
            }
            if (lineIndex % this.linesPerUnit != 0 || lineIndex == this.totalLines) continue;
            for (int i = 0; i < this.totalColumns + this.linesPerUnit - 1; ++i) {
                System.out.print("-");
            }
            System.out.print('\n');
        }
    }

    private String generateName() {
        Random generator = new Random();
        String tempRandomName = new String();
        int nameLength = generator.nextInt(11) + 10;
        block28: for (int i = 0; i <= nameLength; ++i) {
            int nextChar = generator.nextInt(26);
            switch (nextChar) {
                case 0: {
                    tempRandomName = tempRandomName.concat("a");
                    continue block28;
                }
                case 1: {
                    tempRandomName = tempRandomName.concat("b");
                    continue block28;
                }
                case 2: {
                    tempRandomName = tempRandomName.concat("c");
                    continue block28;
                }
                case 3: {
                    tempRandomName = tempRandomName.concat("d");
                    continue block28;
                }
                case 4: {
                    tempRandomName = tempRandomName.concat("e");
                    continue block28;
                }
                case 5: {
                    tempRandomName = tempRandomName.concat("f");
                    continue block28;
                }
                case 6: {
                    tempRandomName = tempRandomName.concat("g");
                    continue block28;
                }
                case 7: {
                    tempRandomName = tempRandomName.concat("h");
                    continue block28;
                }
                case 8: {
                    tempRandomName = tempRandomName.concat("i");
                    continue block28;
                }
                case 9: {
                    tempRandomName = tempRandomName.concat("j");
                    continue block28;
                }
                case 10: {
                    tempRandomName = tempRandomName.concat("k");
                    continue block28;
                }
                case 11: {
                    tempRandomName = tempRandomName.concat("l");
                    continue block28;
                }
                case 12: {
                    tempRandomName = tempRandomName.concat("m");
                    continue block28;
                }
                case 13: {
                    tempRandomName = tempRandomName.concat("n");
                    continue block28;
                }
                case 14: {
                    tempRandomName = tempRandomName.concat("o");
                    continue block28;
                }
                case 15: {
                    tempRandomName = tempRandomName.concat("p");
                    continue block28;
                }
                case 16: {
                    tempRandomName = tempRandomName.concat("q");
                    continue block28;
                }
                case 17: {
                    tempRandomName = tempRandomName.concat("r");
                    continue block28;
                }
                case 18: {
                    tempRandomName = tempRandomName.concat("s");
                    continue block28;
                }
                case 19: {
                    tempRandomName = tempRandomName.concat("t");
                    continue block28;
                }
                case 20: {
                    tempRandomName = tempRandomName.concat("u");
                    continue block28;
                }
                case 21: {
                    tempRandomName = tempRandomName.concat("v");
                    continue block28;
                }
                case 22: {
                    tempRandomName = tempRandomName.concat("w");
                    continue block28;
                }
                case 23: {
                    tempRandomName = tempRandomName.concat("x");
                    continue block28;
                }
                case 24: {
                    tempRandomName = tempRandomName.concat("y");
                    continue block28;
                }
                case 25: {
                    tempRandomName = tempRandomName.concat("z");
                    continue block28;
                }
                default: {
                    tempRandomName = tempRandomName.concat("1");
                }
            }
        }
        return tempRandomName;
    }
}

