/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver.consistencyAlgorithms;

import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.arcConsistency;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;
import java.util.LinkedList;

public class shavingMAC
extends consistencyAlgorithm {
    arcConsistency myArcConsistency;

    public shavingMAC(constraintProblem newProblem, sudokuBoard board) {
        super(newProblem, board);
        this.myArcConsistency = new arcConsistency(newProblem, board);
        this.brokenConstraint = null;
        this.setEncounteredError(false);
    }

    public boolean runAlgorithm() {
        this.variableReductions = new LinkedList();
        boolean runAgain = true;
        while (runAgain) {
            runAgain = false;
            for (problemVariable currentVariable : this.parentProblem.getAllVariables()) {
                if (currentVariable.isAssigned()) continue;
                LinkedList originalDomain = new LinkedList(currentVariable.getEntireDomain());
                for (String currentValue : originalDomain) {
                    LinkedList tempDomain = new LinkedList(currentVariable.getEntireDomain());
                    currentVariable.setAssigned(currentValue);
                    if (!this.myArcConsistency.runAlgorithm()) {
                        tempDomain.remove(currentValue);
                        runAgain = true;
                        variableIndexAndValueGrouping myReduction = new variableIndexAndValueGrouping(currentVariable.getIndex(), currentValue);
                        this.variableReductions.add(myReduction);
                    }
                    currentVariable.unSetAssigned();
                    currentVariable.setCurrentDomain(tempDomain);
                    for (variableIndexAndValueGrouping currentReduction : this.myArcConsistency.getVariableReductions()) {
                        this.parentProblem.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
                    }
                    if (tempDomain.size() != 0) continue;
                    this.brokenConstraint = (problemConstraint)currentVariable.getBinaryConstraints().get(0);
                    this.setEncounteredError(true);
                    return false;
                }
            }
        }
        return true;
    }
}

