/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver.consistencyAlgorithms;

import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.nonBinaryMAC;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;
import java.util.Iterator;
import java.util.LinkedList;

public class shavingGAC
extends consistencyAlgorithm {
    private nonBinaryMAC myNonBinaryMAC;

    public shavingGAC(constraintProblem newProblem, sudokuBoard board) {
        super(newProblem, board);
        this.myNonBinaryMAC = new nonBinaryMAC(newProblem, board);
        this.brokenConstraint = null;
        this.setEncounteredError(false);
    }

    public boolean runAlgorithm() throws InterruptedException {
        this.variableReductions = new LinkedList();
        boolean runAgain = true;
        while (runAgain) {
            Iterator i = this.parentProblem.getAllVariables().iterator();
            runAgain = false;
            while (i.hasNext()) {
                problemVariable currentVariable = (problemVariable)i.next();
                if (currentVariable.isAssigned()) continue;
                LinkedList originalDomain = new LinkedList(currentVariable.getEntireDomain());
                Iterator j = originalDomain.iterator();
                while (j.hasNext()) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String currentValue = (String)j.next();
                    LinkedList tempDomain = new LinkedList(currentVariable.getEntireDomain());
                    currentVariable.setAssigned(currentValue);
                    if (!this.myNonBinaryMAC.runAlgorithm()) {
                        tempDomain.remove(currentValue);
                        runAgain = true;
                        variableIndexAndValueGrouping myReduction = new variableIndexAndValueGrouping(currentVariable.getIndex(), currentValue);
                        this.variableReductions.add(myReduction);
                    }
                    currentVariable.unSetAssigned();
                    currentVariable.setCurrentDomain(tempDomain);
                    for (variableIndexAndValueGrouping currentReduction : this.myNonBinaryMAC.getVariableReductions()) {
                        this.parentProblem.getVariable(currentReduction.getVariableIndex()).addToCurrentDomain(currentReduction.getValue());
                    }
                    if (tempDomain.size() != 0) continue;
                    this.brokenConstraint = (problemConstraint)currentVariable.getNonBinaryIntensiveConstraints().get(0);
                    this.setEncounteredError(true);
                    return false;
                }
            }
        }
        return true;
    }
}

