/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver.consistencyAlgorithms;

import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class binaryRestrictedArcConsistency
extends consistencyAlgorithm {
    private List arcConsistentVariables;

    public binaryRestrictedArcConsistency(constraintProblem newProblem, sudokuBoard board, List newArcConsistentVariables) {
        super(newProblem, board);
        this.arcConsistentVariables = newArcConsistentVariables;
    }

    public boolean runAlgorithm() {
        this.variableReductions = new LinkedList();
        this.parentProblem.registerDomainReductionListener(this.variableReductions);
        Stack constraintQueue = new Stack();
        for (int variableIndex = 0; variableIndex < this.arcConsistentVariables.size(); ++variableIndex) {
            constraintQueue.addAll(this.findRelevantConstraints((problemVariable)this.arcConsistentVariables.get(variableIndex), this.arcConsistentVariables));
        }
        while (constraintQueue.size() > 0) {
            problemConstraint currentConstraint = (problemConstraint)constraintQueue.pop();
            if (currentConstraint.isViolated()) {
                this.setBrokenConstraint(currentConstraint);
                this.setEncounteredError(true);
                this.parentProblem.unregisterDomainReductionList(this.variableReductions);
                return false;
            }
            if (currentConstraint.revise((problemVariable)currentConstraint.getScope().get(0))) {
                constraintQueue.addAll(this.findRelevantConstraints((problemVariable)currentConstraint.getScope().get(0), this.arcConsistentVariables));
            }
            if (!currentConstraint.revise((problemVariable)currentConstraint.getScope().get(1))) continue;
            constraintQueue.addAll(this.findRelevantConstraints((problemVariable)currentConstraint.getScope().get(1), this.arcConsistentVariables));
        }
        this.setBrokenConstraint(null);
        this.setEncounteredError(false);
        this.parentProblem.unregisterDomainReductionList(this.variableReductions);
        return true;
    }

    private List findRelevantConstraints(problemVariable currentVariable, List ArcConsistentVariables) {
        LinkedList constraintQueue = new LinkedList();
        LinkedList variableConstraints = new LinkedList(currentVariable.getBinaryConstraints());
        for (int constraintIndex = 0; constraintIndex < variableConstraints.size(); ++constraintIndex) {
            if (((problemVariable)((LinkedList)((problemConstraint)variableConstraints.get(constraintIndex)).getScope()).get(0)).getIndex().equals(currentVariable.getIndex())) {
                if (!ArcConsistentVariables.contains(((LinkedList)((problemConstraint)variableConstraints.get(constraintIndex)).getScope()).get(1))) continue;
                constraintQueue.add(variableConstraints.get(constraintIndex));
                continue;
            }
            if (!ArcConsistentVariables.contains(((LinkedList)((problemConstraint)variableConstraints.get(constraintIndex)).getScope()).get(0))) continue;
            constraintQueue.add(variableConstraints.get(constraintIndex));
        }
        return constraintQueue;
    }
}

