/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms.arcConsistency;
import edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms.nonBinaryMAC;
import edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms.shavingGAC;
import edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms.shavingMAC;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.parserArray;
import edu.unl.consystlab.sudokuSolver.problemVariable;

public class checkConsistencyNeeded {
    private constraintProblem myProblem;
    private String[] numbers;
    private int unassignedVars;
    private consistencyAlgorithm myAlgorithm;

    public checkConsistencyNeeded(String puzzle) {
        this.numbers = puzzle.split("");
    }

    public String checkConsistency() {
        if (this.numbers != null) {
            this.myProblem = this.loadProblemFromArray(this.numbers);
            this.unassignedVars = 0;
            for (problemVariable currentVariable : this.myProblem.getAllVariables()) {
                if (currentVariable.isAssigned()) continue;
                ++this.unassignedVars;
            }
            this.myAlgorithm = new arcConsistency(this.myProblem);
            this.myAlgorithm.runAlgorithm();
            int variablesReduced = this.myAlgorithm.getVariableReductions().size();
            if (variablesReduced == 8 * this.unassignedVars) {
                return "AC";
            }
            this.myAlgorithm = new nonBinaryMAC(this.myProblem);
            this.myAlgorithm.runAlgorithm();
            if ((variablesReduced += this.myAlgorithm.getVariableReductions().size()) == 8 * this.unassignedVars) {
                return "GAC";
            }
            variablesReduced = 0;
            this.myProblem = this.loadProblemFromArray(this.numbers);
            this.myAlgorithm = new arcConsistency(this.myProblem);
            this.myAlgorithm.runAlgorithm();
            variablesReduced = this.myAlgorithm.getVariableReductions().size();
            this.myAlgorithm = new shavingMAC(this.myProblem);
            this.myAlgorithm.runAlgorithm();
            if ((variablesReduced += this.myAlgorithm.getVariableReductions().size()) == 8 * this.unassignedVars) {
                return "SAC";
            }
            int curVariablesReduced = 0;
            boolean alternate = true;
            do {
                if (alternate) {
                    this.myAlgorithm = new nonBinaryMAC(this.myProblem);
                    this.myAlgorithm.runAlgorithm();
                    curVariablesReduced = this.myAlgorithm.getVariableReductions().size();
                } else {
                    this.myAlgorithm = new shavingMAC(this.myProblem);
                    this.myAlgorithm.runAlgorithm();
                    curVariablesReduced = this.myAlgorithm.getVariableReductions().size();
                }
                if ((variablesReduced += curVariablesReduced) == 8 * this.unassignedVars) {
                    return "SAC + GAC";
                }
                boolean bl = alternate = !alternate;
            } while (curVariablesReduced != 0);
            this.myAlgorithm = new shavingGAC(this.myProblem);
            this.myAlgorithm.runAlgorithm();
            if ((variablesReduced += this.myAlgorithm.getVariableReductions().size()) == 8 * this.unassignedVars) {
                return "SGAC";
            }
        }
        return "Unsolved";
    }

    private constraintProblem loadProblemFromArray(String[] numArray) {
        parserArray myparser = new parserArray();
        myparser.parseArray(numArray);
        System.out.println("Load constraint from array");
        return myparser.getProblem();
    }
}

