/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudokuSolver;

import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;
import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.shavingGAC;
import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.parserArray;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class SGACloop {
    private static constraintProblem myProblem;
    private static int unassignedVars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, Exception {
        if (args.length >= 0) {
            String addon = null;
            String line = null;
            BufferedReader in = null;
            String[] numbers = null;
            String[] numArray = new String[82];
            int arrayIndex = 1;
            try {
                for (int puzzNum = 51; puzzNum <= 100; ++puzzNum) {
                    arrayIndex = 1;
                    String batchFile = "http://consystlab.unl.edu/SudokuLibrary/FromFiles/Basic/VegardHanssen/3x3_4.";
                    addon = puzzNum < 10 ? "00" + puzzNum : (puzzNum == 100 ? "" + puzzNum : "0" + puzzNum);
                    batchFile = batchFile + addon;
                    URL source = new URL(batchFile);
                    in = new BufferedReader(new InputStreamReader(source.openStream()));
                    do {
                        if ((line = in.readLine()) == null) continue;
                        numbers = line.split("");
                        for (int i = 1; i <= 18; i += 2) {
                            numArray[arrayIndex++] = numbers[i].equals("1") ? numbers[i + 1] : "0";
                        }
                    } while (line != null);
                    if (numbers == null || numArray == null) continue;
                    String[] tmpStr = batchFile.split("_");
                    String[] tmpStr2 = tmpStr[1].split("\\.");
                    int diff = Integer.parseInt(tmpStr2[0]);
                    myProblem = SGACloop.loadProblemFromArray(numArray, diff);
                    shavingGAC myAlgorithm = new shavingGAC(myProblem, null);
                    unassignedVars = 0;
                    for (problemVariable currentVariable : myProblem.getAllVariables()) {
                        if (currentVariable.isAssigned()) continue;
                        ++unassignedVars;
                    }
                    ((consistencyAlgorithm)myAlgorithm).runAlgorithm();
                    if (myAlgorithm.getVariableReductions().size() == 8 * unassignedVars) {
                        System.out.println(puzzNum + "  Solved");
                        continue;
                    }
                    System.out.println(puzzNum + "  UNSOLVED");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        } else {
            System.out.println("Invalid argument");
        }
    }

    private static constraintProblem loadProblemFromArray(String[] numArray) {
        parserArray myparser = new parserArray();
        myparser.parseArray(numArray);
        return myparser.getProblem();
    }

    private static constraintProblem loadProblemFromArray(String[] numArray, int diffLevel) {
        parserArray myparser = new parserArray();
        myparser.parseArray(numArray, diffLevel);
        return myparser.getProblem();
    }

    public static int count(String fileName) throws IOException {
        String line;
        int numLines = 0;
        URL source = new URL(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(source.openStream()));
        do {
            if ((line = br.readLine()) == null) continue;
            ++numLines;
        } while (line != null);
        return numLines;
    }
}

