/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudoku;

import edu.unl.consystlab.gui.GameProgressBar;
import edu.unl.consystlab.sudoku.Grid;
import edu.unl.consystlab.sudoku.Griddable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import javax.swing.JButton;
import javax.swing.JPanel;

public class VisualGrid
extends JPanel
implements Griddable,
MouseListener,
KeyListener {
    private static Font FONT = new Font(null, 1, 18);
    private static final Color BACKGROUND = Color.lightGray;
    private static final Color EMPTY = Color.white;
    private static final Color ERROR = Color.red;
    private static final Color LOCKED = Color.black;
    private static final Color UTRYING = new Color(0.1f, 0.6f, 0.1f);
    private static final Color STRYING = Color.blue;
    private static final Color SOLVED = Color.gray;
    private static final Color CERROR = Color.magenta;
    private static final Color SELECTED = Color.white;
    private Grid grid = null;
    private GameProgressBar progressBar;
    public JButton[][] jButtons;
    private boolean updateLife = true;
    private int selectedCell = 0;
    private boolean showSelectedCell = true;

    public VisualGrid(Grid grid, GameProgressBar progressBar) {
        this.progressBar = progressBar;
        this.setGrid(grid);
        this.mkGui();
        this.calc();
        this.requestFocus();
    }

    public void repaint(Graphics g) {
        this.requestFocus();
        super.paint(g);
    }

    private void mkGui() {
        this.setLayout(new GridLayout(3, 3, 7, 7));
        this.setBackground(BACKGROUND);
        this.jButtons = new JButton[9][9];
        for (int i = 0; i < 9; ++i) {
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(3, 3, 1, 1));
            p.setBackground(BACKGROUND);
            for (int j = 0; j < 9; ++j) {
                int row = 3 * (i / 3);
                int col = 3 * (i % 3);
                String s = j + 1 + "";
                JButton jButton = new JButton(s);
                this.jButtons[row += j / 3][col += j % 3] = jButton;
                JButton b = jButton;
                p.add(b);
                b.addMouseListener(this);
                b.addKeyListener(this);
                b.setToolTipText("Just click here to add or change the entry");
                b.setFont(FONT);
            }
            this.add(p);
        }
    }

    public boolean isSelectedCell(int row, int col) {
        int t = row * 9 + col;
        return t == this.selectedCell;
    }

    public void calc(int n) {
        this.calc(n / 9, n % 9);
    }

    public void calc(int row, int col) {
        if (!this.updateLife) {
            return;
        }
        JButton c = this.jButtons[row][col];
        if (this.isSelectedCell(row, col) && this.showSelectedCell()) {
            c.setBackground(SELECTED);
        } else {
            c.setBackground(BACKGROUND);
        }
        c.setForeground(this.stateToColor(row, col));
        if (this.getValue(row, col) == 0) {
            c.setText("");
        } else {
            c.setText("" + this.getValue(row, col));
        }
        if (this.progressBar != null) {
            this.progressBar.setProgressPct(this.grid.getProgressPct());
        }
        this.repaint();
    }

    public void calc() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.calc(i, j);
            }
        }
    }

    public Color stateToColor(int i, int j) {
        byte val = this.getValue(i, j);
        if (val != 0 && !this.grid.isOk(i, j, val)) {
            return ERROR;
        }
        byte state = this.getState(i, j);
        switch (state) {
            case 0: {
                return EMPTY;
            }
            case 2: {
                return LOCKED;
            }
            case 5: {
                return SOLVED;
            }
            case 3: {
                return UTRYING;
            }
            case 4: {
                return STRYING;
            }
        }
        return CERROR;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void mousePressed(MouseEvent e) {
        Object o = e.getSource();
        if (!(o instanceof JButton)) {
            return;
        }
        JButton b = (JButton)o;
        this.pressJButton(b, (byte)-1);
    }

    public void pressJButton(JButton b, byte val) {
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                if (this.jButtons[row][col] != b) continue;
                this.press(row, col, val);
            }
        }
    }

    public void press(int row, int col, byte val) {
        if (this.getState(row, col) == 2) {
            return;
        }
        if (!this.isSelectedCell(row, col)) {
            this.setSelectedCell(row, col);
            return;
        }
        if (val < 0 && (val = (byte)(this.getValue(row, col) + 1)) > 9) {
            val = 0;
        }
        this.setSelectedCell(row, col);
        this.setValue(row, col, val);
        if (val == 0) {
            this.setState(row, col, (byte)0);
        } else {
            this.setState(row, col, (byte)3);
        }
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void keyPressed(KeyEvent event) {
        if (this.selectedCell < 0 || this.selectedCell >= 81) {
            this.selectedCell = 0;
        }
        int row = this.selectedCell / 9;
        int col = this.selectedCell % 9;
        int key = event.getKeyCode();
        switch (key) {
            case 8: 
            case 32: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 127: {
                int direction = 0;
                byte val = this.getValue(row, col);
                if (key == 32) {
                    direction = 1;
                    val = 0;
                }
                if (key == 12 || key == 8 || key == 127) {
                    direction = -1;
                    val = 0;
                }
                if (key >= 48 && key <= 57) {
                    val = (byte)(key - 48);
                    direction = 1;
                }
                this.setValue(row, col, val);
                if (val == 0) {
                    this.setState(row, col, (byte)0);
                } else {
                    this.setState(row, col, (byte)3);
                }
                if (!this.isOk(row, col)) break;
                this.setSelectedCell(this.getSelectedCell() + direction);
                break;
            }
            case 38: {
                if (--row < 0) {
                    row = 8;
                }
                this.setSelectedCell(row, col);
                break;
            }
            case 40: {
                if (++row >= 9) {
                    row = 0;
                }
                this.setSelectedCell(row, col);
                break;
            }
            case 37: {
                if (--col < 0) {
                    col = 8;
                }
                this.setSelectedCell(row, col);
                break;
            }
            case 39: {
                if (++col >= 9) {
                    col = 0;
                }
                this.setSelectedCell(row, col);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public boolean isUpdateLife() {
        return this.updateLife;
    }

    public void setUpdateLife(boolean b) {
        this.updateLife = b;
    }

    public void clear() {
        this.grid.clear();
        this.calc();
    }

    public void clear(int row, int col) {
        this.grid.clear(row, col);
        this.calc(row, col);
    }

    public void lock(int row, int col, byte val) {
        this.grid.lock(row, col, val);
        this.calc(row, col);
    }

    public boolean isUsed(int row, int col, byte val) {
        return this.grid.isUsed(row, col, val);
    }

    public boolean isOk(int row, int col) {
        return this.grid.isOk(row, col);
    }

    public int getEntropy(int row, int col) {
        return this.grid.getEntropy(row, col);
    }

    public void setValue(int row, int col, byte val) {
        this.grid.setValue(row, col, val);
        this.calc(row, col);
    }

    public void setState(int row, int col, byte state) {
        this.grid.setState(row, col, state);
        this.calc(row, col);
    }

    public byte getValue(int row, int col) {
        return this.grid.getValue(row, col);
    }

    public byte getState(int row, int col) {
        return this.grid.getState(row, col);
    }

    public int getProgressPct() {
        return this.grid.getProgressPct();
    }

    public int getSelectedCell() {
        return this.selectedCell;
    }

    public void setSelectedCell(int newCell) {
        if (newCell < 0 || newCell >= 81) {
            newCell = 0;
        }
        int oldCell = this.selectedCell;
        this.selectedCell = newCell;
        this.calc(oldCell);
        this.calc(newCell);
    }

    public void setSelectedCell(int i, int j) {
        this.setSelectedCell(i * 9 + j);
        this.setShowSelectedCell(true);
    }

    public boolean isShowSelectedCell() {
        return this.showSelectedCell;
    }

    public boolean showSelectedCell() {
        return this.isShowSelectedCell();
    }

    public void setShowSelectedCell(boolean b) {
        this.showSelectedCell = b;
        this.calc(this.getSelectedCell());
    }

    public void lock() {
        this.grid.lock();
        this.calc();
    }

    public void lockToggle() {
        this.grid.lockToggle();
        this.calc();
    }

    public boolean save(String name, BufferedWriter bw) {
        boolean res = this.grid.save(name, bw);
        this.calc();
        return res;
    }

    public boolean load(String name, BufferedReader br) {
        boolean res = this.grid.load(name, br);
        this.calc();
        return res;
    }
}

