/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudoku;

import edu.unl.consystlab.ftp.FTPClient;
import edu.unl.consystlab.ftp.FTPException;
import edu.unl.consystlab.gui.Dialogs;
import edu.unl.consystlab.gui.GameProgressBar;
import edu.unl.consystlab.sudoku.BFrame;
import edu.unl.consystlab.sudoku.Game;
import edu.unl.consystlab.sudoku.Grid;
import edu.unl.consystlab.sudoku.Griddable;
import edu.unl.consystlab.sudoku.Puzzle;
import edu.unl.consystlab.sudoku.Puzzles;
import edu.unl.consystlab.sudoku.Solver;
import edu.unl.consystlab.sudoku.SuMenuBar;
import edu.unl.consystlab.sudoku.VisualGrid;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SuFrame
extends BFrame
implements Game,
ActionListener {
    private static final String INFO = "All kinds of informational messages go here.\nDrag the slider (to the right) all way up, to speedthings up.\nHave fun!\n";
    private JTextArea info;
    private JPanel buttonPanel;
    private JPanel textFieldPanel;
    private JButton buttonSubmit;
    private JComboBox suTypeList;
    private JTextField sourceField;
    private JTextField lowerField;
    private JTextField upperField;
    private JTextField levelField;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JSlider speedSlider;
    private GameProgressBar gameProgressBar;
    private VisualGrid grid;
    private List puzzles;
    private Solver solver;
    private int optimization = 0;

    public SuFrame(String title) {
        super(title);
        this.initGame();
        this.mkGui();
        this.info.addKeyListener(this.grid);
        this.setSize(600, 600);
        this.show();
    }

    public Griddable getGrid() {
        return this.grid;
    }

    private void initGame() {
        this.gameProgressBar = new GameProgressBar(this, 1);
        this.grid = new VisualGrid(new Grid(), this.gameProgressBar);
        this.addKeyListener(this.grid);
        this.puzzles = Puzzles.getPuzzles();
        Puzzle puzzle = (Puzzle)this.puzzles.get(0);
        puzzle.fillGrid(this.grid);
    }

    private JPanel newButtonPanel() {
        JPanel panel = new JPanel();
        this.buttonSubmit = new JButton("Submit");
        this.buttonSubmit.setToolTipText("Submit to start the CSP solver");
        this.buttonSubmit.addActionListener(this);
        panel.add(this.buttonSubmit);
        return panel;
    }

    private JPanel newRightPanel() {
        JPanel panel = new JPanel();
        String[] typeStrings = new String[]{"base", "dodeka", "monster", "diagonal", "extra regions", "even-odd", "big-small", "even-odd", "geometry", "magic", "samurai"};
        this.suTypeList = new JComboBox<String>(typeStrings);
        this.suTypeList.setSelectedIndex(1);
        this.suTypeList.addActionListener(this);
        panel.add(this.suTypeList);
        this.sourceField = new JTextField(20);
        this.sourceField.addActionListener(this);
        panel.add(this.sourceField);
        this.lowerField = new JTextField(10);
        this.lowerField.setText("0");
        this.lowerField.addActionListener(this);
        this.upperField = new JTextField(10);
        this.upperField.setText("5");
        this.upperField.addActionListener(this);
        this.textFieldPanel = new JPanel();
        this.textFieldPanel.setLayout(new GridLayout(1, 0));
        this.textFieldPanel.add(this.lowerField);
        this.textFieldPanel.add(this.upperField);
        panel.add(this.textFieldPanel);
        this.levelField = new JTextField(10);
        this.levelField.setText("1");
        this.levelField.addActionListener(this);
        panel.add(this.levelField);
        this.label1 = new JLabel("Sudoku Type");
        this.label1.setLabelFor(this.suTypeList);
        this.label2 = new JLabel("Sudoku Source");
        this.label2.setLabelFor(this.sourceField);
        this.label3 = new JLabel("Sudoku Difficulty Level");
        this.label3.setLabelFor(this.textFieldPanel);
        this.label4 = new JLabel("This sudoku's difficulty level");
        this.label4.setLabelFor(this.levelField);
        return panel;
    }

    public void mkGui() {
        this.setJMenuBar(new SuMenuBar(this));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.info = new JTextArea(6, 20);
        this.inform(INFO);
        this.info.setAutoscrolls(true);
        this.info.setEditable(false);
        this.info.setToolTipText("All kinds of informational messages can be found here");
        content.add("North", new JScrollPane(this.info));
        content.add("South", this.newButtonPanel());
        content.add((Component)this.grid, "Center");
        this.speedSlider = new JSlider(1, 0, 100, 50);
        this.speedSlider.setToolTipText("Configure the speed of the solving process");
        content.add((Component)this.speedSlider, "East");
        content.add((Component)this.gameProgressBar, "West");
        content.setSize(600, 600);
    }

    public int getOptimization() {
        return this.optimization;
    }

    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o == this.buttonSubmit) {
            this.solve();
        }
    }

    public void solve() {
        this.stop();
        this.grid.setShowSelectedCell(false);
        this.solver = new Solver(this.grid, this);
        this.grid.setUpdateLife(true);
        this.grid.setShowSelectedCell(false);
        this.solver.initialize();
        this.solver.setOptimization(this.getOptimization());
        if (this.getOptimization() == 2) {
            this.grid.setUpdateLife(false);
        } else {
            this.grid.setUpdateLife(true);
        }
        this.solver.start();
    }

    public void stop() {
        if (this.solver != null) {
            this.solver.stop();
            this.solver = null;
        }
    }

    public void solverDone(boolean ok) {
        this.grid.setUpdateLife(true);
        this.grid.calc();
        this.solver = null;
        if (ok) {
            this.inform("Solved!");
        } else {
            this.inform("Could not solve.");
        }
    }

    public void clear() {
        this.inform("Clearing the playing field.");
        this.grid.clear();
        this.repaint();
    }

    public void inform(String msg) {
        this.info.append(msg + "\n");
        this.info.setCaretPosition(this.info.getText().length());
    }

    public int getSpeedPct() {
        return 100 - this.speedSlider.getValue();
    }

    public void setOptimization(int level) {
        this.optimization = level;
        if (this.solver != null) {
            this.solver.setOptimization(level);
        }
    }

    public void quit() {
        this.setSize(100, 100);
        this.setVisible(false);
        this.setEnabled(false);
        this.dispose();
    }

    public int getProgressPct() {
        if (this.grid != null) {
            return this.grid.getProgressPct();
        }
        return 0;
    }

    public void lockToggle() {
        this.inform("Locking/unlocking current cells.");
        this.grid.setShowSelectedCell(false);
        this.grid.lockToggle();
    }

    public String secureFileName(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        s = s.trim();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c - 65 + 97);
            }
            if (c >= 'a' && c <= 'z') {
                res.append(c);
            }
            if (c == '_' || c == '-' || c == '+' || c == '@') {
                res.append(c);
            }
            if (c < '0' || c > '9') continue;
            res.append(c);
        }
        return res.toString();
    }

    public void save() {
        String name = Dialogs.input(this, "Saving Puzzle", "Enter a unique name to store the puzzle as.\nYou can use a-z, A-Z, numbers\nand some special characters.\n");
        if (name == null) {
            return;
        }
        String orig = name;
        if ((name = this.secureFileName(name)).length() == 0) {
            Dialogs.error(this, "Invalid Puzzle Name", "Use a-z, A-Z, 0-9 for the puzzle name");
            return;
        }
        if (!orig.equals(name)) {
            Dialogs.info(this, "Puzzle Name Simplified by Solver", "NOTICE: the puzzle name is changed to: \n\n" + name + "\n\n");
        }
        this.inform("Puzzle will be saved as '" + name + "'.");
        this.inform("IMPORTANT: please write this down for later.");
        try {
            FTPClient ftp = new FTPClient("sudoku.klaas.nl");
            ftp.login("ftp", "sudoku applet");
            BufferedWriter bw = ftp.putStart("/pub/sudoku/" + name);
            this.grid.save(name, bw);
            ftp.putEnd(bw);
            Dialogs.info(this, "Saving Successfull", "Just saved your puzzle as '" + name + "'");
        }
        catch (IOException e) {
            this.inform("IOError saving: " + e);
        }
        catch (FTPException e) {
            Dialogs.error(this, "File not Found", "Sorry - cannot store puzzle '" + name + "'");
        }
    }

    public void load() {
        String name = Dialogs.input(this, "Loading Puzzle", "Enter your puzzle name");
        String orig = name;
        if (!orig.equals(name = this.secureFileName(name))) {
            Dialogs.info(this, "Puzzle Name Simplified by Solver", "NOTICE: before even trying to load the puzzle,\nthe puzzle name is changed to: \n\n" + name + "\n\n");
        }
        if (name == null) {
            return;
        }
        if (name.length() == 0) {
            Dialogs.error(this, "Invalid Puzzle Name", "Use a-z, A-Z, 0-9 for the puzzle name");
            return;
        }
        this.inform("Puzzle will be loaded from '" + name + "'...");
        try {
            FTPClient ftp = new FTPClient("sudoku.klaas.nl");
            ftp.login("ftp", "sudoku applet");
            BufferedReader br = ftp.getStart("/pub/sudoku/" + name);
            this.grid.load(name, br);
            ftp.getEnd(br);
            Dialogs.info(this, "Puzzle Loaded", "Succesfully loaded puzzle '" + name + "'");
        }
        catch (IOException e) {
            this.inform("IOError loading: " + e);
        }
        catch (FTPException e) {
            Dialogs.error(this, "File Not Found", "Sorry - cannot find puzzle '" + name + "'");
        }
    }
}

