/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudoku;

import edu.unl.consystlab.sudoku.Game;
import edu.unl.consystlab.sudoku.Griddable;

public class Solver
implements Runnable {
    public static final int SLOW = 250;
    public static final int FAST = 0;
    public static final int DEFAULT_SPEED = 500;
    private Griddable grid;
    private Game game;
    private Thread thread = null;
    private boolean pleaseStop = false;
    private int optimization = 0;

    public Solver(Griddable grid, Game game) {
        this.grid = grid;
        this.game = game;
    }

    public void setOptimization(int level) {
        this.optimization = level;
    }

    private int getNext(int prev) {
        if (this.optimization == 0) {
            return prev + 1;
        }
        int lowPos = -1;
        int lowEntropy = 0;
        for (int pos = 0; pos < 81; ++pos) {
            int row = pos / 9;
            int col = pos % 9;
            if (this.grid.getValue(row, col) != 0) continue;
            int entropy = this.grid.getEntropy(row, col);
            if (lowPos == -1) {
                lowPos = pos;
                lowEntropy = entropy;
                continue;
            }
            if (entropy >= lowEntropy) continue;
            lowPos = pos;
            lowEntropy = entropy;
        }
        return lowPos;
    }

    public void clearSolved() {
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                byte state = this.grid.getState(row, col);
                if (state != 5 && state != 4) continue;
                this.grid.clear(row, col);
            }
        }
    }

    public void showSolved() {
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                byte state = this.grid.getState(row, col);
                if (state != 4) continue;
                this.grid.setState(row, col, (byte)5);
            }
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void slowDown() {
        if (this.optimization == 2) {
            return;
        }
        int pct = this.game.getSpeedPct();
        if (pct == 0) {
            return;
        }
        int msec = 0 + pct * 250 / 100;
        try {
            Thread.sleep(msec);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean solve(int prev) {
        int start = this.getNext(prev);
        if (start < 0) {
            return true;
        }
        int row = start / 9;
        int col = start % 9;
        if (this.pleaseStop) {
            return false;
        }
        if (row >= 9 || col >= 9) {
            return true;
        }
        if (this.grid.getState(row, col) != 0) {
            return this.solve(start);
        }
        this.grid.setState(row, col, (byte)4);
        for (byte v = 1; v <= 9 && !this.pleaseStop; v = (byte)(v + 1)) {
            if (this.grid.isUsed(row, col, v)) continue;
            this.grid.setValue(row, col, v);
            this.slowDown();
            boolean res = this.solve(start);
            if (!res) continue;
            return true;
        }
        this.grid.clear(row, col);
        return false;
    }

    public void stop() {
        this.pleaseStop = true;
        this.game.inform("Stopping solving process...  ");
    }

    public void initialize() {
        this.clearSolved();
        this.pleaseStop = false;
    }

    public void run() {
        this.game.inform("Starting to solve - please wait...");
        boolean res = this.solve(-1);
        this.showSolved();
        this.game.solverDone(res);
        this.thread = null;
    }
}

