/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudoku;

import edu.unl.consystlab.sudoku.SuMenuBar;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Solve
extends Applet
implements MouseListener,
Runnable,
KeyListener {
    public static final String VERSION = "v1.61";
    private static String INFO = "Select one of the puzzles, then Solve.\n\nAlternatively, use Clear and then your mouse to fill\nin your own puzzle, then press Solve.\n\nMail me at sudoku@klaas.nl (this is v1.61)\n";
    private JButton[][] jbuttons = new JButton[9][9];
    private JTextArea info = new JTextArea(INFO, 6, 20);
    private JScrollPane infoScroll = new JScrollPane(this.info);
    private JFrame frame;
    private boolean isFirstRun = true;
    private JCheckBox optimize;
    private static Font cellFont = new Font(null, 1, 18);
    private static Color colorFixed = Color.black;
    private static Color colorTrying = Color.blue;
    private static Color colorError = Color.red;
    private static Color colorFound = Color.gray;
    private int[][] values = new int[9][9];
    private boolean[][] fixeds = new boolean[9][9];
    private int[][] rowUsed = new int[9][10];
    private int[][] colUsed = new int[9][10];
    private int[][] sqUsed = new int[9][10];
    private Thread thread = null;
    private boolean pleaseStop = true;
    private boolean pleaseOptimize = false;
    private static int UNKNOWN = 0;
    private static int OK = 1;
    private static int ERR = 2;
    private JButton jbuttonStart = new JButton("Solve");
    private JButton jbuttonStop = new JButton("Stop");
    private JButton jbuttonGame1 = new JButton("Puzzle 1");
    private JButton jbuttonGame2 = new JButton("Puzzle 2");
    private JButton jbuttonGame3 = new JButton("Puzzle 3");
    private JButton jbuttonGame4 = new JButton("Puzzle 4");
    private JButton jbuttonClear = new JButton("Clear");
    private JButton jbuttonQuit = new JButton("Quit");

    void game1() {
        this.clearGame();
        this.info.setText("From http://www.simetric.co.uk/sudoku/step1.htm\n");
        this.fix(1, 2, 3);
        this.fix(1, 4, 5);
        this.fix(1, 7, 8);
        this.fix(1, 8, 1);
        this.fix(2, 4, 7);
        this.fix(2, 5, 6);
        this.fix(2, 8, 9);
        this.fix(3, 1, 4);
        this.fix(4, 2, 4);
        this.fix(4, 3, 3);
        this.fix(4, 4, 9);
        this.fix(4, 6, 5);
        this.fix(4, 9, 6);
        this.fix(5, 2, 1);
        this.fix(5, 8, 7);
        this.fix(6, 1, 6);
        this.fix(6, 4, 8);
        this.fix(6, 6, 1);
        this.fix(6, 7, 9);
        this.fix(6, 8, 3);
        this.fix(7, 9, 9);
        this.fix(8, 2, 9);
        this.fix(8, 5, 8);
        this.fix(8, 6, 6);
        this.fix(9, 2, 6);
        this.fix(9, 3, 1);
        this.fix(9, 6, 2);
        this.fix(9, 8, 8);
    }

    public void game2() {
        this.clearGame();
        this.info.setText("From  may 22. 2005: \nhttp://www.griffiths-jones.co.uk/sudoku/\n");
        this.fix(1, 3, 6);
        this.fix(1, 6, 2);
        this.fix(2, 5, 5);
        this.fix(2, 7, 4);
        this.fix(2, 9, 2);
        this.fix(3, 2, 7);
        this.fix(3, 4, 4);
        this.fix(3, 5, 9);
        this.fix(3, 8, 1);
        this.fix(4, 1, 7);
        this.fix(4, 3, 4);
        this.fix(4, 6, 9);
        this.fix(4, 7, 2);
        this.fix(5, 1, 1);
        this.fix(5, 9, 8);
        this.fix(6, 3, 9);
        this.fix(6, 4, 1);
        this.fix(6, 7, 5);
        this.fix(6, 9, 3);
        this.fix(7, 2, 1);
        this.fix(7, 5, 4);
        this.fix(7, 6, 6);
        this.fix(7, 8, 5);
        this.fix(8, 1, 6);
        this.fix(8, 3, 5);
        this.fix(8, 5, 7);
        this.fix(9, 4, 5);
        this.fix(9, 7, 3);
    }

    public void game3() {
        this.clearGame();
        this.info.setText("From Times Online, may 14, 2005\nhttp://www.timesonline.co.uk/article/0,,18209-1609537,00.html\n");
        this.fix(1, " 6       ");
        this.fix(2, "1     264");
        this.fix(3, "    4   5");
        this.fix(4, "7  62 9  ");
        this.fix(5, " 9 4 8 7 ");
        this.fix(6, "  5 91  2");
        this.fix(7, "5   7    ");
        this.fix(8, "937     6");
        this.fix(9, "       8 ");
    }

    public void game4() {
        this.clearGame();
        this.info.setText("From Times Online, 'very hard'\nhttp://www.timesonline.co.uk/article/0,,18209-1354183,00.html\n");
        this.fix(1, " 43 8 25 ");
        this.fix(2, "6        ");
        this.fix(3, "     1 94");
        this.fix(4, "9    4 7 ");
        this.fix(5, "   6 8   ");
        this.fix(6, " 1 2    3");
        this.fix(7, "82 5     ");
        this.fix(8, "        5");
        this.fix(9, " 34 9 71 ");
    }

    public void clearGame() {
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                JButton b = this.jbuttons[row][col];
                b.setText("");
                b.setEnabled(true);
                this.values[row][col] = UNKNOWN;
                this.fixeds[row][col] = false;
                b.setForeground(Color.blue);
                b.setFont(cellFont);
            }
        }
    }

    public void fix(int row, String s) {
        for (int col = 0; col < 9; ++col) {
            char c = s.charAt(col);
            if (c < '0' || c > '9') continue;
            int i = c - 48;
            this.fix(row, col + 1, i);
        }
    }

    public void fix(int r, int c, int v) {
        this.values[--r][--c] = v;
        this.fixeds[r][c] = true;
        JButton b = this.jbuttons[r][c];
        b.setText("" + v);
        b.setForeground(Color.black);
    }

    public void clearInfo() {
        this.info.setText(INFO);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isFirstRun && this.frame != null) {
            this.frame.setVisible(true);
            this.frame.toFront();
            this.isFirstRun = false;
        }
    }

    public void init() {
        this.frame = new JFrame();
        this.frame.setJMenuBar(new SuMenuBar(null));
        Container content = this.frame.getContentPane();
        content.setLayout(new BorderLayout());
        this.info.setAutoscrolls(true);
        this.info.setEditable(false);
        this.info.setToolTipText("All kinds of informational messages can be found here");
        content.add("North", this.infoScroll);
        JPanel jbuttonPanel = new JPanel();
        jbuttonPanel.setLayout(new GridLayout(-1, 4));
        jbuttonPanel.add(this.jbuttonGame1);
        this.jbuttonGame1.addMouseListener(this);
        jbuttonPanel.add(this.jbuttonGame2);
        this.jbuttonGame2.addMouseListener(this);
        jbuttonPanel.add(this.jbuttonGame3);
        this.jbuttonGame3.addMouseListener(this);
        jbuttonPanel.add(this.jbuttonGame4);
        this.jbuttonGame4.addMouseListener(this);
        this.jbuttonStart.setToolTipText("Start the solving process");
        jbuttonPanel.add(this.jbuttonStart);
        this.jbuttonStart.addMouseListener(this);
        this.jbuttonStop.setToolTipText("Stop the solving process (if active)");
        jbuttonPanel.add(this.jbuttonStop);
        this.jbuttonStop.addMouseListener(this);
        this.jbuttonStop.setEnabled(false);
        this.jbuttonClear.setToolTipText("Clear the grid; use your mouse to fill in a puzzle, then press the Solve button");
        jbuttonPanel.add(this.jbuttonClear);
        this.jbuttonClear.addMouseListener(this);
        this.jbuttonQuit.setToolTipText("Stop this applet");
        jbuttonPanel.add(this.jbuttonQuit);
        this.jbuttonQuit.addMouseListener(this);
        this.optimize = new JCheckBox("Optimize");
        this.optimize.setToolTipText("When enabled, solving is done far smarter (more like a human would)");
        jbuttonPanel.add(this.optimize);
        String[] data = new String[]{"red", "green", "blue"};
        JComboBox<String> puzzles = new JComboBox<String>(data);
        jbuttonPanel.add(puzzles);
        content.add("South", jbuttonPanel);
        JPanel field = new JPanel();
        field.setLayout(new GridLayout(3, 3, 7, 7));
        field.setBackground(Color.lightGray);
        for (int i = 0; i < 9; ++i) {
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(3, 3, 1, 1));
            p.setBackground(Color.lightGray);
            for (int j = 0; j < 9; ++j) {
                int row = 3 * (i / 3);
                int col = 3 * (i % 3);
                String s = j + 1 + "";
                JButton jButton = new JButton(s);
                this.jbuttons[row += j / 3][col += j % 3] = jButton;
                JButton b = jButton;
                p.add(b);
                b.addMouseListener(this);
                b.addKeyListener(this);
                b.setToolTipText("Just click here to add or change the entry");
            }
            field.add(p);
        }
        content.add("Center", field);
        this.clearGame();
        this.clearInfo();
        this.frame.setSize(600, 600);
        this.frame.setVisible(true);
        this.frame.requestFocus();
        this.frame.show();
        this.frame.toFront();
    }

    public void start() {
        this.frame.toFront();
    }

    public void stopThread() {
        this.pleaseStop = true;
        this.thread = null;
        this.info.append("Stopped.\n");
        this.jbuttonStop.setEnabled(false);
        this.jbuttonStart.setEnabled(true);
        this.jbuttonGame1.setEnabled(true);
        this.jbuttonGame2.setEnabled(true);
        this.jbuttonGame3.setEnabled(true);
        this.jbuttonGame4.setEnabled(true);
        this.jbuttonClear.setEnabled(true);
    }

    public void startThread() {
        this.jbuttonStop.setEnabled(true);
        this.jbuttonStart.setEnabled(false);
        this.jbuttonGame1.setEnabled(false);
        this.jbuttonGame2.setEnabled(false);
        this.jbuttonGame3.setEnabled(false);
        this.jbuttonGame4.setEnabled(false);
        this.jbuttonClear.setEnabled(false);
        this.thread = new Thread(this);
        this.pleaseStop = false;
        this.thread.start();
    }

    public void SolveIt() {
        int errors = this.initStats();
        if (errors > 0) {
            this.showErrors();
            this.info.append("Sorry, cannot solve, errors in grid.\n");
            this.info.setCaretPosition(9999);
            return;
        }
        this.startThread();
    }

    public boolean isActionJButton(JButton b) {
        if (b == this.jbuttonQuit) {
            this.stopThread();
            this.frame.setSize(100, 100);
            this.frame.setVisible(false);
            this.frame.setEnabled(false);
            this.frame.dispose();
            this.frame = null;
            return true;
        }
        if (b == this.jbuttonStop) {
            this.stopThread();
            return true;
        }
        if (this.thread != null) {
            return true;
        }
        if (b == this.jbuttonStart) {
            this.SolveIt();
            return true;
        }
        if (b == this.jbuttonGame1) {
            this.game1();
            return true;
        }
        if (b == this.jbuttonGame2) {
            this.game2();
            return true;
        }
        if (b == this.jbuttonGame3) {
            this.game3();
            return true;
        }
        if (b == this.jbuttonGame4) {
            this.game4();
            return true;
        }
        if (b == this.jbuttonClear) {
            this.clearGame();
            this.info.setText("Field cleared.\nUse your mouse to fill in the puzzle.\n");
            return true;
        }
        return false;
    }

    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (!(o instanceof JButton)) {
            return;
        }
        JButton b = (JButton)o;
        if (this.isActionJButton(b)) {
            return;
        }
        this.pressJButton(b, -1);
    }

    public void pressJButton(JButton b, int val) {
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                if (this.jbuttons[row][col] != b) continue;
                this.press(row, col, val);
            }
        }
    }

    public void press(int row, int col, int val) {
        if (val >= 0 && val <= 9) {
            this.values[row][col] = val;
        } else {
            int[] nArray = this.values[row];
            int n = col;
            nArray[n] = nArray[n] + 1;
            if (this.values[row][col] > 9) {
                this.values[row][col] = UNKNOWN;
            }
        }
        int v = this.values[row][col];
        JButton b = this.jbuttons[row][col];
        if (v == UNKNOWN) {
            this.fixeds[row][col] = false;
            b.setText("");
            b.setForeground(Color.blue);
        } else {
            this.fixeds[row][col] = true;
            b.setText("" + v);
            b.setForeground(Color.black);
        }
        if (this.initStats() > 0) {
            this.showErrors();
        }
    }

    public void checkRowCol(boolean doRow, int where) {
        int c;
        int r;
        int state = UNKNOWN;
        int sum = 0;
        boolean[] have = new boolean[10];
        for (int i = 0; i < 10; ++i) {
            have[i] = false;
        }
        for (int n = 0; n < 9; ++n) {
            r = doRow ? where : n;
            int n2 = c = !doRow ? where : n;
            if (this.values[r][c] == UNKNOWN) continue;
            int v = this.values[r][c];
            if (have[v]) {
                state = ERR;
                break;
            }
            sum += this.values[r][c];
            have[v] = true;
        }
        for (int k = 0; k < 9; ++k) {
            r = doRow ? where : k;
            c = !doRow ? where : k;
            this.setState(r, c, state);
        }
    }

    private void setState(int row, int col, int state) {
        JButton b = this.jbuttons[row][col];
        if (this.fixeds[row][col]) {
            return;
        }
        if (state == OK) {
            b.setForeground(new Color(0.0f, 0.7f, 0.0f));
        }
        if (state == UNKNOWN) {
            b.setForeground(Color.blue);
        }
        if (state == ERR) {
            b.setForeground(Color.red);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public int getSq(int row, int col) {
        return 3 * (row / 3) + col / 3;
    }

    public int getSq(int pos) {
        return this.getSq(pos / 9, pos % 9);
    }

    public int initStats() {
        int errors = 0;
        for (int x = 0; x < 9; ++x) {
            for (int val = 1; val < 10; ++val) {
                this.rowUsed[x][val] = 0;
                this.colUsed[x][val] = 0;
                this.sqUsed[x][val] = 0;
            }
        }
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                if (!this.fixeds[row][col]) {
                    this.values[row][col] = UNKNOWN;
                    this.jbuttons[row][col].setText("");
                    this.jbuttons[row][col].setForeground(Color.blue);
                    continue;
                }
                this.jbuttons[row][col].setForeground(Color.black);
                int v = this.values[row][col];
                int sq = 3 * (row / 3) + col / 3;
                if (this.rowUsed[row][v] > 0 || this.colUsed[col][v] > 0 || this.sqUsed[sq][v] > 0) {
                    ++errors;
                }
                int[] nArray = this.rowUsed[row];
                int n = v;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.colUsed[col];
                int n2 = v;
                nArray2[n2] = nArray2[n2] + 1;
                int[] nArray3 = this.sqUsed[sq];
                int n3 = v;
                nArray3[n3] = nArray3[n3] + 1;
            }
        }
        return errors;
    }

    public int getEntropy(int pos) {
        int row = pos / 9;
        int col = pos % 9;
        if (this.fixeds[row][col]) {
            return 0;
        }
        int sq = 3 * (row / 3) + col / 3;
        int entropy = 0;
        for (int v = 0; v < 9; ++v) {
            if (this.rowUsed[row][v] > 0 || this.colUsed[col][v] > 0 || this.sqUsed[sq][v] > 0) continue;
            ++entropy;
        }
        return entropy;
    }

    public int getNext(int prev) {
        if (!this.pleaseOptimize) {
            return prev + 1;
        }
        int lowPos = -1;
        int lowEntropy = 0;
        for (int pos = 0; pos < 81; ++pos) {
            if (this.values[pos / 9][pos % 9] != UNKNOWN) continue;
            int entropy = this.getEntropy(pos);
            if (lowPos == -1) {
                lowPos = pos;
                lowEntropy = entropy;
                continue;
            }
            if (entropy >= lowEntropy) continue;
            lowPos = pos;
            lowEntropy = entropy;
        }
        return lowPos;
    }

    public boolean solveBrute(int prev) {
        int start = this.getNext(prev);
        if (start < 0) {
            return true;
        }
        int row = start / 9;
        int col = start % 9;
        if (this.pleaseStop) {
            return false;
        }
        if (row >= 9 || col >= 9) {
            this.repaint();
            return true;
        }
        int sq = 3 * (row / 3) + col / 3;
        if (this.fixeds[row][col]) {
            return this.solveBrute(start);
        }
        for (int v = 1; v <= 9; ++v) {
            if (this.rowUsed[row][v] > 0 || this.colUsed[col][v] > 0 || this.sqUsed[sq][v] > 0) continue;
            this.values[row][col] = v;
            this.jbuttons[row][col].setText("" + v);
            int[] nArray = this.rowUsed[row];
            int n = v;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.colUsed[col];
            int n2 = v;
            nArray2[n2] = nArray2[n2] + 1;
            int[] nArray3 = this.sqUsed[sq];
            int n3 = v;
            nArray3[n3] = nArray3[n3] + 1;
            boolean res = this.solveBrute(start);
            if (res) {
                return true;
            }
            int[] nArray4 = this.rowUsed[row];
            int n4 = v;
            nArray4[n4] = nArray4[n4] - 1;
            int[] nArray5 = this.colUsed[col];
            int n5 = v;
            nArray5[n5] = nArray5[n5] - 1;
            int[] nArray6 = this.sqUsed[sq];
            int n6 = v;
            nArray6[n6] = nArray6[n6] - 1;
        }
        this.values[row][col] = UNKNOWN;
        this.jbuttons[row][col].setText("");
        return false;
    }

    public void showSolved() {
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                if (this.fixeds[row][col]) {
                    this.jbuttons[row][col].setForeground(colorFixed);
                    continue;
                }
                this.jbuttons[row][col].setForeground(colorFound);
            }
        }
    }

    public void showErrors() {
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                int v = this.values[row][col];
                if (v == UNKNOWN) continue;
                int sq = this.getSq(row, col);
                if (this.rowUsed[row][v] <= 1 && this.colUsed[col][v] <= 1 && this.sqUsed[sq][v] <= 1) continue;
                this.jbuttons[row][col].setForeground(colorError);
            }
        }
    }

    public void run() {
        this.info.append("Solving ");
        this.pleaseOptimize = this.optimize.isEnabled();
        this.info.append(" optimization, please wait...\n");
        boolean res = this.solveBrute(-1);
        this.stopThread();
        if (res) {
            this.showSolved();
            this.info.append("Solved!\n");
        } else {
            this.info.append("NOT SOLVED!\n");
        }
    }

    public void keyPressed(KeyEvent e) {
        Object o = e.getSource();
        if (o == null || !(o instanceof JButton)) {
            return;
        }
        if (this.thread != null) {
            return;
        }
        int c = e.getKeyChar();
        if (c == 32) {
            c = 48;
        }
        if (c >= 48 && c <= 57) {
            this.pressJButton((JButton)o, c - 48);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

