/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudoku;

import edu.unl.consystlab.sudoku.Game;
import edu.unl.consystlab.sudoku.Puzzle;
import edu.unl.consystlab.sudoku.Puzzles;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PuzzleMenu
extends JMenu
implements ActionListener {
    private List puzzles;
    private Game game;

    public PuzzleMenu(Game game) {
        super("Puzzles");
        this.game = game;
        this.puzzles = Puzzles.getPuzzles();
        for (Puzzle p : this.puzzles) {
            JMenuItem jm = new JMenuItem(p.getName());
            jm.setActionCommand(p.getName());
            jm.addActionListener(this);
            this.add(jm);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o instanceof JMenuItem) {
            JMenuItem jm = (JMenuItem)o;
            this.setPuzzle(jm.getActionCommand());
        }
    }

    public void setPuzzle(String name) {
        for (Puzzle p : this.puzzles) {
            if (!p.getName().equals(name)) continue;
            this.game.inform("Using " + p.getName() + "(" + p.getDescription() + ")");
            p.fillGrid(this.game.getGrid());
        }
    }
}

