/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.sudoku;

import edu.unl.consystlab.sudoku.Griddable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Grid
implements Griddable {
    public static final int SZ = 9;
    public static final byte EMPTY = 0;
    public static final byte LOCKED = 2;
    public static final byte UTRYING = 3;
    public static final byte STRYING = 4;
    public static final byte SOLVED = 5;
    private byte[][] values = new byte[9][9];
    private byte[][] states = new byte[9][9];
    private byte[][] rowUsed = new byte[9][10];
    private byte[][] colUsed = new byte[9][10];
    private byte[][] sqUsed = new byte[9][10];

    public Grid() {
        this.clear();
    }

    public void clear(int row, int col) {
        this.setValue(row, col, (byte)0);
        this.setState(row, col, (byte)0);
    }

    public void clear() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.clear(i, j);
            }
        }
        for (int x = 0; x < 9; ++x) {
            for (int val = 1; val < 10; val = (int)((byte)(val + 1))) {
                this.rowUsed[x][val] = 0;
                this.colUsed[x][val] = 0;
                this.sqUsed[x][val] = 0;
            }
        }
    }

    public byte getState(int row, int col) {
        return this.states[row][col];
    }

    public void setState(int row, int col, byte state) {
        this.states[row][col] = state;
    }

    public void setValue(int row, int col, byte val) {
        int sq = 3 * (row / 3) + col / 3;
        byte oldval = this.values[row][col];
        byte[] byArray = this.rowUsed[row];
        byte by = oldval;
        byArray[by] = (byte)(byArray[by] - 1);
        byte[] byArray2 = this.colUsed[col];
        byte by2 = oldval;
        byArray2[by2] = (byte)(byArray2[by2] - 1);
        byte[] byArray3 = this.sqUsed[sq];
        byte by3 = oldval;
        byArray3[by3] = (byte)(byArray3[by3] - 1);
        this.values[row][col] = val;
        byte[] byArray4 = this.rowUsed[row];
        byte by4 = val;
        byArray4[by4] = (byte)(byArray4[by4] + 1);
        byte[] byArray5 = this.colUsed[col];
        byte by5 = val;
        byArray5[by5] = (byte)(byArray5[by5] + 1);
        byte[] byArray6 = this.sqUsed[sq];
        byte by6 = val;
        byArray6[by6] = (byte)(byArray6[by6] + 1);
    }

    public void lock(int row, int col, byte val) {
        this.setValue(row, col, val);
        if (val == 0) {
            this.setState(row, col, (byte)0);
        } else {
            this.setState(row, col, (byte)2);
        }
    }

    public byte getValue(int row, int col) {
        return this.values[row][col];
    }

    public int getEntropy(int row, int col) {
        if (this.states[row][col] == 2) {
            return 0;
        }
        int sq = 3 * (row / 3) + col / 3;
        int entropy = 0;
        for (byte v = 0; v < 9; v = (byte)(v + 1)) {
            if (this.isUsed(row, col, v)) continue;
            ++entropy;
        }
        return entropy;
    }

    public boolean isUsed(int row, int col, byte val) {
        if (this.rowUsed[row][val] > 0) {
            return true;
        }
        if (this.colUsed[col][val] > 0) {
            return true;
        }
        int sq = 3 * (row / 3) + col / 3;
        return this.sqUsed[sq][val] > 0;
    }

    public boolean isOk(int row, int col) {
        byte val = this.getValue(row, col);
        if (this.rowUsed[row][val] > 1) {
            return false;
        }
        if (this.colUsed[col][val] > 1) {
            return false;
        }
        int sq = 3 * (row / 3) + col / 3;
        return this.sqUsed[sq][val] <= 1;
    }

    public boolean isOk(int row, int col, int val) {
        if (this.rowUsed[row][val] > 1) {
            return false;
        }
        if (this.colUsed[col][val] > 1) {
            return false;
        }
        int sq = 3 * (row / 3) + col / 3;
        return this.sqUsed[sq][val] <= 1;
    }

    public int getProgressPct() {
        int ok = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.values[i][j] == 0) continue;
                ++ok;
            }
        }
        return ok * 100 / 81;
    }

    public void lock(boolean mustLock) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.getValue(i, j) == 0) continue;
                if (mustLock) {
                    if (!this.isOk(i, j)) continue;
                    this.setState(i, j, (byte)2);
                    continue;
                }
                this.setState(i, j, (byte)3);
            }
        }
    }

    public void lock() {
        this.lock(true);
    }

    public void lockToggle() {
        boolean mustLock = false;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.getValue(i, j) == 0 || this.getState(i, j) == 2 || !this.isOk(i, j)) continue;
                mustLock = true;
            }
        }
        this.lock(mustLock);
    }

    public boolean save(String name, BufferedWriter bw) {
        try {
            int j;
            int i;
            bw.write(name + "\n");
            for (i = 0; i < 9; ++i) {
                for (j = 0; j < 9; ++j) {
                    bw.write("" + this.getValue(i, j));
                }
                bw.write("\n");
            }
            bw.write("States:\n");
            for (i = 0; i < 9; ++i) {
                for (j = 0; j < 9; ++j) {
                    bw.write("" + this.getState(i, j));
                }
                bw.write("\n");
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean load(String name, BufferedReader br) {
        try {
            byte c;
            int j;
            int i;
            String line = br.readLine();
            for (i = 0; i < 9; i = (int)((byte)(i + 1))) {
                line = br.readLine();
                for (j = 0; j < 9; j = (int)((byte)(j + 1))) {
                    c = (byte)(line.charAt(j) - 48);
                    this.lock(i, j, c);
                }
            }
            line = br.readLine();
            for (i = 0; i < 9; i = (int)((byte)(i + 1))) {
                line = br.readLine();
                for (j = 0; j < 9; j = (int)((byte)(j + 1))) {
                    c = (byte)(line.charAt(j) - 48);
                    this.setState(i, j, c);
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

