/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.gui;

import edu.unl.consystlab.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class ScalingImage
extends Component {
    private Image image;
    private Image orig;

    public ScalingImage(Image image) {
        this.orig = this.image = image;
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(this.image.getHeight(this), this.image.getWidth(this));
        Debug.debug("ScalingImage(): preferredSize: " + dim);
        return dim;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(10, 10);
        Debug.debug("ScalingImage(): getMinimumSize(): " + dim);
        return dim;
    }

    public void setSize(Dimension d) {
        this.setSize(d.height, d.width);
    }

    public void setSize(int h, int w) {
        Debug.debug("ScalingImage(): scaling to: " + h + "x" + w);
        this.image = this.image.getScaledInstance(w, h, 2);
    }

    public void paint(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        if (this.image == null || h <= 0 || w <= 0) {
            return;
        }
        if (this.image.getHeight(this) != h || this.image.getWidth(this) != w) {
            this.image = this.orig.getScaledInstance(w, h, 2);
        }
        Debug.debug("ScalingImage(): painting...");
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        }
    }
}

