/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.gui;

import edu.unl.consystlab.gui.Graphable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class GrapherComponent
extends Component
implements Runnable {
    private int[] values;
    private Graphable g;
    private int f = 0;
    private int msec = 100;
    private boolean partial = true;
    private Thread t;
    private int min = 0;
    private int max = 0;

    public GrapherComponent(Graphable g, int num, int msec) {
        this.g = g;
        this.values = new int[num];
        this.msec = msec;
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.msec);
            }
            catch (Exception e) {
                // empty catch block
            }
            int n = this.g.getValue();
            this.values[this.f++] = n;
            int t = n;
            if (t < this.min) {
                this.min = t * 2;
            }
            if (t > this.max) {
                this.max = t * 2;
            }
            if (this.f == this.values.length) {
                this.f = 0;
                this.partial = false;
            }
            this.repaint();
        }
    }

    public void paint(Graphics g, int value, int pos, int mh, int mw, int middle, int scale) {
        int x = mw * pos / this.values.length;
        int dy = value * mh / scale;
        int w = mw / this.values.length;
        if ((dy *= -1) < 0) {
            g.fillRect(x, middle + dy, w, -dy);
        } else {
            g.fillRect(x, middle + 1, w, dy);
        }
    }

    public void paint(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        int middle = 0;
        int scale = 1;
        if (this.max >= 0 && this.min >= 0) {
            scale = this.max;
            middle = h;
        }
        if (this.max <= 0 && this.min <= 0) {
            scale = Math.abs(this.min);
            middle = 0;
        }
        if (this.max >= 0 && this.min < 0) {
            scale = this.max - this.min;
            middle = h - this.max * h / (scale == 0 ? 1 : scale);
        }
        g.setColor(Color.red);
        g.drawLine(0, middle, w, middle);
        g.setColor(Color.blue);
        int pos = 0;
        if (this.partial) {
            for (int i = 0; i < this.f; ++i) {
                this.paint(g, this.values[i], pos++, h, w, middle, scale);
            }
        } else {
            int i;
            for (i = this.f; i < this.values.length; ++i) {
                this.paint(g, this.values[i], pos++, h, w, middle, scale);
            }
            for (i = 0; i < this.f; ++i) {
                this.paint(g, this.values[i], pos++, h, w, middle, scale);
            }
        }
    }
}

