/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.ftp;

import edu.unl.consystlab.ftp.FTPException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;

public class FTPControlSocket {
    private static String cvsId = "$Id: FTPControlSocket.java,v 1.2 2006/02/14 14:46:00 cvs Exp $";
    static final String EOL = "\r\n";
    private static final int CONTROL_PORT = 21;
    private boolean debugResponses = false;
    private Socket controlSock = null;
    private Writer writer = null;
    private BufferedReader reader = null;

    public FTPControlSocket(String remoteHost) throws IOException, FTPException {
        this(remoteHost, 21);
    }

    public FTPControlSocket(String remoteHost, int controlPort) throws IOException, FTPException {
        this.controlSock = new Socket(remoteHost, controlPort);
        this.initStreams();
        this.validateConnection();
    }

    public FTPControlSocket(InetAddress remoteAddr) throws IOException, FTPException {
        this(remoteAddr, 21);
    }

    public FTPControlSocket(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this.controlSock = new Socket(remoteAddr, controlPort);
        this.initStreams();
        this.validateConnection();
    }

    private void validateConnection() throws IOException, FTPException {
        String reply = this.readReply();
        this.validateReply(reply, "220");
    }

    private void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is));
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os);
    }

    String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    public void logout() throws IOException {
        this.writer.close();
        this.reader.close();
        this.controlSock.close();
    }

    Socket createDataSocket() throws IOException, FTPException {
        String reply = this.sendCommand("PASV");
        this.validateReply(reply, "227");
        int bracket1 = reply.indexOf(40);
        int bracket2 = reply.indexOf(41);
        String ipData = reply.substring(bracket1 + 1, bracket2);
        int[] parts = new int[6];
        int len = ipData.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len && partCount <= 6; ++i) {
            char ch = ipData.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
            } else if (ch != ',') {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
            if (ch != ',' && i + 1 != len) continue;
            try {
                parts[partCount++] = Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
        }
        String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = (parts[4] << 8) + parts[5];
        return new Socket(ipAddress, port);
    }

    String sendCommand(String command) throws IOException {
        this.writer.write(command + EOL);
        this.writer.flush();
        return this.readReply();
    }

    String readReply() throws IOException {
        StringBuffer reply = new StringBuffer(this.reader.readLine());
        if (this.debugResponses) {
            System.out.println(reply.toString());
        }
        String replyCode = reply.toString().substring(0, 3);
        if (reply.charAt(3) == '-') {
            boolean complete = false;
            while (!complete) {
                String line = this.reader.readLine();
                if (line.length() == 0) continue;
                if (this.debugResponses) {
                    System.out.println(line);
                }
                if (line.substring(0, 3).equals(replyCode) && line.charAt(3) == ' ') {
                    reply.append(line.substring(3));
                    complete = true;
                    continue;
                }
                reply.append(" ");
                reply.append(line);
            }
        }
        return reply.toString();
    }

    void validateReply(String reply, String expectedReplyCode) throws IOException, FTPException {
        String replyCode = reply.substring(0, 3);
        if (!replyCode.equals(expectedReplyCode)) {
            throw new FTPException(reply.substring(4));
        }
    }

    void validateReply(String reply, String[] expectedReplyCodes) throws IOException, FTPException {
        String replyCode = reply.substring(0, 3);
        for (int i = 0; i < expectedReplyCodes.length; ++i) {
            if (!replyCode.equals(expectedReplyCodes[i])) continue;
            return;
        }
        throw new FTPException(reply);
    }

    void debugResponses(boolean on) {
        this.debugResponses = on;
    }
}

