/*
 * Decompiled with CFR 0.152.
 */
package edu.unl.consystlab.ftp;

import edu.unl.consystlab.ftp.FTPControlSocket;
import edu.unl.consystlab.ftp.FTPException;
import edu.unl.consystlab.ftp.FTPTransferType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;

public class FTPClient {
    private FTPControlSocket control = null;
    private Socket data = null;
    public short tmode = (short)-1;
    public long tbytes = 0L;
    public long sbytes = 0L;
    private FTPTransferType transferType = null;

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost, controlPort);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr, controlPort);
    }

    public void login(String user, String password) throws IOException, FTPException {
        String response = this.control.sendCommand("USER " + user);
        this.control.validateReply(response, "331");
        response = this.control.sendCommand("PASS " + password);
        this.control.validateReply(response, "230");
    }

    public void user(String user) throws IOException, FTPException {
        String reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.control.validateReply(reply, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        String reply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202"};
        this.control.validateReply(reply, validCodes);
    }

    public void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        props.put("socksProxyPort", port);
        props.put("socksProxyHost", host);
        System.setProperties(props);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public void quote(String command, String[] validCodes) throws IOException, FTPException {
        String reply = this.control.sendCommand(command);
        if (validCodes != null && validCodes.length > 0) {
            this.control.validateReply(reply, validCodes);
        }
    }

    public void put(InputStream in, String remoteFile) throws IOException, FTPException {
        this.put(in, remoteFile, false);
    }

    public void put(InputStream in, String remoteFile, boolean append) throws IOException, FTPException {
        this.data = this.control.createDataSocket();
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        String cmd = append ? "APPE " : "STOR ";
        String reply = this.control.sendCommand(cmd + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        byte[] buf = new byte[4096];
        this.tmode = 1;
        this.tbytes = in.available();
        this.sbytes = 0L;
        int len = in.read(buf);
        while (len > -1) {
            out.write(buf, 0, len);
            this.sbytes += (long)len;
            len = in.read(buf);
        }
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.tmode = (short)-1;
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
    }

    public BufferedWriter putStart(String remoteFile) throws IOException, FTPException {
        return this.putStart(remoteFile, false);
    }

    public BufferedWriter putStart(String remoteFile, boolean append) throws IOException, FTPException {
        this.data = this.control.createDataSocket();
        DataOutputStream dos = new DataOutputStream(this.data.getOutputStream());
        OutputStreamWriter osw = new OutputStreamWriter(dos);
        BufferedWriter bw = new BufferedWriter(osw);
        String cmd = append ? "APPE " : "STOR ";
        String reply = this.control.sendCommand(cmd + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        return bw;
    }

    public void putEnd(BufferedWriter bw) throws IOException, FTPException {
        bw.flush();
        bw.close();
        try {
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.tmode = (short)-1;
        String[] validCodes2 = new String[]{"226", "250"};
        String reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
    }

    public byte[] get(String remoteFile) throws IOException, FTPException {
        int count;
        this.data = this.control.createDataSocket();
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in);
        String reply = this.control.sendCommand("RETR " + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        byte[] resultBuf = new byte[chunksize];
        byte[] temp = null;
        int bufsize = 0;
        while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
            temp = new byte[bufsize + count];
            System.arraycopy(resultBuf, 0, temp, 0, bufsize);
            System.arraycopy(chunk, 0, temp, bufsize, count);
            resultBuf = temp;
            bufsize += count;
        }
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
        return resultBuf;
    }

    public BufferedReader getStart(String remoteFile) throws IOException, FTPException {
        this.data = this.control.createDataSocket();
        DataInputStream din = new DataInputStream(this.data.getInputStream());
        BufferedReader br = new BufferedReader(new InputStreamReader(din));
        String reply = this.control.sendCommand("RETR " + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        return br;
    }

    public void getEnd(BufferedReader br) throws IOException, FTPException {
        try {
            br.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250"};
        String reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
    }

    public boolean site(String command) throws IOException, FTPException {
        String reply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "502"};
        this.control.validateReply(reply, validCodes);
        return reply.substring(0, 3).equals("200");
    }

    public String list(String mask) throws IOException, FTPException {
        return this.list(mask, false);
    }

    public String list(String mask, boolean full) throws IOException, FTPException {
        int count;
        boolean isBinary = false;
        if (this.transferType.equals(FTPTransferType.BINARY)) {
            isBinary = true;
            this.setType(FTPTransferType.ASCII);
        }
        this.data = this.control.createDataSocket();
        InputStreamReader in = new InputStreamReader(this.data.getInputStream());
        BufferedReader bIn = new BufferedReader(in);
        String command = full ? "LIST " : "NLST ";
        String reply = this.control.sendCommand(command + mask);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        int chunksize = 4096;
        char[] chunk = new char[chunksize];
        char[] resultBuf = new char[chunksize];
        char[] temp = null;
        int bufsize = 0;
        while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
            temp = new char[bufsize + count];
            System.arraycopy(resultBuf, 0, temp, 0, bufsize);
            System.arraycopy(chunk, 0, temp, bufsize, count);
            resultBuf = temp;
            bufsize += count;
        }
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
        if (isBinary) {
            this.setType(FTPTransferType.BINARY);
        }
        String result = null;
        if (resultBuf.length > 0) {
            result = new String(resultBuf);
        }
        return result;
    }

    public void debugResponses(boolean on) {
        this.control.debugResponses(on);
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        String reply = this.control.sendCommand("TYPE " + typeStr);
        this.control.validateReply(reply, "200");
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        String reply = this.control.sendCommand("DELE " + remoteFile);
        this.control.validateReply(reply, "250");
    }

    public void rename(String from, String to) throws IOException, FTPException {
        String reply = this.control.sendCommand("RNFR " + from);
        this.control.validateReply(reply, "350");
        reply = this.control.sendCommand("RNTO " + to);
        this.control.validateReply(reply, "250");
    }

    public void rmdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("RMD " + dir);
        this.control.validateReply(reply, "250");
    }

    public void mkdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("MKD " + dir);
        this.control.validateReply(reply, "257");
    }

    public void chdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("CWD " + dir);
        this.control.validateReply(reply, "250");
    }

    public String pwd() throws IOException, FTPException {
        String reply = this.control.sendCommand("PWD");
        this.control.validateReply(reply, "257");
        return reply;
    }

    public String system() throws IOException, FTPException {
        String reply = this.control.sendCommand("SYST");
        this.control.validateReply(reply, "215");
        return reply;
    }

    public void quit() throws IOException, FTPException {
        String reply = this.control.sendCommand("QUIT\r\n");
        this.control.validateReply(reply, "221");
        this.control.logout();
        this.control = null;
    }
}

