// CSP variable methods.

// Chris Thiel <cthiel@cse.unl.edu>
// 2008-02-02
// CSCE 821


#include "Variable.h"
#include "Constraint.h"


namespace CSPSolver
{
  const Neighbors &
  Variable::get_neighbors (void) const
  {
    // If no constraints have been added, then the neighbors are
    // unchanged, so just return them.
    if (!constraint_added && !constraint_removed)
      return neighbors;

    // If a constraint has been removed, clear the neighbors and reset
    // the constraint_removed flag.  Continue processing.
    if (constraint_removed)
      {
	neighbors.clear ();
	constraint_removed = false;
      }

    // Reset the constraint_added flag.
    assert (constraint_added);
    constraint_added = false;

    // For each constraint acting on this variable, add the variables
    // in its scope to neighbors (except this variable).
    for (ConstraintList::const_iterator ci (constraints.begin ());
	 ci != constraints.end (); ++ci)
      {
	assert (*ci != NULL);
	const Scope &scope ((*ci)->get_scope ());
	for (Scope::const_iterator vi (scope.begin ()); vi != scope.end ();
	     ++vi)
	  {
	    assert (*vi != NULL);
	    if (*vi != this)
	      neighbors.insert (*vi);
	  }
      }

    return neighbors;
  }


  std::ostream &
  operator<< (std::ostream &out, const Variable &var)
  {
    out << var.get_name ();
    return out;
  }


  std::ostream &
  operator<< (std::ostream &out, const VariableVector &vector)
  {
    out << '{';
    for (VariableVector::const_iterator i (vector.begin ()); i != vector.end ();
	 ++i)
      {
	assert (*i != NULL);
	if (i != vector.begin ())
	  out << ", ";
	out << **i;
      }
    out << '}';
    return out;
  }


  std::ostream &
  operator<< (std::ostream &out, const Neighbors &set)
  {
    out << '{';
    for (Neighbors::const_iterator i (set.begin ()); i != set.end (); ++i)
      {
	if (i != set.begin ())
	  out << ", ";
	assert (*i != NULL);
	out << **i;
      }
    out << '}';
    return out;
  }


  std::ostream &
  operator<< (std::ostream &out, const Vvp &vvp)
  {
    assert (vvp.first != NULL);
    out << '(' << *vvp.first << '=' << vvp.second << ')';
    return out;
  }


  std::ostream &
  operator<< (std::ostream &out, const VvpSet &vvps)
  {
    out << '{';
    for (VvpSet::const_iterator i (vvps.begin ()); i != vvps.end (); ++i)
      {
	if (i != vvps.begin ())
	  out << ", ";
	out << *i;
      }
    out << '}';
    return out;
  }
} // namespace CSPSolver



