// -*- C++ -*-

// Common data structures used to hold CSP variable values.

// Chris Thiel <cthiel@cse.unl.edu>
// 2008-02-02
// CSCE 821


#ifndef _Value_h_
#define _Value_h_

#include <cassert>
#include <iostream>
#include <set>
#include <vector>


namespace CSPSolver
{
  // This will work for values found in XCSP 2.1.
  typedef int Value;
  

  // A vector of values.  This is used for value tuples.
  typedef std::vector<Value> ValueVector;
  std::ostream &operator<< (std::ostream &out, const ValueVector &values);


  // A set of values representing a domain.
  typedef std::set<Value> Domain;
  std::ostream &operator<< (std::ostream &out, const Domain &domain);


  // A set of value vectors.  This can be used in constraint
  // definitions.  E.g., C(V_1, V_1) = {(1,2), (3,5), (2,3),...}.
  typedef std::set<ValueVector> ValueVectorSet;
  std::ostream &operator<< (std::ostream &out,
			    const ValueVectorSet &value_vec_set);
} // namespace CSPSolver

#endif	// _Value_h_
