// CSP constraint methods and functions.

// Chris Thiel <cthiel@cse.unl.edu>
// 2008-02-24
// CSCE 821


#include "Value.h"
#include <iostream>

namespace CSPSolver
{
  std::ostream &
  operator<< (std::ostream &out, const ValueVector &values)
  {
    out << '(';
    for (ValueVector::const_iterator i = values.begin (); i != values.end ();
	 ++i)
      {
	if (i != values.begin ())
	  out << ',';
	out << *i;
      }
    out << ')';
    return out;
  }


  std::ostream &
  operator<< (std::ostream &out, const ValueVectorSet &value_vec_set)
  {
    out << '{';
    for (ValueVectorSet::const_iterator i = value_vec_set.begin (); 
	 i != value_vec_set.end (); ++i)
      {
	if (i != value_vec_set.begin ())
	  out << ", ";
	out << *i;
      }
    out << '}';
    return out;
  }


  std::ostream &
  operator<< (std::ostream &out, const Domain &domain)
  {
//     out << domain.name << " (" << domain.id << "): ";
    out << '{';
    for (Domain::const_iterator i = domain.begin (); i != domain.end (); ++i)
      {
	if (i != domain.begin ())
	  out << ", ";
	out << *i;
      }
    out << '}';
    return out;
  }
} // namespace CSPSolver
