/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#include <malloc.h>
#include "utils.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "llist.h"
#include "globals.h"

static llist * profile_times = NULL;
double profiled [20];
char * profile_desc[20];
int    profiled_count[20];

void profile_time_start (int id, const char * desc ) {
  clock_t * t = NULL;
  extern main_structure * m_s_g;
  if ( m_s_g->profile == 0 ) 
    return;
  if ( profile_times == NULL ) {
    int i;
    profile_times = new_llist();
    for ( i = 0; i < 20; i++ ) {
      profiled[i] = -1.0;
      profile_desc[i] = NULL;
      profiled_count[i] = 0;
    }
  }

  if ( profiled[id] == -1.0 ) {
    profiled[id] = 0.0;
    profile_desc[id] = (char*)desc;
  }
  
  t = (clock_t*)checked_malloc(sizeof(clock_t) );
  add_node_tail(t, profile_times);
  *t = clock();
  profiled_count[id]++;
}

void profile_time_end (int id) {
  extern main_structure * m_s_g;
  if ( m_s_g->profile == 0 ) 
    return;
  else {
    clock_t et = clock();
    llist_node * tn  = remove_tail ( profile_times );
    clock_t * t = (clock_t*) tn->body;
    free(tn);
    profiled[id] += (((long long int)et-(long long int)(*t))*1000) / CLOCKS_PER_SEC;
    free(t);
  }
}

void print_profile (void) {
  int i;
  extern main_structure * m_s_g;
  if ( m_s_g->profile == 0 ) 
    return;

  if ( profile_times == NULL ) 
    return;
  if ( profile_times->head ) {
    printf("\n**************\nunbalanced profiling!***************\n");
  }
  for ( i = 0; i < 20; i++ ) {
    if ( profiled[i] == -1.0 ) {
      continue;
    }
    printf("%d. %s[%d]: %f msec.\n", i, profile_desc[i], profiled_count[i], profiled[i]);
  }
}


int string_equal_casted ( void * a, void * b ) { 
  return string_equal ( (char*)a, (char*)b );
}

int string_equal ( char * a, char * b ) { 

  int i;

  for ( i = 0; a[i] != '\0' && b[i] != '\0'; i++ )
    if ( a[i] != b[i] )
      return 0;

  if ( a[i] == '\0' && b[i] == '\0' ) 
    return 1;
  return 0;
}


char * str_copy ( char * a ) {

  int i;
  char * b = NULL;
  for ( i = 0; a[i] != '\0'; i++ );

  b = (char *) checked_malloc ( sizeof(char) * i+1 );

  for ( i = 0; a[i] != '\0'; i++ )
    b[i] = a[i];

  if ( a[i] == '\0' )
    b[i] = a[i];
	
  return b;


}


char * str_copy_short ( char * a, int max ) {

  int i;
  char * b = NULL;
  int maxi;

  for ( i = 0; a[i] != '\0' && i < max; i++ );
  maxi = i;

  b = (char *) checked_malloc ( sizeof(char) * i+1 );

  for ( i = 0; i < maxi; i++ )
    b[i] = a[i];

  b[i] = '\0';
	
  return b;


}



int max ( int a, int b) { 
  if ( a > b ) 
    return a;
  return b;
}

char * str_cat ( char * a, char * b ) {
  int i, j, k;

  char * c = NULL;

  for ( i = 0; a[i] != '\0'; i++ );
  for ( j = 0; b[j] != '\0'; j++ );

  c = (char*) checked_malloc ( sizeof(char) * (i+j+1) );

  k = 0;
  for ( i = 0; a[i] != '\0'; i++ )
    c[k++] = a[i];

  for ( j = 0; b[j] != '\0'; j++ ) 
    c[k++] = b[j];

  c[k] = '\0';
  
  return c;

}

char * str_cat_sep ( char * a, char * b, char * s ) {
  int i, j, k, l;

  char * c = NULL;

  for ( i = 0; a[i] != '\0'; i++ );
  for ( j = 0; b[j] != '\0'; j++ );
  for ( l = 0; s[l] != '\0'; l++ );

  c = (char*) checked_malloc ( sizeof(char) * (i+j+l+1) );

  k = 0;
  for ( i = 0; a[i] != '\0'; i++ )
    c[k++] = a[i];

  for ( l = 0; s[l] != '\0'; l++ )
    c[k++] = s[l];

  for ( j = 0; b[j] != '\0'; j++ ) 
    c[k++] = b[j];

  c[k] = '\0';
  
  return c;

}


void warn ( char * a ) {

  printf("** WARNING ***********************\n %s\n*******************************", a);

}

void error ( char * a ) {

  printf("**********************************\n %s\n*******************************", a);
  exit(0);
}

char * str_cat_recursive ( char * a, char * b, char * s ) {
  int i, j, k, l;

  char * c = NULL;

  for ( i = 0; a[i] != '\0'; i++ );
  for ( j = 0; b[j] != '\0'; j++ );
  for ( l = 0; s[l] != '\0'; l++ );

  c = (char*) checked_malloc ( sizeof(char) * (i+j+l+3) );

  k = 0;
  c[k++] = '(';

  for ( i = 0; a[i] != '\0'; i++ )
    c[k++] = a[i];

  for ( l = 0; s[l] != '\0'; l++ )
    c[k++] = s[l];

  for ( j = 0; b[j] != '\0'; j++ ) 
    c[k++] = b[j];

  c[k++] = ')';
  c[k] = '\0';
  
  return c;

}


void * checked_malloc ( int size ) {
  
  void * mm = malloc (size);
  if ( mm == NULL ) {
    printf ("requested malloc of size: %d \n", size);
    error ( "malloc failed!\n");
  }
  return mm;
}




int skip_char ( char * line, int i, char c ) {

  for ( ; line[i] == c; i++ );
  return i;

}

int skip_space ( char * line, int i ) {
  return skip_char ( line, i, ' ');
}

int get_int ( char * line, int i, int * num ) {
  int xi;
  int ei;

  xi = skip_space ( line, i );
  for ( ei = xi; line[ei] != ' ' && line[ei] != '\0'; ei++ );
  line[ei] = '\0';
  *num = atoi(&line[xi]);
  line[ei] = ' ';
  return ei;

}



int get_string ( char * line, int i, char ** str ) {
  int xi;
  int ei;
  int x = 0;
  int size = 0;

  xi = skip_space ( line, i );

  for ( ei = xi; line[ei] != ' ' && line[ei] != '\0'; ei++ )
    size++;
  size++;

  *str = (char *) checked_malloc ( sizeof(char) * size );

  for ( ei = xi; line[ei] != ' ' && line[ei] != '\0'; ei++ )
    (*str)[x++] = line[ei];

  (*str)[x] = '\0';
  return ei;

}

