/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#include "tree.h"
#include "utils.h"
#include <stdio.h>

tree * new_tree ( void * body ) {
  tree * t = (tree*) checked_malloc ( sizeof(tree) );
  t->children = new_llist();
  t->body = body;
  t->color = 0;
  t->parent = NULL;
  return t;
}

tree * new_int_tree ( int ibody ) {
  tree * t = new_tree ( NULL );
  t->ibody = ibody;
  return t;
}


void destroy_tree ( tree * t ) {
  
  llist_node * lp = NULL;
  for ( lp = t->children->head; lp != NULL; lp = lp->next ) {
    destroy_tree ( (tree*)lp->body );
  }
  destroy_list ( t->children );
  free ( t );
}

void destroy_tree_body ( tree * t, int l, int save_nodes ) {
  llist_node * lp = NULL;
  if ( t->body != NULL ) {
    int i; 
    int k;
    for ( k = 0; k <= l; k++ ) {
      if ( ((llist***)t->body)[k] == NULL ) {
	continue;
      }
      for ( i = 0; i < (int)((llist***)t->body)[k][0]; i++ ) {
	destroy_list( ((llist***)t->body)[k][i+1] );
      }
      free ( ((llist***)t->body)[k] );
    }
    free ( (llist***)t->body );
  }
  for ( lp = t->children->head; lp != NULL; lp = lp->next ) {
    destroy_tree_body ( (tree*)lp->body, l-1, save_nodes );
  }
  destroy_list ( t->children );
  if ( save_nodes == 0 ) {
    free ( t );
  }
}


tree * add_int_child ( int ibody, tree * t ) {
  tree * ct = new_int_tree ( ibody );
  add_node_tail ( ct, t->children );
  ct->parent = t;
  return ct;
}


void print_i_tree ( tree * t ) {
  
  llist_node * lp = NULL;
  printf("%d[c:%d]: ", t->ibody, t->color);
  for ( lp = t->children->head; lp != NULL; lp = lp->next ) {
    printf("%d ", ((tree*)lp->body)->ibody);    
  }
  printf("\n");
  for ( lp = t->children->head; lp != NULL; lp = lp->next ) {
    print_i_tree ( (tree*)lp->body );
  }
}

void print_i_tree_dot ( tree * t, char * x ) {
  
  llist_node * lp = NULL;
  int i = 1;
  int j = 0;
  char  y [1024];
  for ( lp = t->children->head; lp != NULL; lp = lp->next ) {
    printf("%s->", x);
    sprintf(y, "a%s_%d", x, ((tree*)lp->body)->ibody); 
    printf("%s;\n", y);
    print_i_tree_dot ( (tree*)lp->body, y );
  }
}
