/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#include "set.h"
#include "utils.h"
s_node * new_s_node ( int key, void * body ) {
  s_node * sn = (s_node *) checked_malloc ( sizeof (s_node) );
  sn->key = key;
  sn->body = body;
  return sn;
}

set * copy_set ( set * s ) {
  set * copy =  (set *) checked_malloc ( sizeof(set) );
  int i = 0;
  llist_node * np = NULL;
  copy->size = s->size;
  copy->map = (char*)checked_malloc ( s->size * sizeof(char) );
  copy->list = new_llist();
  for ( np = s->list->head; np != NULL; np = np->next ) {
    add_node_tail (      
		   new_s_node( ((s_node*)np->body)->key, ((s_node*)np->body)->body ), 
		   copy->list );
  }
  
  copy->element_ptrs  = NULL;
  if ( s->element_ptrs ) {
    //    error("this code is not veirfied yet!");
    copy->element_ptrs = (llist_node**)checked_malloc ( s->size * sizeof(llist_node*) );
    for ( np = copy->list->head; np != NULL; np = np->next ) {
      copy->element_ptrs[((s_node*)np->body)->key] = np;
    }    
  }
  for ( i = 0; i < copy->size; i++ ) {
    copy->map[i] = s->map[i];
  }
  return copy;
}

set * new_set ( int size ) {
  int i;
  //size is the max key
  set * nset = NULL;
  nset = (set *) checked_malloc ( sizeof(set) );
  nset->list = new_llist ();
  nset->map = (char*)checked_malloc ( size * sizeof(char) );
  nset->size = size;
  for ( i = 0; i < size; i++ )
    nset->map[i] = 'o';
  nset->element_ptrs = NULL;
  return nset;
}

set * new_set_map ( int size ) {
  int i;
  //size is the max key
  set * nset = NULL;
  nset = (set *) checked_malloc ( sizeof(set) );
  nset->list = new_llist ();
  nset->map = (char*)checked_malloc ( size * sizeof(char) );
  nset->element_ptrs = (llist_node**)checked_malloc ( size * sizeof(llist_node*) );
  nset->size = size;
  for ( i = 0; i < size; i++ ) {
    nset->map[i] = 'o';
    nset->element_ptrs[i] = NULL;
  }
  return nset;
}


void destroy_set ( set * s ) {
  destroy_list_body(s->list);
  free(s->map);
  if ( s->element_ptrs ) 
    free(s->element_ptrs);
  free(s);
}

int add_int_element ( set * s, int key ) {
  if ( key >= s->size ) {
    error("set size overflow!");
  }
  if ( s->map[key] == 'i' )
    return 0;
  s->map[key] = 'i';
  return 1;
}

int get_int_element ( set * s, int key ) {
  return s->map[key] == 'i';
}

int remove_int_element ( set * s, int key ) {
  if ( s->map[key] == 'i' ) {
    s->map[key] == 'o';
    return 1;
  }
  return 0;
}

int add_element ( set * s, void * e, int key ) {
  s_node * node = NULL;
  if ( key >= s->size ) {
    error("set size overflow!");
  }
  if ( s->map[key] == 'i' )
    return 0;

  node = new_s_node(key, e);
  add_element_node ( s, node );
  if ( s->element_ptrs ) {
    s->element_ptrs[key] = s->list->tail;
  }
  return 1;
}	

void add_element_node ( set * s, s_node * n ) {
	
  add_node_tail ( n, s->list );
  s->map[n->key] = 'i';
}	

void* remove_element ( set * s ) {
  llist_node * lln = remove_head ( s->list );
  s_node * sn = (s_node*)lln->body;
  void * ret;
  free(lln);
  s->map[sn->key] = 'o';
  ret = sn->body;
  s->last_removed = sn->key;
  free (sn);
  return ret;
}

void* peek_element ( set * s ) {
  llist_node * lln = s->list->head;
  s_node * sn = (s_node*)lln->body;
  void * ret;
  ret = sn->body;
  return ret;
}


void* remove_element_with_key ( set * s, int key ) {
  llist_node * lln = NULL;
  s_node * sn = NULL; 
  void * ret;
  if ( key >= s->size ) {
    error("key larget than set size!");
  }
  if ( s->map[key] == 'o' ) {
    return NULL;
  }
  lln = remove_node_no_check ( s->element_ptrs[key], s->list );
  sn = (s_node*)lln->body;
  free(lln);
  s->map[sn->key] = 'o';
  ret = sn->body;
  s->last_removed = sn->key;
  free (sn);
  return ret;
}


int remove_element_key ( set * s ) {
  llist_node * lln = remove_head ( s->list );
  s_node * sn = (s_node*)lln->body;
  int k = sn->key;
  free(lln);
  s->map[sn->key] = 'o';
  s->last_removed = sn->key;
  free (sn);
  return k  ;
}

int set_empty ( set * s ) {
  return s->list->head == NULL;
}

