/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#include <getopt.h>
#include <stdlib.h>
#include <stdio.h>
#include "globals_comb.h"
#include "ggenerator.h"
#include "combinations.h"
#include "utils.h"
#include "tree.h"
#include "globals.h"

main_structure_comb * m_s_g_c;
main_structure * m_s_g;
llist *** storedmult_leafs;
int multcount;
int main(int argc, char **argv) {

  int i = 0;
  char opt;
  int n = 0;
  double d = -1.0;
  int deg = -1;
  int e = -1;
  int t = 1;
  int s = 1;
  int c = 0;
  int C = 0;
  int B = 0;
  int X = 0;
  int ccount = 0;
  char * f = NULL;
  char * F = NULL;
  int vertices = -1;
  llist ** graphl = NULL;
  llist * sols = NULL;
  llist_node * np1 = NULL;
  llist_node * np2 = NULL;
  m_s_g = (main_structure*) checked_malloc ( sizeof(main_structure) );
  m_s_g->profile = 1;
  m_s_g_c = (main_structure_comb*) checked_malloc ( sizeof(main_structure_comb) );
  m_s_g_c->print_combs = 0;
  m_s_g_c->sum_tree_filter = 0;
  m_s_g_c->forward_check = 0;
  m_s_g_c->prop_algo = -1;

  while ( (opt = getopt( argc, argv, "pXhn:e:t:s:c:C:B:f:F:d:D:o:")) != -1 ) {

    switch ( opt ) {
    case 'h':
      printf("usage: comp [options]\n");
      printf("The random graph generator:\n");
      printf("\t-p\tprint combinations\n");
      printf("\t-n nodes-\tnumber of nodes to generate\n");
      printf("\t(-d density|-e edges|-D degree)\t specify the graph density or the number of edges or the degree of the graph\n");
      printf("\t-t tolerance\tAllow +/- tolerance for the degree of each node\n");
      printf("\t-s seed\tThe seed of the random number generated to generate random graphs\n");
      printf("\t-X\tcheck if the graph is connected and regenerate if not\n");

      printf("The combination generator:\n");
      printf("\t-c combination-size\tBrute-force algorithm for combinations of size combination-size\n");
      printf("\t-B combination-size\tBrute-force with partitioning algorithm for combinations of size combination-size\n");
      printf("\t-C combination-size\tConnected-subgraph  algorithm for combinations of size combination-size\n");
      printf("\t-f filename\tfilename of the graph. File format:\n\t\t#line -- commented line. ignored by the parser\n\t\tnodes vertices -- should appear on the first non-comment line. Just two integers separated by a space.\n\t\tnodeid nodeid -- two integers sparated by a spece, specifying an edge by the ids of the two nodes. The ids begin from 0 to nodes-1   \n");
      printf("\t-o [cp[prn|fc|dac|mac]]\toptions for connected subgraph: fc-forward checking, dac-directed arc consistency, mac-maintaining arc consistency\n");

      //[-p print combinatinos] (-n #nodes (-d density|-e #edges| -D degree) [-t tolerance] [-s seed]) \n         | (-c <brute-force combination-size> | -C combination-size | -B <brute-force-with-partitioning combination-size>| -X /*check connected*/) -f filename\n [-o [cp[prn|fc|dac|mac]] \n");
      exit (0);
      break;

    case 'p':
      m_s_g_c->print_combs = 1;
      break; 

    case 'n':
      n = atoi(optarg);
      break;
      
    case 'd':
      d = atof(optarg);
      break;

    case 'D':
      deg = atof(optarg);
      break;

    case 'e':
      e = atoi(optarg);
      break;
      
    case 't':
      t = atoi(optarg);
      break;
      
    case 's':
      s = atoi(optarg);
      break;
      
    case 'c':
      c = atoi(optarg);
      break;

    case 'C':
      C = atoi(optarg);
      break;

    case 'o':
      i = 0; 
      for ( ;optarg[i] != '\0'; i++ ) {
	if ( optarg[i] == 'c' && optarg[i+1] == 'p' ) {
	  m_s_g_c->forward_check = 1;
	  i++;
	  continue;
	}
	if ( optarg[i] == 'p' && optarg[i+1] == 'r' && optarg[i+2] == 'n' ) {
	  m_s_g_c->sum_tree_filter = 1;
	  i += 2;
	  continue;
	}
	if ( optarg[i] == 'f' && optarg[i+1] == 'c' ) {
	  m_s_g_c->prop_algo = 1;
	  i += 1;
	  continue;
	}
	if ( optarg[i] == 'd' && optarg[i+1] == 'a' && optarg[i+2] == 'c' ) {
	  m_s_g_c->prop_algo = 2;
	  i += 2;
	  continue;
	}
	if ( optarg[i] == 'm' && optarg[i+1] == 'a' && optarg[i+2] == 'c' ) {
	  m_s_g_c->prop_algo = 3;
	  i += 2;
	  continue;
	}
      }
      break;

    case 'B':
      B = atoi(optarg);
      break;

    case 'X':
      X = 1;
      break;

    case 'f':
      f = optarg;
      break;

    case 'F':
      f = optarg;
      F = optarg;
      break;

    default:
      printf("error! option unrecognized! try -h for help.\n");
      exit(1);
      break;
    }
  }

  if ( c > 0 && f == NULL ) {
    printf("enter file (-f file)\n");
    exit(1);
  }

  if ( n ) {
    m_s_g_c->cmap = (int*) checked_malloc ( sizeof(int) * n );
    m_s_g_c->v = 0;
    m_s_g_c->profile = 1;
    for  ( i = 0; i < n; i++ )  {
      m_s_g_c->cmap[i] = -1;
    }
  }
  
  if ( X && f != NULL ) {
    if ( F ) {
      vertices = parse2 ( &graphl, f );
    }
    else {
      vertices = parse ( &graphl, f );
    }
    m_s_g_c->cmap = (int*) checked_malloc ( sizeof(int) * vertices );
    m_s_g_c->v = 0;
    m_s_g_c->profile = 1;
    for  ( i = 0; i < vertices; i++ )  {
      m_s_g_c->cmap[i] = -1;
    }

    if ( graph_connected ( graphl, vertices ) ) {
      printf("graph connected\n");
    }
    else {
      printf("graph NOT connected\n");
    }
    exit(0);
  }

  if ( c == 0 && C == 0 && B == 0 ) {
    if ( n == 0 ) {
      printf("usage: comp [options]\n");
      printf("The random graph generator:\n");
      printf("\t-p\tprint combinations\n");
      printf("\t-n nodes-\tnumber of nodes to generate\n");
      printf("\t(-d density|-e edges|-D degree)\t specify the graph density or the number of edges or the degree of the graph\n");
      printf("\t-t tolerance\tAllow +/- tolerance for the degree of each node\n");
      printf("\t-s seed\tThe seed of the random number generated to generate random graphs\n");
      printf("\t-X\tcheck if the graph is connected and regenerate if not\n");

      printf("The combination generator:\n");
      printf("\t-c combination-size\tBrute-force algorithm for combinations of size combination-size\n");
      printf("\t-B combination-size\tBrute-force with partitioning algorithm for combinations of size combination-size\n");
      printf("\t-C combination-size\tConnected-subgraph  algorithm for combinations of size combination-size\n");
      printf("\t-f filename\tfilename of the graph. File format:\n\t\t#line -- commented line. ignored by the parser\n\t\tnodes vertices -- should appear on the first non-comment line. Just two integers separated by a space.\n\t\tnodeid nodeid -- two integers sparated by a spece, specifying an edge by the ids of the two nodes. The ids begin from 0 to nodes-1   \n");
      printf("\t-o [cp[prn|fc|dac|mac]]\toptions for connected subgraph: fc-forward checking, dac-directed arc consistency, mac-maintaining arc consistency\n");
      //      printf("usage: a.out [-p print combinatinos] (-n #nodes (-d density|-e #edges| -D degree) [-t tolerance] [-s seed]) \n         | (-c <brute-force combination-size> | -C combination-size | -B <brute-force-with-partitioning combination-size>| -X /*check connected*/) -f filename\n [-o [cp[prn|fc|dac|mac]] \n");
      exit (0);
    }
    generate_graph ( n, e, deg, d, t, s );
    exit(0);
  }
  if ( F ) {
    vertices = parse2 ( &graphl, f );
  }
  if ( f && !F ) {
    vertices = parse ( &graphl, f );
  }
  m_s_g_c->cmap = (int*) checked_malloc ( sizeof(int) * vertices );
  m_s_g_c->v = 0;
  m_s_g_c->profile = 1;
  for  ( i = 0; i < vertices; i++ )  {
    m_s_g_c->cmap[i] = -1;
  }

  if ( C ) {
    int x, y;
    m_s_g_c->vmap = (int*) checked_malloc ( sizeof(int) * vertices );
    for ( x = 0; x < vertices; x++ ) {
      m_s_g_c->vmap[x] = 0;
    }
   
    multcount = 0;
    storedmult_leafs = (llist***) malloc(sizeof(llist**)*C);
    for ( x = 0; x < C; x++ ) {
      storedmult_leafs[x] = (llist**) malloc(sizeof(llist*)*C);
      for ( y = 0; y < C; y++ ) {
	storedmult_leafs[x][y] = NULL;
      }
    }
   
    profile_time_start ( 5, "main-kcc" );
    ccount = get_combinations ( graphl, vertices, C, NULL );
    profile_time_end ( 5 );
    //    if ( m_s_g_c->print_combs ) {
      //      printf("multcount: %d\n", multcount );
    //    }
    printf("count: %d\n", ccount );
  }
  
  ccount = -1;
    
  if ( sols ) {
    for ( np1 = sols->head; np1 != NULL; np1 = np1->next ) {
      for ( np2 = ((llist*)np1->body)->head; np2 != NULL; np2 = np2->next ) {
	printf("%d ", ((tree*)np2->body)->ibody);
      }
      printf("\n");
    }
  }

  if ( B ) { 
    llist ** occurances = NULL;
    profile_time_start ( 7, "main-sub-graphs" );    
    ccount = get_bf_combinations_from_subgraphs ( graphl, B, vertices, occurances );
    profile_time_end ( 7 );    
    printf("count: %d\n", ccount );
  }


  if ( c ) {
    profile_time_start ( 6, "main-bf" );
    switch ( c ) {
    case 8:
      ccount = get_bf_combinations_8 ( graphl, c, vertices );
      break;
    case 7:
      ccount = get_bf_combinations_7 ( graphl, c, vertices );
      break;
    case 6:
      ccount = get_bf_combinations_6 ( graphl, c, vertices );
      break;
    case 5:
      ccount = get_bf_combinations_5 ( graphl, c, vertices );
      break;
    case 4:
      ccount = get_bf_combinations_4 ( graphl, c, vertices );
      break;
    case 3:
      ccount = get_bf_combinations_3 ( graphl, c, vertices );
      break;
    case 2:
      ccount = get_bf_combinations_2 ( graphl, c, vertices );
      break;
      
    }
    profile_time_end ( 6 );
    
    printf("count: %d\n", ccount );
  }

  print_profile();
}
