/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#ifndef LLIST_H
#define LLIST_H

#include <stdlib.h>

typedef struct llist_node {
  void * body;
  int ibody;
  struct llist_node * next;
  struct llist_node * previous;
  struct llist * list;
}llist_node;

typedef struct  llist {
  struct llist_node * head;
  struct llist_node * tail;
  struct llist_node * min;
  struct llist_node * max;
  int id;
  int count;
	
}llist;

llist_node * new_lnode (void);
llist * new_llist (void);

void add_int ( int ibody, llist * list );
void add_node ( void * body, llist * list );
void add_node_tail ( void * body, llist * list );
void add_node_tail_distinct ( void * body, llist * list );
void add_int_tail ( int ibody, llist * list );
void add_int_tail_distinct ( int ibody, llist * list );
void add_this_node_tail ( llist_node * node, llist * list );
void add_this_node ( llist_node * node, llist * list );
llist_node * remove_node ( llist_node * node, llist * list );
llist_node * remove_node_no_check ( llist_node * node, llist * list );
void remove_node_of_body ( void * body, llist * list );
llist_node * find_remove_node_of_body  ( void * value, int compare (void * value, void * bodyb), llist * list );
llist_node * get_node_of_body ( void * body, llist * list );
llist_node * find_node_of_value ( void * value, int compare (void*value, void * bodyb),  llist * list );
llist_node * find_node_of_ivalue ( int value, llist * list );
llist_node * remove_single_node_of_body ( void * body, llist * list );
llist_node * remove_head ( llist * list );
llist_node * remove_tail ( llist * list );
llist * copy_value_llist ( llist * list );
llist * copy_llist ( llist * list );
void copy_llist_to ( llist * list, llist * destination_list );
void copy_llist_to_distinct ( llist * list, llist * destination_list );
llist * copy_int_llist_add_pos ( llist * list, int pos0 );
int is_empty ( llist * list );

void destroy_list_nodes_only ( llist * list );
void destroy_list_nodes ( llist_node * llist_node );
void destroy_list_nodes_body ( llist_node * llist_node );
void destroy_list ( llist * list );
void destroy_list_body ( llist * list );
int max_int ( llist * list, int get_value(void * body) );
int max_int ( llist * list, int get_value(void * body) );

llist_node * remove_max ( llist * list, int get_value(void * body) );
llist_node * remove_min ( llist * list, int get_value(void * body) );

llist_node * get_max ( llist * list, int get_value(void * body) );
llist_node * get_min ( llist * list, int get_value(void * body) );

void move_to_tail ( llist_node * node, llist * list );
void move_to_head ( llist_node * node, llist * list );

llist_node * remove_node_of_ibody ( int ibody, llist * list );
llist_node * get_node_of_ibody ( int ibody, llist * list );
int min_int ( llist * list, int get_value(void * body) );
void move_llist_to ( llist * list, llist * destination_list );
#endif
