/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#ifndef SET_H
#define SET_H
#include <stdlib.h>
#include "llist.h"

typedef struct s_node {
  int key;
  void * body;
} s_node;

typedef struct set {

  llist * list;
  char * map;//'i' for in, 'o' for out
  llist_node ** element_ptrs;
  int last_removed;
  int size;
}set;

s_node * new_s_node ( int key, void * body ); 
set * new_set ( int size );
set * new_set_map ( int size );
int add_element ( set * s, void * e, int key ); 
void add_element_node ( set * s, s_node * n );
void* remove_element ( set * s );
int remove_element_key ( set * s );
int set_empty ( set * s ); 
void destroy_set ( set * s );
void* peek_element ( set * s );
void* remove_element_with_key ( set * s, int key );
int remove_int_element ( set * s, int key );
int get_int_element ( set * s, int key );
int add_int_element ( set * s, int key );
set * copy_set ( set * s );

#endif
