/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#include "llist.h"
#include "utils.h"

static int llistids = 0;
llist_node * new_lnode (void) {

  llist_node * nnode = (llist_node *) checked_malloc ( sizeof(llist_node) );
  nnode->body = NULL;
  nnode->next = NULL;
  nnode->previous = NULL;
  nnode->list = NULL;
  return nnode;
}

llist * new_llist (void) {

  llist * nlist = (llist *) checked_malloc ( sizeof(llist) );
  nlist->head = NULL;
  nlist->tail = NULL;
  nlist->count = 0;
  nlist->id = llistids++;
  return nlist;	

}

void destroy_list_nodes_only ( llist * list ) {
  destroy_list_nodes ( list->head );
  list->head = NULL;
  list->tail = NULL;
  list->count = 0;
}

void destroy_list_nodes ( llist_node * nodes ) {

  llist_node * llnp = NULL;
  llist_node * llnp2 = NULL;

  if ( nodes == NULL ) 
    return;
  llnp = nodes->next;
  llnp2 = nodes;
  for ( ; llnp != NULL; llnp = llnp->next ) {
    free(llnp2);
    llnp2 = llnp;
  }
  free(llnp2);
}

void destroy_list_nodes_body ( llist_node * nodes ) {
  
  llist_node * llnp = NULL;
  llist_node * llnp2 = NULL;
  if ( nodes == NULL ) 
    return;
  llnp = nodes->next;
  llnp2 = nodes;
  for ( ; llnp != NULL; llnp = llnp->next ) {
    free(llnp2->body);
    free(llnp2);
    llnp2 = llnp;
  }
  free(llnp2->body);
  free(llnp2);
}

void destroy_list ( llist * list ) {

  destroy_list_nodes ( list->head );
  free (list);
}

void destroy_list_body ( llist * list ) {

  destroy_list_nodes_body ( list->head );
  free (list);
}



void add_int ( int ibody, llist * list ) {

  llist_node * nnode = NULL;

  nnode = new_lnode();
  nnode->ibody = ibody;

  list->count++;
  nnode->previous = NULL;

  if ( list->head == NULL ) {

    list->head = nnode;
    list->tail = nnode;
  }
  else {

    nnode->next = list->head;
    list->head->previous = nnode;
    list->head = nnode;	
  }

}


void add_node ( void * body, llist * list ) {

  llist_node * nnode = NULL;

  if ( body == NULL )
    return;

  nnode = new_lnode();
  nnode->body = body;

  list->count++;
  nnode->previous = NULL;

  if ( list->head == NULL ) {

    list->head = nnode;
    list->tail = nnode;
  }
  else {

    nnode->next = list->head;
    list->head->previous = nnode;
    list->head = nnode;	
  }

}


void add_node_tail ( void * body, llist * list ) {

  llist_node * nnode = NULL;
  if ( body == NULL )
    return;

  nnode = new_lnode();
	
  nnode->body = body;

  list->count++;
  nnode->next = NULL;

  if ( list->head == NULL ) {

    list->head = nnode;
    list->tail = nnode;
  }
  else {

    nnode->previous = list->tail;
    list->tail->next = nnode;
    list->tail = nnode;	
  }

}

//first removes the node if already in list, then adds it
//to the tail
void add_node_tail_distinct ( void * body, llist * list ) {

  remove_node_of_body ( body, list );
  add_node_tail ( body, list );

}


void add_int_tail_distinct ( int ibody, llist * list ) {
  llist_node * np;
  for ( np = list->head; np != NULL; np = np->next ) {
    if ( ibody == np->ibody )
      break;
  }
  if ( np == NULL ) {
    add_int_tail ( ibody, list );
  }

}


void add_int_tail ( int ibody, llist * list ) {

  llist_node * nnode = new_lnode();
  nnode->ibody = ibody;

  list->count++;
  nnode->next = NULL;

  if ( list->head == NULL ) {

    list->head = nnode;
    list->tail = nnode;
  }
  else {

    nnode->previous = list->tail;
    list->tail->next = nnode;
    list->tail = nnode;	
  }

}



void add_this_node_tail ( llist_node * node, llist * list ) {

  if ( node == NULL )
    return;

  list->count++;
  node->next = NULL;
  node->previous = NULL;

  if ( list->head == NULL ) {

    list->head = node;
    list->tail = node;
  }
  else {

    node->previous = list->tail;
    list->tail->next = node;
    list->tail = node;	
  }
}


void add_this_node ( llist_node * node, llist * list ) {

  if ( node == NULL )
    return;

  list->count++;
  node->next = NULL;
  node->previous = NULL;

  if ( list->head == NULL ) {

    list->head = node;
    list->tail = node;
  }
  else {

    node->next = list->head;
    list->head->previous = node;
    list->head = node;	
  }
}


llist_node * find_remove_node_of_body ( void * value, int compare (void * value, void * bodyb), llist * list ) {
  llist_node * nptr = NULL;
  
  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( compare ( value, nptr->body ) ) {
      return remove_node_no_check ( nptr, list );
    }
  }
  return NULL;
}


//TODO: to substitute with this all places where remove_node is not needed
llist_node * remove_node_no_check ( llist_node * node, llist * list ) {

  llist_node * nptr = node;
  if ( node == NULL )
    return NULL;

  list->count--;
  if ( nptr->previous != NULL ) 
    nptr->previous->next = nptr->next;
  else
    list->head = nptr->next;

  if ( nptr->next != NULL )
    nptr->next->previous = nptr->previous;
  else
    list->tail = nptr->previous;

  nptr->next = NULL;
  nptr->previous = NULL;
  return nptr;
}


void move_to_tail ( llist_node * node, llist * list ) {
  remove_node_no_check ( node, list );
  add_this_node_tail ( node, list );
}

void move_to_head ( llist_node * node, llist * list ) {
  remove_node_no_check ( node, list );
  add_this_node ( node, list );
}



llist_node * remove_node ( llist_node * node, llist * list ) {

  llist_node * nptr = list->head;

  if ( node == NULL )
    return NULL;
		
  //TODO: no need for this step if sure the value in the list! 
  for ( ; nptr != node && nptr != NULL; nptr = nptr->next );
	
  if ( nptr == node ) {
    list->count--;
    if ( nptr->previous != NULL ) 
      nptr->previous->next = nptr->next;
    else
      list->head = nptr->next;

    if ( nptr->next != NULL )
      nptr->next->previous = nptr->previous;
    else
      list->tail = nptr->previous;

    nptr->next = NULL;
    nptr->previous = NULL;
    return nptr;
  }
  else {
    return NULL;
  }
}


//could be duplicates!
//TODO: take care after setting duplicates
void remove_node_of_body ( void * body, llist * list ) {

  llist_node * nptr = list->head;
  llist_node * nptr_temp = NULL;

  for ( ; nptr != NULL; ) {

    nptr_temp = nptr->next;
    if ( nptr->body == body ) {

      list->count--;
      if ( nptr->previous != NULL ) 
	nptr->previous->next = nptr->next;
      else
	list->head = nptr->next;

      if ( nptr->next != NULL )
	nptr->next->previous = nptr->previous;
      else
	list->tail = nptr->previous;

      free(nptr);
    }
    nptr = nptr_temp;
  }
}

llist_node * remove_single_node_of_body ( void * body, llist * list ) {

  llist_node * nptr = list->head;
  llist_node * nptr_temp = NULL;

  for ( ; nptr != NULL; ) {

    nptr_temp = nptr->next;
    if ( nptr->body == body ) {

      list->count--;
      if ( nptr->previous != NULL ) 
	nptr->previous->next = nptr->next;
      else
	list->head = nptr->next;

      if ( nptr->next != NULL )
	nptr->next->previous = nptr->previous;
      else
	list->tail = nptr->previous;

      nptr->next = NULL;
      nptr->previous = NULL;
      return nptr;
    }
    nptr = nptr_temp;
  }
  return NULL;
}

llist_node * find_node_of_value ( void * value, int compare (void*value, void * bodyb),  llist * list ) {
  llist_node * nptr = NULL;
  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( compare(value, nptr->body) ) {
      return nptr;
    }
  }
  return NULL;
}


llist_node * find_node_of_ivalue ( int value, llist * list ) {
  llist_node * nptr = NULL;
  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( value == nptr->ibody) {
      return nptr;
    }
  }
  return NULL;
}


llist_node * get_node_of_body ( void * body, llist * list ) {

  llist_node * nptr = list->head;
  llist_node * nptr_temp = NULL;

  for ( ; nptr != NULL; ) {
    nptr_temp = nptr->next;
    if ( nptr->body == body ) {
      return nptr;
    }
    nptr = nptr_temp;
  }

  return NULL;

}


llist_node * remove_head ( llist * list ) {

  llist_node * rnode = list->head;
  if ( rnode == NULL )
    return NULL;

  list->count--;
  list->head = list->head->next;

  if ( list->head == NULL )
    list->tail = NULL;


  if ( list->head != NULL )
    list->head->previous = NULL;

  rnode->next = NULL;
  rnode->previous = NULL;

  return rnode;
}


llist_node * remove_tail ( llist * list ) {

  llist_node * rnode = list->tail;
  if ( rnode == NULL )
    return NULL;

  list->count--;
  list->tail = list->tail->previous;
  if ( list->tail == NULL ) {
    list->head = NULL;		
  }
  else {
    list->tail->next = NULL;
  }
  rnode->next = NULL;
  rnode->previous = NULL;

  return rnode;
}


void move_llist_to ( llist * list, llist * destination_list ) {

  if ( destination_list->head == NULL ) {
    destination_list->head = list->head;
    destination_list->tail = list->tail;    
  }
  else {
    if ( list->head == destination_list->head ) 
      error("cannot copy same lists!");
    destination_list->head->previous = list->tail;
    list->tail->next = destination_list->head;
    destination_list->head = list->head;
  }
  destination_list->count += list->count;
}

void copy_llist_to ( llist * list, llist * destination_list ) {

  llist_node * nptr = NULL;

  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( nptr->body == NULL ) {
      add_int_tail ( nptr->ibody, destination_list );
    }
    else {
      add_node_tail ( nptr->body, destination_list );
      destination_list->tail->ibody = nptr->ibody;
    }
  }
}

//TODO: fix this n^2 thing
void copy_llist_to_distinct ( llist * list, llist * destination_list ) {

  llist_node * nptr = NULL;

  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( !get_node_of_body (nptr->body, destination_list ) ) {
      add_node_tail ( nptr->body, destination_list );
    }
  }
}


llist * copy_int_llist_add_pos ( llist * list, int pos0 ) {

  llist * copy_list = new_llist();
  llist_node * nptr = NULL;
  int p = pos0;
  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    int * nbody = (int*) checked_malloc ( 2 * sizeof(int));
    nbody[0] = *(int*)nptr->body;
    nbody[1] = p;
    add_node_tail ( nbody, copy_list );
    p++;
  }

  return copy_list;
}



llist * copy_llist ( llist * list ) {

  llist * copy_list = new_llist();
  llist_node * nptr = NULL;

  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    add_node_tail ( nptr->body, copy_list );
  }

  return copy_list;
}



int is_empty ( llist * list ) {

  return list->head == NULL;
}


int max_int ( llist * list, int get_value(void * body) ) {

  llist_node * nptr = NULL;
  int max = -1;
  
  if ( list == NULL || list->head == NULL ) 
    return -1;

  max = get_value(list->tail->body);

  for ( nptr = list->tail; nptr != NULL; nptr = nptr->previous ) {
    if ( max < get_value(nptr->body) ) {
      max = get_value(nptr->body);
    }
  }
  return max;
}


int min_int ( llist * list, int get_value(void * body) ) {

  llist_node * nptr = NULL;
  int min = -1;
  if ( list == NULL || list->head == NULL ) 
    return -1;


  min = get_value(list->head->body);

  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( min > get_value(nptr->body) ) {
      min = get_value(nptr->body);
    }
  }
  return min;
}



llist_node * remove_max ( llist * list, int get_value(void * body) ) {

  llist_node * nptr = NULL;
  llist_node * maxptr = NULL;
  int max = -1;

  if ( list == NULL || list->head == NULL ) 
    return NULL;

  max = get_value(list->tail->body);
  maxptr = list->tail;

  for ( nptr = list->tail; nptr != NULL; nptr = nptr->previous ) {
    if ( max < get_value(nptr->body) ) {
      max = get_value(nptr->body);
      maxptr = nptr;
    }
  }

  nptr = maxptr;

  if ( nptr != NULL ) {
    list->count--;
    if ( nptr->previous != NULL ) 
      nptr->previous->next = nptr->next;
    else
      list->head = nptr->next;

    if ( nptr->next != NULL )
      nptr->next->previous = nptr->previous;
    else
      list->tail = nptr->previous;

    nptr->next = NULL;
    nptr->previous = NULL;
    return nptr;
  }
  else {
    return NULL;
  }
}





llist_node * remove_min ( llist * list, int get_value(void * body) ) {

  llist_node * nptr = NULL;
  llist_node * minptr = NULL;
  int min = -1;
  
  if ( list == NULL || list->head == NULL ) 
    return NULL;

  min = get_value(list->head->body);
  minptr = list->head;

  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( min > get_value(nptr->body) ) {
      min = get_value(nptr->body);
      minptr = nptr;
    }
  }

  nptr = minptr;

  if ( nptr != NULL ) {
    list->count--;
    if ( nptr->previous != NULL ) 
      nptr->previous->next = nptr->next;
    else
      list->head = nptr->next;

    if ( nptr->next != NULL )
      nptr->next->previous = nptr->previous;
    else
      list->tail = nptr->previous;

    nptr->next = NULL;
    nptr->previous = NULL;
    return nptr;
  }
  else {
    return NULL;
  }
}





llist_node * get_max ( llist * list, int get_value(void * body) ) {

  llist_node * nptr = NULL;
  llist_node * maxptr = NULL;
  int max = -1;
  if ( list == NULL || list->head == NULL ) 
    return NULL;

  max = get_value(list->tail->body);
  maxptr = list->tail;

  for ( nptr = list->tail; nptr != NULL; nptr = nptr->previous ) {
    if ( max < get_value(nptr->body) ) {
      max = get_value(nptr->body);
      maxptr = nptr;
    }
  }

  return maxptr;
}





llist_node * get_min ( llist * list, int get_value(void * body) ) {

  llist_node * nptr = NULL;
  llist_node * minptr = NULL;
  int min = -1;

  if ( list == NULL || list->head == NULL ) 
    return NULL;

  min = get_value(list->head->body);
  minptr = list->head;

  for ( nptr = list->head; nptr != NULL; nptr = nptr->next ) {
    if ( min > get_value(nptr->body) ) {
      min = get_value(nptr->body);
      minptr = nptr;
    }
  }

  return minptr;
}


llist_node * remove_node_of_ibody ( int ibody, llist * list ) {

  llist_node * nptr = list->head;
  llist_node * nptr_temp = NULL;

  for ( ; nptr != NULL; ) {

    nptr_temp = nptr->next;
    if ( *((int*)nptr->body) == ibody ) {

      list->count--;
      if ( nptr->previous != NULL ) 
	nptr->previous->next = nptr->next;
      else
	list->head = nptr->next;

      if ( nptr->next != NULL )
	nptr->next->previous = nptr->previous;
      else
	list->tail = nptr->previous;

      nptr->next = NULL;
      nptr->previous = NULL;
      return nptr;
    }
    nptr = nptr_temp;
  }
  return NULL;
}



llist_node * get_node_of_ibody ( int ibody, llist * list ) {

  llist_node * nptr = list->head;
  llist_node * nptr_temp = NULL;

  for ( ; nptr != NULL; ) {

    nptr_temp = nptr->next;
    if ( nptr->ibody == ibody ) {

      return nptr;
    }
    nptr = nptr_temp;
  }
  return NULL;
}



