/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#include "ggenerator.h"
#include "utils.h"
#include <math.h>
#include <stdio.h>

void generate_graph ( int vertices, int edges, int degree, double density, int tolarance, int seed ) {

  char ** grapht = NULL;
  int i = 0;
  int j = 0;
  int * counts = NULL;
  int randna = -1;
  int randnb = -1;
  int maxdegree = 0;
  int limit = 0;
  int connected = 0;
  llist ** graphl = NULL;
  srand(seed);
  
  if ( edges == -1 ) {
    if ( degree == -1 ) {
      edges = (vertices*(vertices-1))*density/2;
    }
    else {
      edges = degree * vertices / 2;
    }
  }

  if ( density == -1 ) {
    density = (double)edges / (double)(vertices*(vertices-1)/2);
  }


  maxdegree = (int)ceil ((double)edges * 2 / (double)vertices) + tolarance;

  printf("#edges: %d degree: %d density: %f\n", edges, maxdegree, density );
  counts = (int*) checked_malloc(sizeof(int) * vertices );

  if ( edges * 2 > maxdegree * vertices || edges + 1 < vertices ) {
    printf( "edges x 2 > maxdegree * vertices: %d x 2 > %d x %d \n", edges, maxdegree, vertices);
    error ( "impossible to generate!");
  }

  grapht = (char**) checked_malloc ( sizeof(char*)*vertices );
  for ( i = 0; i < vertices; i++ ) {
    grapht[i] = (char*) checked_malloc ( sizeof(char)*vertices );
    counts[i] = 0;
    for ( j = 0; j < vertices; j++ ) {
      grapht[i][j] = '0';
    }
  }
  limit = edges * 1000;
  do {
    while ( i != edges ) {
      for ( i = 0; i < vertices; i++ ) {
	counts[i] = 0;
	for ( j = 0; j < vertices; j++ ) {
	  grapht[i][j] = '0';
	}
      }
      //generate the graph
      for ( i = 0; i < edges; i++ ) {
	int cc = 0;
	do {
	  randna = (int) (vertices * ((float)rand()   /   (float)(RAND_MAX+1.0) ));
	  cc++;
	  if ( cc == limit ) {
	    error("I thought will never happen!");
	    break; 
	  }
	}while ( randna >= vertices || counts[randna] >= maxdegree );
	if ( cc == limit ) 
	  break;
	cc = 0;
	do {
	  randnb = (int) (vertices * ((float)rand()   /   (float)(RAND_MAX+1.0) ));
	  cc++;
	  if ( cc == limit ) {

	    break;
	  }
	}while ( randnb >= vertices || counts[randnb] >= maxdegree || randna == randnb || grapht[randna][randnb] == '1' );
	if ( cc == limit ) 
	  break;
	
	counts[randna]++;
	counts[randnb]++;
	
      grapht[randna][randnb] = '1';
      grapht[randnb][randna] = '1';
      }
    }
    convert_grapht_graphl ( &graphl, grapht, vertices );
    connected = graph_connected ( graphl, vertices );
    destroy_graphl ( graphl, vertices );
  } while ( !connected );

  //print the graph
  printf("%d %d\n", vertices, edges );
  
  for ( i = 0; i < vertices; i++ ) {
    for ( j = i+1; j < vertices; j++ ) {
      if ( grapht[i][j] == '1' ) {
	printf ( "%d %d\n", i, j );
      }
    }
  }
}



void destroy_graphl (llist ** graphl, int vertices ) {
  int i;
  for ( i = 0; i < vertices; i++ ) {
    destroy_list ( graphl[i] );
  }
  free ( graphl );
}

int convert_grapht_graphl ( llist *** graphl, char ** grapht, int vertices ) {

  int a = 0;
  int b = 0;
  int v = 0;
  int e = 0;
  int i = 0;
  int j = 0;
  llist ** g = NULL;
  char tmp [257];
  
  g = (llist**) checked_malloc ( sizeof(llist*) * vertices );
  *graphl = g;
  for ( i = 0; i < vertices; i++ ) {
    g[i] = new_llist();
  }

  for ( j = 0; j < vertices; j++ ) {
    for ( i = j+1; i < vertices; i++ ) {
      if ( grapht[i][j] != '1' )
	continue;
      a = i;
      b = j;
      add_int_tail ( a, g[b] );
      add_int_tail ( b, g[a] );
      g[b]->tail->list = g[b];
      g[a]->tail->list = g[a];
      g[b]->tail->body = g[a]->tail;
      g[a]->tail->body = g[b]->tail;
    }
  }
  return v;
}


int parse ( llist *** graphl, char * filename ) {

  FILE * f = fopen ( filename, "r" );
  int a = 0;
  int b = 0;
  int v = 0;
  int e = 0;
  int i = 0;
  int j = 0;
  llist ** g = NULL;
  char tmp [257];

  fgets ( tmp, 256, f);
  fscanf( f, "%d %d\n", &v, &e );
  g = (llist**) checked_malloc ( sizeof(llist*) * v );
  *graphl = g;
  
  for ( i = 0; i < v; i++ ) {
    g[i] = new_llist();
  }

  for ( i = 0; i < e; i++ ) {
    fscanf( f, "%d %d\n", &a, &b );
    add_int_tail ( a, g[b] );
    add_int_tail ( b, g[a] );
    g[b]->tail->list = g[b];
    g[a]->tail->list = g[a];
    g[b]->tail->body = g[a]->tail;
    g[a]->tail->body = g[b]->tail;
  }
  fclose(f);
  return v;
}



int parse2 ( llist *** graphl, char * filename ) {

  FILE * f = fopen ( filename, "r" );
  int a = 0;
  int b = 0;
  int c = 0;
  int v = 0;
  int e = 0;
  int i = 0;
  int j = 0;
  llist ** g = NULL;
  char tmp [257];
  int ** gmat = NULL;

  fgets ( tmp, 256, f);
  fgets ( tmp, 256, f);
  fscanf( f, "# directed_scale_free_graph(%d,", &v );
  fgets ( tmp, 256, f);
  g = (llist**) checked_malloc ( sizeof(llist*) * v );
  gmat = ( int ** ) malloc(sizeof(int*) * v );
  *graphl = g;
  
  for ( i = 0; i < v; i++ ) {
    g[i] = new_llist();
    gmat[i] = ( int * ) malloc(sizeof(int) * v );
    for ( j = 0; j < v; j++ ) {
      gmat[i][j] = 0;
    }
  }

  for ( i = 0; 1; i++ ) {
    if ( fscanf( f, "%d %d {}\n", &a, &b ) == EOF ){
      break;
    }
    if ( gmat[a][b] ) 
      continue;
    if ( a == b ) 
      continue;
    e++;
    gmat[a][b] = 1;
    gmat[b][a] = 1;
    add_int_tail ( a, g[b] );
    add_int_tail ( b, g[a] );
    g[b]->tail->list = g[b];
    g[a]->tail->list = g[a];
    g[b]->tail->body = g[a]->tail;
    g[a]->tail->body = g[b]->tail;
  }
  fclose(f);
  for ( i = 0; i < v; i++ ) {
    free (gmat[i]);
  }
  free (gmat);
  printf("loaded v:%d e:%d\n", v, e);
  return v;
}
