/* Copyright (c) 2010, Shant Karakashian                                                                                                    
   All rights reserved.                                                                                                                     
*/
#ifndef COMBINATIONS_H
#define COMBINATIONS_H

#include "llist.h"
#include "tree.h"
#include "set.h"


typedef struct solution_structure {

  int size; 
  llist ** solutions;
  

}solution_structure;


int compare_nodes ( void * va, void * vb );
int  comb ( llist  ** graphl, int c, int l, int k, set * alpha, tree * b );
void collect_solutions ( int * counts, int size, llist * branches, llist * solutions_list );
llist ** get_solutions_of_size ( tree *  n, int  k );
void combine_check_solution (  int * counts, int size,  void * arg1, void * arg2 );
void count_base_k ( int k, int l, llist * children, llist * solution_list  );
void count_base_kv ( int * kv, int l, void function(), void * arg1, void  * arg2 );
int get_combinations ( llist ** graphl, int vertices, int c, llist * combs );
int get_combinations_with ( int n, llist ** graphl, int vertices, int * gcolors, int c, llist * combs  );
void print_node_tree ( tree * b, int * gcolors, int t );
void markup_node_tree_recursive ( tree * b, int * gcolors );
void markup_node_tree ( tree * b, int * gcolors, int vertices );
void multipliers ( int k, int d, int * sizes_d, int depth, tree * mults, llist * leafs );

void collect_solutions_with_all_combs ( int * counts, int size, llist * branches, llist * solutions_list );
void count_base_k_function ( int * xk, int i, int l, int k, llist * children, llist * solution_list  );
void memo_count_base_k_function ( int * xk, int i, int l, int k, llist * children, llist * solution_list  );
void xxcount_base_k_function ( int * xk, int i, int l, int k, void arg00(), void * arg01, void * arg02  );
void n_choose_i ( int n, int i, int l, tree * chose, llist * leafs );
int hide_get_combinations ( llist ** graphl, int vertices, int c, llist * combs );
int get_bf_combinations_8 ( llist ** graphl, int c, int vertices );
int get_bf_combinations_7 ( llist ** graphl, int c, int vertices );
int get_bf_combinations_6 ( llist ** graphl, int c, int vertices );
int get_bf_combinations_5 ( llist ** graphl, int c, int vertices );
int get_bf_combinations_4 ( llist ** graphl, int c, int vertices );
int get_bf_combinations_3 ( llist ** graphl, int c, int vertices );
int get_bf_combinations_2 ( llist ** graphl, int c, int vertices );
void mark_cmap ( int c, llist ** marked );
void clear_cmarks ( llist * marked );
void dfs_on_marked ( int n, llist ** graphl );
int check_connected_subgraph ( llist * cgns, llist ** graphl );
int graph_connected ( llist ** graphl, int vertices );

int sac_check_join ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc );
int dac_check_join  ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc, llist * remaining_vars  );
int forward_check_join ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc, llist * remaining_vars);
int assign_next_join ( int x, llist_node ** assigned_values, llist ** domain_lists, llist ** assigned_current_domains );
void undo_filtering_join (int l, llist ** undo_list, llist ** domain_lists );
int fc_join ( int l, llist *** solutions, llist * solutions_list, llist ** passed_domain_lists );
int mac_check_join  ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc, llist * remaining_vars  );
int check_constraint ( llist * comba, llist * combb );
int revise_combs ( int * tuple, llist *** solutions, int  *** last, char ** alive );
int apply_ac_join (llist *** solutions, set * queue);
void print_combinations ( llist * combs );
void print_combination ( llist * comb );
int choose_var_join ( llist * remaining_vars, llist ** domain_lists );
void get_distance_k_nodes_rec ( llist ** graphl, int node, int k, int vertices, llist * dirty, llist * collected, int dfo );
llist * get_distance_k_nodes ( llist ** graphl, int node, int k, int vertices );
int get_bf_combinations_from_subgraphs ( llist ** graphl, int c, int vertices, llist ** occurances );
int get_bf_combinations_list_8 ( llist ** graphl, int c, llist * vertices );
int get_bf_combinations_list_7 ( llist ** graphl, int c, llist * vertices );
int get_bf_combinations_list_6 ( llist ** graphl, int c, llist * vertices );
int get_bf_combinations_list_5 ( llist ** graphl, int c, llist * vertices );
int get_bf_combinations_list_4 ( llist ** graphl, int c, llist * vertices );
int get_bf_combinations_list_3 ( llist ** graphl, int c, llist * vertices );
int get_bf_combinations_list_2 ( llist ** graphl, int c, llist * vertices );
int compare_ints (const int *a, int *b);
void backtrack_search_join ( int l, llist *** solutions, llist * solutions_list );
int backtrack_search_join_rec ( int l, llist_node ** assigned_values, llist ** assigned_current_domains, llist * remaining_vars, llist *** solutions, llist * solutions_list, llist ** domain_lists  );


#endif
