/* Copyright (c) 2010, Shant Karakashian 
   All rights reserved.
*/
#include <stdio.h>
#include <stdlib.h>
#include "combinations.h"
#include "llist.h"
#include "utils.h"
#include "tree.h"
#include "globals_comb.h"

static int xxx = 0;
int comb ( llist  ** graphl, int c, int l, int k, set * alpha, tree * b ){

  set * alphap = NULL;
  llist_node * np; 
  int cgn = -1; 
  int i = 0;
  tree * tn = NULL;
  extern main_structure_comb * m_s_g_c;
  int subtree_count  = 1;
  if ( l == k ) {
    b->subtree_size = subtree_count;    
    return subtree_count;
  }

  alphap = copy_set(alpha);
  
  //TODO free new_tree
  add_int_element ( alphap, c );

  if ( b->body == NULL ) {
    b->body = (llist ***) checked_malloc ( sizeof(llist**) * (k-l+2) );
    for ( i = 0; i < k-l+2; i++ ) {
      ((llist***)b->body)[i] = NULL;
    }
  }

  for ( np = graphl[c]->head; np != NULL; np = np->next ) {
    
    cgn = np->ibody;

    if ( get_int_element ( alphap, cgn ) == 0 ) {

      tn = new_int_tree(cgn);
      add_node_tail ( tn, b->children );
      tn->parent = b;
      tn->body = (llist ***) checked_malloc ( sizeof(llist**) * (k-l+1) );
      for ( i = 0; i < k-l+1; i++ ) {
	((llist***)tn->body)[i] = NULL;
      }
      subtree_count += comb ( graphl, cgn, l+1, k, alphap, tn);
      add_int_element ( alphap, cgn );
    }
  }
  destroy_set(alphap);
  b->subtree_size = subtree_count;
  return subtree_count;
}


void collect_solutions ( int * counts, int size, llist * branches, llist * solutions_list ) {
  extern main_structure_comb * m_s_g_c;
  int i,j; 
  int l = size;
  //  llist * branches = (llist*)arg1;
  llist_node * np = branches->head;
  
  llist *** not_zero_solutions = NULL;
  //  llist * solutions_list = arg2;

  //  llist * xa = new_llist();
  //  llist * xb = new_llist();

  int * kv = NULL;
  int notzero = 0;

  if ( m_s_g_c->forward_check == 0 ) {
    return collect_solutions_with_all_combs ( counts, size, branches, solutions_list );
  }


  not_zero_solutions = (llist ***) checked_malloc ( sizeof(llist**) * l );
  kv = (int*) checked_malloc(sizeof(int)*l);
  /*
    solutions is an array of size 'size', each position points to an array X
    each array X has at pos 0 the size of the array, and each of the other positions hold 
    a solution given as a list of cgn's. 
  */
  xxx++;
  for ( i = 0; i < size; i++ ) {
    if ( counts[i] > 0 ) {
      not_zero_solutions[notzero] = get_solutions_of_size ( (tree*)np->body, counts[i] );
      if (  not_zero_solutions[notzero][0] == 0 ) {
	free ( not_zero_solutions );
	return;
      } 
      //for ( j = 1; j <= not_zero_solutions[notzero][0]; j++) print_combination (not_zero_solutions [notzero ][j]);
      notzero++;
    }
    //failed to get the required number of solutions from this branch
    np = np->next;
  }
  
  /*
    the solutions 2d array flattened into an array of lists
  */
  /*
    The CSP method
  */

  ////////  fc_join ( notzero, not_zero_solutions, solutions_list, NULL );
  backtrack_search_join ( notzero, not_zero_solutions, solutions_list );


  free ( not_zero_solutions );  
  free(kv);
}


void collect_solutions_with_all_combs ( int * counts, int size, llist * branches, llist * solutions_list ) {
  
  int i; 
  int l = size;
  llist_node * np = branches->head;
  
  llist *** solutions = (llist ***) checked_malloc ( sizeof(llist**) * l );

  int * kv = (int*) checked_malloc(sizeof(int)*l);
  /*
    solutions is an array of size 'size', each position points to an array X
    each array X has at pos 0 the size of the array, and each of the other positions hold 
    a solution given as a list of cgn's. 
  */

  for ( i = 0; i < l; i++ ) 
    solutions[i] = NULL;

  for ( i = 0; i < size; i++ ) {
    solutions[i] = get_solutions_of_size ( (tree*)np->body, counts[i] );
    //failed to get the required number of solutions from this branch
    if ( solutions[i][0] == 0 ) {
      free(kv);
      if (  0 ) {//does not take place because need to remember the solutions
	for ( i--; i >= 0; i-- ) {
	  int j;
	  for ( j = 0; j < (int)solutions[i][0]; j++ ) {
	    destroy_list ( solutions[i][j+1] );
	  }
	}
	free(solutions[i]);
      }
      free ( solutions );
      return;
    }
    np = np->next;
  }

  /*
    the solutions 2d array flattened into an array of lists
  */
  for ( i = 0; i < l; i++ ) {
    kv[i] = (int)solutions[i][0];
  }
  count_base_kv ( kv, l, combine_check_solution, solutions, solutions_list );
  free ( solutions );
  free(kv);
}

void print_combinations ( llist * combs ) {
  llist_node * cm = NULL;
  llist_node * cm2 = NULL;
  for ( cm = combs->head; cm != NULL; cm = cm->next ) {
    for ( cm2 = ((llist*)cm->body)->head; cm2 != NULL; cm2 = cm2->next ) {
      printf("%d ", ((tree*)cm2->body)->ibody);
    }
    printf("\n");
  }
}

void print_combination ( llist * comb ) {
  llist_node * cm2 = NULL;
  for ( cm2 = comb->head; cm2 != NULL; cm2 = cm2->next ) {
    printf("%d ", ((tree*)cm2->body)->ibody);
  }
  printf("\n");
}





int check_constraint ( llist * combR, llist * combL ) {
  
  int i = 0;
  int j = 0;

  llist_node * ip = NULL;
  llist_node * jp = NULL;
  extern main_structure_comb * m_s_g_c;
  int orig = 0;

  //check common variables
  for ( ip = combR->head; ip != NULL; ip = ip->next ) {
    int cgn =  ((tree*)ip->body)->ibody;
    m_s_g_c->vmap[cgn] = 1;
    //    printf("%d ", cgn);
  }
  //  printf(" xxxx\n ");
  for ( ip = combL->head; ip != NULL; ip = ip->next ) {
    int cgn =  ((tree*)ip->body)->ibody;
    //    printf("%d ", cgn);
    if ( m_s_g_c->vmap[cgn] == 1 ) {
      //have common vartex! fail
      for ( ip = combR->head; ip != NULL; ip = ip->next ) {
	int cgn =  ((tree*)ip->body)->ibody;
	m_s_g_c->vmap[cgn] = 0;
      }  
      return 0;
    }
  }
  //  printf(" xxxx\n ");
  for ( ip = combR->head; ip != NULL; ip = ip->next ) {
    int cgn =  ((tree*)ip->body)->ibody;
    m_s_g_c->vmap[cgn] = 0;
  }  

  //check original node
  for ( ip = combR->head; ip != NULL; ip = ip->next ) {
    if ( ((tree*)ip->body)->color ) {
      orig++;
      break;
    }
  }
  if ( orig ) {
    return 1;
  }

  {//TODO: can improve this!
    int bbreak = 0;
    //for each node n in this branch, if no node in the all previous branches has n as a child, then make it orig
    for ( ip = combR->head; ip != NULL; ip = ip->next ) {
      int cgn = ((tree*)ip->body)->ibody;
      //for each node on the previous branch
      for ( jp = combL->head; jp != NULL; jp = jp->next ) {
	tree * tnx = (tree*) jp->body;
	//for each child of the x node
	llist_node * child = NULL;
	for ( child = tnx->children->head; child != NULL; child = child->next ) {
	  if ( ((tree*)child->body)->ibody == cgn ) {
	    return 0;
	  }
	}
      }	      
    }
  }
  return 1;
}

/*
//tuple specifies the two variables to revise
//the solutions is a 2d array. first dimention the variable, the second: 
//   first postion count of combinatons, rest the combinations
//filter tuple[0] given tuple[1]
int revise_combs ( int * tuple, llist *** solutions, int  *** last, char ** alive ) {

//delete <- false
int delete = 0;
int a = 0;
int b = 0;

//for each a in D_i
for ( a = 0; a < (int)solutions[tuple[0]][0]; a++ ) {
//    b <- last((x_i, a), x_j)
b = last[tuple[0]][tuple[1]][a];
//    if b \notin D_j
if ( alive[tuple[1]][b] == '0' ) {
//    b <- succ(b, D_j)
b++;
if ( b == (int)solutions[b][0] ) {
b = -1;
}
//    while ( b != NULL && !C_ij(a,b)
while ( b != -1 //&& check_constraint (tuple[0], tuple[1], a, b, solutions, vmap)
) {
//        b <- succ(b, D_j)
b++;
if ( b == (int)solutions[b][0] ) {
b = -1;
}
}
//    if ( b != NULL ) 
if ( b != -1 ) {
//        last((x_i, a), x_j) <- b
last[tuple[0]][tuple[1]][a] = b;
}
//    else
else {
//        delete a from D_i
alive[tuple[0]][a] = '0';
delete = 1;
}
}
}
return delete;
}


int apply_ac_join (llist *** solutions, set * queue) {
  
int i = 0;
while ( !set_empty(queue) ) {
int * tuple = (int*) remove_element(queue);
    
if ( revise_combs ( tuple, solutions, NULL, NULL ) ) {
//push into queue all (x_k,x_i) | k != j
}
}    
  
}
 
*/

int dac_check_join  ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc, llist * remaining_vars  ) {
  //for each var x > var
  //for each value in x
  int x = 0;
  llist_node * xp = NULL;
  int givenvar = var;
  int check = 0;
  for ( givenvar = var; givenvar < l-1; givenvar++ ) {
    for ( x = givenvar+1; x < l; x++ ) {
      for ( xp = domain_lists[x]->head; xp != NULL;  ) {
	(*cc)++;
	if ( givenvar == var ) {
	  if ( var < x )
	    check = check_constraint ( (llist*)xp->body, (llist*)assigned_values[var]->body );
	  else
	    check = check_constraint ( (llist*)assigned_values[var]->body, (llist*)xp->body );
	}
	else {
	  llist_node * vp = NULL;
	  check = 0;
	  for ( vp = domain_lists[givenvar]->head; vp != NULL; vp = vp->next ) {
	    if ( givenvar < x )	    
	      check = check_constraint ( (llist*)xp->body, (llist*)vp->body );
	    else
	      check = check_constraint ( (llist*)vp->body, (llist*)xp->body );
	    if ( check ) 
	      break;
	  }
	}
	if ( !check ) {
	  llist_node * toremove = xp;
	  xp = xp->next;
	  if ( undo_list[x] == NULL ) {
	    undo_list[x] = new_llist();
	  }
	  add_this_node ( remove_node_no_check(toremove, domain_lists[x]),  undo_list[x] );
	}
	else {
	  xp = xp->next;
	}
	if ( domain_lists[x]->count == 0 ) {
	  return 0;
	}
      }
    }
  }
  return 1;
}

//////broken! useless
////int sac_check_join ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc ) {
////  //for each var x > var
////  //for each value in x
////  int x = 0;
////  llist_node * xp = NULL;
////  llist_node * sdp = NULL;
////  int givenvar = var;
////  int check = 0;
////  llist * single_value_domain = NULL;
////  llist * orig_domain = NULL;
////  llist ** temp_undo_list = NULL;
////  int pass = 0;
////
////  //!!!!!!!!!!!  pass = forward_check_join ( var, l,  assigned_values, domain_lists, undo_list, cc );
////  if ( !pass ) {
////    return 0;
////  }
////
////  single_value_domain = new_llist();
////  for ( givenvar = l-2; givenvar > var; givenvar-- ) {
////    orig_domain = domain_lists [givenvar];
////    //for each value in the domain of givenvar, check if a sol exists.
////    for ( sdp = orig_domain->head; sdp != NULL;  ) {
////      llist_node * nextsdp = sdp->next;
////      add_node_tail ( sdp->body, single_value_domain );
////      domain_lists[givenvar] = single_value_domain;
////      profile_time_start ( 10, "fc_join" );
////      pass = fc_join ( l-givenvar, NULL, NULL, &(domain_lists[givenvar]) );
////      profile_time_end ( 10 );
////      domain_lists[givenvar] = orig_domain;
////      if ( pass == 0 ) {
////	if ( undo_list[givenvar] == NULL ) {
////	  undo_list[givenvar] = new_llist();
////	}
////	add_this_node ( remove_node_no_check(sdp, domain_lists[givenvar]), undo_list[givenvar] );
////	if ( domain_lists[givenvar]->count == 0 ) {
////	  return 0;
////	}
////      }
////      sdp = nextsdp;
////    }
////  }
////  return 1;
////}
////


int mac_check_join  ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc, llist * remaining_vars  ) {
  //for each var x > var
  //for each value in x
  int x = 0;
  llist_node * xp = NULL;
  int check = 0;
  int i, j;
  set * queue = NULL;
  int *** last = NULL;
  char ** alive = NULL;
  llist_node *** domains = NULL;
  int * counts  = NULL;
  int delete = 0;
  int domwipeout = 0;
  int * pair = NULL;

  last = (int***) checked_malloc(sizeof(int**)*l);
  alive = (char**) checked_malloc(sizeof(char*)*l);
  counts = (int *) checked_malloc(sizeof(int)*l);
  queue = new_set ( l*l );
  for ( i = var; i < l; i++ ) {
    last[i] = (int**) checked_malloc(sizeof(int*)*l);
    alive[i] = (char*) checked_malloc(sizeof(char)*((llist*)domain_lists[i])->count );
    for ( x = 0; x < ((llist*)domain_lists[i])->count; x++ ) {
      alive[i][x] = 'y';
    }
    counts[i] = domain_lists[i]->count;
    for ( j = var; j < l; j++ ) {
      pair = NULL;
      if ( j == i )
	continue;
      pair = (int*) checked_malloc(sizeof(int)*2);
      pair[0] = i;
      pair[1] = j;
      add_element ( queue, pair, pair[0]*l+pair[1] );
      last[i][j] = (int*) checked_malloc(sizeof(int)*domain_lists[i]->count);
      for ( x = 0; x < domain_lists[i]->count; x++ ) {
	last[i][j][x] = -1;
      }
    }
  }
  pair = NULL;

  domains = (llist_node***) checked_malloc(sizeof(llist_node**)*l);
  for ( i = var; i < l; i++ ) {
    //    int bingo = 0;
    //    int bingo2= 0;
    xp = domain_lists[i]->head;
    domains[i] = (llist_node**) checked_malloc(sizeof(llist_node*)*domain_lists[i]->count );
    for ( j = 0; j < domain_lists[i]->count; j++ ) {
      /*      if (  ((tree*)xp->body)->ibody == 0 || ((tree*)xp->body)->ibody == 1 && domain_lists[i]->count == 2 )
	      bingo++;
	      if (  ((tree*)xp->body)->ibody == 12 || ((tree*)xp->body)->ibody == 13 && domain_lists[i]->count == 2 )
	      bingo2++;
      */
      domains[i][j] = xp;
      xp = xp->next;
    }
    /*    if ( bingo == 2 ) 
	  printf("boom1! %d\n", xxx);
	  if ( bingo2 == 2 ) 
	  printf("boom2! %d\n", xxx);
    */
  }
  while ( !set_empty(queue) ) {
    pair = (int*) remove_element ( queue );
    delete = 0;
    //revise
    {
      for ( i = 0; i < domain_lists[pair[0]]->count; i++ ) {
	if ( alive[pair[0]][i] == 'n' )
	  continue;
	j = last[pair[0]][pair[1]][i];
	while ( 1 ) {
	  int check = 0;
	  if ( j == domain_lists[pair[1]]->count ) {
	    j = -1;
	    break;
	  }
	  if ( j == -1 || alive[pair[1]][j] == 'n' ) {
	    j++;
	    continue;
	  }
	  if ( pair[0] < pair[1] )
	    check = check_constraint ( (llist*)domains[pair[1]][j]->body, (llist*)domains[pair[0]][i]->body );
	  else 
	    check = check_constraint ( (llist*)domains[pair[0]][i]->body, (llist*)domains[pair[1]][j]->body );
	  if ( check == 1 ) 
	    break;
	  j++;
	}
	if ( j != -1 ) {
	  last[pair[0]][pair[1]][i] = j;
	}
	else {
	  delete = 1;
	  alive[pair[0]][i] = 'n';
	  counts[pair[0]]--;
	  if ( counts[pair[0]] == 0 )  {
	    domwipeout = 1;
	    break;
	  }
	}
      }//for domain
    }//revise     
    if ( domwipeout  ) 
      break;
    if ( delete ) {
      i = pair[0];
      for ( j = var; j < l; j++ ) {
	if ( i == j )
	  continue;
	if ( !get_int_element ( queue, j*l+i ) ){
	  int * npair = (int*) checked_malloc(sizeof(int)*2);
	  npair[0] = j;
	  npair[1] = i;
	  add_element ( queue, npair, pair[0]*l+pair[1] );
	}
      }
    }
    free ( pair );
    pair = NULL;
  }
  if ( pair ) {
    free ( pair );
  }
  if ( domwipeout == 0 ) {
    for ( i = var; i < l; i++ ) {
      int dc = 0;
      dc = domain_lists[i]->count;
      for ( j = 0; j < dc; j++ ) {
	if ( alive[i][j] == 'n' ) {
	  if ( undo_list[i] == NULL ) {
	    undo_list[i] = new_llist();
	  }
	  add_this_node ( remove_node_no_check(domains[i][j], domain_lists[i]),  undo_list[i] );	
	}
      }
    }
  }
  
  //free stuff
  while ( !set_empty(queue) ) {
    free ( remove_element(queue) );
  }
  destroy_set(queue);

  for ( i = var; i < l; i++ ) {
    for ( j = var; j < l; j++ ) {
      if ( i == j )
	continue;
      free( last[i][j] );
    }
    free(last[i]);
    free(alive[i]);
    free(domains[i]);
  }
  free(last);
  free(alive);
  free(counts);
  free(domains);


  return (domwipeout == 0);
}

int forward_check_join ( int var, int l, llist_node ** assigned_values, llist ** domain_lists, llist ** undo_list, int * cc, llist * remaining_vars  ) {
  //for each var x > var
  //for each value in x
  int x = 0;
  llist_node * xp = NULL;
  int check = 0;
  llist_node * next_var = NULL;
  for ( next_var = remaining_vars->head; next_var != NULL; next_var = next_var->next ) {
    x = next_var->ibody;
    for ( xp = domain_lists[x]->head; xp != NULL;  ) {
      (*cc)++;
      if ( var < x ) 
	check = check_constraint ( (llist*)xp->body, (llist*)assigned_values[var]->body );
      else 
	check = check_constraint ( (llist*)assigned_values[var]->body, (llist*)xp->body );	
      if ( !check ) {
	llist_node * toremove = xp;
	xp = xp->next;
	if ( undo_list[x] == NULL ) {
	  undo_list[x] = new_llist();
	}
	add_this_node ( remove_node_no_check(toremove, domain_lists[x]),  undo_list[x] );
	if ( domain_lists[x]->count == 0 ) {
	  return 0;
	}
      }
      else {
	xp = xp->next;
      }
    }
    if ( domain_lists[x]->count == 0 ) {
      return 0;
    }
  }
  return 1;
}

 
int assign_next_join ( int x, llist_node ** assigned_values, llist ** domain_lists, llist ** assigned_current_domains ) {

  if ( assigned_values[x] == NULL ) {
    assigned_values[x] = domain_lists[x]->head;
    assigned_current_domains[x] = domain_lists[x];
    domain_lists[x] = new_llist();
    add_node_tail ( assigned_values[x]->body, domain_lists[x] );    
    return 1;
  }
  
  if ( assigned_values[x]->next == NULL ) {
    assigned_values[x] = NULL;
    destroy_list(domain_lists[x]);
    domain_lists[x] = assigned_current_domains[x];
    assigned_current_domains[x] = NULL;
    return 0;
  }

  assigned_values[x] = assigned_values[x]->next;
  free ( remove_tail ( domain_lists[x] ) );
  add_node_tail ( assigned_values[x]->body, domain_lists[x] );    	 
  return 1;
}


void undo_filtering_join (int l, llist ** undo_list, llist ** domain_lists ) {
  int x = 0;
  for ( x = 0; x < l; x++ ) {
    if ( undo_list[x] != NULL && undo_list[x]->count) {
      move_llist_to ( undo_list[x], domain_lists[x] );
      undo_list[x]->head = NULL;
      undo_list[x]->tail = NULL;
      undo_list[x]->count = 0;
    }
  }
}


int compare_ints (const int *a, int *b) {
  int temp = a[0] - b[0];
  if (temp > 0)
    return 1;
  else if (temp < 0)
    return -1;
  else
    return 0;
}


void backtrack_search_join ( int l, llist *** solutions, llist * solutions_list ) {
  llist_node ** assigned_values = (llist_node**) checked_malloc(sizeof(llist_node*)*l);
  llist ** assigned_current_domains = (llist**) checked_malloc(sizeof(llist*)*l);
  llist ** domain_lists = (llist**) checked_malloc ( sizeof(llist*) * l );
  llist * remaining_vars = new_llist ();
  int i = 0;
  int k = 0;
  int j = 0;

  for ( i = 0; i < l; i++ ) {
    assigned_values[i] = NULL;
    assigned_current_domains[i] = NULL;    
    add_int_tail ( i, remaining_vars );
  }
  
  for ( k = 0; k < l; k++ ) {
    i = k;
    domain_lists[k] = new_llist ();
    for ( j = 1; j <= (int)solutions[i][0]; j++ ) {
      add_node_tail ( solutions[i][j], domain_lists[k] );
    }
  }
  
  backtrack_search_join_rec ( l, assigned_values, assigned_current_domains, remaining_vars, solutions, solutions_list, domain_lists );

  for ( k = 0; k < l; k++ ) {
    i = k;
    destroy_list ( domain_lists[k] );
  }
  
  free ( assigned_values );
  free ( assigned_current_domains );
  free ( domain_lists );
  destroy_list ( remaining_vars );
}

int choose_var_join ( llist * remaining_vars, llist ** domain_lists ) {
  llist_node * v = NULL;
  int min = 0;
  llist_node * min_pos = NULL;
  int ret_val = -1;
  min = domain_lists[remaining_vars->head->ibody]->count;
  min_pos = remaining_vars->head;
  for ( v = remaining_vars->head; v != NULL; v = v->next ) {
    if ( domain_lists[v->ibody]->count < min ) {
      min_pos = v;
    }
  }
  ret_val = min_pos->ibody;
  free ( remove_node_no_check ( min_pos, remaining_vars ) );
  return ret_val;
}


int backtrack_search_join_rec ( int l, llist_node ** assigned_values, llist ** assigned_current_domains, llist * remaining_vars, llist *** solutions, llist * solutions_list, llist ** domain_lists  ) {
  extern main_structure_comb * m_s_g_c;
  int var = -1;
  int consistent = 0;
  int sol_found = 0;
  int i = 0;
  llist ** undo_list = NULL;
  int cc = 0;
  if ( remaining_vars->count == 0 ) {
    llist * solution = new_llist();
    llist_node * np = NULL;
    llist * psol = NULL;
    for ( i = 0; i < l; i++ ) {
      psol = (llist*)assigned_values[i]->body;
      for ( np = psol->head; np != NULL; np = np->next ) {
	add_node_tail ((tree*)np->body, solution);
      }
    }
    add_node_tail ( solution, solutions_list );
    
    return 1;
  }
  
  //choose the var
  var = choose_var_join ( remaining_vars, domain_lists );
  undo_list = (llist**) checked_malloc(sizeof(llist*)*l);
  for ( i = 0; i < l; i++ ) {
    undo_list [i] = NULL;
  }
  //try each value of the variable
  while ( 1 ) { //while there are more values for var to be assigned
    consistent = assign_next_join ( var, assigned_values, domain_lists, assigned_current_domains );
    if ( !consistent ) {
      undo_filtering_join(l, undo_list, domain_lists);
      break;
    }
    //propagate constraints
    switch ( m_s_g_c->prop_algo ) {
    case 1:
      consistent =  forward_check_join ( var, l, assigned_values, domain_lists, undo_list, &cc, remaining_vars  );
      break;
    case 2:
      consistent =  dac_check_join ( var, l, assigned_values, domain_lists, undo_list, &cc, remaining_vars   );
      break;
    case 3:
      consistent =  mac_check_join ( var, l, assigned_values, domain_lists, undo_list, &cc, remaining_vars  );
      break;
    default:
      error("choose prop algo!");
    }
    if ( consistent ) {
      //do with the remaining vars
      sol_found = backtrack_search_join_rec ( l, assigned_values, assigned_current_domains, remaining_vars, solutions, solutions_list, domain_lists  );   
    }
    undo_filtering_join(l, undo_list, domain_lists);
  }
  
  add_int_tail ( var, remaining_vars );
  for ( i = 0; i < l; i++ ) {
    if ( undo_list[i] && undo_list[i]->count ) {
      error("undo list should be empty!");
    }
    if ( undo_list[i] ) {
      destroy_list ( undo_list[i] );
    }
  }
  free ( undo_list );
  return sol_found; 
}
///////
///////int fc_join ( int l, llist *** solutions, llist * solutions_list, llist ** passed_domain_lists ) {
///////  
///////  
///////  /* for each variable x from 0 to l-1
///////     assign x
///////     for each variable y from x+1 to l-1
///////     ---forwardcheck(x,y)//filter y given x
///////  */
///////  extern main_structure_comb * m_s_g_c;
///////  int x = 0;
///////  int y = 0;
///////  int failed = 0;
///////  int i = 0;
///////  int j = 0;
///////  int k = 0;
///////  llist ** domain_lists =  NULL;
///////  llist_node ** assigned_values = (llist_node**) checked_malloc(sizeof(llist_node*)*l);
///////  llist ** assigned_current_domains = (llist**) checked_malloc(sizeof(llist*)*l);
///////  llist * undo_lists = new_llist();//list of levels. each level has array[l], each position list of deleted
///////  //  char ** alive = NULL;
///////  int nv = 0;
///////  int cc = 0;
///////  int sols = 0;
///////  int dp = 1;
///////
///////  if ( passed_domain_lists == NULL ) {
///////    domain_lists = (llist**) checked_malloc ( sizeof(llist*) * l );
///////  }
///////  else {
///////    domain_lists = passed_domain_lists;
///////  }
///////
///////  for ( i = 0; i < l; i++ ) {
///////    assigned_values[i] = NULL;
///////    assigned_current_domains[i] = NULL;    
///////  }
///////
///////  if ( passed_domain_lists == NULL ) {
///////    sortedmap = (int*) checked_malloc ( 2*l*sizeof(int) );
///////    //sort the vars
///////    for ( i = 0; i < l; i++ ) {
///////      sortedmap[2*i] = (int)solutions[i][0];
///////      sortedmap[2*i+1] = i;
///////    }
///////    qsort (sortedmap, l, 2*sizeof(int), compare_ints);
///////    for ( k = 0; k < l; k++ ) {
///////      i = sortedmap[2*k+1];
///////      domain_lists[k] = new_llist ();
///////      dp *= (int)solutions[i][0];
///////      for ( j = 1; j <= (int)solutions[i][0]; j++ ) {
///////	add_node_tail ( solutions[i][j], domain_lists[k] );
///////      }
///////    }
///////  }
///////  if ( m_s_g_c->print_combs ) {
///////    if ( dp > 10000 ) {
///////      printf ("doms: %d : ", dp);
///////      for ( i = 0; i < l; i++ ) {
///////	printf("%d ", (int)solutions[i][0] );
///////      }
///////      printf ("\n");
///////    }
///////  }
///////
///////
///////  x = 0;
///////  while ( 1 ) {
///////    for ( ; x < l && x >= 0;  ) {
///////      llist ** undo_list = NULL;
///////      if ( x < undo_lists->count ) {
///////	undo_filtering_join(l, (llist**)undo_lists->tail->body, domain_lists);
///////	free ( remove_tail( undo_lists ) );
///////      }
///////      if ( !assign_next_join ( x, assigned_values, domain_lists, assigned_current_domains ) ) {
///////	x--;
///////	continue;
///////      }
///////      nv++;
///////      failed = 0;
///////      undo_list = (llist**) checked_malloc(sizeof(llist*)*l);
///////      for ( i = 0; i < l; i++ ) {
///////	undo_list[i] = NULL;
///////      }
///////      add_node_tail ( undo_list, undo_lists );
///////      switch ( m_s_g_c->prop_algo ) {
///////      case 1:
///////	failed =  ( l > 1 && forward_check_join ( x, l, assigned_values, domain_lists, undo_list, &cc, sortedmap  ) == 0 );
///////	break;
///////      case 2:
///////	failed =  ( l > 1 && dac_check_join ( x, l, assigned_values, domain_lists, undo_list, &cc, sortedmap   ) == 0 );
///////	break;
///////      case 3:
///////	failed =  ( l > 1 && mac_check_join ( x, l, assigned_values, domain_lists, undo_list, &cc, sortedmap  ) == 0 );
///////	break;
///////      default:
///////	error("choose prop algo!");
///////      }
///////
///////      if ( failed ) {
///////	undo_filtering_join(l, (llist**)undo_lists->tail->body, domain_lists);
///////	free ( remove_tail( undo_lists ) );
///////      }
///////      else {
///////	x++;
///////      }
///////    }
///////    if ( x == l ) {
///////      if ( solutions_list == NULL ) {
///////	llist_node * ulp = NULL;
///////
///////	for ( i = l; i >= 0; i-- ) {
///////	  destroy_list(domain_lists[i]);
///////	  domain_lists[i] = assigned_current_domains[i];
///////	  assigned_current_domains[i] = NULL;
///////	}
///////
///////	for ( ulp = undo_lists->tail; ulp != NULL; ulp = ulp->previous ) {
///////	  undo_filtering_join(l, (llist**)ulp->body, domain_lists);
///////	}
///////	free ( assigned_values );
///////	free ( assigned_current_domains );
///////	destroy_list ( undo_lists );
///////	//	free ( alive );
///////	if ( passed_domain_lists == NULL ) {
///////	  for ( i = 0; i < l; i++ ) {
///////	    destroy_list ( domain_lists[i] );
///////	    //	  free ( alive[i] );
///////	  }
///////	  free ( domain_lists );
///////	}
///////	if ( sortedmap != NULL ) 
///////	  free(sortedmap );
///////	return 1;
///////      }
///////      else {
///////	//get solution
///////	llist * solution = new_llist();
///////	llist_node * np = NULL;
///////	llist * psol = NULL;
///////	for ( i = 0; i < l; i++ ) {
///////	  psol = (llist*)assigned_values[i]->body;
///////	  for ( np = psol->head; np != NULL; np = np->next ) {
///////	    add_node_tail ((tree*)np->body, solution);
///////	  }
///////	}
///////	sols++;
///////	add_node_tail ( solution, solutions_list );
///////
///////	undo_filtering_join(l, (llist**)undo_lists->tail->body, domain_lists);
///////	free ( remove_tail( undo_lists ) );
///////	x--;
///////      }
///////    }
///////    if ( x == -1 ) {
///////      break;
///////    }
///////  }
///////
///////    if ( m_s_g_c->print_combs ) {
///////      if ( cc > 10000 ) 
///////	printf ( "variables: %d nv: %d cc: %d sols: %d\n", l, nv, cc, sols); 
///////    }
///////  
///////  free ( assigned_values );
///////  free ( assigned_current_domains );
///////  destroy_list ( undo_lists );
///////
///////  if ( passed_domain_lists == NULL ) {
///////    for ( i = 0; i < l; i++ ) {
///////      destroy_list ( domain_lists[i] );
///////    }
///////    free ( domain_lists );
///////  }
///////  if ( sortedmap != NULL ) 
///////    free(sortedmap );
///////  return 0;
///////}
///////
/*
  void mac_join ( int l, llist *** solutions, llist * solutions_list ) {

  //l is the number of vertices involved. 
  llist ** domain_lists = NULL;
  int *** last = NULL;

  char ** alive = NULL;

  int v = 0;
  int i = 0;
  int j = 0;
  int s = 0;

  set * queue  = new_set ( l*l );

  //  not sure if domain list is to be used!!
  
  domain_lists = (llist**) checked_malloc ( sizeof(llist*) * l );
  last = (int***) checked_malloc ( sizeof(int**) * l );
  alive = (char**) checked_malloc ( sizeof(char*) * l );

  for ( v = 0; v < l; v++ ) {
  domain_lists[v] = new_llist ();
  alive[v] = (char*) checked_malloc ( sizeof(char) * (int)solutions[v][0] );
  for ( i = 1; i <= (int)solutions[v][0]; i++ ) {
  add_node_tail ( solutions[v][i], domain_lists[v] );
  alive[v][i-1] = '1';
  }
    
  last[v] = (int**) checked_malloc(sizeof(int*) * l );
  for ( i = v+1; i < l; i++ ) {    
  int * tuple = (int*) checked_malloc ( sizeof(int) * 2 );
  tuple[0] = i;
  tuple[1] = v;
  last[v][i] =  (int*) checked_malloc ( sizeof(int) * (int)solutions[v][0] );
  for ( s = 0; s < (int)solutions[v][0]; s++ ) {
  //last[v][i][s] = 0;
  }
  add_element ( queue, tuple, l*v+i );
  }
  }

  
  


  {
  llist_node * xp = NULL;
  for ( xp = queue->list->head; xp != NULL; xp = xp->next ) {
  free ( xp->body );
  }
  destroy_set ( queue );
  }

  for ( v = 0; v < l; v++ ) {
  destroy_list ( domain_lists[v] );
  free ( alive[v] );
  free ( last[v] );
  }
  free ( alive );
  free ( last );
  free ( domain_lists );

  }
*/

//returns array of solutions. Each solutions is given as a list of constraint_graph_nodes
//the first position of the array is the count of solutions.
llist ** get_solutions_of_size ( tree *  n, int  k ) {

  int l = n->children->count;
  int i;
  llist * solutions_list = NULL;
  llist ** solutions_array = NULL;
  llist_node * np = NULL;
  /*
    if ( n->ibody == 13 && n->parent   && n->parent->ibody == 19 ) {
    llist_node * npp = n->children->head; 
    for ( ; npp != NULL; npp = npp->next ) {
    if ( ((tree*)npp->body)->ibody == 12 ) {
    llist_node * npp2 =  ((tree*)npp->body)->children->head; 
    for ( ; npp2 != NULL; npp2 = npp2->next ) {
    if ( ((tree*)npp2->body)->ibody == 0 && k == 3) {
    printf("boom3! %d\n", xxx);
    }
    }
    }
    }
    }
    if ( n->ibody == 1  && n->parent && n->parent->ibody == 19 ) {
    llist_node * npp = n->children->head; 
    for ( ; npp != NULL; npp = npp->next ) {
    if ( ((tree*)npp->body)->ibody == 0 ) {
    llist_node * npp2 =  ((tree*)npp->body)->children->head; 
    for ( ; npp2 != NULL; npp2 = npp2->next ) {
    if ( ((tree*)npp2->body)->ibody == 12 ) {
    llist_node * npp3 =  ((tree*)npp2->body)->children->head; 
    for ( ; npp3 != NULL; npp3 = npp3->next ) {
    if ( ((tree*)npp3->body)->ibody == 13 && k == 4) {
    printf("boom4! %d\n", xxx);
    }
    }
    }
    }
    }
    }
    }
  */



  {//remember the solutions by hanging them from the tree
    if ( ((llist***)n->body)[k] != NULL ) {
      return ((llist***)n->body)[k];
    }
  }


  //base case of the recursion
  if ( k == 0 ) {
    llist * sol = new_llist();
    solutions_array = (llist**) checked_malloc(sizeof(llist*) * (2) );
    solutions_array[1] = sol;
    solutions_array[0] = (llist*)1;
  }
  else if ( k == 1 ) {
    llist * sol = new_llist();
    solutions_array = (llist**) checked_malloc(sizeof(llist*) * (2) );
    add_node ( n/*xx->body*/, sol );
    solutions_array[1] = sol;
    solutions_array[0] = (llist*)1;
  }
  else {
    solutions_list = new_llist();
    count_base_k ( k-1, l, n->children, solutions_list );
    solutions_array = (llist**) checked_malloc(sizeof(llist*) * (solutions_list->count + 1) );
    solutions_array[0] = (llist *)solutions_list->count;

    np = solutions_list->head;
    for ( i = 0; i < solutions_list->count; i++ ) {
      add_node ( n, (llist*)np->body );
      solutions_array[i+1] = (llist*)np->body;
      np = np->next;
    }
    destroy_list (solutions_list);
  }

  ((llist***)n->body)[k] = solutions_array;

  return solutions_array;
}

void combine_check_solution (  int * counts, int size,  void * arg1, void * arg2 ) {
  llist *** all_solutions = (llist***) arg1;
  llist * solution = NULL;
  int i;
  llist_node * np = NULL;
  extern main_structure_comb * m_s_g_c;
  llist * psol = NULL;
  int fail = 0;
  int orig = 1;
  int not_0_size = 0;
  llist * solutions_list = (llist*) arg2;
  llist * undo_map = new_llist ();
  for ( i = 0; i < size; i++ ) {
    if ( all_solutions[i][1]->count > 0 ) 
      not_0_size++;
  }

  //for each branch i
  for ( i = 0; i < size; i++ ) {
    psol = all_solutions[i][counts[i]+1];
    if ( psol->head ) {
      orig = 0;
    }

    //each node in the solution
    for ( np = psol->head; np != NULL; np = np->next ) {
      int cgn =  ((tree*)np->body)->ibody/*xx*/;
      
      //each solution coming from a branch must have at least one original node
      //if the solution does not have any original node
      if ( ((tree*)np->body)->color ) {
	orig++;
      }
      if ( m_s_g_c->vmap[cgn] == 1 ) {
	fail = 1; 
	break;
      }
      else {
	m_s_g_c->vmap[cgn] = 1;
	add_int_tail ( cgn, undo_map );
      }
    }

    if ( !orig && not_0_size > 1 ) {
      if ( i == 0 ) {
	orig++;
      }
      else {
	int bbreak = 0;
	//for each node n in this branch, if no node in all previous branches has n as a child, then make it orig
	for ( np = psol->head; np != NULL; np = np->next ) {
	  int cgn = ((tree*)np->body)->ibody;
	  int ii = 0;
	  //for each previous branch
	  for ( ii = 0; ii < i; ii++ ) {
	    llist * pxsol = all_solutions[ii][counts[ii]+1];
	    //for each node on the previous branch
	    llist_node * nxp = NULL;
	    for ( nxp = pxsol->head; nxp != NULL; nxp = nxp->next ) {
	      tree * tnx = (tree*) nxp->body;
	      //for each child of the x node
	      llist_node * child = NULL;
	      for ( child = tnx->children->head; child != NULL; child = child->next ) {
		if ( ((tree*)child->body)->ibody == cgn ) {
		  bbreak = 1;
		  break;
		}
	      }
	      if ( bbreak ) 
		break;
	    }	      
	    if ( bbreak )
	      break;
	  }
	  if ( bbreak )
	    break;
	}
	if ( !bbreak  )
	  orig++;
      }
    }
    if ( fail || (!orig && not_0_size > 1) )  {
      break;
    }
  }
  //  printf("________\n");
  if ( !fail && (orig || not_0_size <= 1) ) {
    solution = new_llist();
    for ( i = 0; i < size; i++ ) {
      psol = all_solutions[i][counts[i]+1];
      for ( np = psol->head; np != NULL; np = np->next ) {
	add_node_tail ((tree*)np->body, solution);
      }
    }
    add_node_tail ( solution, solutions_list );
  }
  else {
    for ( i = 0; i < size; i++ ) {
      psol = all_solutions[i][counts[i]+1];
    }
  }
  { 
    llist_node * vmp = NULL;
    for (  vmp = undo_map->head; vmp != NULL; vmp = vmp->next ) {
      m_s_g_c->vmap[vmp->ibody] = 0;
    }
    destroy_list ( undo_map );
  }
}

void count_base_k_function ( int * xk, int i, int l, int k, llist * children, llist * solution_list  ) {
  //xk is of size i
  int j = 0;
  int x = 0;
  llist_node * mp = NULL;
  llist * mult_leafs = NULL;
  tree * mults = NULL;
  tree * tp = NULL;
  int * n = (int*) checked_malloc (sizeof(int) * l );
  extern llist*** storedmult_leafs;
  extern main_structure_comb * m_s_g_c;

  int * xk_sizes = NULL;
  int li = 0;
  llist_node * lp = NULL;

  if ( m_s_g_c->sum_tree_filter ) {
    xk_sizes = (int*) checked_malloc ( sizeof(int) * children->count );
    for ( lp = children->head; lp != NULL; lp = lp->next ) {
      if ( xk[x] != li ) {
	li++;
	continue;
      }
      li++;
      xk_sizes[x++] = ((tree*)lp->body)->subtree_size;
    }
  }
  mult_leafs = new_llist();
  mults = new_int_tree ( -1 );
  
  /*profiling  if ( m_s_g_c->sum_tree_filter ) {
    llist * xx = new_llist();
    m_s_g_c->sum_tree_filter = 0;
    multipliers ( k, i, xk_sizes, 0, mults, xx );    
    printf("noprn: %d ", xx->count );
    m_s_g_c->sum_tree_filter = 1;
    }
  */
  multipliers ( k, i, xk_sizes, 0, mults, mult_leafs );
  //pf  printf("prn: %d \n", mult_leafs->count );
  for ( mp = mult_leafs->head; mp != NULL; mp = mp->next ) {
    for ( x = 0; x < l; x++ ) {
      n[x] = 0;
    }
    tp = (tree*)mp->body;
    for ( j = i-1; j >= 0; j-- ) {  
      //the number of solutions to pick from branch xk[j], i.e. the jth branch in the combination of size n[xk[j]]
      n[xk[j]] += tp->ibody;
      tp = tp->parent;
    }
    collect_solutions( n, l, children, solution_list );
  }
  if ( m_s_g_c->sum_tree_filter ) {
    free ( xk_sizes );
  }
  destroy_list ( mult_leafs );
  destroy_tree ( mults );
  
  free (n);
  
}


//with the memo instead of prunning
void memo_count_base_k_function ( int * xk, int i, int l, int k, llist * children, llist * solution_list  ) {
  //xk is of size i
  int j = 0;
  int x = 0;
  llist_node * mp = NULL;
  llist * mult_leafs = NULL;
  tree * mults = NULL;
  tree * tp = NULL;
  int * n = (int*) checked_malloc (sizeof(int) * l );
  extern llist*** storedmult_leafs;
  extern main_structure_comb * m_s_g_c;

  if ( storedmult_leafs[k][i] == NULL ) {
    int * xk_sizes = NULL;
    int li = 0;
    llist_node * lp = NULL;

    if ( m_s_g_c->sum_tree_filter ) {
      error ( "conflicting options!");
    }
    mult_leafs = new_llist();
    mults = new_int_tree ( -1 );
    
    multipliers ( k, i, NULL, 0, mults, mult_leafs );
    storedmult_leafs[k][i] = mult_leafs;
  }
  else {
    mult_leafs = storedmult_leafs[k][i];
  }
  
  for ( mp = mult_leafs->head; mp != NULL; mp = mp->next ) {
    
    for ( x = 0; x < l; x++ ) {
      n[x] = 0;
    }
    tp = (tree*)mp->body;
    for ( j = i-1; j >= 0; j-- ) {  
      //the number of solutions to pick from branch xk[j], i.e. the jth branch in the combination of size n[xk[j]]
      n[xk[j]] += tp->ibody;
      tp = tp->parent;
    }
    collect_solutions( n, l, children, solution_list );
  }
  
  free (n);
  
}






void count_base_k ( int k, int l, llist * children, llist * solution_list  ) {
  int i = 0;
  int ii = k<l?k:l;
  int j = 0;
  tree * chose = NULL;
  llist * chleafs = NULL;
  llist_node * chp = NULL;
  int * n = NULL;
  tree * tp  = NULL;
  extern main_structure_comb * m_s_g_c;


  if ( l == 0 || k == 0 ) 
    return;
  for ( i = 1; i <= ii; i++ ) {
    chose = new_int_tree(-1);
    chleafs = new_llist();
    n = (int*) checked_malloc ( sizeof(int) * i );
    n_choose_i ( l, i, 0, chose, chleafs  );
    
    //for each xk in l choose i
    for ( chp = chleafs->head; chp != NULL; chp = chp->next ) {
      tp = (tree*) chp->body;
      for ( j = i-1; j >= 0; j-- ) {
	n[j] = tp->ibody;
	tp = tp->parent;
      }
      if ( m_s_g_c->sum_tree_filter ) {
	count_base_k_function ( n, i, l, k, children, solution_list );
      }
      else {
	memo_count_base_k_function ( n, i, l, k, children, solution_list );
      }
    }

    destroy_list(chleafs);
    destroy_tree(chose);
    free(n);
  }
}

/* NO LONGER USED! REPLACED BY FC */
void count_base_kv ( int * kv, int l, void function(), void * arg1, void  * arg2 ) {

  int * n = (int*) checked_malloc ( sizeof(int)*l);

  int i = 0;
  int j = 0;
  int sum = 0;

  if ( l == 0 ) 
    return;

  for ( i = 0; i < l; i++ ) {
    n[i] = 0;
  }

  i = 0;
  while ( 1 ) {
    while ( 1 ) {
      sum = 0;

      if ( n[i] >= kv[i] ) 
	break;

      for ( j = i-1; j >=0; j-- ) 
	n[j] = 0;

      i = 0;
      
      if ( n[i] >= kv[i] )
	break;

      function (n, l, arg1, arg2);

      n[i]++;	
    }

    i++;
    if ( i == l ) 
      break;
    n[i]++;	
  }

  free (n);
}

void markup_node_tree_recursive ( tree * b, int * gcolors ) {
  llist_node * np = NULL;
  //color initially -1, when ++, becomes 0, which implies new node
  //new node tree nodes are colored 1.
  gcolors[b->ibody]++;
  if ( !gcolors[b->ibody] ) {
    b->color = 1;
  }
  for ( np = b->children->head; np != NULL; np = np->next ) 
    markup_node_tree_recursive ( (tree*)np->body, gcolors );
}

void markup_node_tree ( tree * b, int * gcolors, int vertices  ) {
  int i = 0;
  for ( i = 0; i < vertices; i++ ) {
    gcolors[i] = -1;
  }
  markup_node_tree_recursive ( b, gcolors );
}

 

void print_node_tree ( tree * b, int * gcolors, int t ) {
  int i;
  llist_node * np;
  if( b->children->count == 0 )
    return;
  printf("\n");
  for ( i = 0; i < t; i++ ) 
    printf("\t");
  if ( gcolors == NULL )
    printf("[%d]: ", b->ibody );
  else  
    printf("%s[%d]: ", b->ibody, gcolors[b->ibody] );
  for ( np = b->children->head; np != NULL; np = np->next ) {
    printf("%d ", ((tree*)np->body)->ibody );
  }
  printf("\n");
  for ( np = b->children->head; np != NULL; np = np->next ) 
    print_node_tree ( (tree*)np->body, gcolors, t+1 );

}


int get_combinations ( llist ** graphl, int vertices, int c, llist * combs ) {

  llist * stack = new_llist();
  llist_node * np = NULL;
  int cgn = -1;
  int * cgn_map = (int*) checked_malloc(sizeof(int)*vertices);
  int i = 0;
  int * combinations_removed = NULL;
  int * gcolors = NULL;
  extern main_structure_comb * m_s_g_c;
  int count = 0;
  
  combinations_removed = (int*) checked_malloc(sizeof(int)*vertices);
  gcolors = (int*) checked_malloc(sizeof(int)*vertices);
  for ( i = 0; i < vertices; i++ ) {
    cgn_map[i] = 0;
    combinations_removed[i] = 0;
    gcolors[i] = -1;
  }

  for ( i = 0; i < vertices; i++ ) {
    add_int ( i, stack );
  }
  i = 0;

  while ( stack->count ) {
    np = remove_head ( stack );
    cgn = np->ibody;
    free(np);
    if ( combinations_removed[cgn] ) {
      continue;
    }
    cgn_map[cgn] = 1; 
    count += get_combinations_with ( cgn, graphl, vertices, gcolors, c, combs );

    for ( np = graphl[cgn]->head; np != NULL; np = np->next ) {
      remove_node_no_check ( (llist_node*)(np->body), ((llist_node*)(np->body))->list );
    }
    destroy_list ( graphl[cgn] );
    graphl[cgn] = NULL;
    combinations_removed[cgn] = 1;
  }
  free(cgn_map);
  return count;
}

int hide_get_combinations ( llist ** graphl, int vertices, int c, llist * combs ) {

  llist * stack = new_llist();
  llist_node * np = NULL;
  int cgn = -1;
  int * cgn_map = (int*) checked_malloc(sizeof(int)*vertices);
  int i = 0;
  int * combinations_removed = NULL;
  int * gcolors = NULL;
  extern main_structure_comb * m_s_g_c;
  int count = 0;
  
  combinations_removed = (int*) checked_malloc(sizeof(int)*vertices);
  gcolors = (int*) checked_malloc(sizeof(int)*vertices);
  for ( i = 0; i < vertices; i++ ) {
    cgn_map[i] = 0;
    combinations_removed[i] = 0;
    gcolors[i] = -1;
  }

  add_int ( 0, stack );
  i = 0;

  while ( stack->count ) {
    np = remove_head ( stack );
    cgn = np->ibody;
    free(np);
    if ( combinations_removed[cgn] ) {
      if ( stack->count == 0 ) {
	for ( ; i < vertices; i++ ) {
	  if ( cgn_map[i] == 0 ) {
	    //add all nodes that are not considered as head yet
	    //mostly case of not connected graph I guess.
	    add_int ( i, stack );
	    break;
	  }
	}
      }
      continue;
    }
    cgn_map[cgn] = 1; 
    count += get_combinations_with ( cgn, graphl, vertices, gcolors, c, combs );

    for ( np = graphl[cgn]->tail; np != NULL; np = np->previous ) {
      int n = np->ibody;
      add_int ( n, stack );
    }

    for ( np = graphl[cgn]->head; np != NULL; np = np->next ) {
      remove_node_no_check ( (llist_node*)(np->body), ((llist_node*)(np->body))->list );
    }
    destroy_list ( graphl[cgn] );
    graphl[cgn] = NULL;
    combinations_removed[cgn] = 1;

    if ( stack->count == 0 ) {
      for ( ; i < vertices; i++ ) {
	if ( cgn_map[i] == 0 ) {
	  add_int ( i, stack );
	  break;
	}
      }
    }
  }
  free(cgn_map);
  return count;
}

int get_combinations_with ( int n, llist ** graphl, int vertices, int * gcolors, int c, llist * combs  ) {

  tree * b = NULL; 
  int i;
  llist * sol = NULL;
  llist **  sols = NULL;
  llist_node * np = NULL;
  int cgn = -1;
  set * temp2 = new_set(vertices);
  extern main_structure_comb * m_s_g_c;
  int count = 0;

  b = new_int_tree ( n );
  
  comb ( graphl, n, 1, c, temp2, b );
  destroy_set(temp2);
  markup_node_tree ( b, gcolors, vertices );
  //  if ( b->ibody != 19 ) 
  //    error("not 19");
  sols = get_solutions_of_size ( b, c);
  

  for ( i = 1; i <= (int)sols[0]; i++ ) {
    sol = sols[i];
    if ( combs == NULL ) {
      count++;
      if ( m_s_g_c->print_combs ) {
	llist_node * sp = NULL;
	for ( sp = sol->head; sp != NULL; sp = sp->next ) {
	  printf ( "%d ", ((tree*)sp->body)->ibody );
	}
	printf("\n");
      }
    }
    else {
      add_node_tail ( sol, combs );
      count++;
    }
    if ( m_s_g_c->v > 3 ) {
      for ( np = sol->head; np != NULL; np = np->next ) {
	cgn = ((tree*)np->body)->ibody/*xx*/;
	printf ("%d ", cgn );
      }
      printf("\n");
    }
  }
  if ( combs != NULL ) {
    ((llist***)b->body)[c] = NULL;
    free ( sols );
  }
  destroy_tree_body ( b, c, combs != NULL );
  return count;
}

void multipliers ( int k, int d, int * sizes_d, int depth, tree * mults, llist * leafs ) {
  int m = 0;
  tree * t = NULL;
  extern int multcount;
  extern main_structure_comb * m_s_g_c;
  multcount++;
  if ( d == 1 ) {
    if ( m_s_g_c->sum_tree_filter && sizes_d[depth] < k ) {
      return;
    }
    t = add_int_child ( k, mults );
    add_node_tail ( t, leafs );
    return;
  }

  for ( m = d-1; m < k; m++ ) {
    if ( m_s_g_c->sum_tree_filter && sizes_d[depth] < k-m ) {
      continue;
    }
    t = add_int_child ( k-m, mults );
    multipliers ( m, d-1, sizes_d, depth+1, t, leafs );
  }
}


void n_choose_i ( int n, int i, int l, tree * chose, llist * leafs ) {
  int x = 0;
  tree * t = NULL;
  
  if ( i == 0 ) {
    add_node_tail ( chose, leafs );
    return;
  }
    
  for ( x = 0; x+l+i <= n; x++ ) {
    t = add_int_child ( x+l, chose );
    n_choose_i ( n, i-1, l+1+x, t, leafs );
  }
}


void mark_cmap ( int c, llist ** marked ) {
  extern main_structure_comb * m_s_g_c;
  if ( *marked == NULL ) {
    *marked = new_llist();
  }
  add_int_tail ( c, *marked );
  m_s_g_c->cmap[c] = 1;
}

void clear_cmarks ( llist * marked ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * np = NULL;
  if ( marked == NULL )
    return;
  for ( np = marked->head; np != NULL; np = np->next ) {
    m_s_g_c->cmap[np->ibody] = -1;
  }
  destroy_list ( marked );
}

//static int xxx = 0;
void dfs_on_marked ( int n, llist ** graphl ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * np = NULL;
  for ( np = graphl[n]->head; np != NULL; np = np->next ) {
    int cg = np->ibody;
    if ( m_s_g_c->cmap[cg] == -1 || m_s_g_c->cmap[cg] == 2 ) {
      continue;
    }
    m_s_g_c->cmap[cg] = 2;
    dfs_on_marked ( cg, graphl );
  }
}

int check_connected_subgraph ( llist * cgns, llist ** graphl   )  {
  extern main_structure_comb * m_s_g_c;
  llist_node * np = NULL;
  llist * marks = NULL;
  int cg = -1;
  int connected = 1;
  //mark all cgns in the combination
  //do DFS on the marked nodes (1) coloring them 2
  //check if all marked are colored.
  for ( np = cgns->head; np != NULL; np = np->next ) {
    cg = np->ibody;
    mark_cmap ( cg, &marks );
  }
  cg = cgns->head->ibody;
  dfs_on_marked ( cg, graphl );
  
  for ( np = cgns->head; np != NULL; np = np->next ) {
    cg = np->ibody;
    if ( m_s_g_c->cmap[cg] != 2 ) {
      connected = 0;
      break;
    }
  }  
  clear_cmarks ( marks );
  return connected;
}


int graph_connected ( llist ** graphl, int vertices ) {
  int i = 0;
  llist * cgns = new_llist();
  int connected = 0;
  for ( i = 0; i < vertices; i++ ) {
    add_int_tail ( i, cgns );
  }
  connected = check_connected_subgraph (cgns, graphl);
  destroy_list ( cgns );
  return connected;
}


void get_distance_k_nodes_rec ( llist ** graphl, int node, int k, int vertices, llist * dirty, llist * collected, int dfo ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * np = NULL;
  if ( k == 0 ) {
    return;
  }
  for (  np = graphl[node]->head; np != NULL; np = np->next ) {
    if ( m_s_g_c->cmap[np->ibody] == -1 ) {
      add_int_tail ( np->ibody, collected );
      mark_cmap ( np->ibody, &dirty );
      m_s_g_c->cmap[np->ibody] = dfo;
      get_distance_k_nodes_rec ( graphl, np->ibody, k-1, vertices, dirty, collected, dfo+1 );
    }
    else if ( m_s_g_c->cmap[np->ibody] > dfo ) {
      m_s_g_c->cmap[np->ibody] = dfo;
      get_distance_k_nodes_rec ( graphl, np->ibody, k-1, vertices, dirty, collected, dfo+1 );
    }
  }
}

llist * get_distance_k_nodes ( llist ** graphl, int node, int k, int vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist * dirty = NULL;
  llist * collected = new_llist();
  
  add_int_tail ( node, collected );
  mark_cmap ( node, &dirty );
  m_s_g_c->cmap[node] = 0;
  get_distance_k_nodes_rec ( graphl, node, k, vertices, dirty, collected, 1 );
  clear_cmarks ( dirty );
  return collected;
}

int get_bf_combinations_from_subgraphs ( llist ** graphl, int c, int vertices, llist ** occurances ) {

  int total_count = 0;
  int v = 0;
  llist * dist_k_vertices = NULL;
  llist_node * np = NULL;
  for ( v = 0; v < vertices; v++ ) {
    dist_k_vertices = get_distance_k_nodes ( graphl, v, c, vertices );

    switch ( c ) {
    case 2:
      total_count += get_bf_combinations_list_2 ( graphl, c, dist_k_vertices );
      break;
      
    case 3:
      total_count += get_bf_combinations_list_3 ( graphl, c, dist_k_vertices );
      break;
      
    case 4:
      total_count += get_bf_combinations_list_4 ( graphl, c, dist_k_vertices );
      break;
            
    case 5:
      total_count += get_bf_combinations_list_5 ( graphl, c, dist_k_vertices );
      break;
      
    case 6:
      total_count += get_bf_combinations_list_6 ( graphl, c, dist_k_vertices );
      break;
      
    case 7:
      total_count += get_bf_combinations_list_7 ( graphl, c, dist_k_vertices );
      break;
      
    case 8:
      total_count += get_bf_combinations_list_8 ( graphl, c, dist_k_vertices );
      break;
      
    }
    for ( np = graphl[v]->head; np != NULL; np = np->next ) {
      remove_node_no_check ( (llist_node*)(np->body), ((llist_node*)(np->body))->list );
    }
    destroy_list ( graphl[v] );
    graphl[v] = NULL;
  }
  return total_count;
}


int get_bf_combinations_list_8 ( llist ** graphl, int c, llist * vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * i, * j, * k, * l, * m, * n, * o, * p;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = vertices->head; i != NULL; i=NULL /*i = i->next*/ ){
    for ( j = i->next; j != NULL; j = j->next ){
      for ( k = j->next; k != NULL; k = k->next ){
	for ( l = k->next; l != NULL; l = l->next ){
	  for ( m = l->next; m != NULL; m = m->next ){
	    for ( n = m->next; n != NULL; n = n->next ){
	      for ( o = n->next; o != NULL; o = o->next ){
		for ( p = o->next; p != NULL; p = p->next ){
		  add_int_tail ( i->ibody, cgns );
		  add_int_tail ( j->ibody, cgns );
		  add_int_tail ( k->ibody, cgns );
		  add_int_tail ( l->ibody, cgns );
		  add_int_tail ( m->ibody, cgns );
		  add_int_tail ( n->ibody, cgns );
		  add_int_tail ( o->ibody, cgns );
		  add_int_tail ( p->ibody, cgns );
		  if ( check_connected_subgraph (cgns, graphl) ) {
		    count++;
		    if ( m_s_g_c->print_combs ) {
		      printf("%d %d %d %d %d %d %d %d\n", i->ibody, j->ibody, k->ibody, l->ibody, m->ibody, n->ibody, o->ibody, p->ibody);
		    }
		  }
		  destroy_list_nodes_only ( cgns );
		}
	      }
	    }
	  }
	}
      }
    }
  }
  return count;
}



int get_bf_combinations_list_7 ( llist ** graphl, int c, llist * vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * i, * j, * k, * l, * m, * n, * o;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = vertices->head; i != NULL; i=NULL /*i = i->next*/ ){
    for ( j = i->next; j != NULL; j = j->next ){
      for ( k = j->next; k != NULL; k = k->next ){
	for ( l = k->next; l != NULL; l = l->next ){
	  for ( m = l->next; m != NULL; m = m->next ){
	    for ( n = m->next; n != NULL; n = n->next ){
	      for ( o = n->next; o != NULL; o = o->next ){
		add_int_tail ( i->ibody, cgns );
		add_int_tail ( j->ibody, cgns );
		add_int_tail ( k->ibody, cgns );
		add_int_tail ( l->ibody, cgns );
		add_int_tail ( m->ibody, cgns );
		add_int_tail ( n->ibody, cgns );
		add_int_tail ( o->ibody, cgns );
		if ( check_connected_subgraph (cgns, graphl) ) {
		  count++;
		  if ( m_s_g_c->print_combs ) {
		    printf("%d %d %d %d %d %d %d\n", i->ibody, j->ibody, k->ibody, l->ibody, m->ibody, n->ibody, o->ibody);
		  }
		}
		destroy_list_nodes_only ( cgns );
	      }
	    }
	  }
	}
      }
    }
  }
  return count;
}


int get_bf_combinations_list_6 ( llist ** graphl, int c, llist * vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * i, * j, * k, * l, * m, * n;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = vertices->head; i != NULL; i=NULL /*i = i->next*/ ){
    for ( j = i->next; j != NULL; j = j->next ){
      for ( k = j->next; k != NULL; k = k->next ){
	for ( l = k->next; l != NULL; l = l->next ){
	  for ( m = l->next; m != NULL; m = m->next ){
	    for ( n = m->next; n != NULL; n = n->next ){
	      add_int_tail ( i->ibody, cgns );
	      add_int_tail ( j->ibody, cgns );
	      add_int_tail ( k->ibody, cgns );
	      add_int_tail ( l->ibody, cgns );
	      add_int_tail ( m->ibody, cgns );
	      add_int_tail ( n->ibody, cgns );
	      if ( check_connected_subgraph (cgns, graphl) ) {
		count++;
	      }
	      if ( m_s_g_c->print_combs ) {
		printf("%d %d %d %d %d %d\n", i->ibody, j->ibody, k->ibody, l->ibody, m->ibody, n->ibody);
	      }
	      destroy_list_nodes_only ( cgns );
	    }
	  }
	}
      }
    }
  }
  return count;
}



int get_bf_combinations_list_5 ( llist ** graphl, int c, llist * vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * i, * j, * k, * l, * m;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = vertices->head; i != NULL; i=NULL /*i = i->next*/ ){
    for ( j = i->next; j != NULL; j = j->next ){
      for ( k = j->next; k != NULL; k = k->next ){
	for ( l = k->next; l != NULL; l = l->next ){
	  for ( m = l->next; m != NULL; m = m->next ){
	    add_int_tail ( i->ibody, cgns );
	    add_int_tail ( j->ibody, cgns );
	    add_int_tail ( k->ibody, cgns );
	    add_int_tail ( l->ibody, cgns );
	    add_int_tail ( m->ibody, cgns );
	    if ( check_connected_subgraph (cgns, graphl) ) {
	      count++;
	      if ( m_s_g_c->print_combs ) {
		printf("%d %d %d %d %d\n", i->ibody, j->ibody, k->ibody, l->ibody, m->ibody );
	      }
	    }
	    destroy_list_nodes_only ( cgns );
	  }
	}
      }
    }
  }
  return count;
}



int get_bf_combinations_list_4 ( llist ** graphl, int c, llist * vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * i, * j, * k, * l;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = vertices->head; i != NULL; i=NULL /*i = i->next*/ ){
    for ( j = i->next; j != NULL; j = j->next ){
      for ( k = j->next; k != NULL; k = k->next ){
	for ( l = k->next; l != NULL; l = l->next ){
	  add_int_tail ( i->ibody, cgns );
	  add_int_tail ( j->ibody, cgns );
	  add_int_tail ( k->ibody, cgns );
	  add_int_tail ( l->ibody, cgns );
	  if ( check_connected_subgraph (cgns, graphl) ) {
	    count++;
	    if ( m_s_g_c->print_combs ) {
	      printf("%d %d %d %d\n", i->ibody, j->ibody, k->ibody, l->ibody );
	    }
	  }
	  destroy_list_nodes_only ( cgns );
	}
      }
    }
  }
  return count;
}


int get_bf_combinations_list_3 ( llist ** graphl, int c, llist * vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * i, * j, * k;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = vertices->head; i != NULL; i=NULL /*i = i->next*/ ){
    for ( j = i->next; j != NULL; j = j->next ){
      for ( k = j->next; k != NULL; k = k->next ){
	add_int_tail ( i->ibody, cgns );
	add_int_tail ( j->ibody, cgns );
	add_int_tail ( k->ibody, cgns );
	if ( check_connected_subgraph (cgns, graphl) ) {
	  count++;
	  if ( m_s_g_c->print_combs ) {
	    printf("%d %d %d\n", i->ibody, j->ibody, k->ibody );
	  }
	}
	destroy_list_nodes_only ( cgns );
      }
    }
  }
  return count;
}


int get_bf_combinations_list_2 ( llist ** graphl, int c, llist * vertices ) {
  extern main_structure_comb * m_s_g_c;
  llist_node * i, * j;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = vertices->head; i != NULL; i=NULL /*i = i->next*/ ){
    for ( j = i->next; j != NULL; j = j->next ){
      add_int_tail ( i->ibody, cgns );
      add_int_tail ( j->ibody, cgns );
      if ( check_connected_subgraph (cgns, graphl) ) {
	count++;
	if ( m_s_g_c->print_combs ) {
	  printf("%d %d\n", i->ibody, j->ibody );
	}
      }
      destroy_list_nodes_only ( cgns );
    }
  }
  return count;
}



int get_bf_combinations_8 ( llist ** graphl, int c, int vertices ) {
  extern main_structure_comb * m_s_g_c;
  int i, j, k, l, m, n, o, p;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = 0; i < vertices; i++ ){
    for ( j = i+1; j < vertices; j++ ){
      for ( k = j+1; k < vertices; k++ ){
	for ( l = k+1; l < vertices; l++ ){
	  for ( m = l+1; m < vertices; m++ ){
	    for ( n = m+1; n < vertices; n++ ){
	      for ( o = n+1; o < vertices; o++ ){
		for ( p = o+1; p < vertices; p++ ){
		  add_int_tail ( i, cgns );
		  add_int_tail ( j, cgns );
		  add_int_tail ( k, cgns );
		  add_int_tail ( l, cgns );
		  add_int_tail ( m, cgns );
		  add_int_tail ( n, cgns );
		  add_int_tail ( o, cgns );
		  add_int_tail ( p, cgns );
		  if ( check_connected_subgraph (cgns, graphl) ) {
		    count++;
		  }
		  if ( m_s_g_c->print_combs ) {
		    printf("%d %d %d %d %d %d %d %d\n", i, j, k, l, m, n, o, p);
		  }
		  destroy_list_nodes_only ( cgns );
		}
	      }
	    }
	  }
	}
      }
    }
  }
  return count;
}




int get_bf_combinations_7 ( llist ** graphl, int c, int vertices ) {

  int i, j, k, l, m, n, o;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = 0; i < vertices; i++ ){
    for ( j = i+1; j < vertices; j++ ){
      for ( k = j+1; k < vertices; k++ ){
	for ( l = k+1; l < vertices; l++ ){
	  for ( m = l+1; m < vertices; m++ ){
	    for ( n = m+1; n < vertices; n++ ){
	      for ( o = n+1; o < vertices; o++ ){
		add_int_tail ( i, cgns );
		add_int_tail ( j, cgns );
		add_int_tail ( k, cgns );
		add_int_tail ( l, cgns );
		add_int_tail ( m, cgns );
		add_int_tail ( n, cgns );
		add_int_tail ( o, cgns );
		if ( check_connected_subgraph (cgns, graphl) ) {
		  count++;
		}
		destroy_list_nodes_only ( cgns );
	      }
	    }
	  }
	}
      }
    }
  }

  return count;
}



int get_bf_combinations_6 ( llist ** graphl, int c, int vertices ) {

  int i, j, k, l, m, n;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = 0; i < vertices; i++ ){
    for ( j = i+1; j < vertices; j++ ){
      for ( k = j+1; k < vertices; k++ ){
	for ( l = k+1; l < vertices; l++ ){
	  for ( m = l+1; m < vertices; m++ ){
	    for ( n = m+1; n < vertices; n++ ){
	      add_int_tail ( i, cgns );
	      add_int_tail ( j, cgns );
	      add_int_tail ( k, cgns );
	      add_int_tail ( l, cgns );
	      add_int_tail ( m, cgns );
	      add_int_tail ( n, cgns );
	      if ( check_connected_subgraph (cgns, graphl) ) {
		count++;
	      }
	      destroy_list_nodes_only ( cgns );
	    }
	  }
	}
      }
    }
  }
  return count;
}




int get_bf_combinations_5 ( llist ** graphl, int c, int vertices ) {

  int i, j, k, l, m;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = 0; i < vertices; i++ ){
    for ( j = i+1; j < vertices; j++ ){
      for ( k = j+1; k < vertices; k++ ){
	for ( l = k+1; l < vertices; l++ ){
	  for ( m = l+1; m < vertices; m++ ){
	    add_int_tail ( i, cgns );
	    add_int_tail ( j, cgns );
	    add_int_tail ( k, cgns );
	    add_int_tail ( l, cgns );
	    add_int_tail ( m, cgns );
	    if ( check_connected_subgraph (cgns, graphl) ) {
	      count++;
	    }
	    destroy_list_nodes_only ( cgns );
	  }
	}
      }
    }
  }
  return count;
}


int get_bf_combinations_4 ( llist ** graphl, int c, int vertices ) {
  
  int i, j, k, l;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = 0; i < vertices; i++ ){
    for ( j = i+1; j < vertices; j++ ){
      for ( k = j+1; k < vertices; k++ ){
	for ( l = k+1; l < vertices; l++ ){
	  add_int_tail ( i, cgns );
	  add_int_tail ( j, cgns );
	  add_int_tail ( k, cgns );
	  add_int_tail ( l, cgns );
	  if ( check_connected_subgraph (cgns, graphl) ) {
	    count++;
	  }
	  destroy_list_nodes_only ( cgns );
	}
      }
    }
  }
  return count;
}



int get_bf_combinations_3 ( llist ** graphl, int c, int vertices ) {
  
  int i, j, k, l;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = 0; i < vertices; i++ ){
    for ( j = i+1; j < vertices; j++ ){
      for ( k = j+1; k < vertices; k++ ){
	add_int_tail ( i, cgns );
	add_int_tail ( j, cgns );
	add_int_tail ( k, cgns );
	if ( check_connected_subgraph (cgns, graphl) ) {
	  count++;
	}
	destroy_list_nodes_only ( cgns );
      }
    }
  }
  return count;
}



int get_bf_combinations_2 ( llist ** graphl, int c, int vertices ) {
  
  int i, j, k, l;
  int count = 0;
  llist * cgns = new_llist();  
  for ( i = 0; i < vertices; i++ ){
    for ( j = i+1; j < vertices; j++ ){
      add_int_tail ( i, cgns );
      add_int_tail ( j, cgns );
      if ( check_connected_subgraph (cgns, graphl) ) {
	count++;
      }
      destroy_list_nodes_only ( cgns );
    }
  }
  return count;
}
