//A Non-Binary CSP Problem Generator (Ver1.00)
//-----------------------------------------------------------------------------------------------
// Name : Hui Zou
// Date : Aug. 17, 2001
// Description: This program is a Non-binary CSP problem generator. It takes 8 command arguments as follows,
//              gen n a p p2 p3 p4 t outfile
//                n - the number of variables
//                a - domain size
//                p - constraint probability
//                p2- the percentage of binary constraints
//                p3- the percentage of ternary constraints
//                p4- the percentage of quaternary constraints
//                t - tightness of a constraint
//                outfile - filename you want to store the results
//                we assume all values of above parameters ,given by user,are appropriate.               
//                A detailed description will be provided with a readme file.
//-----------------------------------------------------------------------------------------------
#include "constraint.h"
//-----------------------------------------------------------------------------------------------

int main(int argc, char *argv[]) {
    int n,a,C,c2,c3,c4;
    float p,p2,p3,p4,t;
    int num_no_tuple2,num_no_tuple3,num_no_tuple4; //the number of incompatible tubles
    int combination2, combination3,combination4;
    if (argc !=9 )
        usage();
    
    //reads data from character strings
    sscanf(argv[1],"%d",&n);
    sscanf(argv[2],"%d",&a);
    sscanf(argv[3],"%f",&p);
    sscanf(argv[4],"%f",&p2);
    sscanf(argv[5],"%f",&p3);
    sscanf(argv[6],"%f",&p4);
    sscanf(argv[7],"%f",&t);
    
    //open output fule
    ofstream fout;
    fout.open(argv[8]);
    if (fout.fail()) {
        cout << "Output file opening failed.\n";
        exit(1); 
    }
    fout<<"CSP-"<<n<<"-"<<a<<"-"<<p<<"-"<<p2<<"-"<<p3<<"-"<<p4<<"-"<<t<<endl;
    fout<<n<<" "<<a<<" "<<"-1"<<"\n\n";
    //fout<<C<<endl;
    
    combination2=n*(n-1)/2;
    combination3=n*(n-1)*(n-2)/6;
    combination4=n*(n-1)*(n-2)*(n-3)/24;
    C=int( (combination2*p2+combination3*p3+combination4*p4)*p+0.5 );
    c2=int(p2*C+0.5);
    c3=int(p3*C+0.5);
    c4=int(p4*C+0.5);
    num_no_tuple2=int(t*a*a + 0.5);
    num_no_tuple3=int(t*a*a*a + 0.5);
    num_no_tuple4=int(t*a*a*a*a + 0.5);
      
    constraint_attr *constraint;
    constraint=new constraint_attr[C+1];
    for (int i=1;i<=c2;i++) {
        constraint[i].arity=2;
	constraint[i].var=new int[3];
        for (int j=1;j<=2;j++)
            constraint[i].var[j]=0;
	}
    for (i=c2+1;i<=(c2+c3);i++) {
        constraint[i].arity=3;
	constraint[i].var=new int[4];
        for (int j=1;j<=3;j++)
            constraint[i].var[j]=0;
	}
    for (i=c2+c3+1;i<=(c2+c3+c4);i++){
        constraint[i].arity=4;
	constraint[i].var=new int[5];
        for (int j=1;j<=4;j++)
            constraint[i].var[j]=0;
	}
	
	
    //get the seed
    time_t T;
    T=time(&T);
    pid_t pid;
    pid=getpid();
    unsigned seed;
    seed=T/pid;
    srandom(seed);   
      
    // generate constraints
    gen(fout,a,2,c2,num_no_tuple2,constraint,0);
    gen(fout,a,3,c3,num_no_tuple3,constraint,c2);
    gen(fout,a,4,c4,num_no_tuple4,constraint,c2+c3);
    
    
    //assign constraints to any two variables
    assignment(n,2,c2,combination2,constraint,0);
    assignment(n,3,c3,combination3,constraint,c2);
    assignment(n,4,c4,combination4,constraint,c2+c3);
    
    //if the CSP is not connected, assign constraint again untill it is connected
    while (!IsConnected(constraint,n,C)) {
        assignment(n,2,c2,combination2,constraint,0);
        assignment(n,3,c3,combination3,constraint,c2);
        assignment(n,4,c4,combination4,constraint,c2+c3);
    }
    output(fout,constraint,C);
    fout.close();
    return 0;
}

