//A CSP Problem Generator in batch (Ver1.03)
//-----------------------------------------------------------------------------------------------
// Name : Hui Zou
// Date : June 28, 2001
// Description: This program is a CSP problem generator used for generating CSPs in batch. 
//              It takes 7 command arguments as follows,
//              gen_batch N K C I T R outfile
//                N - the number of variables
//                K - domain size
//                C - distinct constraints number
//                I - the degree of interchangeability
//                T - tightness of each constrain,that is the percentage of zero 
//                R - the series number of instance
//                outfile - filename you want to store the results
//                we assume all values of above parameters ,given by user,are appropriate.               
//                A detailed description will be provided with a readme file.
//                After a succefull generating, "." is displayed. otherwise,
//                "/" will be displayed.
//-----------------------------------------------------------------------------------------------
#include "vector.h"
//-----------------------------------------------------------------------------------------------

int main(int argc, char *argv[]) {
    int N,K,C,I;float T, fn,seed;
    int deg, first_time=0,fail=0;
    if (argc !=8 )
        usage();
    
    //reads data from character strings
    sscanf(argv[1],"%d",&N);
    sscanf(argv[2],"%d",&K);
    sscanf(argv[3],"%d",&C);
    sscanf(argv[4],"%d",&I);
    sscanf(argv[5],"%f",&T);
    sscanf(argv[6],"%f",&fn);
    
    //if the degree of interchangeability=1, then the number of zero should be multiple of K(domain size)
    //Otherwise, it is impossible to get solution at this case
    if ((int(K*K*T)%K !=0) && (I==1))
        exit(0);
    if ( (int(T*100)==4) && (I!=2) )
        exit(0);
    if (K==7) {
        if ( (int(T*100)==12) && (I>6) )//K=7, I>6
    	exit(0);
    	}
    if (K==5) {
        if ( (int(T*100)==12) && (I>4) )//K=5, I>4
    	exit(0);
    	}
    if ( (int(T*100)==52) && (I>4) )
        exit(0);
    if ( (int(T*100)==92) && (I>3) )
        exit(0);
    
    //open output fule
    ofstream fout;
    ofstream fout1;
    fout.open(argv[7]);
    if (fout.fail()) {
        cout << "Output file opening failed.\n";
        exit(1); 
    }
    fout<<"CSP-"<<N<<"-"<<K<<"-"<<C<<"-"<<I<<"-"<<T<<endl;
    fout<<N<<" "<<K<<" "<<"-1"<<"\n\n";
    fout<<C<<endl;
    
    //define a matrix class object
    matrix m(K);
    
    //generate the first seed
    time_t t;
    t=time(&t);
    pid_t pid;
    pid=getpid();
    unsigned seed1;
    seed1=t/pid;   
    
    //generate constraints
    float T_temp=T;
    for (int i=0;i<C;i++) {
        if (first_time==0) {
            seed=seed1;
            first_time=1;
        }
        else
            seed=getseed();//seed will be generated by random generators after first time
        srandom(seed);
 
        vector degree(m.getrow(),0);
        m.tight(T,seed);
        deg=m.Degree_Inter(degree);
        bool done=false;
        while (deg!=I){ 
            fail++;  
	    if (fail>=1 && !done) {
                T=1-T;	
                m.tight(T,seed);
                done=true;
            }    
            m.set_equal(deg,I,degree);
            degree.ini(m.getrow());
            deg=m.Degree_Inter(degree); 
	    if (fail>=150 ) {
	        //after try it 50 times, if still no solution, then give up
                cout<<"/";
		//remove the outfile
	        unlink(argv[7]);
	        if (T != T_temp )
                    T=T_temp;
                fout1.open("fail_record",ios::app);
                fout1<<"irand-"<<C<<"-"<<I<<"-"<<T<<"."<<fn<<endl;
                fout1.close();
	        exit(0);
            }
        }   	
        int flag=0;
        int tmp=m.tightness();
        // give up the matrix whose tightness does not satisfy the specification
        if( tmp != int(K*K*T) ){
            flag=1;
            i--;
        }
        //select the constraint that satisfies both tightness& the degree of interchangeability
        if (flag != 1) {
	    //in order to get more general problem, we permute the matrix
            m.permute(K);
	    if (T != T_temp ) {
	        m.need_change();
	        T=T_temp;
	        }
            fout<<i+1<<" "<<K<<" "<<K<<endl;
            fout<<m<<endl;
            fail=0;
        }
	//put the matix into original status
        m.initialization();
    }//end of for

    //assign constraints to any two variables
    assign_CS(fout,C,N);
    cout<<".";
    fout.close();
    return 0;
}
