//--------------------------------------------------------------------------------------------
// Name : Hui Zou
// Date: June 27, 2001
// Description: This is the implementation file of matrix and Queue class. The header file is 
//              in vector.h
// Ver 1.03
//--------------------------------------------------------------------------------------------
#include "vector.h"
//--------------------------------------------------------------------------------------------
//Implementation of matrix class
//--------------------------------------------------------------------------------------------
matrix::matrix(int n) {
    row=n;col=n;
    mat=new vector*[row];
    for (int i=0; i<row;i++) 
	mat[i]=new vector(col);
}

void matrix::initialization() {
    for(int i=0;i<row;i++) 
	for(int j=0;j<col;j++)
	    mat[i]->vec[j]=1;
}
       
matrix::matrix(int r, int c){
    row=r;col=c;
    mat=new vector*[row];
    for (int i=0;i<row;i++)
	mat[i]=new vector(col);
}

matrix::matrix(const matrix& m) {
    row=m.row;col=m.col;
    mat=new vector*[row];
    for (int i=0;i<row;i++)
	mat[i]=new vector(col);
    for (i=0;i<row;i++)
	*mat[i]=*m.mat[i];
	
}

matrix::~matrix() {
    for (int i=row;i>0;i--)
	delete mat[i-1];
    delete mat;
}

matrix& matrix::operator=(const matrix& m) {
    if (m.row != row || m.col != col) {
	for (int i=row;i>0;i--)
            delete mat[i-1];
	row=m.row;col=m.col;
    	mat=new vector*[row];
	for (i=0;i<row;i++)
	    mat[i]=new vector(col);
    }//end of if
    for (int i=0;i<row;i++)
	*mat[i]=*m.mat[i];
    return *this;
}

vector& matrix::operator[](int i) {
    return *mat[i];
}

int matrix::getsize() {
    return row;
}

int matrix::getrow() {
    return row;
}

int matrix::getcol() {
    return col;
}

void matrix::swap(int i, int j) {
    vector *temp=mat[i];
    mat[i]=mat[j];
    mat[j]=temp;
}

void matrix::change(int num, int x, int y) {
    int temp;
    temp=mat[num]->vec[x];
    mat[num]->vec[x]=mat[num]->vec[y];
    mat[num]->vec[y]=temp;
}

bool matrix::Isequal(const vector &v1,const vector &v2) {
    for (int i=0;i<col;i++)
        if (v1.vec[i] != v2.vec[i])
	    return 0;
    return 1;
}

void matrix::transpose() {
    int x=row; int y=col;
    matrix mt(y,x); //create a transpose matrix;
    for (int i=0;i<y;i++) {
	for(int j=0;j<x;j++)
	    mt.mat[i]->vec[j]=mat[j]->vec[i];
    }
}

bool operator==(const matrix &m1,const matrix&m2){
    if ((m1.row != m2.row) || (m1.col != m2.col) )
        return false;
    for (int i=0;i<m1.row;i++) {
        vector v1(m1.mat[i],m1.row);vector v2(m2.mat[i],m2.row);
	for(int j=0;j<m1.col;j++) {
            if(v1.getvalue(j) != v2.getvalue(j))
                return false;
        }
    }
    return true;
}

ostream& operator<<(ostream& out,const matrix &m) {
    for(int i=0;i<m.row;i++)
        out<<*m.mat[i];
    return out;
}


int matrix::tightness() {
    int sum=0;
    for(int i=0;i<row;i++) 
	for(int j=0;j<col;j++)
	    sum=sum+mat[i]->vec[j];//get the sum of all 1s in matrix
    return (row*col-sum);//return the number of zeros
}

int matrix::Degree_Inter(vector &degree){
    //we use the vector class object- degree to record the information of a matrix
    int max_index=0;
    for(int i=0;i<row;i++) { 
	for(int j=i+1;j<row;j++){
            vector v1(mat[i],row);vector v2(mat[j],row);
            if (degree.vec[i]==0){
                max_index=max_index+1;
                degree.vec[i]=max_index;
            }
	    if(Isequal(v1,v2)) {
                if(degree.vec[j]==0)
                    degree.vec[j]=max_index;      
             }    
        }
    }
    if(degree.vec[row-1]==0) {
        max_index++;
        degree.vec[row-1]=max_index;
    }
    return max_index;
}
    
void matrix::tight(double tight,unsigned seed) {
    int tmp;
    do {
    	int num1=random()% row;
    	int num2=random()% col;
    	mat[num1]->vec[num2]=0;
    	tmp=tightness();
    }while (tmp <int(tight*row*col));

}

void matrix::set_equal(int current_dg,int desired_dg, vector degree) {
    int index=0;
    int num1,num2,num3,num4;
    int dif=current_dg - desired_dg;//we need dif pairs of vectors to be equal   
    int *A=new int[current_dg+1];
        for(int i=1;i<=current_dg;i++)
           A[i]=0;
        //A[j] contains the number of elements whose value=j (j>=1)
        for(int j=0;j<row;j++) 
            A[degree.vec[j]]=A[degree.vec[j]]+1;
        //to classify each vector into its responding equivalence class
        int **B;
        B=new int*[current_dg];
        for(i=0;i<current_dg;i++) 
            B[i]=new int[A[i+1]];
        for(j=1;j<=current_dg;j++) {
	    for (int k=0;k<row;k++) {
		if (degree.vec[k]==j) {
		    B[j-1][index]=k;
		    index++;
		} // end of if
	    } //end of inter for
            index=0;
        }
    if (dif>0) {//if the current degree > the desired degree, we need to set some pairs of vectors
                //to be equal.
        
	//to select any two vectors to be equal
        for (i=0;i<dif;i++) {
	    num1=random()%current_dg;
            num2=random()%current_dg;
	    num3=random()%A[num1+1];
	    num4=random()%A[num2+1];
            if (num1>num2)
		mat[B[num1][num3]]=mat[B[num2][num4]];
            else
                mat[B[num2][num4]]=mat[B[num1][num3]];
        } //end of for
	//free memory
        delete A;
        delete []B;
     }
    else if (dif<0){// if the current degree < the desired degree, we need reduce the number of equivalent class
        for(int i=0;i<(-1)*dif;i++) {
	    //take any one vectors out of the equivalent classes in random
            num1=random()% current_dg;
            while (A[num1+1] == 1)
		num1=random()% current_dg;
            num2=random()% A[num1+1];
            num3=random()%col;
	    num4=random()%col;
            int count=0;         
            while(mat[B[num1][num2]]->vec[num3]==mat[B[num1][num2]]->vec[num4]) {
                //cout<<"ok"<<endl;
		num3=random()% col;
                num4=random()% col;
                count++;
		if (count>row*(row-1)/2)
		    break;
            }
            
            if (mat[B[num1][num2]]->vec[num3] != mat[B[num1][num2]]->vec[num4])
                change(B[num1][num2],num3,num4);
            else {
		if (((random()% 10) /10.0)>0.5){
                    if (mat[B[num1][num2]]->vec[num3]==0) 
                        mat[B[num1][num2]]->vec[num3]=1;
                    else 
                        mat[B[num1][num2]]->vec[num3]=0;
                    }
                else {
		    if (mat[B[num1][num2]]->vec[num4]==0) 
                        mat[B[num1][num2]]->vec[num4]=1;
                    else 
                        mat[B[num1][num2]]->vec[num4]=0;
                    }
            }
       }//end of for
   }//end of if	   
   else {//if dif=0, then do nothing
       }         
   delete A;
   delete []B;
}//end of function

void matrix::permute(int K){
    int i,num, v1,v2,fail=0;
    num=random()%(K*(K-1)/2);
    int **V;
    V=new int*[K];
    for(i=0;i<K;i++)
        V[i]=new int[K];
    for(i=0;i<K;i++)
 	for(int j=0;j<K;j++)
	    V[i][j]=0;
    for(i=0;i<=num;i++) {
        v1=random()%K;
        v2=random()%K;
        while(v1==v2 && fail<=num) {      
            v1=random()%K;
            v2=random()%K;
            fail++;
        }
        swap(v1,v2);    
    }
    delete []V;
}    	    

void matrix::need_change() {
    matrix n(row);
    for(int i=0;i<row;i++) {
	for(int j=0;j<col;j++) {
	    if (mat[i]->vec[j]==1)
	        n.mat[i]->vec[j]=0;
            else 
	        n.mat[i]->vec[j]=1;
	 }
    }
    *this=n;
}

//------------------------------------------------------------------------------------------------------
// Implementation of Queue class
//------------------------------------------------------------------------------------------------------

Queue::Queue() {
    front=NULL;
    rear=NULL;
} // end constructer

Queue::~Queue() {
    make_empty();
} // end destructor

Queue::Queue(const Queue& TheQ) {
    if ( TheQ.empty() ) {
 	front=NULL;
	rear=NULL; //original list is empty
	}
    else {
	QueueNode *x=TheQ.front;// x is temporary pointer, which traverses TheQ.

	// copy the first Queuenode
        front=new QueueNode;
        front->element=x->element;
        rear=front;// The new Queue just has a node.
	
        // copy the rest element of the list.
        x=x->next;
        while ( x != NULL) {
	    rear->next=new QueueNode;
            rear=rear->next;
            rear->element=x->element;
	    x=x->next;
	    }
        rear->next=NULL;
	}
} // end copy constructor

Queue& Queue::operator=(const Queue& TheQ) {
        
    // Deallocated memory.
    if ( this != & TheQ )
        make_empty();

    // Special case, the Queue is empty
    if ( TheQ.front == NULL && TheQ.rear == NULL) {
	front=NULL;
	rear=NULL; // The original list is empty
       	}

    else {
  	QueueNode *x=TheQ.front;// x is temporary pointer, which traverses TheQ.

	// copy the first Queuenode
        front=new QueueNode;
        front->element=x->element;
        rear=front;// The new Queue just has a node.

        // copy the rest element of the list.
        x=x->next;
        while ( x != NULL) {
	    rear->next=new QueueNode;
            rear=rear->next;
            rear->element=x->element;
	    x=x->next;
	    }
        rear->next=NULL;
	}
    return *this;
} // end assignment operator

//Uses stdlib.h and iostream.h
void Queue::enqueue(int newElement) {
    // creat a new node
    QueueNode *newptr;
    newptr=new QueueNode;
 
    if (newptr !=NULL ) { // check allocation and allocation successful,
                          // set data portion of new node
	newptr->element=newElement;

        // insert the new node
        // special case, the Queue is empty
        if ( front==NULL && rear==NULL) {
	    front=newptr;
	    rear=front;// The new Queue just has one node.
            }

        // the queue is not empty
	else {
            rear->next=newptr;
            rear=newptr;
            }
        }
    else {
	cout<<"The Queue is full, insuffucient memory. \n";
	exit(1);
	}
} //end enqueue

//Uses stdlib.h and iostream.h
int Queue::dequeue() {
    if ( !empty() ) { // the Queue is not empty.
	int front_item=front->element;

        // special case: the Queue just has one node.  
        if (front==rear) {
	    delete front;
            front=NULL;
            rear=NULL;  
            }

        // the queue has more than one node
	else {
            QueueNode *x=front;// x is temporary pointer.
	    front=front->next;
	    delete x;
            x=NULL;
            }
        return front_item;
        }
    else { // the Queue is empty
	cout<<"The Queue is empty. \n";
	return 0;
	}
} // end dequeue

void Queue::make_empty() {
    QueueNode *x=front;  // x is temporary pointer, which traverses the Queue.
    while (! empty() ) {
         // special case: the Queue just has one node.
         if (front==rear) {
	     delete front;
             front=NULL;
             rear=NULL;  
             }
         // the queue has more than one node
         else {
	    front=front->next;
	    delete x;
	    x=front;
	 } //end if
    } // end while loop
} //end make_empty

bool Queue::empty() const {
    if (front==NULL && rear==NULL )
	return true;
    else
	return false;
} // end empty

//------------------------------------------------------------------------------------------------------
//Implementation of other functions in main program
//------------------------------------------------------------------------------------------------------
float ran1() {
    static long int a=100001;
    a=(a*random())%2796203;
    return a;
}

float ran2() {
    static long int a=1;
    a=(a*32719+random())%32749;
    return a;
}

float getseed() {
    float x=(random()%10/10.0); 
    if (x>0.5)
        return ran1();
    else
        return ran2();
}

void assign_CS(ofstream& fout,int C,int N){
    int i, j,k,v1,v2;bool Connected;
    int size=N*(N-1)/2;
    int *V=new int[size+1];//indicates which two variables are constrained
    CS_vars *constraint=new CS_vars[C+1];//keep the record of two variables limited by a constraint
    int *visited=new int[N+1]; //to mark a variable if it is visited
    time_t t;
    t=time(&t);
    pid_t pid;
    pid=getpid();
    unsigned seed;
    seed=t/pid;   
    srandom(seed);
    do {
        Connected=1;
        for(i=1;i<=size;i++)
            V[i]=0;
        
        //assign a constraint to any two variables
        for (k=1;k<=C;k++) {
            int num=random()%(size);
	    if (V[num+1]==0)
	        V[num+1]=1;
	    else
	        k--;
        } //end of for
        int count=1;
        int index=1;
        
        //pick up the two constrainted variables, and store them.
        for (i=1;i<=N;i++) {
            for (j=i+1;j<=N;j++) {
                if (V[index]==1) {
                    constraint[count].var1=i;
                    constraint[count].var2=j;
                    count++;
                 }//end of if
                 index++;
            }
        }
         
        // to check if the CSP is connected     
        Queue Q;
        for(i=1;i<=N;i++) 
            visited[i]=0;
        visited[1]=1;
        Q.enqueue(1);
        while ( !Q.empty() ) {
            int v=Q.dequeue();
            for(int j=1;j<=C;j++) {
                v1=constraint[j].var1;
                v2=constraint[j].var2;
                if (v1==v && visited[v2]==0) {
                    Q.enqueue(v2);
                    visited[v2]=1;
                }
                if (v2==v && visited[v1]==0) {
                    Q.enqueue(v1);
                    visited[v1]=1;
                }
            } //end of for
        } //end of while
        
        //if C<(N-1), it is impossible to be connected
        if (C >= (N-1)) {
            //if there exists any a variable that is not visited, then this CSP is not connected
            for(i=1;i<=N;i++) {
                if (visited[i]==0) {
                    Connected=0;
                    break;
                    }
            } //end of if
        } //end of if
    } while (!Connected); //if not connected, then select againt
    //store the connected CSP into output file
    for (i=1;i<=C;i++) {
        v1=constraint[i].var1;
        v2=constraint[i].var2;
        fout<<v1<<" "<<setw(3)<<v2<<" "<<setw(3)<<i<<endl;
    }
    //deallocate memory
    delete visited;
    delete constraint;
    delete V;
} 
         

void usage(){
    cout << "Usage: gen N K C I T outfile"<< endl;
    exit(1);
}    


  
