//---------------------------------------------------------------------------------------------
// Name : Hui Zou
// Date: June 27, 2001
// Description: This is the header file of vector ,matrix and Queue class. 
// ver 1.02
//---------------------------------------------------------------------------------------------
#include <iostream.h>
#include <math.h>
#include <iomanip.h>
#include <stdlib.h>
#include <fstream.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <float.h>
#include <stdio.h>
#include <signal.h>
//---------------------------------------------------------------------------------------------
//a structure CS_vars to record each constraint assigned to any two varibles
struct CS_vars {
    int var1;
    int var2;
};

class matrix;
//---------------------------------------------------------------------------------------------
//vector class prototype
//---------------------------------------------------------------------------------------------
class vector {
friend class matrix;
public:
    // constructor 
    //to initialize each element to be zero
    //Precondition: the size of vector shall be given.
    //Postcondition: each element in vector is initialized to be 1.
    vector(int);
    
    //constructor
    //to initialize each element to be the specified value
    //Precondition:the size of vector and the specified value shall be given
    //Postcondition: each element in vector is initialized to be the specified
    //               value
    vector(int,int);

    //constructor
    // to initialize vector by a given array
    //Precondition: an given array and the size of vector is avalable
    //Postcondition:the vector copys each element of the given array
    vector(const vector*,int);

    //copy constructor
    //make a copy of an object
    //Precondition:an object of class existing
    //Postcondition: the vector is copied
    vector(const vector&);

    //distructor
    //deallocate the memory used by an object
    //Precondition: none
    //Postcondition:memory is free
    ~vector();

    //assign =operator
    //assign an object to another
    //Precondition: an object existing
    //Postcondition:the object is assigned with the given object
    vector& operator= (const vector&);

    //set each element of the vector to be 0
    //Precondition:the size of vector shall be given
    //Postcondition:each element=0
    void ini(int);
    
    //the [] opreator
    //return the value of element indexed by int
    int& operator[](int);

    //return the size of a vector
    int getsize();

    //return the value of one element of an object
    //Precondition: the index of an existing object given 
    //Postcondition:return the value of the element pointed by the index
    int getvalue(int);
    
    //to swap any two elements in vector
    void swap(int,int);
    

    //the output operator
    friend ostream& operator<<(ostream&,const vector&);


private:
    int size;
    int *vec;

};

//---------------------------------------------------------------------------------------------
//matrix class prototype
//---------------------------------------------------------------------------------------------
class matrix {
public:
    //contructor
    //Precondition : two integers should be given
    //Postcondition: a matrix size of integer1*interger2 will be defined
    matrix(int,int);
    
    //contructor
    //Precondition : an integer should be given
    //Postcondition: a matrix size of integer*interger will be defined
    matrix(int);
    
    //copy constructor
    //Precondition :a marix class object is existing
    //Postcondition:to make a copy of the existing object
    matrix(const matrix&);
    
    //destructor
    //Precondition : none
    //Postcondition: deallocate memory
    ~matrix();
    
    //[] operator
    //return a complete row vector
    vector& operator[](int);
    
    //assign operator
    //Precondition :a marix class object is existing
    //Postcondition:to assign the existing object to another object
    matrix& operator=(const matrix&);
    
    //to test if two vetors(such that two rows) are equal
    //Precondition: two vector class objects is existing
    //Postcondition:if equal,then return 1,otherwise 0
    bool Isequal(const vector&,const vector&);
    
    //to calculate the tightness of a matrix
    //Precondition :a matrix class object is existing
    //Postcondition:return the number of zero in matrix
    int tightness();
    
    //to calculate the degree of interchangeaqbility of a matrix
    //return the degree 
    int Degree_Inter(vector&);
    
    //according to the tightness, to fix the matrix
    void tight(double,unsigned);
    
    //according to the degree of interchangeability, to fix a matrix
    void set_equal(int,int,vector);
    
    //set the matrix to its orignal status
    void initialization();
    
    //return row
    int getsize();
    int getrow();
    
    //return col
    int getcol();
    
    //to swap any two vectors of the matrix
    void swap(int,int);
    
    //to exchange two elements of some vector of the matrix
    //the 1st numner is the row#, and the 2rd&3rd are the indexs of the elements of the row
    void change(int,int,int);
    
    void need_change();
    
    //to get a transpose matrix of the original matirx
    void transpose();
    
    //in order to get a more general solution and improve the rate of distinct constraints
    //after we get a solution, we permute this matrix in random
    void permute(int);
    
    //to test if two matrixs are equal
    //return 1 if equal, otherwise return 0;
    friend bool operator==(const matrix&,const matrix&);
    
    //the output operator
    friend ostream& operator<<(ostream&,const matrix&);
private:
    int row;
    int col;
    vector **mat;
};

//-----------------------------------------------------------------------------------------------
//Queue class prototype
//-----------------------------------------------------------------------------------------------
class Queue;                  // forward declaration
//--------------------------------------------------------------------
// Class for a node to be used in a linked list:creates and empty element
// Programming note: no implementation coding is needed.
// The queue is implemented as a linked list with two external pointers.
// One points to the front of the queue, another one points to the rear 
//of the queue.
class QueueNode               
{
    private:

    // Data members
    int element;          // Queue element
    QueueNode *next;      // Pointer to the next element

    friend class Queue;
};

//--------------------------------------------------------------------
class Queue
{
  public:

    Queue ();                                   // Constructor
    // The constructor. creates an empty queue
    // Precondition : none
    // Postcondition: the variable front and rear has an appropriate 
    //                value assigned.

    ~Queue ();                                  // Destructor
    // The destructor.  Deallocated the memory assigned to pointers
    //Precondition: a Queue object has been created
    //Postcondition: Memory used by the queue is freed

    Queue(const Queue& TheQ);                   // Copy constructor
    //Initializes Queue by making a copy of an existing Queue object
    //Precondition: object to be copied to is empty or can be emptied
    //              and object to be copied from exists
    //Postcondition: a copy of the object is made

    Queue& operator=(const Queue & TheQ);       // Assignment operator
    //Initializes Queue by making a copy of an existing Queue object
    //Precondition: object to be assigned to is empty or can be emptied
    //              and object to be assigned from exists
    //Postcondition: makes a copy of the Queue TheQ

    void enqueue (int newElement );           // Enqueue element
    //Adds a new item to the rear of the Queue
    //Precondition: A previously created Queue.  The parameter newElement
    //              is added to the rear of the Queue. 
    //              There is memory available to add the new item in the Queue.
    //Postcondition:If the Queue is not full, the item is added to the rear
    //              of the Queue.  Otherwise, the Queue is unchanged.

    int dequeue ();                           // Dequeue element
    //Removes an item from the front of the Queue.
    //Precondition: A previously created Queue.
    //Postcondition: If the Queue is not empty, it has its front item removed
    //and returned. Otherwise (the Queue is empty) 0 is returned.

    void make_empty();                          // Clear queue
    //To make an existing Queue empty.
    //Precondition: A Queue object has been created.
    //Postcondition: The Queue is cleared.

    bool empty () const;                        // Queue is empty
    //Class instance tester
    //Precondition: A previously created Queue.
    //Postcondition: returns true if empty, false if not.


  private:

    // Data members
    QueueNode *front,                  // Pointer to the front element
              *rear;                   // Pointer to the rear element
};

//------------------------------------------------------------------------------------------
//other functions in main program
//------------------------------------------------------------------------------------------

//two random number generators to generate seed in random
float ran1();
float ran2();

//return seed in random with ran1() or ran2()
float getseed();

//assign constraints to any two variables
void assign_CS(ofstream&,int,int);

//to display the usage 
void usage();

