//This is a header file for the CSP generator
//-----------------------------------------------------------------------------------------------
// Name : Hui Zou
// Date : Aug. 17, 2001
//-----------------------------------------------------------------------------------------------
#include <iostream.h>
#include <math.h>
#include <iomanip>
#include <stdlib.h>
#include <fstream.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <float.h>
#include <stdio.h>
//-----------------------------------------------------------------------------------------------
struct constraint_attr {
    int arity; //the arity of a constraint
    int *var;  //record which variables assigned to a constraint
    };

//to generate constraints, called by main program
//Precondition : relative arguments should be given
//Postcondition: generate c constraints with specified arity and tightness   
void gen(ofstream& out, int a, int arity, int ci, int num_no_tuple, constraint_attr *constraint, int offset, int *assign);


//to set the tightness of a constraint according to a specified value, called by gen()
//Precondition : an initialized constraint existing
//Postcondition: the constraint will be set to a specified tightness
void set_tightness(int *v, int size, int num_no_tuple,int forbidden);

//to find all tuples, called by gen()
//Precondition : a constraint with specified tightness existing
//Postcondition: all compatible tuples will selected from this constraint
void retrieve(ofstream& out, int *v, int a, int arity);

//to find all tuples of a binery constraint, called by retrieve()
//Precondition :  a binery constraint with specified tightness existing
//Postcondition: all compatible tuples will selected from this constraint
void ARITY2(ofstream& out, int *v, int a);

//to find all tuples of a ternary constraint, called by retrieve()
void ARITY3(ofstream& out, int *v, int a);

//to find all tuples of a quaternary constraint, called by retrieve()
void ARITY4(ofstream& out, int *v, int a);

//to assign variables to a constraint
void assignment(int a , int arity, int c, int num_tuple, constraint_attr *constraint, int offset);
void assign2(int *selected_var, constraint_attr *constraint, int n, int offset);
void assign3(int *selected_var, constraint_attr *constraint, int n, int offset);
void assign4(int *selected_var, constraint_attr *constraint, int n, int offset);

//check if all constraints are connectedif yes return true, otherwise return false
bool IsConnected(constraint_attr *,int n, int C);

void output(ofstream& out,constraint_attr *constraint, int C);

//to display the usage of the program
void usage();

