//This is the implementation file of constraint.h
//------------------------------------------------------------------------------------------------
// Name : Hui Zou
// Date : Aug. 17, 2001
//------------------------------------------------------------------------------------------------
#include "constraint2.h"
//------------------------------------------------------------------------------------------------

int index_of_assignment(constraint_attr *constraint, int *assign, int a){     
     int index = 0;
     int mult_factor =1;
     if(assign == NULL) return -1 ;
     //     if(constraint == NULL) printf("NULL");
     for(int i =0; i < constraint->arity -1;i++) mult_factor *=a;
     //     printf("constraint arity %d",constraint->arity);
     for(int i =1; i <= constraint->arity; i++)
     {
       // printf("\n %d] var %d, mul = %d, %d ",i,constraint->var[i], mult_factor,assign[constraint->var[i]]); fflush(stdout);
       index+= (assign[constraint->var[i]] -1)*mult_factor;
       mult_factor = mult_factor / a;        
     }
     index++;
     // printf("index = %d",index );
     return index;

}

void gen(ofstream& out,int a, int arity, int c, int num_no_tuple, constraint_attr *constraint, int offset,int *assign){
    int size; // the size of 1-dimension array representing a constraint
    int forbidden;
    if (arity==2)
        size=a*a;
    if (arity==3)
        size=a*a*a;
    if (arity==4)
        size=a*a*a*a;
    /*
     size = (int) pow(a,arity);
     */	
    int *v=new int[size+1]; // allocate memory for array v[]
    
    for (int j=1;j<=c;j++) {
      
        //initialize array v[]
        for(int i=1;i<=size;i++) 
            v[i]=1;
	
	//printf("\n forbidden entering %d \n ",j+offset); fflush(stdout);
	forbidden = index_of_assignment(&constraint[j+offset],assign,a);
	//printf("done forbidden"); fflush(stdout);
	set_tightness(v,size,num_no_tuple,forbidden); 
	out<<j+offset;
	//for(int k=1;k<=arity;k++)
	//    out<<" "<<a;
	out<<endl; 
	retrieve(out,v,a,arity);  
    }// end of for
    delete v;
}

void set_tightness(int *v, int size, int num_no_tuple,int forbidden) {
    int index;
    for (int i=1;i<=num_no_tuple;i++) {
      
        do {
	   index=random()%(size)+1;
	   } while ( v[index]==0 || (index == forbidden) );
	v[index]=0;
	
	}//end of for
}

void retrieve(ofstream& out, int *v, int a, int arity){
    if (arity==2)
        ARITY2(out,v,a);
    if (arity==3)
        ARITY3(out,v,a);
    if (arity==4)
        ARITY4(out,v,a);
}

void ARITY2(ofstream& out, int *v, int a){
    int index=1;
    out<<"( ";
    for (int i=1;i<=a;i++)
        for(int j=1;j<=a;j++)
	    if(v[index++]==1)
	        out<<"("<<i<<" "<<j<<") ";
    out<<")"<<endl;
}

void ARITY3(ofstream& out, int *v, int a){
    int index=1;
    out<<"( ";
    for (int i=1;i<=a;i++)
        for(int j=1;j<=a;j++)
	    for(int k=1;k<=a;k++)
	        if(v[index++]==1)
	            out<<"("<<i<<" "<<j<<" "<<k<<") ";
    out<<")"<<endl;
}

void ARITY4(ofstream& out, int *v, int a){
    int index=1;
    out<<"( ";
    for (int i=1;i<=a;i++)
        for(int j=1;j<=a;j++)
	    for(int k=1;k<=a;k++)
	        for(int l=1;l<=a;l++)
	            if(v[index++]==1)
	                out<<"("<<i<<" "<<j<<" "<<k<<" "<<l<<") ";
    out<<")"<<endl;
}

void assignment(int n , int arity, int c, int num_tuple, constraint_attr *constraint, int offset){
    int *selected_var=new int[num_tuple+1];//indicates which variables are constrainted
    for (int i=1;i<=num_tuple;i++)
        selected_var[i]=0; // initialize
    //printf("initialized one assignment c = %d, num_tuple  = %d", c,num_tuple);
    fflush(stdout);
    // assign a constraint to any a group of varibles
    for( int j=1;j<=c;j++) {
      
        int num=random()%num_tuple;
	//printf("<%d,%d>",num,j);
	//if(j >= 1) exit(0);
        if ( selected_var[num+1]==0)
	  { selected_var[num+1]=1;}
        else
            j--;
    }
    //printf("created one assignment");
    fflush(stdout);
    //pick up the varibles assigned to a constraint and store them
    if (arity==2)
        assign2(selected_var, constraint, n, offset);
    if (arity==3)
        assign3(selected_var, constraint, n, offset);
    if (arity==4)
	assign4(selected_var, constraint, n, offset);
           
}

void assign2(int *selected_var, constraint_attr *constraint, int n, int offset){
    int count=1+offset;
    int index=1;
    for(int i=1; i<=n; i++)
        for(int j=i+1;j<=n;j++) {
            if (selected_var[index]==1) {
		constraint[count].var[1]=i;
		constraint[count].var[2]=j;
		count++;
		}
	    index++;
	}
}


void assign3(int *selected_var, constraint_attr *constraint, int n, int offset){
    int count=1+offset;
    int index=1;
    for(int i=1; i<=n; i++)
        for(int j=i+1;j<=n;j++) 
	    for(int k=j+1;k<=n;k++) {
                if (selected_var[index]==1) {
		    constraint[count].var[1]=i;
		    constraint[count].var[2]=j;
		    constraint[count].var[3]=k;
		    count++;
		    }
	        index++;
	    }
}

void assign4(int *selected_var, constraint_attr *constraint, int n, int offset){
    int count=1+offset;
    int index=1;
    for(int i=1; i<=n; i++)
        for(int j=i+1;j<=n;j++) 
	    for(int k=j+1;k<=n;k++) 
                for(int l=k+1;l<=n;l++) {
                    if (selected_var[index]==1) {
		        constraint[count].var[1]=i;
		        constraint[count].var[2]=j;
		        constraint[count].var[3]=k;
                        constraint[count].var[4]=l;
		        count++;
		        }
	            index++;
	        }
}

bool IsConnected(constraint_attr *constraint,int n, int C) {
    //if C<(n-1), it is impossible to be connected
    if (C<(n-1)) {
      // cout<<"It is impossible to be connected\n";
        //exist(0);
	// return false;
    }

    int *visited=new int[n+1]; //to mark a variable if it is visited
    for(int i=1;i<=n;i++) 
        visited[i]=0;
    for (int i=1;i<=C;i++){
        for (int j=1;j<=constraint[i].arity;j++)
	    if (constraint[i].var[j]!=0)
		visited[constraint[i].var[j]]=1;
    }

    //if there exists any a variable that is not visited, then this CSP is not connected
    for(int i=1;i<=n;i++) 
        if (visited[i]==0) 
            return false;
    return true;
}
 
    

void output(ofstream& out,constraint_attr *constraint, int C) {
    for (int i=1;i<=C;i++){
	out<<i<<" ";
	if (constraint[i].arity==2)
	  out<<"("<<constraint[i].var[1]<<" "<<constraint[i].var[2]<<")"<<endl;
        if (constraint[i].arity==3)
	  out<<"("<<constraint[i].var[1]<<" "<<constraint[i].var[2]<<" "<<constraint[i].var[3]<<")"<<endl;
        if (constraint[i].arity==4)
	  out<<"("<<constraint[i].var[1]<<" "<<constraint[i].var[2]<<" "<<constraint[i].var[3]<<" "<<constraint[i].var[4]<<")"<<endl;
    }
}

void usage(){
    cout << "Usage: gen2 n a  p2 p3 p4 t outfile mode"<< endl;
    cout<<"mode = 1 for guaranteeing a solution; mode = 0 for no guarantee of the presence of a solution" <<endl;
    exit(1);
}    

